<?php
/**
 * Login Form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/form-login.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.4.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

?>

<?php wc_print_notices(); ?>

<?php do_action( 'soho_before_customer_login_form' ); ?>

<?php if ( get_option( 'soho_enable_myaccount_registration' ) === 'yes' ) : ?>

<div class="u-columns col2-set clearfix" id="customer_login">

    <div class="u-column1 col-1">

<?php endif; ?>

    <h2><?php _e( 'Login', 'soho' ); ?></h2>

    <form class="woocomerce-form soho-form-login login" method="post">

        <?php do_action( 'soho_login_form_start' ); ?>

        <?php /*** Our code modification inside Woo template - begin ***/ ?>

        <p class="soho-FormRow soho-FormRow--wide form-row form-row-wide">
            <input type="text" class="soho-Input soho-Input--text input-text placeholder" placeholder="<?php _e('Username or email', 'soho'); ?>" name="username" id="username" value="<?php if ( ! empty( $_POST['username'] ) ) echo esc_attr( $_POST['username'] ); ?>" />
        </p>
        <p class="soho-FormRow soho-FormRow--wide form-row form-row-wide">
            <input class="soho-Input soho-Input--text input-text placeholder" placeholder="<?php _e('Password', 'soho'); ?>" type="password" name="password" id="password" />
        </p>

        <?php do_action( 'soho_login_form' ); ?>

        <p class="form-row">
            <?php wp_nonce_field( 'soho-login', 'soho-login-nonce' ); ?>
            <input type="submit" class="soho-Button button" name="login" value="<?php esc_attr_e( 'Login', 'soho' ); ?>" /> 
            <a class="lost_password woo-lost_password2" href="<?php echo esc_url( wc_lostpassword_url() ); ?>"><?php _e( 'Lost Password?', 'soho' ); ?></a>
            <label class="soho-form__label soho-form__label-for-checkbox inline woo-my-account-rememberme">
                <input class="soho-form__input soho-form__input-checkbox" name="rememberme" type="checkbox" id="rememberme" value="forever" /> <?php _e( 'Remember me', 'soho' ); ?>
            </label>
        </p>

        <?php /*** Our code modification inside Woo template - end ***/ ?>

        <?php do_action( 'soho_login_form_end' ); ?>

    </form>

<?php if ( get_option( 'soho_enable_myaccount_registration' ) === 'yes' ) : ?>

    </div>

    <div class="u-column2 col-2">

        <h2><?php _e( 'Register', 'soho' ); ?></h2>

        <form method="post" class="register">

            <?php do_action( 'soho_register_form_start' ); ?>

            <?php if ( 'no' === get_option( 'soho_registration_generate_username' ) ) : ?>

                <p class="soho-FormRow soho-FormRow--wide form-row form-row-wide">
                    <input type="text" class="soho-Input soho-Input--text input-text placeholder" placeholder="<?php _e('Username', 'soho'); ?>" name="username" id="reg_username" value="<?php if ( ! empty( $_POST['username'] ) ) echo esc_attr( $_POST['username'] ); ?>" />
                </p>

            <?php endif; ?>

            <p class="soho-FormRow soho-FormRow--wide form-row form-row-wide">
                <input type="email" class="soho-Input soho-Input--text input-text placeholder" placeholder="<?php _e('Email', 'soho'); ?>" name="email" id="reg_email" value="<?php if ( ! empty( $_POST['email'] ) ) echo esc_attr( $_POST['email'] ); ?>" />
            </p>

            <?php if ( 'no' === get_option( 'soho_registration_generate_password' ) ) : ?>
    
                <p class="soho-FormRow soho-FormRow--wide form-row form-row-wide">
                    <input type="password" class="soho-Input soho-Input--text input-text placeholder" placeholder="<?php _e('Password', 'soho'); ?>" name="password" id="reg_password" />
                </p>

            <?php endif; ?>

            <?php /*** Our code modification inside Woo template - end ***/ ?>

            <!-- Spam Trap -->
            <div style="<?php echo ( ( is_rtl() ) ? 'right' : 'left' ); ?>: -999em; position: absolute;"><label for="trap"><?php _e( 'Anti-spam', 'soho' ); ?></label><input type="text" name="email_2" autocomplete="off" id="trap" tabindex="-1" /></div>

            <?php do_action( 'soho_register_form' ); ?>
            
            <p class="woocomerce-FormRow form-row">
                <?php wp_nonce_field( 'soho-register', 'soho-register-nonce' ); ?>
                <input type="submit" class="soho-Button button" name="register" value="<?php esc_attr_e( 'Register', 'qode' ); ?>" />
            </p>
            
            <?php do_action( 'soho_register_form_end' ); ?>
        
        </form>
    
    </div>
    
    </div>
<?php endif; ?>

<?php do_action( 'soho_after_customer_login_form' ); ?>