<?php
/**
 * Thankyou page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/thankyou.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @author      WooThemes
 * @package     WooCommerce/Templates
 * @version     3.2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>

<div class="woocommerce-order">

    <?php if ( $order ) : ?>

        <?php if ( $order->has_status( 'failed' ) ) : ?>

            <p class="woocommerce-message woocommerce-notice woocommerce-notice--error woocommerce-thankyou-order-failed"><?php _e( 'Unfortunately your order cannot be processed as the originating bank/merchant has declined your transaction. Please attempt your purchase again.', 'soho' ); ?></p>

            <p class="woocommerce-message woocommerce-notice woocommerce-notice--error woocommerce-thankyou-order-failed-actions">
                <a href="<?php echo esc_url( $order->get_checkout_payment_url() ); ?>" class="button pay"><?php _e( 'Pay', 'soho' ) ?></a>
                <?php if ( is_user_logged_in() ) : ?>
                    <a href="<?php echo esc_url( wc_get_page_permalink( 'myaccount' ) ); ?>" class="button pay"><?php _e( 'My account', 'soho' ); ?></a>
                <?php endif; ?>
            </p>

        <?php else : ?>

            <p class="woocommerce-message woocommerce-notice woocommerce-notice--success woocommerce-thankyou-order-received"><?php echo apply_filters( 'woocommerce_thankyou_order_received_text', __( 'Thank you. Your order has been received.', 'soho' ), $order ); ?></p>

            <ul class="woocommerce-order-overview woocommerce-thankyou-order-details order_details clearfix">

                <li class="woocommerce-order-overview__order order">
                    <span><?php _e( 'Order:', 'soho' ); ?></span>
                    <p><?php echo esc_html($order->get_order_number()); ?></p>
                </li>

                <li class="woocommerce-order-overview__date date">
                    <span><?php _e( 'Date:', 'soho' ); ?></span>
                    <p><?php echo wc_format_datetime( $order->get_date_created() ); ?></p>
                </li>

                <?php if ( is_user_logged_in() && $order->get_user_id() === get_current_user_id() && $order->get_billing_email() ) : ?>
                    <li class="woocommerce-order-overview__email email">
                        <span><?php _e( 'Email:', 'woocommerce' ); ?></span>
                        <p><?php echo $order->get_billing_email(); ?></p>
                    </li>
                <?php endif; ?>

                <li class="woocommerce-order-overview__total total">
                    <span><?php _e( 'Total:', 'soho' ); ?></span>
                    <p><?php echo $order->get_formatted_order_total(); ?></p>
                </li>

                <?php if ( $order->get_payment_method_title() ) : ?>

                    <li class="woocommerce-order-overview__payment-method method">
                        <span><?php _e( 'Payment method:', 'soho' ); ?></span>
                        <p><?php echo wp_kses_post( $order->get_payment_method_title() ); ?></p>
                    </li>

                <?php endif; ?>

            </ul>

            <div class="clear"></div>

        <?php endif; ?>

        <div class="order-details-wrapper">
            <?php do_action( 'woocommerce_thankyou_' . $order->get_payment_method(), $order->get_id() ); ?>
            <?php do_action( 'woocommerce_thankyou', $order->get_id() ); ?>
        </div>

    <?php else : ?>

        <p class="woocommerce-message woocommerce-notice woocommerce-notice--success woocommerce-thankyou-order-received"><?php echo apply_filters( 'woocommerce_thankyou_order_received_text', __( 'Thank you. Your order has been received.', 'soho' ), null ); ?></p>

    <?php endif; ?>

</div>