<?php

global $qode_options_theme18;

$args = array(
    "type"                  => "",
    "background_color"      => "",
    "background_image"      => "",
    "border_color"          => "",
    "icon_pack"             => "",
    "fa_icon"               => "",
    "fe_icon"               => "",
    "icon_size"             => "39",
    "icon_color"            => "",
    "icon_border_color"     => "",
    "image"                 => "",
    "text_in_process"       => "",
    "font_size"             => "",
    "text_in_process_color" => "",
    "link"                  => "",
    "link_target"           => "_self",
    "title"                 => "",
    "title_tag"             => "h5",
    "title_color"           => "",
    "text"                  => "",
    "text_color"            => "",
    "text_separator"        => "",
    "text_separator_color"  => "",
    "process_line_color"    => ""   
);

extract(shortcode_atts($args, $atts));

$headings_array = array('h2', 'h3', 'h4', 'h5', 'h6');
                
//get correct heading value. If provided heading isn't valid get the default one
$title_tag = (in_array($title_tag, $headings_array)) ? $title_tag : $args['title_tag'];

$html                  = '';
$image_src             = '';
$image_alt             = '';
$process_style         = '';
$text_in_process_style = '';
$icon_style            = '';
$title_style           = '';
$title_link_style      = '';
$text_style            = '';
$separator_style       = '';
$line_style            = '';

if($background_color != "") {
    $process_style .= "background-color: ".$background_color.";";
}

if($background_image != "") {
    $attachment_scr = wp_get_attachment_image_src( $background_image, 'full');
    $process_style .= "background-image: url(".$attachment_scr[0].");";
}

if($border_color != "") {
    $process_style .= " border: 1px solid ".$border_color;
}

if($text_in_process_color != "") {
    $text_in_process_style .= "color: ".$text_in_process_color.";";
}

if($font_size != "") {
    $text_in_process_style .= " font-size: ".$font_size."px;";
}

if($icon_color != "") {
    $icon_style .= "color: ".$icon_color.";";
}

if($icon_border_color != "") {
    $icon_style .= "border: 3px solid ".$icon_border_color.";";
}

if($icon_size != "") {
    $icon_style .= "font-size: ".$icon_size."px;";
}

if($title_color != "" && $link == "") {
    $title_style .= "color: ".$title_color;
}

if($title_color != "" && $link != "") {
    $title_link_style .= "color: ".$title_color;
}

if($text_color != "") {
    $text_style .= "color: ".$text_color;
}

if($process_line_color != ""){
    $line_style .= "style='background-color: ".$process_line_color."'";
}

if($text_separator_color != ""){

    $rgba_color = qode_hex2rgb($text_separator_color);

    $separator_style .= "background: -moz-linear-gradient(left, rgba(".$rgba_color[0].",".$rgba_color[1].",".$rgba_color[2].",0) 13%, rgba(".$rgba_color[0].",".$rgba_color[1].",".$rgba_color[2].",0.6) 50%, rgba(".$rgba_color[0].",".$rgba_color[1].",".$rgba_color[2].",0) 87%);";
    $separator_style .= "background: -webkit-gradient(linear, left top, right top, color-stop(13%,rgba(".$rgba_color[0].",".$rgba_color[1].",".$rgba_color[2].",0)), color-stop(50%,rgba(".$rgba_color[0].",".$rgba_color[1].",".$rgba_color[2].",0.6)), color-stop(87%,rgba(".$rgba_color[0].",".$rgba_color[1].",".$rgba_color[2].",0)));";
    $separator_style .= "background: -webkit-linear-gradient(left, rgba(".$rgba_color[0].",".$rgba_color[1].",".$rgba_color[2].",0) 13%,rgba(".$rgba_color[0].",".$rgba_color[1].",".$rgba_color[2].",0.6) 50%,rgba(".$rgba_color[0].",".$rgba_color[1].",".$rgba_color[2].",0) 87%);";
    $separator_style .= "background: -o-linear-gradient(left, rgba(".$rgba_color[0].",".$rgba_color[1].",".$rgba_color[2].",0) 13%,rgba(".$rgba_color[0].",".$rgba_color[1].",".$rgba_color[2].",0.6) 50%,rgba(".$rgba_color[0].",".$rgba_color[1].",".$rgba_color[2].",0) 87%);";
    $separator_style .= "background: -ms-linear-gradient(left, rgba(".$rgba_color[0].",".$rgba_color[1].",".$rgba_color[2].",0) 13%,rgba(".$rgba_color[0].",".$rgba_color[1].",".$rgba_color[2].",0.6) 50%,rgba(".$rgba_color[0].",".$rgba_color[1].",".$rgba_color[2].",0) 87%);";
    $separator_style .= "background: linear-gradient(to right, rgba(".$rgba_color[0].",".$rgba_color[1].",".$rgba_color[2].",0) 13%,rgba(".$rgba_color[0].",".$rgba_color[1].",".$rgba_color[2].",0.6) 50%,rgba(".$rgba_color[0].",".$rgba_color[1].",".$rgba_color[2].",0) 87%);";
}

$html .= '<li class="q_process_outer">';

if($link != ""){
    $html .= '<a href="'.$link.'" target="'.$link_target.'">';
}

$html .= '<span class="q_process_inner"><span class="q_process_inner2" style="'.$process_style.'">';

if ($type == "icon_type"){
    if($icon_pack == "font_awesome" && $fa_icon != ""){
        $html .= '<i class="fa '.$fa_icon.'" style="'.$icon_style.'"></i>';
    }
    elseif($icon_pack == "font_elegant" && $fe_icon != ""){
        $html .= '<span class="q_font_elegant_icon '.$fe_icon.'" style="'.$icon_style.'" ></span>';
    }
} else if ($type == "text_type"){
    $html .= '<span class="q_text_in_process" style="'.$text_in_process_style.'">'.$text_in_process.'</span>';
}

$html .= '</span></span>';

if($link != ""){
    $html .= '</a>';
}

if($title != "" || $text != ""){
    $html .= '<div class="q_process_text_holder">';

    if($title != ""){
        $html .= '<'.$title_tag.' class="q_process_title" style="'.$title_style.'">';

        if($link != ""){
            $html .= '<a href="'.$link.'" target="'.$link_target.'" style="'.$title_link_style.'">'.$title.'</a>';
        } else {
            $html .= $title;
        }

        $html .= '</'.$title_tag.'>';
    }

    if($text_separator == "yes"){
        $html .= '<span class="separator small" style="'.$separator_style.'"></span>';
    }

    if($text != ""){
        $html .= '<p class="q_process_text" style="'.$text_style.'">'.$text.'</p>';
    }

    $html .= '</div>';
}

$html .= '<span class="line_between_process" '.$line_style.'></span>';

$html .= '</li>';

echo $html;