<?php
global $qode_options_theme18;
/* Set id on -1 beacause archive page id can have same id as some post and settings is not good */
$archive_id = '';
if(is_category() || is_tag() || is_author()){
    $archive_id = $id;
    $id = -1;
}

if(get_post_meta($id, "qode_responsive-title-image", true) != ""){
    $responsive_title_image = get_post_meta($id, "qode_responsive-title-image", true);
}else{
    $responsive_title_image = $qode_options_theme18['responsive_title_image'];
}

if(get_post_meta($id, "qode_fixed-title-image", true) != ""){
    $fixed_title_image = get_post_meta($id, "qode_fixed-title-image", true);
}else{
    $fixed_title_image = $qode_options_theme18['fixed_title_image'];
}

if(get_post_meta($id, "qode_title-image", true) != ""){
    $title_image = get_post_meta($id, "qode_title-image", true);
}else{
    $title_image = $qode_options_theme18['title_image'];
}
$title_image_height = "";
$title_image_width = "";
if(!empty($title_image)){
    $title_image_url_obj = parse_url($title_image);
    if (file_exists($_SERVER['DOCUMENT_ROOT'].$title_image_url_obj['path']))
        list($title_image_width, $title_image_height, $title_image_type, $title_image_attr) = getimagesize($_SERVER['DOCUMENT_ROOT'].$title_image_url_obj['path']);
}

if(get_post_meta($id, "qode_title-overlay-image", true) != ""){
    $title_overlay_image = get_post_meta($id, "qode_title-overlay-image", true);
}else{
    $title_overlay_image = $qode_options_theme18['title_overlay_image'];
}

$header_height_padding = 0;
if (!empty($qode_options_theme18['header_height'])) {
    $header_height = $qode_options_theme18['header_height'];
} else {
    $header_height = 110;
}
if (isset($qode_options_theme18['header_bottom_border_color']) && !empty($qode_options_theme18['header_bottom_border_color'])) {
    $header_height = $header_height + 1;
}
if($qode_options_theme18['header_bottom_appearance'] == 'stick menu_bottom'){
    $menu_bottom = '46';
    if(is_active_sidebar('header_fixed_right')){
        $menu_bottom = $menu_bottom + 22;
    }
} else {
    $menu_bottom = 0;
}
$nav_font_size = 7;
if(isset($qode_options_theme18['menu_fontsize']) && $qode_options_theme18['menu_fontsize'] != ""){
    $nav_font_size = $qode_options_theme18['menu_fontsize'] / 2;
}
$header_top = 0;
if (isset($_SESSION['qode_theme18_header_top']) && $_SESSION['qode_theme18_header_top'] == 'yes') {
    $header_top = 36;
}elseif(isset($qode_options_theme18['header_top_area']) && $qode_options_theme18['header_top_area'] == "yes"){
    $header_top = 36;
}
$header_height_padding = $header_height + $menu_bottom + $header_top;
if (isset($qode_options_theme18['center_logo_image']) && $qode_options_theme18['center_logo_image'] == "yes") {
    if(isset($qode_options_theme18['logo_image'])){
        $logo_width = 0;
        $logo_height = 0;
        if (!empty($qode_options_theme18['logo_image'])) {
            $logo_url_obj = parse_url($qode_options_theme18['logo_image']);
            list($logo_width, $logo_height, $logo_type, $logo_attr) = getimagesize($_SERVER['DOCUMENT_ROOT'].$logo_url_obj['path']);
        }
    }
    if($qode_options_theme18['header_bottom_appearance'] == 'stick menu_bottom'){
        $header_height_padding = $logo_height + 30 + $menu_bottom + $header_top; // 30 is top and bottom margin of centered logo
    } else {
        $header_height_padding = $logo_height + 30 + $header_height + $header_top; // 30 is top and bottom margin of centered logo
    }
}

$title_type = "standard_title";
if(get_post_meta($id, "qode_page_title_type", true) != ""){
    $title_type = get_post_meta($id, "qode_page_title_type", true);
}else if(is_404()){
    $title_type = "breadcrumbs_title";
}else{
    $title_type = $qode_options_theme18['title_type'];
}

$title_image_class = "";
if(get_post_meta($id, "qode_title-image-pattern", true) != ""){
    $title_image_class = " use_pattern_image";
}else if($qode_options_theme18['title_image_pattern'] == "yes"){
    $title_image_class = " use_pattern_image";
}

$title_height = 430; // default title height without header height
if($title_type == "breadcrumbs_title") {
    $title_height = 102;
}

if(get_post_meta($id, "qode_title-height", true) != ""){
    $title_height = get_post_meta($id, "qode_title-height", true);
}else if($qode_options_theme18['title_height'] != ''){
    $title_height = $qode_options_theme18['title_height'];
}else {
    if (isset($qode_options_theme18['center_logo_image']) && $qode_options_theme18['center_logo_image'] == "yes") {
        if($qode_options_theme18['header_bottom_appearance'] == 'stick menu_bottom'){
            $title_height = $title_height + $logo_height + 30 + $menu_bottom + $header_top; // 30 is top and bottom margin of centered logo
        } else {
            $title_height = $header_height + $title_height + $logo_height + 30 + $header_top; // 30 is top and bottom margin of centered logo
        }
    } else {
        $title_height = $title_height + $header_height + $menu_bottom + $header_top;
    }
}
if(get_post_meta($id, "qode_fixed-title-image", true) != ""){
    $fixed_title_image = get_post_meta($id, "qode_fixed-title-image", true);
}else{
    $fixed_title_image = $qode_options_theme18['fixed_title_image'];
}

$title_background_color = '';
if(get_post_meta($id, "qode_page-title-background-color", true) != ""){
    $title_background_color = get_post_meta($id, "qode_page-title-background-color", true);
}else{
    $title_background_color = $qode_options_theme18['title_background_color'];
}

$show_title_image = true;
if(get_post_meta($id, "qode_show-page-title-image", true)) {
    $show_title_image = false;
}
$qode_page_title_style = "standard";
if(get_post_meta($id, "qode_page_title_style", true) != ""){
    $qode_page_title_style = get_post_meta($id, "qode_page_title_style", true);
}else{
    if(isset($qode_options_theme18['title_style'])) {
        $qode_page_title_style = $qode_options_theme18['title_style'];
    } else {
        $qode_page_title_style = "standard";
    }
}

$animate_title_area = '';
if(get_post_meta($id, "qode_animate-page-title", true) != ""){
    $animate_title_area = get_post_meta($id, "qode_animate-page-title", true);
}else{
    $animate_title_area = $qode_options_theme18['animate_title_area'];
}

if($animate_title_area == "text_right_left") {
    $animate_title_class = "animate_title_text";
}elseif($animate_title_area == "fade_in_title_text"){
    $animate_title_class = "fade_in_title_text";
}elseif($animate_title_area == "area_top_bottom"){
    $animate_title_class = "animate_title_area";
} elseif($animate_title_area == "area_top_bottom_with_title_fade_in"){
    $animate_title_class = "animate_title_area with_fade_in_text";
}else {
    $animate_title_class = "title_without_animation";
}

//init variables
$title_subtitle_padding 	= '';
$header_transparency 		= '';
$is_header_transparent  	= false;
$transparent_values_array 	= array('0.00', '0');
$solid_values_array			= array('', '1');
$header_bottom_border		= '';

//is header transparent not set on current page?
if(get_post_meta($id, "qode_header_color_transparency_per_page", true) === "") {
    //take global value set in Qode Options
    $header_transparency = $qode_options_theme18['header_background_transparency_initial'];
} else {
    //take value set for current page
    $header_transparency = get_post_meta($id, "qode_header_color_transparency_per_page", true);
}

//is border bottom color for header set in Qode Options?
if(isset($qode_options_theme18['header_bottom_border_color']) && !empty($qode_options_theme18['header_bottom_border_color'])) {
    $header_bottom_border = $qode_options_theme18['header_bottom_border_color'];
}

//is header completely transparent?
$is_header_transparent 	= in_array($header_transparency, $transparent_values_array);

//is header solid?
$is_header_solid		= in_array($header_transparency, $solid_values_array);

//is header solid?
if($is_header_solid) {
    $title_holder_height = 'style="padding-top:' . $header_height_padding . 'px; height:' . ($title_height - $header_height_padding) . 'px;"';
    $title_subtitle_padding = 'style="padding-top:' . $header_height_padding . 'px;"';
} else {

    //is border for header bottom set?
    if ($header_bottom_border != '') {

        //center title between header and end of title section
        $title_holder_height = 'style="padding-top:' . $header_height_padding . 'px; height:' . ($title_height - $header_height_padding) . 'px;"';
        $title_subtitle_padding = 'style="padding-top:' . $header_height_padding . 'px;"';
    } else {

        //is header semi-transparent?
        if(!$is_header_transparent) {
            //center title between border and end of title section
            $title_holder_height = 'style="padding-top:' . $header_height_padding . 'px; height:' . ($title_height - $header_height_padding) . 'px;"';
            $title_subtitle_padding = 'style="padding-top:' . $header_height_padding . 'px;"';
        } else {
            //header is transparent. Center it between main menu item's text beginning and end of title section
            $title_holder_height = 'style="padding-top:'.(($header_height/2 - $nav_font_size) + $header_top) .'px; height:' . ($title_height - ($header_height/2 - $nav_font_size + $header_top)) . 'px;"';
            $title_subtitle_padding = 'style="padding-top:'.(($header_height/2 - $nav_font_size) + $header_top) .'px;"';
        }
    }
}

//is vertical menu activated in Qode Options?
if(isset($qode_options_theme18['vertical_area']) && $qode_options_theme18['vertical_area'] =='yes'){
    $title_subtitle_padding = 0;
    $title_holder_height = 430;
    if($title_type == "breadcrumbs_title") {
        $title_holder_height = 102;
    }
    $title_height = 430; // default title height without header height
    if($title_type == "breadcrumbs_title") {
        $title_height = 102;
    }
    if(get_post_meta($id, "qode_title-height", true) != ""){
        $title_holder_height = get_post_meta($id, "qode_title-height", true);
        $title_height = get_post_meta($id, "qode_title-height", true);
    }else if($qode_options_theme18['title_height'] != ''){
        $title_holder_height = $qode_options_theme18['title_height'];
        $title_height = $qode_options_theme18['title_height'];
    }
    $title_holder_height = 'style="height:' . $title_holder_height . 'px;"';
}

$page_title_position = 'left';
if(get_post_meta($id, "qode_page_title_position", true) != ""){
    $page_title_position = " position_" . get_post_meta($id, "qode_page_title_position", true);
}else{
    $page_title_position = " position_" . $qode_options_theme18['page_title_position'];
}

$enable_breadcrumbs = 'no';
if(get_post_meta($id, "qode_enable_breadcrumbs", true) != ""){
    $enable_breadcrumbs = get_post_meta($id, "qode_enable_breadcrumbs", true);
}elseif(isset($qode_options_theme18['enable_breadcrumbs'])){
    $enable_breadcrumbs = $qode_options_theme18['enable_breadcrumbs'];
}

$title_text_shadow = '';
if(get_post_meta($id, "qode_title_text_shadow", true) != ""){
    if(get_post_meta($id, "qode_title_text_shadow", true) == "yes"){
        $title_text_shadow = ' title_text_shadow';
    }
}else{
    if($qode_options_theme18['title_text_shadow'] == "yes"){
        $title_text_shadow = ' title_text_shadow';
    }
}

$title_text_background_class = '';
if(get_post_meta($id, "qode_page-title-text-background", true) != ""){
    if(get_post_meta($id, "qode_page-title-text-background", true) == "yes"){
        $title_text_background_class = ' title_text_background';
    }
}else{
    if($qode_options_theme18['page_title_text_background'] == "yes"){
        $title_text_background_class = ' title_text_background';
    }
}

$title_color = "";
if(get_post_meta($id, "qode_page-title-color", true) != '') {
    $title_color = 'color:'.get_post_meta($id, "qode_page-title-color", true).';';
}

$title_text_background_color = '';
if(get_post_meta($id, "qode_page-title-text-background-color", true) != '') {
    $title_background_color_rgb = qode_hex2rgb(get_post_meta($id, "qode_page-title-text-background-color", true));
    $title_text_background_color = 'background-color:rgba('.$title_background_color_rgb[0].','.$title_background_color_rgb[1].','.$title_background_color_rgb[2].',0.8);';
}else{
    if($qode_options_theme18['page_title_text_background_color'] != ""){
        $title_background_color_rgb = qode_hex2rgb($qode_options_theme18['page_title_text_background_color']);
        $title_text_background_color = 'background-color:rgba('.$title_background_color_rgb[0].','.$title_background_color_rgb[1].','.$title_background_color_rgb[2].',0.8);';
    }
}

$title_font_style = "";
if(get_post_meta($id, "qode_page_title_font_style", true) != '') {
    $title_font_style = 'font-style:'.get_post_meta($id, "qode_page_title_font_style", true).';';
}

$title_style = "";
if($title_color != "" || $title_font_style != "" || $title_text_background_color != ""){
    $title_style = 'style="'.$title_color.$title_text_background_color.$title_font_style.'"';
}

$subtitle_color ="";
if(get_post_meta($id, "qode_page_subtitle_color", true) != ""){
    $subtitle_color = " style='color:" . get_post_meta($id, "qode_page_subtitle_color", true) . "';";
} else {
    $subtitle_color = "";
}

if (is_tag()) {
    $title = single_term_title("", false)." Tag";
}elseif (is_date()) {
    $title = get_the_time('F Y');
}elseif (is_author()){
    $title = "Author: ".get_the_author();
}elseif (is_category()){
    $title = single_cat_title('', false);
}elseif (is_home()){
    $title = get_option('blogname');
}elseif (is_search()){
    $title = __('Search', 'qode');
}elseif (is_404()){
    if($qode_options_theme18['404_title'] != "") {
        $title = $qode_options_theme18['404_title'];
    } else {
        $title = __('404 - Page not found', 'qode');
    }
}elseif(function_exists("is_woocommerce") && (is_shop() || is_singular('product'))){
    global $woocommerce;
    $shop_id = get_option('woocommerce_shop_page_id');
    $shop= get_page($shop_id);
    $title = $shop->post_title;
}elseif(function_exists("is_woocommerce") && (is_product_category() || is_product_tag())){
    global $wp_query;
    $tax = $wp_query->get_queried_object();
    $category_title = $tax->name;
    $title = $category_title;
}elseif (is_archive()){
    $title = __('Archive','qode');
}else {
    $title = get_the_title($id);
}
if(!get_post_meta($id, "qode_show-page-title", true)) { ?>
    <div class="title_outer <?php echo $animate_title_class.$title_text_shadow; if($responsive_title_image == 'yes' && $show_title_image == true){ echo ' with_image'; }?>" <?php echo 'data-height="'.$title_height.'"'; if($title_height != '' && ($animate_title_area == 'area_top_bottom' || $animate_title_area == 'area_top_bottom_with_title_fade_in')){ echo 'style="opacity:0;height:' . $header_height_padding .'px;"'; } ?>>
        <div class="title <?php echo $page_title_position.' '.$title_type.$title_image_class; if($responsive_title_image == 'no' && $title_image != "" && ($fixed_title_image == "yes" || $fixed_title_image == "yes_zoom") && $show_title_image == true){ echo ' has_fixed_background '; if($fixed_title_image == "yes_zoom"){ echo 'zoom_out '; } } if($responsive_title_image == 'no' && $title_image != "" && $fixed_title_image == "no" && $show_title_image == true){ echo ' has_background'; }  ?> <?php echo $title_text_background_class; ?>" style="<?php if($responsive_title_image == 'no' && $title_image != "" && $show_title_image == true){ if($title_image_width != ''){ echo 'background-size:'.$title_image_width.'px auto;'; } echo 'background-image:url('.$title_image.');';  } if($title_height != ''){ echo 'height:'.$title_height.'px;'; } if($title_background_color != ''){ echo 'background-color:'.$title_background_color.';'; } ?>">
            
            <div class="image <?php if($responsive_title_image == 'yes' && $title_image != "" && $show_title_image == true){ echo "responsive"; }else{ echo "not_responsive"; } ?>"><?php if($title_image != ""){ ?><img src="<?php echo $title_image; ?>" alt="&nbsp;" /> <?php } ?></div>
            <?php if($title_overlay_image != ""){ ?>
                <div class="title_overlay" style="background-image:url('<?php echo $title_overlay_image; ?>');"></div>
            <?php } ?>

            <?php if(!get_post_meta($id, "qode_show-page-title-text", true)) { ?>
                <div class="title_holder" <?php if($responsive_title_image != 'yes' && get_post_meta($id, "qode_show-page-title-image", true) == ""){ echo $title_holder_height; }?>>
                    <div class="container">
                        <div class="container_inner clearfix">
                            <div class="title_subtitle_holder" <?php if($responsive_title_image == 'yes' && $show_title_image == true){ echo $title_subtitle_padding; }?>>
                                <?php if(($responsive_title_image == 'yes' && $show_title_image == true) || ($fixed_title_image == "yes" || $fixed_title_image == "yes_zoom") || ($responsive_title_image == 'no' && $title_image != "" && $fixed_title_image == "no" && $show_title_image == true)){ ?>
                                    <div class="title_subtitle_holder_inner">
                                <?php } ?>

                                        <?php if($title_type != "breadcrumbs_title") { ?>

                                            <h1 <?php echo $title_style; ?>><span><?php echo $title; ?></span></h1>

                                            <?php if(get_post_meta($id, "qode_page_subtitle", true) != ""){ ?>
                                                <h3 class="subtitle" <?php echo $subtitle_color; ?>><?php echo get_post_meta($id, "qode_page_subtitle", true); ?></h3>
                                            <?php } ?>
                                            <?php if (function_exists('qode_custom_breadcrumbs') && $enable_breadcrumbs == "yes") { ?>
                                                <div class="breadcrumb"> <?php qode_custom_breadcrumbs(); ?></div>
                                            <?php } ?>

                                        <?php } else { ?>

                                            <div class="breadcrumb"> <?php qode_custom_breadcrumbs(); ?></div>

                                        <?php } ?>
                                
                                <?php if(($responsive_title_image == 'yes' && $show_title_image == true)  || ($fixed_title_image == "yes" || $fixed_title_image == "yes_zoom") || ($responsive_title_image == 'no' && $title_image != "" && $fixed_title_image == "no" && $show_title_image == true)){ ?>
                                    </div>
                                <?php } ?>
                            </div>    
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>
    </div>
<?php } ?>
<?php
/* Return id for archive pages */
if(is_category() || is_tag() || is_author()){
    $id = $archive_id;
}
?>