<?php
global $qode_options_theme18;

$porftolio_categories = 'yes';
if(get_post_meta(get_the_ID(), "qode_show-portfolio-categories", true) != ""){
	$porftolio_categories = get_post_meta(get_the_ID(), "qode_show-portfolio-categories", true);
}else{
	if(isset($qode_options_theme18['portfolio_categories']) && $qode_options_theme18['portfolio_categories'] != ""){
		$porftolio_categories = $qode_options_theme18['portfolio_categories'];
	}
}

$portfolio_qode_like = "on";
if (isset($qode_options_theme18['portfolio_qode_like'])) {
	$portfolio_qode_like = $qode_options_theme18['portfolio_qode_like'];
}

?>

<?php echo do_shortcode('[social_share_simple]'); ?>

<?php

$portfolios = get_post_meta(get_the_ID(), "qode_portfolios", true);
if ($portfolios){
	usort($portfolios, "comparePortfolioOptions");
	foreach($portfolios as $portfolio){	
	?>
		<div class="info q_custom_info">
			<?php if($portfolio['optionLabel'] != ""): ?>
				<h5><?php echo stripslashes($portfolio['optionLabel']); ?></h5>
			<?php endif; ?>
			<p>
				<?php if($portfolio['optionUrl'] != ""): ?>
					<a href="<?php echo $portfolio['optionUrl']; ?>" target="_blank">
					<?php echo do_shortcode(stripslashes($portfolio['optionValue'])); ?>
					</a>
				<?php else:?>
					<?php echo do_shortcode(stripslashes($portfolio['optionValue'])); ?>
				<?php endif; ?>
			</p>
		</div>
	<?php						
	}
}
?>

<?php if(get_post_meta(get_the_ID(), "qode_portfolio_date", true)) : ?>

	<div class="info q_date_info">
		<h5><?php _e('DATE:','qode'); ?></h5>
		<p><?php echo get_post_meta(get_the_ID(), "qode_portfolio_date", true); ?></p>
	</div>

<?php endif; ?>

<?php if($porftolio_categories == 'yes'){ ?>
	<div class="info q_category_info">
		<h5><?php _e('CATEGORY:','qode'); ?></h5>
		<span class="category">
			<?php
				$terms = wp_get_post_terms(get_the_ID(),'portfolio_category');
				$counter = 0;
				$all = count($terms);
				foreach($terms as $term) {
					$counter++;
					if($counter < $all){ $after = ', ';}
					else{ $after = ''; }
					echo $term->name.$after;
				}
			?>
		</span>
	</div>
<?php } ?>

<?php if($portfolio_qode_like == "on") { ?>
	<div class="portfolio_single_like"><?php if( function_exists('qode_like') ) qode_like(); ?></div>
<?php } ?>
