<?php 
global $qode_options_theme18;
$blog_hide_comments = "";
if (isset($qode_options_theme18['blog_hide_comments'])) {
	$blog_hide_comments = $qode_options_theme18['blog_hide_comments'];
}
$blog_author_info="no";
if (isset($qode_options_theme18['blog_author_info'])) {
	$blog_author_info = $qode_options_theme18['blog_author_info'];
}
$qode_like = "on";
if (isset($qode_options_theme18['qode_like'])) {
	$qode_like = $qode_options_theme18['qode_like'];
}
$blog_hide_post_title = "";
if (isset($qode_options_theme18['blog_hide_post_title'])) {
	$blog_hide_post_title = $qode_options_theme18['blog_hide_post_title'];
}

$_post_format = get_post_format();
?>
<?php
	switch ($_post_format) {
		case "video":
?>
		<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
			<div class="post_image">
				<?php $_video_type = get_post_meta(get_the_ID(), "video_format_choose", true);?>
				<?php if($_video_type == "youtube") { ?>
					<iframe src="https://www.youtube.com/embed/<?php echo get_post_meta(get_the_ID(), "video_format_link", true);  ?>?wmode=transparent" wmode="Opaque" frameborder="0" allowfullscreen></iframe>
				<?php } elseif ($_video_type == "vimeo"){ ?>
					<iframe src="https://player.vimeo.com/video/<?php echo get_post_meta(get_the_ID(), "video_format_link", true);  ?>?title=0&amp;byline=0&amp;portrait=0" frameborder="0" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>
				<?php } elseif ($_video_type == "self"){ ?> 
					<div class="video"> 
					<div class="mobile-video-image" style="background-image: url(<?php echo get_post_meta(get_the_ID(), "video_format_image", true);  ?>);"></div> 
					<div class="video-wrap"  > 
						<video class="video" poster="<?php echo get_post_meta(get_the_ID(), "video_format_image", true);  ?>" preload="auto"> 
							<?php if(get_post_meta(get_the_ID(), "video_format_webm", true) != "") { ?> <source type="video/webm" src="<?php echo get_post_meta(get_the_ID(), "video_format_webm", true);  ?>"> <?php } ?> 
							<?php if(get_post_meta(get_the_ID(), "video_format_mp4", true) != "") { ?> <source type="video/mp4" src="<?php echo get_post_meta(get_the_ID(), "video_format_mp4", true);  ?>"> <?php } ?> 
							<?php if(get_post_meta(get_the_ID(), "video_format_ogv", true) != "") { ?> <source type="video/ogg" src="<?php echo get_post_meta(get_the_ID(), "video_format_ogv", true);  ?>"> <?php } ?> 
							<object width="320" height="240" type="application/x-shockwave-flash" data="<?php echo get_template_directory_uri(); ?>/js/flashmediaelement.swf"> 
								<param name="movie" value="<?php echo get_template_directory_uri(); ?>/js/flashmediaelement.swf" /> 
								<param name="flashvars" value="controls=true&file=<?php echo get_post_meta(get_the_ID(), "video_format_mp4", true);  ?>" /> 
								<img src="<?php echo get_post_meta(get_the_ID(), "video_format_image", true);  ?>" width="1920" height="800" title="No video playback capabilities" alt="Video thumb" /> 
							</object> 
						</video>   
					</div></div> 
				<?php } ?>
			</div>
			<div class="post_text">
				
				<?php if(get_post_meta(get_the_ID(), "qode_show-post-title", true) != "yes" && $blog_hide_post_title != "yes") { ?>
				<h2><?php the_title(); ?></h2>
				<?php } ?>

				<div class="post_info_single">
					<span class="post_author">
						<span class="fs1" aria-hidden="true" data-icon="&#x6a;"></span>
						<?php if(get_the_author_meta('first_name') == "" || get_the_author_meta('last_name') == "") { ?>
							<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('display_name'); ?></a></span>
						<?php } else {?>
							<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('first_name'); ?> <?php the_author_meta('last_name'); ?></a></span>
						<?php } ?>
					</span>
					<span class="post_date">
						<span class="fs1" aria-hidden="true" data-icon="&#xe06b;"></span>
						<?php the_time('d F Y'); ?>
					</span>
					<span class="post_category">
						<span class="fs1" aria-hidden="true" data-icon="&#xe07b;"></span>
						<span class="post_info_small">
							<span><?php the_category('/'); ?></span>
						</span>
					</span>
					<?php if( $qode_like == "on" ) { ?>
						<span class="blog_like">
							 <?php if(function_exists('qode_like')) { qode_like(); } ?>
						</span>
					<?php } ?>
				</div>
				<?php the_content(); ?>
                <div class="clear"></div>
			</div>
			<div class="post_social">
				<?php echo do_shortcode('[social_share_simple]'); ?>
			</div>
<?php
		break;
		case "audio":
?>
		<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
			<div class="post_image">
				<div class="post_box_holder">
					<div class="post_box_table">
						<div class="post_box_text">	
							<audio class="blog_audio_holder" src="<?php echo get_post_meta(get_the_ID(), "audio_link", true) ?>" controls="controls">
								<?php _e("Your browser don't support audio player","qode"); ?>
							</audio>
						</div>	
					</div>
				</div>
			</div>
			<div class="post_text">

				<?php if(get_post_meta(get_the_ID(), "qode_show-post-title", true) != "yes" && $blog_hide_post_title != "yes") { ?>
				<h2><?php the_title(); ?></h2>
				<?php } ?>

				<div class="post_info_single">
					<span class="post_author">
						<span class="fs1" aria-hidden="true" data-icon="&#x6a;"></span>
						<?php if(get_the_author_meta('first_name') == "" || get_the_author_meta('last_name') == "") { ?>
							<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('display_name'); ?></a></span>
						<?php } else {?>
							<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('first_name'); ?> <?php the_author_meta('last_name'); ?></a></span>
						<?php } ?>
					</span>
					<span class="post_date">
						<span class="fs1" aria-hidden="true" data-icon="&#xe06b;"></span>
						<?php the_time('d F Y'); ?>
					</span>
					<span class="post_category">
						<span class="fs1" aria-hidden="true" data-icon="&#xe07b;"></span>
						<span class="post_info_small">
							<span><?php the_category('/'); ?></span>
						</span>
					</span>
					<?php if( $qode_like == "on" ) { ?>
						<span class="blog_like">
							 <?php if(function_exists('qode_like')) { qode_like(); } ?>
						</span>
					<?php } ?>
				</div>
				<?php the_content(); ?>
                <div class="clear"></div>
			</div>
			<div class="post_social">
				<?php echo do_shortcode('[social_share_simple]'); ?>
			</div>
<?php
		break;
		case "link":
?>
		<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
			<div class="post_image">
				<div class="post_box_holder">
					<div class="post_box_table">
						<div class="post_box_text">	
							<div class="link_mark">
								<span class="icon_link" aria-hidden="true"></span>
							</div>
							<div class="post_title">
								<h4><?php the_title(); ?></h4>
							</div>
						</div>	
					</div>
				</div>
			</div>
			<div class="post_text">
				<div class="post_info_single">
					<span class="post_author">
						<span class="fs1" aria-hidden="true" data-icon="&#x6a;"></span>
						<?php if(get_the_author_meta('first_name') == "" || get_the_author_meta('last_name') == "") { ?>
							<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('display_name'); ?></a></span>
						<?php } else {?>
							<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('first_name'); ?> <?php the_author_meta('last_name'); ?></a></span>
						<?php } ?>
					</span>
					<span class="post_date">
						<span class="fs1" aria-hidden="true" data-icon="&#xe06b;"></span>
						<?php the_time('d F Y'); ?>
					</span>
					<span class="post_category">
						<span class="fs1" aria-hidden="true" data-icon="&#xe07b;"></span>
						<span class="post_info_small">
							<span><?php the_category('/'); ?></span>
						</span>
					</span>
					<?php if( $qode_like == "on" ) { ?>
						<span class="blog_like">
							 <?php if(function_exists('qode_like')) { qode_like(); } ?>
						</span>
					<?php } ?>
				</div>
				<?php the_content(); ?>
                <div class="clear"></div>
			</div>
			<div class="post_social">
				<?php echo do_shortcode('[social_share_simple]'); ?>
			</div>
<?php
		break;
		case "gallery":
?>
		<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
			<div class="post_image">
				<div class="flexslider">
					<ul class="slides">
						<?php
							$post_content = get_the_content();
							preg_match('/\[gallery.*ids=.(.*).\]/', $post_content, $ids);
							$array_id = explode(",", $ids[1]);
							
							$content =  str_replace($ids[0], "", $post_content);
							$filtered_content = apply_filters( 'the_content', $content);
							
							foreach($array_id as $img_id){ ?>
								<li><?php echo wp_get_attachment_image( $img_id, 'blog_image_in_grid' ); ?></li>
							<?php } ?>
					</ul>
				</div>
			</div>
			<div class="post_text">

				<?php if(get_post_meta(get_the_ID(), "qode_show-post-title", true) != "yes" && $blog_hide_post_title != "yes") { ?>
				<h2><?php the_title(); ?></h2>
				<?php } ?>

				<div class="post_info_single">
					<span class="post_author">
						<span class="fs1" aria-hidden="true" data-icon="&#x6a;"></span>
						<?php if(get_the_author_meta('first_name') == "" || get_the_author_meta('last_name') == "") { ?>
							<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('display_name'); ?></a></span>
						<?php } else {?>
							<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('first_name'); ?> <?php the_author_meta('last_name'); ?></a></span>
						<?php } ?>
					</span>
					<span class="post_date">
						<span class="fs1" aria-hidden="true" data-icon="&#xe06b;"></span>
						<?php the_time('d F Y'); ?>
					</span>
					<span class="post_category">
						<span class="fs1" aria-hidden="true" data-icon="&#xe07b;"></span>
						<span class="post_info_small">
							<span><?php the_category('/'); ?></span>
						</span>
					</span>
					<?php if( $qode_like == "on" ) { ?>
						<span class="blog_like">
							 <?php if(function_exists('qode_like')) { qode_like(); } ?>
						</span>
					<?php } ?>
				</div>
				<?php echo do_shortcode($filtered_content); ?>
			</div>	
			<div class="post_social">
				<?php echo do_shortcode('[social_share_simple]'); ?>
			</div>
<?php
		break;
		case "quote":
?>
		<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
			<div class="post_image">
				<div class="post_box_holder">
					<div class="post_box_table">
						<div class="post_box_text">	
							<div class="qoute_mark">
								<span aria-hidden="true" class="icon_quotations"></span>
							</div>
							<div class="post_title">
								<h4><?php echo get_post_meta(get_the_ID(), "quote_format", true); ?></h4>
								<span class="quote_author">&mdash; <?php the_title(); ?></span>
							</div>
						</div>	
					</div>
				</div>
			</div>
			<div class="post_text">
				<div class="post_info_single">
					<span class="post_author">
						<span class="fs1" aria-hidden="true" data-icon="&#x6a;"></span>
						<?php if(get_the_author_meta('first_name') == "" || get_the_author_meta('last_name') == "") { ?>
							<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('display_name'); ?></a></span>
						<?php } else {?>
							<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('first_name'); ?> <?php the_author_meta('last_name'); ?></a></span>
						<?php } ?>
					</span>
					<span class="post_date">
						<span class="fs1" aria-hidden="true" data-icon="&#xe06b;"></span>
						<?php the_time('d F Y'); ?>
					</span>
					<span class="post_category">
						<span class="fs1" aria-hidden="true" data-icon="&#xe07b;"></span>
						<span class="post_info_small">
							<span><?php the_category('/'); ?></span>
						</span>
					</span>
					<?php if( $qode_like == "on" ) { ?>
						<span class="blog_like">
							 <?php if(function_exists('qode_like')) { qode_like(); } ?>
						</span>
					<?php } ?>
				</div>
				<?php the_content(); ?>
                <div class="clear"></div>
			</div>
			<div class="post_social">
				<?php echo do_shortcode('[social_share_simple]'); ?>
			</div>
<?php
		break;
		default:
?>
		<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
			<?php if(get_post_meta(get_the_ID(), "qode_hide-featured-image", true) != "yes") {
				if ( has_post_thumbnail() ) { ?>
					<div class="post_image">
                        <?php the_post_thumbnail('blog_image_in_grid'); ?>
					</div>
			<?php } } ?>
			<div class="post_text">

				<?php if(get_post_meta(get_the_ID(), "qode_show-post-title", true) != "yes" && $blog_hide_post_title != "yes") { ?>
				<h2><?php the_title(); ?></h2>
				<?php } ?>

				<div class="post_info_single">
					<span class="post_author">
						<span class="fs1" aria-hidden="true" data-icon="&#x6a;"></span>
						<?php if(get_the_author_meta('first_name') == "" || get_the_author_meta('last_name') == "") { ?>
							<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('display_name'); ?></a></span>
						<?php } else {?>
							<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('first_name'); ?> <?php the_author_meta('last_name'); ?></a></span>
						<?php } ?>
					</span>
					<span class="post_date">
						<span class="fs1" aria-hidden="true" data-icon="&#xe06b;"></span>
						<?php the_time('d F Y'); ?>
					</span>
					<span class="post_category">
						<span class="fs1" aria-hidden="true" data-icon="&#xe07b;"></span>
						<span class="post_info_small">
							<span><?php the_category('/'); ?></span>
						</span>
					</span>
					<?php if( $qode_like == "on" ) { ?>
						<span class="blog_like">
							 <?php if(function_exists('qode_like')) { qode_like(); } ?>
						</span>
					<?php } ?>
				</div>
				
				<?php the_content(); ?>
                <div class="clear"></div>
			</div>	
			<div class="post_social">
				<?php echo do_shortcode('[social_share_simple]'); ?>
			</div>
<?php
}
?>
	<?php if( has_tag()) { ?>
		<div class="single_tags clearfix">
            <div class="tags_text"><h4>Tags:</h4></div>
			<?php the_tags('', '', ''); ?>
		</div>
	<?php } ?>				
	<?php 
		$args_pages = array(
			'before'           => '<p class="single_links_pages">',
			'after'            => '</p>',
			'link_before'      => '<span>',
			'link_after'       => '</span>',
			'pagelink'         => '%'
		);

		wp_link_pages($args_pages);
	?>
<?php if($blog_author_info == "yes") { ?>
	<div class="author_description">
		<div class="author_description_inner">
			<div class="image">
				<?php echo get_avatar(get_the_author_meta( 'ID' ), 160); ?>
			</div>
			<div class="author_text_holder">
				<h4 class="author_name">
				<?php  
					if(get_the_author_meta('first_name') != "" || get_the_author_meta('last_name') != "") {
						echo get_the_author_meta('first_name') . " " . get_the_author_meta('last_name');
					} else {
						echo get_the_author_meta('display_name');
					}
				?>
				</h4>
				<?php if(get_the_author_meta('description') != "") { ?>
					<div class="author_text">
						<p><?php echo get_the_author_meta('description') ?></p>
					</div>
				<?php } ?>
			</div>
		</div>
	</div>
<?php } ?>
</article>