<?php 
global $qode_options_theme18;
$blog_hide_comments = "";
if (isset($qode_options_theme18['blog_hide_comments'])) {
	$blog_hide_comments = $qode_options_theme18['blog_hide_comments'];
}
$qode_like = "on";
if (isset($qode_options_theme18['qode_like'])) {
	$qode_like = $qode_options_theme18['qode_like'];
}
?>
<?php
$_post_format = get_post_format();
?>
<?php
	switch ($_post_format) {
		case "video":
?>
		<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
			<div class="post_info_holder">
				<div class="post_info">
					<div class="post_info_inner">
						<span class="post_date">
							<span class="post_info_large"><?php the_time('d'); ?></span>
							<span class="post_info_small">
								<span><?php the_time('F'); ?></span>
								<span ><?php the_time('Y'); ?></span>
							</span>
						</span>
						<span class="post_author">
							<span class="post_info_large"><?php _e('By', 'qode'); ?></span>
							<span class="post_info_small">
							<?php if(get_the_author_meta('first_name') == "" || get_the_author_meta('last_name') == "") { ?>
								<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('display_name'); ?></a></span>
							<?php } else {?>
								<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('first_name'); ?></a></span>
								<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('last_name'); ?></a></span>
							<?php } ?>
							</span>
						</span>
						<span class="post_category">
							<span class="post_info_large"><?php _e('In', 'qode'); ?></span>
							<span class="post_info_small">
								<span><?php the_category(' '); ?></span>
							</span>
						</span>
					</div>
				</div>
			</div>
			<div class="post_image">
				<?php $_video_type = get_post_meta(get_the_ID(), "video_format_choose", true);?>
				<?php if($_video_type == "youtube") { ?>
					<iframe  src="https://www.youtube.com/embed/<?php echo get_post_meta(get_the_ID(), "video_format_link", true);  ?>?wmode=transparent" wmode="Opaque" frameborder="0" allowfullscreen></iframe>
				<?php } elseif ($_video_type == "vimeo"){ ?>
					<iframe src="https://player.vimeo.com/video/<?php echo get_post_meta(get_the_ID(), "video_format_link", true);  ?>?title=0&amp;byline=0&amp;portrait=0" frameborder="0" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>
				<?php } elseif ($_video_type == "self"){ ?> 
					<div class="video"> 
					<div class="mobile-video-image" style="background-image: url(<?php echo get_post_meta(get_the_ID(), "video_format_image", true);  ?>);"></div> 
					<div class="video-wrap"  > 
						<video class="video" poster="<?php echo get_post_meta(get_the_ID(), "video_format_image", true);  ?>" preload="auto"> 
							<?php if(get_post_meta(get_the_ID(), "video_format_webm", true) != "") { ?> <source type="video/webm" src="<?php echo get_post_meta(get_the_ID(), "video_format_webm", true);  ?>"> <?php } ?> 
							<?php if(get_post_meta(get_the_ID(), "video_format_mp4", true) != "") { ?> <source type="video/mp4" src="<?php echo get_post_meta(get_the_ID(), "video_format_mp4", true);  ?>"> <?php } ?> 
							<?php if(get_post_meta(get_the_ID(), "video_format_ogv", true) != "") { ?> <source type="video/ogg" src="<?php echo get_post_meta(get_the_ID(), "video_format_ogv", true);  ?>"> <?php } ?> 
							<object width="320" height="240" type="application/x-shockwave-flash" data="<?php echo get_template_directory_uri(); ?>/js/flashmediaelement.swf"> 
								<param name="movie" value="<?php echo get_template_directory_uri(); ?>/js/flashmediaelement.swf" /> 
								<param name="flashvars" value="controls=true&file=<?php echo get_post_meta(get_the_ID(), "video_format_mp4", true);  ?>" /> 
								<img src="<?php echo get_post_meta(get_the_ID(), "video_format_image", true);  ?>" width="1920" height="800" title="No video playback capabilities" alt="Video thumb" /> 
							</object> 
						</video>   
					</div></div> 
				<?php } ?>
			</div>
			<div class="post_text">
				<h2><a href="<?php the_permalink(); ?>" target="_self" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h2>
				<?php the_content(); ?>
			</div>
		</article>
<?php
		break;
		case "audio":
?>
		<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
			<div class="post_info_holder">
				<div class="post_info">
					<div class="post_info_inner">
						<span class="post_date">
							<span class="post_info_large"><?php the_time('d'); ?></span>
							<span class="post_info_small">
								<span><?php the_time('F'); ?></span>
								<span ><?php the_time('Y'); ?></span>
							</span>
						</span>
						<span class="post_author">
							<span class="post_info_large"><?php _e('By', 'qode'); ?></span>
							<span class="post_info_small">
							<?php if(get_the_author_meta('first_name') == "" || get_the_author_meta('last_name') == "") { ?>
								<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('display_name'); ?></a></span>
							<?php } else {?>
								<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('first_name'); ?></a></span>
								<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('last_name'); ?></a></span>
							<?php } ?>
							</span>
						</span>
						<span class="post_category">
							<span class="post_info_large"><?php _e('In', 'qode'); ?></span>
							<span class="post_info_small">
								<span><?php the_category(' '); ?></span>
							</span>
						</span>
					</div>
				</div>
			</div>
			<div class="post_image">
				<div class="post_box_holder">
					<div class="post_box_table">
						<div class="post_box_text">	
							<audio class="blog_audio_holder" src="<?php echo get_post_meta(get_the_ID(), "audio_link", true) ?>" controls="controls">
								<?php _e("Your browser don't support audio player","qode"); ?>
							</audio>
						</div>	
					</div>
				</div>
			</div>
			<div class="post_text">
				<h2><a href="<?php the_permalink(); ?>" target="_self" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h2>
				<?php the_content(); ?>
			</div>
		</article>
<?php
		break;
		case "link":
?>
		<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
			<div class="post_info_holder">
				<div class="post_info">
					<div class="post_info_inner">
						<span class="post_date">
							<span class="post_info_large"><?php the_time('d'); ?></span>
							<span class="post_info_small">
								<span><?php the_time('F'); ?></span>
								<span ><?php the_time('Y'); ?></span>
							</span>
						</span>
						<span class="post_author">
							<span class="post_info_large"><?php _e('By', 'qode'); ?></span>
							<span class="post_info_small">
							<?php if(get_the_author_meta('first_name') == "" || get_the_author_meta('last_name') == "") { ?>
								<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('display_name'); ?></a></span>
							<?php } else {?>
								<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('first_name'); ?></a></span>
								<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('last_name'); ?></a></span>
							<?php } ?>
							</span>
						</span>
						<span class="post_category">
							<span class="post_info_large"><?php _e('In', 'qode'); ?></span>
							<span class="post_info_small">
								<span><?php the_category(' '); ?></span>
							</span>
						</span>
					</div>
				</div>
			</div>
			<div class="post_image">
				<div class="post_box_holder">
					<div class="post_box_table">
						<div class="post_box_text">	
							<div class="link_mark">
								<span class="icon_link" aria-hidden="true"></span>
							</div>
							<div class="post_title">
								<h4><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h4>
							</div>
						</div>	
					</div>
				</div>
			</div>
			<div class="post_text">
				<?php the_content(); ?>
			</div>
		</article>
<?php
		break;
		case "gallery":
?>
		<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
			<div class="post_info_holder">
				<div class="post_info">
					<div class="post_info_inner">
						<span class="post_date">
							<span class="post_info_large"><?php the_time('d'); ?></span>
							<span class="post_info_small">
								<span><?php the_time('F'); ?></span>
								<span ><?php the_time('Y'); ?></span>
							</span>
						</span>
						<span class="post_author">
							<span class="post_info_large"><?php _e('By', 'qode'); ?></span>
							<span class="post_info_small">
							<?php if(get_the_author_meta('first_name') == "" || get_the_author_meta('last_name') == "") { ?>
								<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('display_name'); ?></a></span>
							<?php } else {?>
								<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('first_name'); ?></a></span>
								<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('last_name'); ?></a></span>
							<?php } ?>
							</span>
						</span>
						<span class="post_category">
							<span class="post_info_large"><?php _e('In', 'qode'); ?></span>
							<span class="post_info_small">
								<span><?php the_category(' '); ?></span>
							</span>
						</span>
					</div>
				</div>
			</div>
			<div class="post_image">
				<div class="flexslider">
					<ul class="slides">
						<?php
							$post_content = get_the_content();
							preg_match('/\[gallery.*ids=.(.*).\]/', $post_content, $ids);
							$array_id = explode(",", $ids[1]);
							
							$content =  str_replace($ids[0], "", $post_content);
							$filtered_content = apply_filters( 'the_content', $content);
							
							foreach($array_id as $img_id){ ?>
								<li><a href="<?php the_permalink(); ?>"><?php echo wp_get_attachment_image( $img_id, 'blog_image_in_grid' ); ?></a></li>
							<?php } ?>
					</ul>
				</div>
			</div>
			<div class="post_text">
				<h2><a href="<?php the_permalink(); ?>" target="_self" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h2>
				<?php echo do_shortcode($filtered_content); ?>
			</div>
		</article>
<?php
		break;
		case "quote":
?>
			<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
				<div class="post_info_holder">
					<div class="post_info">
						<div class="post_info_inner">
							<span class="post_date">
								<span class="post_info_large"><?php the_time('d'); ?></span>
								<span class="post_info_small">
									<span><?php the_time('F'); ?></span>
									<span ><?php the_time('Y'); ?></span>
								</span>
							</span>
							<span class="post_author">
								<span class="post_info_large"><?php _e('By', 'qode'); ?></span>
								<span class="post_info_small">
								<?php if(get_the_author_meta('first_name') == "" || get_the_author_meta('last_name') == "") { ?>
									<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('display_name'); ?></a></span>
								<?php } else {?>
									<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('first_name'); ?></a></span>
									<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('last_name'); ?></a></span>
								<?php } ?>
								</span>
							</span>
							<span class="post_category">
								<span class="post_info_large"><?php _e('In', 'qode'); ?></span>
								<span class="post_info_small">
									<span><?php the_category(' '); ?></span>
								</span>
							</span>
						</div>
					</div>
				</div>
				<div class="post_image">
					<div class="post_box_holder">
						<div class="post_box_table">
							<div class="post_box_text">	
								<div class="qoute_mark">
									<span aria-hidden="true" class="icon_quotations"></span>
								</div>
								<div class="post_title">
									<h4><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php echo get_post_meta(get_the_ID(), "quote_format", true); ?></a></h4>
									<span class="quote_author">&mdash; <?php the_title(); ?></span>
								</div>
							</div>	
						</div>
					</div>
				</div>
				<div class="post_text">
					<?php the_content(); ?>
				</div>
			</article>
<?php
		break;
		default:
?>
		<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
			<div class="post_info_holder">
				<div class="post_info">
					<div class="post_info_inner">
						<span class="post_date">
							<span class="post_info_large"><?php the_time('d'); ?></span>
							<span class="post_info_small">
								<span><?php the_time('F'); ?></span>
								<span ><?php the_time('Y'); ?></span>
							</span>
						</span>
						<span class="post_author">
							<span class="post_info_large"><?php _e('By', 'qode'); ?></span>
							<span class="post_info_small">
							<?php if(get_the_author_meta('first_name') == "" || get_the_author_meta('last_name') == "") { ?>
								<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('display_name'); ?></a></span>
							<?php } else {?>
								<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('first_name'); ?></a></span>
								<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('last_name'); ?></a></span>
							<?php } ?>
							</span>
						</span>
						<span class="post_category">
							<span class="post_info_large"><?php _e('In', 'qode'); ?></span>
							<span class="post_info_small">
								<span><?php the_category(' '); ?></span>
							</span>
						</span>
					</div>
				</div>
			</div>
			<?php if ( has_post_thumbnail() ) { ?>
				<div class="post_image">
					<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
						<?php the_post_thumbnail('blog_image_in_grid'); ?>
					</a>
				</div>
			<?php } ?>
			<div class="post_text">
				<h2><a href="<?php the_permalink(); ?>" target="_self" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h2>
				<?php the_content(); ?>
			</div>
		</article>
<?php
}
?>