<?php
//$qode_toolbar = true;

load_theme_textdomain( 'qode', get_template_directory().'/languages' );

if(isset($qode_toolbar)):
		
add_action('after_setup_theme', 'qodeStartSession', 1);
add_action('wp_logout', 'qodeEndSession');
add_action('wp_login', 'qodeEndSession');

/* Start session */
if (!function_exists('qodeStartSession')) {
function qodeStartSession() {
    if(!session_id()) {
        session_start();
    }
		if (!empty($_GET['animation']))
			$_SESSION['qode_animation'] = $_GET['animation'];
		if (isset($_SESSION['qode_animation']))
		if ($_SESSION['qode_animation'] == "off")
			$_SESSION['qode_animation'] = "";
}}

/* End session */

if (!function_exists('qodeEndSession')) {
function qodeEndSession() {
    session_destroy ();
}
}

endif;

add_filter('widget_text', 'do_shortcode');

define('QODE_ROOT', get_template_directory_uri());
define('QODE_VAR_PREFIX', 'qode_'); 
include_once('includes/shortcodes/shortcodes.php');
include_once('includes/qode-options.php');
include_once('includes/import/qode-import.php');
//include_once('export/qode-export.php');
include_once('includes/custom-fields.php');
include_once('includes/custom-fields-post-formats.php');
include_once('includes/custom-fields-media-uploader.php');
include_once('includes/qode-breadcrumbs.php');
include_once('includes/nav_menu/qode-menu.php');
include_once('includes/sidebar/qode-custom-sidebar.php');
include_once('includes/qode-custom-post-types.php');
include_once('includes/qode-like.php' );
include_once('includes/qode-custom-taxonomy-field.php');
include_once('includes/qode-plugin-helper-functions.php');
/* Include comment functionality */
include_once('includes/comment/comment.php');
/* Include sidebar functionality */
include_once('includes/sidebar/sidebar.php');
/* Include pagination functionality */
include_once('includes/pagination/pagination.php');
/* Include qode carousel select box for visual composer */
include_once('includes/qode_carousel/qode-carousel.php');
/* Include font awesome icons list */
include_once('includes/font_awesome/font-awesome.php');
/* Include font elegant icons list */
include_once('includes/elegant_icons/elegant-icons.php');
/** Include the TGM_Plugin_Activation class. */
require_once dirname( __FILE__ ) . '/includes/plugins/class-tgm-plugin-activation.php';
/* Include activation for plugins */
include_once('includes/plugins/plugins-activation.php');
include_once('widgets/flickr-qode-widget.php');
include_once('widgets/call_to_action_widget.php');

//does woocommerce function exists?
if(function_exists("is_woocommerce")){
	//include woocommerce configuration
	require_once( 'woocommerce/woocommerce_configuration.php' );
    //include cart dropdown widget
    include_once('widgets/woocommerce-dropdown-cart.php');
}

add_filter( 'call_to_action_widget', 'do_shortcode');

/* Add css */

if (!function_exists('qode_styles')) {
    function qode_styles() {
        global $qode_options_theme18;
        global $wp_styles;
        global $qode_toolbar;
        global $woocommerce;
		global $is_chrome;
        global $is_safari;
		
        wp_enqueue_style("default_style", QODE_ROOT . "/style.css");
        wp_enqueue_style("qode-font-awesome", QODE_ROOT . "/css/font-awesome/css/font-awesome.min.css");
        wp_enqueue_style("elegant-icons", QODE_ROOT . "/css/elegant-icons/style.min.css");
        wp_enqueue_style("stylesheet", QODE_ROOT . "/css/stylesheet.min.css");
		
		preg_match( "#Chrome/(.+?)\.#", $_SERVER['HTTP_USER_AGENT'], $match );
		
		if(!empty($match)){ $version = $match[1];}else{ $version = 0; }
		$mac_os = strpos($_SERVER['HTTP_USER_AGENT'], "Macintosh; Intel Mac OS X");
		
		if($is_chrome && ($mac_os !== false) && ($version > 21)) {
		  wp_enqueue_style("mac_stylesheet", QODE_ROOT . "/css/mac_stylesheet.css");
		}

        if($is_chrome || $is_safari) {
            wp_enqueue_style("webkit", QODE_ROOT . "/css/webkit_stylesheet.css");
        }

        $responsiveness = "yes";
        if (isset($qode_options_theme18['responsiveness']))
            $responsiveness = $qode_options_theme18['responsiveness'];

        if ($woocommerce) {
            wp_enqueue_style("woocommerce", QODE_ROOT . "/css/woocommerce.min.css");
            if ($responsiveness != "no"):
                wp_enqueue_style("woocommerce_responsive", QODE_ROOT . "/css/woocommerce_responsive.min.css");
            endif;
        }

        wp_enqueue_style("style_dynamic", QODE_ROOT . "/css/style_dynamic.php");

        if ($responsiveness != "no"):
            wp_enqueue_style("responsive", QODE_ROOT . "/css/responsive.min.css");
        endif;

        $vertical_area = "no";
        if (isset($qode_options_theme18['vertical_area'])){
            $vertical_area = $qode_options_theme18['vertical_area'];
        }
        if($vertical_area == "yes" && $responsiveness != "no"){
            wp_enqueue_style("vertical_responsive", QODE_ROOT . "/css/vertical_responsive.css");
        }

        if (isset($qode_toolbar)):
            wp_enqueue_style("toolbar", QODE_ROOT . "/css/toolbar.css");
        endif;
            wp_enqueue_style( 'js_composer_front' );
        wp_enqueue_style("custom_css", QODE_ROOT . "/css/custom_css.php");

        $fonts_array  = array(
            $qode_options_theme18['google_fonts'].':200,300,400,600,700,800',
            $qode_options_theme18['page_title_google_fonts'].':200,300,400,600,700,800',
            $qode_options_theme18['h1_google_fonts'].':200,300,400,600,700,800',
            $qode_options_theme18['h2_google_fonts'].':200,300,400,600,700,800',
            $qode_options_theme18['h3_google_fonts'].':200,300,400,600,700,800',
            $qode_options_theme18['h4_google_fonts'].':200,300,400,600,700,800',
            $qode_options_theme18['h5_google_fonts'].':200,300,400,600,700,800',
            $qode_options_theme18['h6_google_fonts'].':200,300,400,600,700,800',
            $qode_options_theme18['text_google_fonts'].':200,300,400,600,700,800',
            $qode_options_theme18['menu_google_fonts'].':200,300,400,600,700,800',
            $qode_options_theme18['dropdown_google_fonts'].':200,300,400,600,700,800',
            $qode_options_theme18['dropdown_google_fonts_thirdlvl'].':200,300,400,600,700,800',
            $qode_options_theme18['fixed_google_fonts'].':200,300,400,600,700,800',
            $qode_options_theme18['sticky_google_fonts'].':200,300,400,600,700,800',
            $qode_options_theme18['mobile_google_fonts'].':200,300,400,600,700,800',
            $qode_options_theme18['mobile_main_google_fonts'].':200,300,400,600,700,800',
            $qode_options_theme18['button_title_google_fonts'].':200,300,400,600,700,800',
            $qode_options_theme18['vertical_menu_google_fonts'].':200,300,400,600,700,800',
            $qode_options_theme18['vertical_dropdown_google_fonts'].':200,300,400,600,700,800',
            $qode_options_theme18['vertical_dropdown_google_fonts_thirdlvl'].':200,300,400,600,700,800',
            $qode_options_theme18['popup_menu_google_fonts'].':200,300,400,600,700,800',
            $qode_options_theme18['popup_menu_google_fonts_2nd'].':200,300,400,600,700,800'
        );

		$args = array( 'post_type' => 'slides', 'posts_per_page' => -1);
		$loop = new WP_Query( $args );
		while ( $loop->have_posts() ) : $loop->the_post();
            if(get_post_meta(get_the_ID(), "qode_slide-subtitle-font-family", true) != ""){
                array_push($fonts_array, get_post_meta(get_the_ID(), "qode_slide-subtitle-font-family", true) . ":300,400,600,700,800");
            }
            if(get_post_meta(get_the_ID(), "qode_slide-title-font-family", true) != ""){
				array_push($fonts_array, get_post_meta(get_the_ID(), "qode_slide-title-font-family", true) . ":300,400,600,700,800");
			}
			if(get_post_meta(get_the_ID(), "qode_slide-text-font-family", true) != ""){
				array_push($fonts_array, get_post_meta(get_the_ID(), "qode_slide-text-font-family", true) . ":300,400,600,700,800");
			}
		endwhile;
		wp_reset_query();
        $fonts_array=array_diff($fonts_array, array("-1:200,300,400,600,700,800"));
        $google_fonts_string = implode( '|', $fonts_array);
        if(count($fonts_array) > 0) :
            printf("<link href='https://fonts.googleapis.com/css?family=Raleway:300,400,500,600,700,800|%s&subset=latin,latin-ext' rel='stylesheet' type='text/css'>\r\n", str_replace(' ', '+', $google_fonts_string));
        else :
            printf("<link href='https://fonts.googleapis.com/css?family=Raleway:300,400,500,600,700,800&subset=latin' rel='stylesheet' type='text/css'>\r\n");
        endif;
    }
}

/* Add js */

if (!function_exists('qode_scripts')) {
    function qode_scripts() {
        global $qode_options_theme18;
        global $is_IE;
		global $is_chrome;
		global $is_opera;
        global $qode_toolbar;
        global $woocommerce;
		
		$smooth_scroll = true;
		if(isset($qode_options_theme18['smooth_scroll']) && $qode_options_theme18['smooth_scroll'] == "no"){
			$smooth_scroll = false;
		}	
		
        wp_enqueue_script("jquery");
        wp_enqueue_script("plugins", QODE_ROOT."/js/plugins.js",array(),false,true);
				
		wp_enqueue_script("carouFredSel", QODE_ROOT."/js/jquery.carouFredSel-6.2.1.js",array(),false,true);
		wp_enqueue_script("mousewheel", QODE_ROOT."/js/jquery.mousewheel.min.js",array(),false,true);
		wp_enqueue_script("touchSwipe", QODE_ROOT."/js/jquery.touchSwipe.min.js",array(),false,true);
		
		if(($is_chrome || $is_opera) && $smooth_scroll){ 
			wp_enqueue_script("smoothScroll", QODE_ROOT."/js/SmoothScroll.js",array(),false,true);
		}

        if ( $is_IE ) {
            wp_enqueue_script("html5", QODE_ROOT."/js/html5.js",array(),false,false);
        }
        if($qode_options_theme18['enable_google_map'] == "yes") :
            if(isset($qode_options_theme18['google_maps_api_key']) && $qode_options_theme18['google_maps_api_key'] != '') {
               $google_maps_api_key = $qode_options_theme18['google_maps_api_key'];
               wp_enqueue_script("google_map_api", "https://maps.googleapis.com/maps/api/js?key=" . $google_maps_api_key,array(),false,true);
            }
        endif;
        wp_enqueue_script("default_dynamic", QODE_ROOT."/js/default_dynamic.php",array(),false,true);
        wp_enqueue_script("default", QODE_ROOT."/js/default.min.js",array(),false,true);
        wp_enqueue_script("custom_js", QODE_ROOT."/js/custom_js.php",array(),false,true);
        global $wp_scripts;
        $wp_scripts->add_data('comment-reply', 'group', 1 );
        if ( is_singular() ) wp_enqueue_script( "comment-reply");

        $has_ajax = false;
        $qode_animation = "";
        if (isset($_SESSION['qode_theme18_page_transitions']))
            $qode_animation = $_SESSION['qode_theme18_page_transitions'];
        if (($qode_options_theme18['page_transitions'] != "0") && (empty($qode_animation) || ($qode_animation != "no")))
            $has_ajax = true;
        elseif (!empty($qode_animation) && ($qode_animation != "no"))
            $has_ajax = true;

        if ($has_ajax) :
            wp_enqueue_script("ajax", QODE_ROOT."/js/ajax.min.js",array(),false,true);
        endif;
        wp_enqueue_script( 'wpb_composer_front_js' );

        if($qode_options_theme18['use_recaptcha'] == "yes") :
        wp_enqueue_script("recaptcha_ajax", "http://www.google.com/recaptcha/api/js/recaptcha_ajax.js",array(),false,true);
        endif;

        if(isset($qode_toolbar)):
            wp_enqueue_script("toolbar", QODE_ROOT."/js/toolbar.js",array(),false,true);
        endif;

        if($woocommerce) {
            wp_enqueue_script("woocommerce-qode", QODE_ROOT."/js/woocommerce.js",array(),false,true);
            wp_enqueue_script("qode-select2", QODE_ROOT."/js/select2.min.js",array(),false,true);
        }
    }
}

add_action('wp_enqueue_scripts', 'qode_styles'); 
add_action('wp_enqueue_scripts', 'qode_scripts');

/* Add admin js and css */

if (!function_exists('qode_admin_jquery')) {
function qode_admin_jquery() {
	wp_enqueue_script('jquery'); 
	wp_enqueue_style('qode-admin-style', QODE_ROOT.'/css/admin/admin-style.css', false, '1.0', 'screen');
	wp_enqueue_style('colorstyle', QODE_ROOT.'/css/admin/colorpicker.css', false, '1.0', 'screen');
	wp_register_script('colorpickerss', QODE_ROOT.'/js/admin/colorpicker.js', array('jquery'), '1.0.0', false );
	wp_enqueue_script('colorpickerss'); 
	wp_enqueue_style('thickbox');
	wp_enqueue_script('media-upload');
	wp_enqueue_media();
	wp_enqueue_script('thickbox');
	wp_enqueue_script('jquery-ui-datepicker');
	wp_enqueue_script('jquery-ui-accordion');
	wp_register_script('default', QODE_ROOT.'/js/admin/default.js', array('jquery'), '1.0.0', false );
	wp_enqueue_script('default'); 
	wp_enqueue_script('common');
	wp_enqueue_script('wp-lists');
	wp_enqueue_script('postbox');
}
}
add_action('admin_enqueue_scripts', 'qode_admin_jquery');

if (!isset( $content_width )) $content_width = 1060;

/* Register Menus */

if (!function_exists('qode_register_menus')) {
function qode_register_menus() {
    register_nav_menus(
        array('top-navigation' => __( 'Top Navigation', 'qode')
		)
    );

    register_nav_menus(
        array('popup-navigation' => __( 'Fullscreen Navigation', 'qode')
        )
    );

}
}
add_action( 'after_setup_theme', 'qode_register_menus' ); 

/* Add post thumbnails */

if ( function_exists( 'add_theme_support' ) ) { 
add_theme_support( 'post-thumbnails' );
add_image_size( 'menu-featured-post', 345, 198, true );
add_image_size( 'page_image', 85, 85, true );
add_image_size( 'latest_post_image', 97, 97, true );
add_image_size( 'portfolio_list_square', 550, 550, true ); //for latest post boxes and portfolio list
add_image_size( 'portfolio_list_portrait', 550, 654, true ); //for blog masonry, latest post boxes and portfolio list
add_image_size( 'qode_gallery_thumbnail', 840, 470, true );
add_image_size( 'frame_slider_thumbnail', 645, 426, true );
add_image_size( 'blog_wide', 1920, 450, true );
add_image_size( 'blog_image_in_grid', 1100);
add_image_size( 'blog_small_image_in_grid', 990);
}

/* Add post formats */

if ( function_exists( 'add_theme_support' ) ) { 
add_theme_support('post-formats', array('gallery', 'link', 'quote', 'video', 'audio'));
}

/* Add feedlinks */

add_theme_support( 'automatic-feed-links' );

/* Add class on body for ajax */

if (!function_exists('ajax_classes')) {
function ajax_classes($classes) {
	global $qode_options_theme18;
	$qode_animation="";
	if (isset($_SESSION['qode_animation'])) $qode_animation = $_SESSION['qode_animation'];
	if(($qode_options_theme18['page_transitions'] === "0") && ($qode_animation == "no")) :
		$classes[] = '';
	elseif($qode_options_theme18['page_transitions'] === "1" && (empty($qode_animation) || ($qode_animation != "no"))) :
		$classes[] = 'ajax_updown';
		$classes[] = 'page_not_loaded';
	elseif($qode_options_theme18['page_transitions'] === "2" && (empty($qode_animation) || ($qode_animation != "no"))) :
		$classes[] = 'ajax_fade';
		$classes[] = 'page_not_loaded';
	elseif($qode_options_theme18['page_transitions'] === "3" && (empty($qode_animation) || ($qode_animation != "no"))) :
		$classes[] = 'ajax_updown_fade';
		$classes[] = 'page_not_loaded';
	elseif($qode_options_theme18['page_transitions'] === "4" && (empty($qode_animation) || ($qode_animation != "no"))) :
		$classes[] = 'ajax_leftright';
		$classes[] = 'page_not_loaded';
	elseif(!empty($qode_animation) && $qode_animation != "no") :
		$classes[] = 'page_not_loaded';
	else:
	$classes[] ="";
	endif;

	return $classes;
}
}
add_filter('body_class','ajax_classes');

/* Add class on body boxed layout */

if (!function_exists('boxed_class')) {
function boxed_class($classes) {
	global $qode_options_theme18;
	
	
	if(isset($qode_options_theme18['boxed']) && $qode_options_theme18['boxed'] == "yes") :
		$classes[] = 'boxed';
	else:
	$classes[] ="";
	endif;

	return $classes;
}
}
add_filter('body_class','boxed_class');


/* Add class on body for no elements animation on touch devices */

if (!function_exists('elements_animation_on_touch_class')) {
function elements_animation_on_touch_class($classes) {
	global $qode_options_theme18;
	
	$isMobile = (bool)preg_match('#\b(ip(hone|od|ad)|android|opera m(ob|in)i|windows (phone|ce)|blackberry|tablet'.
									'|s(ymbian|eries60|amsung)|p(laybook|alm|rofile/midp|laystation portable)|nokia|fennec|htc[\-_]'.
									'|mobile|up\.browser|[1-4][0-9]{2}x[1-4][0-9]{2})\b#i', $_SERVER['HTTP_USER_AGENT'] );
	
	if(isset($qode_options_theme18['elements_animation_on_touch']) && $qode_options_theme18['elements_animation_on_touch'] == "no" && $isMobile == true) :
		$classes[] = 'no_animation_on_touch';
	else:
	$classes[] ="";
	endif;

	return $classes;
}
}
add_filter('body_class','elements_animation_on_touch_class');

/* Add class on body for vertical menu */

if (!function_exists('vertical_menu_class')) {
    function vertical_menu_class($classes) {
        global $qode_options_theme18;
        global $wp_query;

        if(isset($qode_options_theme18['vertical_area']) && $qode_options_theme18['vertical_area'] =='yes') :
            $classes[] = 'vertical_menu_enabled';
        endif;

        $id = $wp_query->get_queried_object_id();
        if(isset($qode_options_theme18['vertical_area_transparency']) && $qode_options_theme18['vertical_area_transparency'] =='yes' && get_post_meta($id, "qode_page_vertical_area_transparency", true) != "no"){
            $classes[] = ' vertical_menu_transparency vertical_menu_transparency_on';
        }else if(get_post_meta($id, "qode_page_vertical_area_transparency", true) == "yes"){
            $classes[] = ' vertical_menu_transparency vertical_menu_transparency_on';
        }
        return $classes;
    }
}
add_filter('body_class','vertical_menu_class');

/* Excerpt more */

if (!function_exists('qode_excerpt_more')) {
function qode_excerpt_more( $more ) {
    return '...';
}
}
add_filter('excerpt_more', 'qode_excerpt_more');

/* Excerpt lenght */

if (!function_exists('qode_excerpt_length')) {
function qode_excerpt_length( $length ) {
	global $qode_options_theme18;
	if($qode_options_theme18['number_of_chars']){
		 return $qode_options_theme18['number_of_chars'];
	} else {
		return 45;
	}
}
}
add_filter( 'excerpt_length', 'qode_excerpt_length', 999 );

/* Social excerpt lenght */

if (!function_exists('the_excerpt_max_charlength')) {
function the_excerpt_max_charlength($charlength) {
	global $qode_options_theme18;
	if(isset($qode_options_theme18['twitter_via']) && !empty($qode_options_theme18['twitter_via'])) {
		$via = " via " . $qode_options_theme18['twitter_via'] . " ";
	} else {
		$via = 	"";
	}
	$excerpt = get_the_excerpt();
	$charlength = 140 - (mb_strlen($via) + $charlength);

	if ( mb_strlen( $excerpt ) > $charlength ) {
		$subex = mb_substr( $excerpt, 0, $charlength);
		$exwords = explode( ' ', $subex );
		$excut = - ( mb_strlen( $exwords[ count( $exwords ) - 1 ] ) );
		if ( $excut < 0 ) {
			return mb_substr( $subex, 0, $excut );
		} else {
			return $subex;
		}
	} else {
		return $excerpt;
	}
}
}

if(!function_exists('qode_excerpt')) {
	/**
	* Function that cuts post excerpt to the number of word based on previosly set global
	* variable $word_count, which is defined in qode_set_blog_word_count function
	*/
	function qode_excerpt() {
		global $qode_options_theme18, $word_count, $post;

		$word_count = isset($word_count) && $word_count != "" ? $word_count : $qode_options_theme18['number_of_chars'];
		$post_excerpt = $post->post_excerpt != "" ? $post->post_excerpt : strip_tags($post->post_content);
		$clean_excerpt = strpos($post_excerpt, '...') ? strstr($post_excerpt, '...', true) : $post_excerpt;

		$excerpt_word_array = explode (' ', $clean_excerpt);
  		$excerpt_word_array = array_slice ($excerpt_word_array, 0, $word_count);
  		$excerpt = implode (' ', $excerpt_word_array).'...';
		
		echo '<p>'.$excerpt.'</p>';
	}
}

if(!function_exists('qode_set_blog_word_count')) {
	/**
	* Function that sets global blog word count variable used by qode_excerpt function 
	*/
	function qode_set_blog_word_count($word_count_param) {
		global $word_count;

		$word_count = $word_count_param;
	}
}

/* Use slider instead of image for post */

if (!function_exists('slider_blog')) {
function slider_blog($post_id) {
	$sliders = get_post_meta($post_id, "qode_sliders", true);		
	$slider = $sliders[1];
	if($slider) {
        $html = '';
        $html .= '<div class="flexslider"><ul class="slides">';
		$i=0;
		while (isset($slider[$i])){
			$slide = $slider[$i];
			
			$href = $slide[link];
			$baseurl = home_url();
			$baseurl = str_replace('http://', '', $baseurl);
			$baseurl = str_replace('www', '', $baseurl);
			$host = parse_url($href, PHP_URL_HOST);
			if($host != $baseurl) {
				$target = 'target="_blank"';
			}
			else {
				$target = 'target="_self"';
			}
			
			$html .= '<li class="slide ' . $slide[imgsize] . '">';
			$html .= '<div class="image"><img src="' . $slide[img] . '" alt="' . $slide[title] . '" /></div>';
			
			$html .= '</li>';
			$i++; 
		}
		$html .= '</ul></div>';
	}
	return $html;
}
}

/* Get Page ID */

if(!function_exists('qode_init_page_id')) {
	function qode_init_page_id() {
		global $wp_query;
		global $qode_page_id;

		$qode_page_id = $wp_query->get_queried_object_id();
	}
}

add_action('get_header', 'qode_init_page_id');

if (!function_exists('compareSlides')) {
function compareSlides($a, $b){
	if (isset($a['ordernumber']) && isset($b['ordernumber'])) {
    if ($a['ordernumber'] == $b['ordernumber']) {
        return 0;
    }
    return ($a['ordernumber'] < $b['ordernumber']) ? -1 : 1;
  }
  return 0;
}
}

if (!function_exists('comparePortfolioImages')) {
function comparePortfolioImages($a, $b){
	if (isset($a['portfolioimgordernumber']) && isset($b['portfolioimgordernumber'])) {
    if ($a['portfolioimgordernumber'] == $b['portfolioimgordernumber']) {
        return 0;
    }
    return ($a['portfolioimgordernumber'] < $b['portfolioimgordernumber']) ? -1 : 1;
  }
  return 0;
}
}

if (!function_exists('comparePortfolioOptions')){
function comparePortfolioOptions($a, $b){
	if (isset($a['optionlabelordernumber']) && isset($b['optionlabelordernumber'])) {
    if ($a['optionlabelordernumber'] == $b['optionlabelordernumber']) {
        return 0;
    }
    return ($a['optionlabelordernumber'] < $b['optionlabelordernumber']) ? -1 : 1;
  }
  return 0;
}
}

if (!function_exists('qode_gallery_upload_get_images')){
function qode_gallery_upload_get_images(){
	$ids=$_POST['ids'];
	$ids=explode(",",$ids);
	foreach($ids as $id):
		$image = wp_get_attachment_image_src($id,'thumbnail', true);
		echo '<li class="qode-gallery-image-holder"><img src="'.$image[0].'"/></li>';
	endforeach;
	exit;  
}
}

add_action( 'wp_ajax_qode_gallery_upload_get_images', 'qode_gallery_upload_get_images');

if (!function_exists('qode_hex2rgb')) {
function qode_hex2rgb($hex) {
   $hex = str_replace("#", "", $hex);

   if(strlen($hex) == 3) {
      $r = hexdec(substr($hex,0,1).substr($hex,0,1));
      $g = hexdec(substr($hex,1,1).substr($hex,1,1));
      $b = hexdec(substr($hex,2,1).substr($hex,2,1));
   } else {
      $r = hexdec(substr($hex,0,2));
      $g = hexdec(substr($hex,2,2));
      $b = hexdec(substr($hex,4,2));
   }
   $rgb = array($r, $g, $b);
   return $rgb; // returns an array with the rgb values
}
}

function rewrite_rules_on_theme_activation() {
	flush_rewrite_rules();
}
add_action( 'after_switch_theme', 'rewrite_rules_on_theme_activation' );

if (!function_exists('qode_remove_vc_grid_element')) {
	/**
	 * Function that removes Grid Elements Post Type
	 * that comes with Visual Composer from version 4.4.2
	 */
	function qode_remove_vc_grid_element() {

		remove_action( 'init', 'vc_grid_item_editor_create_post_type' );

	}

	add_action('vc_after_init', 'qode_remove_vc_grid_element', 12);

}

if(!function_exists('qode_get_vc_version')) {
    /**
     * Return Visual Composer version string
     *
     * @return bool|string
     */
    function qode_get_vc_version() {
        if(qode_visual_composer_installed()) {
            return WPB_VC_VERSION;
        }

        return false;
    }
}

if(!function_exists('qode_visual_composer_installed')) {
    /**
     * Function that checks if visual composer installed
     * @return bool
     */
    function qode_visual_composer_installed() {
        //is Visual Composer installed?
        if(class_exists('WPBakeryVisualComposerAbstract')) {
            return true;
        }

        return false;
    }
}

if(!function_exists('qode_is_ajax')) {
    /**
     * Function that checks if current request is ajax request
     * @return bool whether it's ajax request or not
     *
     * @version 0.1
     */
    function qode_is_ajax() {
        return !empty( $_SERVER[ 'HTTP_X_REQUESTED_WITH' ]) && strtolower( $_SERVER[ 'HTTP_X_REQUESTED_WITH' ]) == 'xmlhttprequest';
    }
}

if(!function_exists('qode_admin_notice')) {
    /**
     * Prints admin notice. It checks if notice has been disabled and if it hasn't then it displays it
     * @param $id string id of notice. It will be used to store notice dismis
     * @param $message string message to show to the user
     * @param $class string HTML class of notice
     * @param bool $is_dismisable whether notice is dismisable or not
     */
    function qode_admin_notice($id, $message, $class, $is_dismisable = true) {
        $is_dismised = get_user_meta(get_current_user_id(), 'dismis_'.$id);

        //if notice isn't dismissed
        if(!$is_dismised && is_admin()) {
            echo '<div style="display: block;" class="'.esc_attr($class).' is-dismissible notice">';
            echo '<p>';

            echo wp_kses_post($message);

            if($is_dismisable) {
                echo '<strong style="display: block; margin-top: 7px;"><a href="'.esc_url(add_query_arg('qode_dismis_notice', $id)).'">'.__('Dismiss this notice', 'qode').'</a></strong>';
            }

            echo '</p>';

            echo '</div>';
        }

    }
}

if(!function_exists('qode_save_dismisable_notice')) {
    /**
     * Updates user meta with dismisable notice. Hooks to admin_init action
     * in order to check this on every page request in admin
     */
    function qode_save_dismisable_notice() {
        if(is_admin() && !empty($_GET['qode_dismis_notice'])) {
            $notice_id = sanitize_key($_GET['qode_dismis_notice']);
            $current_user_id = get_current_user_id();

            update_user_meta($current_user_id, 'dismis_'.$notice_id, 1);
        }
    }

    add_action('admin_init', 'qode_save_dismisable_notice');
}

if(!function_exists('qode_wp_title')) {
    /**
     * Function that sets page's title. Hooks to wp_title filter
     * @param $title string current page title
     * @param $sep string title separator
     * @return string changed title text if SEO plugins aren't installed
     *
     * @since 4.3
     * @version 0.2
     */
    function qode_wp_title($title, $sep) {
        global $qode_options_theme18;

        //is SEO plugin installed?
        if(qode_seo_plugin_installed()) {
            //don't do anything, seo plugin will take care of it
        } else {
            //get current post id
            $id = qode_get_page_id();
            $sep = ' | ';
            $title_prefix = get_bloginfo('name');
            $title_suffix = '';

            //is WooCommerce installed and is current page shop page?
            if(qode_is_woocommerce_installed() && qode_is_woocommerce_shop()) {
                //get shop page id
                $id = qode_get_woo_shop_page_id();
            }

            //set unchanged title variable so we can use it later
            $unchanged_title = $title;

            //is qode seo enabled?
            if(isset($qode_options_theme18['disable_qode_seo']) && $qode_options_theme18['disable_qode_seo'] !== 'yes') {
                //get current post seo title
                $seo_title = get_post_meta($id, "qode_seo_title", true);

                //is current post seo title set?
                if($seo_title !== '') {
                    $title_suffix = $seo_title;
                }
            }

            //title suffix is empty, which means that it wasn't set by qode seo
            if(empty($title_suffix)) {
                //if current page is front page append site description, else take original title string
                $title_suffix = is_front_page() ? get_bloginfo('description') : $unchanged_title;
            }

            //concatenate title string
            $title  = $title_prefix.$sep.$title_suffix;

            //return generated title string
            return $title;
        }
    }

    add_filter('wp_title', 'qode_wp_title', 10, 2);
}

if(!function_exists('qode_get_page_id')) {
    /**
     * Function that returns current page / post id.
     * Checks if current page is woocommerce page and returns that id if it is.
     * Checks if current page is any archive page (category, tag, date, author etc.) and returns -1 because that isn't
     * page that is created in WP admin.
     *
     * @return int
     *
     * @version 0.1
     *
     * @see qode_is_woocommerce_installed()
     * @see qode_is_woocommerce_shop()
     */
    function qode_get_page_id() {
        if(qode_is_woocommerce_installed() && qode_is_woocommerce_shop()) {
            return qode_get_woo_shop_page_id();
        }

        if(is_archive() || is_404() || is_search()) {
            return -1;
        }

        return get_queried_object_id();
    }
}

if(!function_exists('qode_ajax_meta')) {
    /**
     * Function that echoes meta data for ajax
     *
     * @since 4.3
     * @version 0.2
     */
    function qode_ajax_meta() {
        global $qode_options_theme18;

        $seo_description = get_post_meta(qode_get_page_id(), "qode_seo_description", true);
        $seo_keywords = get_post_meta(qode_get_page_id(), "qode_seo_keywords", true);
        ?>

        <div class="seo_title"><?php wp_title(''); ?></div>

        <?php if($seo_description !== ''){ ?>
            <div class="seo_description"><?php echo $seo_description; ?></div>
        <?php } else if($qode_options_theme18['meta_description']){?>
            <div class="seo_description"><?php echo $qode_options_theme18['meta_description']; ?></div>
        <?php } ?>
        <?php if($seo_keywords !== ''){ ?>
            <div class="seo_keywords"><?php echo $seo_keywords; ?></div>
        <?php }else if($qode_options_theme18['meta_keywords']){?>
            <div class="seo_keywords"><?php echo $qode_options_theme18['meta_keywords']; ?></div>
        <?php }
    }

    add_action('qode_ajax_meta', 'qode_ajax_meta');
}

if(!function_exists('qode_header_meta')) {
    /**
     * Function that echoes meta data if our seo is enabled
     */
    function qode_header_meta() {
        global $qode_options_theme18;

        if(isset($qode_options_theme18['disable_qode_seo']) && $qode_options_theme18['disable_qode_seo'] == 'no') {
            $seo_description = get_post_meta(qode_get_page_id(), "qode_seo_description", true);
            $seo_keywords = get_post_meta(qode_get_page_id(), "qode_seo_keywords", true);
            ?>

            <?php if($seo_description) { ?>
                <meta name="description" content="<?php echo $seo_description; ?>">
            <?php } else if($qode_options_theme18['meta_description']){ ?>
                <meta name="description" content="<?php echo $qode_options_theme18['meta_description'] ?>">
            <?php } ?>

            <?php if($seo_keywords) { ?>
                <meta name="keywords" content="<?php echo $seo_keywords; ?>">
            <?php } else if($qode_options_theme18['meta_keywords']){ ?>
                <meta name="keywords" content="<?php echo $qode_options_theme18['meta_keywords'] ?>">
            <?php }
        }
    }

    add_action('qode_header_meta', 'qode_header_meta');
}

if ( ! function_exists( 'qode_is_gutenberg_installed' ) ) {
    /**
     * Function that checks if Gutenberg plugin installed
     */
    function qode_is_gutenberg_installed() {
        if ( function_exists( 'is_gutenberg_page' ) ) {
            if(is_admin()){
                wp_enqueue_style( 'gutenberg-fix', get_template_directory_uri() . '/css/gutenberg.css', array(), '1.0' );
            }
        }
    }   
}
add_action( 'admin_enqueue_scripts', 'qode_is_gutenberg_installed' );
