<?php 
/*
Template Name: Contact Page
*/ 
?>

<?php
global $wp_query;
$id = $wp_query->get_queried_object_id();
get_header();

if($qode_options_theme18['enable_google_map'] == "yes"){
	$container_class= " full_map";
} else {
	$container_class= "";
}

?>
	
<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
	
			
		<?php if(get_post_meta($id, "qode_page_scroll_amount_for_sticky", true)) { ?>
			<script>
			var page_scroll_amount_for_sticky = <?php echo get_post_meta($id, "qode_page_scroll_amount_for_sticky", true); ?>;
			</script>
		<?php } ?>
		
		<?php get_template_part( 'title' ); ?>
		<?php if($qode_options_theme18['enable_google_map'] == "yes"){ ?>
			<div class="q_google_map_holder">
				<?php
					$google_maps_scroll_wheel = false;
					if(isset($qode_options_theme18['google_maps_scroll_wheel'])){
						if ($qode_options_theme18['google_maps_scroll_wheel'] == "yes")
							$google_maps_scroll_wheel = true;
					}
					if(!$google_maps_scroll_wheel){
				?>
					<div class="q_google_map_ovrlay"></div>
				<?php } ?>
				<div class="q_google_map" id="map_canvas"></div>
			</div>
		<?php } ?>
		<div class="container">
			<div class="container_inner<?php echo $container_class; ?> clearfix">
				<div class="contact_detail">

					<?php the_content(); ?>
					
					<?php if($qode_options_theme18['enable_contact_form'] == "yes"){ ?>
						<div class="contact_form">

							<h5><?php if($qode_options_theme18['contact_heading_above'] != "") { echo $qode_options_theme18['contact_heading_above'];  } else { ?><?php _e('Contact Us', 'qode'); ?><?php } ?></h5>
							
							<form id="contact-form" method="post" action="">

								<div class="three_columns clearfix">
									<div class="column1">
										<div class="column_inner">
											<input type="text" class="requiredField" name="fname" id="fname" value="" placeholder="<?php _e('First Name *', 'qode'); ?>" />
										</div>
									</div>
									<div class="column2">
										<div class="column_inner">
											<input type="text" class="requiredField" name="lname" id="lname" value="" placeholder="<?php _e('Last Name *', 'qode'); ?>" />
										</div>
									</div>
									<div class="column3">
										<div class="column_inner">
											<input type="text" class="requiredField email" name="email" id="email" value="" placeholder="<?php _e('Email *', 'qode'); ?>" />
										</div>
									</div>
								</div>
								
								<textarea name="message" id="message" rows="10" placeholder="<?php _e('Write Your Message Here', 'qode'); ?>"></textarea>
								
								<?php
								if($qode_options_theme18['use_recaptcha'] == "yes") :
									require_once('includes/recaptchalib.php');
									if($qode_options_theme18['recaptcha_public_key']) {
										$publickey = $qode_options_theme18['recaptcha_public_key'];
									} else {
										$publickey = "6Ld5VOASAAAAABUGCt9ZaNuw3IF-BjUFLujP6C8L";
									}
									if($qode_options_theme18['recaptcha_private_key']) {
										$privatekey = $qode_options_theme18['recaptcha_private_key'];
									} else {
										$privatekey = "6Ld5VOASAAAAAKQdKVcxZ321VM6lkhBsoT6lXe9Z";
									}

									if($qode_options_theme18['page_transitions'] != ""){ ?>
										<script type="text/javascript">
											var RecaptchaOptions = {theme: 'clean'};
											Recaptcha.create("<?php echo $publickey; ?>","captchaHolder",{theme: "clean",callback: Recaptcha.focus_response_field});
										</script>
									<?php } ?>
									<p id="captchaHolder"><?php echo recaptcha_get_html($publickey); ?></p>
									<p id="captchaStatus">&nbsp;</p>
								<?php endif; ?>
								
								<span class="submit_button_contact">
									<input class="qbutton medium" type="submit" value="<?php _e('SEND MESSAGE', 'qode'); ?>" />
								</span>
							</form>	
						</div>
					<?php } ?>
				</div>	
			</div>	
		</div>	
		
<?php endwhile; ?>
<?php endif; ?>
<script type="text/javascript">
jQuery(document).ready(function($){
    $j('form#contact-form').submit(function(){
        $j('form#contact-form .contact-error').remove();
        var hasError = false;
        $j('form#contact-form .requiredField').each(function() {
            if(jQuery.trim($j(this).val()) == '' || jQuery.trim($j(this).val()) == jQuery.trim($j(this).attr('placeholder'))){
                var labelText = $j(this).prev('label').text();
                $j(this).parent().append('<strong class="contact-error"><?php _e('This is a required field', 'qode'); ?></strong>');
                $j(this).addClass('inputError');
                hasError = true;
            } else { //else 1 
                if($j(this).hasClass('email')) { //if hasClass('email')
                    var emailReg = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;
                    if(!emailReg.test(jQuery.trim($j(this).val()))){
                        var labelText = $j(this).prev('label').text();
                        $j(this).parent().append('<strong class="contact-error"><?php _e('Please enter a valid email address.', 'qode'); ?></strong>');
                        $j(this).addClass('inputError');
                        hasError = true;
                    } 
                } //end of if hasClass('email')

            } // end of else 1 
        }); //end of each()
        
        if(!hasError){
			challengeField = $j("input#recaptcha_challenge_field").val();
			responseField = $j("input#recaptcha_response_field").val();
			name =  $j("input#fname").val();
			lastname =  $j("input#lname").val();
			email =  $j("input#email").val();
			message =  $j("textarea#message").val();
			
			var form_post_data = "";
			
			var html = $j.ajax({
			type: "POST",
			url: "<?php echo QODE_ROOT; ?>/includes/ajax_mail.php",
			data: "recaptcha_challenge_field=" + challengeField + "&recaptcha_response_field=" + responseField + "&name=" + name + "&lastname=" + lastname + "&email=" + email + "&message=" + message,
			async: false
			}).responseText;
			
			if(html == "success"){
				var formInput = $j(this).serialize();
				
				$j("form#contact-form").before('<div class="contact-success"><strong><?php _e('THANK YOU!', 'qode'); ?></strong><p><?php _e('Your email was successfully sent. We will contact you as soon as possible.', 'qode'); ?></p></div>');
				$j("form#contact-form").hide();
				$j.post($j(this).attr('action'),formInput);
				hasError = false;
				return false; 
			} else {
				<?php
				if ($qode_options_theme18['use_recaptcha'] == "yes"){
				?>
					$j("#recaptcha_response_field").parent().append('<span class="contact-error extra-padding"><?php _e('Invalid Captcha', 'qode'); ?></span>');
					Recaptcha.reload();
				<?php
				} else {
				?>
					$j("form#contact-form").before('<div class="contact-success"><strong><?php _e("Email server problem", 'qode'); ?></strong></p></div>');
				<?php    
				}
				?>
				return false;
			}
        }
        return false;
    });
});
</script>   
	
<?php get_footer(); ?>			