<?php
include_once('google-fonts.php');

if (!function_exists ('add_action')) {
	header('Status: 403 Forbidden');
	header('HTTP/1.1 403 Forbidden');
	exit();
}
global $qode_options_soho;
$qode_options_soho  = get_option('qode_options_theme18');

class Qode_Theme_Options {

	/*** qode options class constructor, alse compatible for PHP4 ***/
	function __construct() {
		add_action('admin_menu', array(&$this, 'qode_admin_menu'));
		add_action('admin_init', array(&$this, 'register_qode_theme_settings'));
	}

	function init_qode_theme_options() {
		global $qode_options_soho;
		if(isset($qode_options_soho['reset_to_defaults'])){
			if( $qode_options_soho['reset_to_defaults'] == 'yes' ) {
			    delete_option( "qode_options_theme18");
            }
		}
		if (! get_option("qode_options_theme18")) {
			add_option( "qode_options_theme18",
				array(
					"reset_to_defaults" => '',
					"number_of_chars" => 45,
					"first_color" => '',
					"first_area_color" => '',
					"second_color" => '',
					"second_area_color" => '',
					"accordion_color" =>'',
					"accordion_color_hover" =>'',
					"accordion_backgroundcolor" =>'',
					"accordion_backgroundcolor_hover" =>'',
					"accordion_bordercolor" =>'',
					"accordion_bordercolor_hover" =>'',
					"accordion_fontsize" =>'',
					"accordion_lineheight" =>'',
					"accordion_fontweight" =>'',
					"background_color" => '',
					"background_color_box" => '',
					"blockquote_color" => '',
					"blockquote_fontsize" => '',
					"content_input_fields_color" => '',
					"content_input_fields_backgroundcolor" => '',
					"content_input_fields_bordercolor" => '',
					"highlight_color" => '',
					"selection_color" => '',
					"favicon_image" => SOHO_QODE_ROOT."/img/favicon.ico",
					"content_background_image" => '',
					"background_image" => '',
					"patern_background_image" => '',
					"google_fonts" => '-1',
					"page_transitions" => '0',
					"boxed" => 'no',
					"loading_animation" => 'yes',
					"loading_image" => '',
					"smooth_scroll" => 'no',
					"responsiveness" => 'yes',
					"show_back_button" => 'yes',
					"elements_animation_on_touch" => 'no',
					"parallax_minheight" => '400',
					"parallax_onoff" => 'off',
					"internal_no_ajax_links" => '',
					"custom_css" => '',
					"custom_js" => '',
					"meta_keywords" => '',
					"meta_description" => '',
					"disable_qode_seo" => 'no',
					"h1_color" => '',
					"h1_google_fonts" => '-1',
					"h1_fontsize" => '',
					"h1_lineheight" => '',
					"h1_fontstyle" => '',
					"h1_fontweight" => '',
					"h1_texttransform" => '',
					"h2_color" => '',
					"h2_google_fonts" => '-1',
					"h2_fontsize" => '',
					"h2_lineheight" => '',
					"h2_fontstyle" => '',
					"h2_fontweight" => '',
					"h2_texttransform" => '',
					"h3_color" => '',
					"h3_google_fonts" => '-1',
					"h3_fontsize" => '',
					"h3_lineheight" => '',
					"h3_fontstyle" => '',
					"h3_fontweight" => '',
					"h3_texttransform" => '',
					"h4_color" => '',
					"h4_google_fonts" => '-1',
					"h4_fontsize" => '',
					"h4_lineheight" => '',
					"h4_fontstyle" => '',
					"h4_fontweight" => '',
					"h4_texttransform" => '',
					"h5_color" => '',
					"h5_google_fonts" => '-1',
					"h5_fontsize" => '',
					"h5_lineheight" => '',
					"h5_fontstyle" => '',
					"h5_fontweight" => '',
					"h5_texttransform" => '',
					"h6_color" => '',
					"h6_google_fonts" => '-1',
					"h6_fontsize" => '',
					"h6_lineheight" => '',
					"h6_fontstyle" => '',
					"h6_fontweight" => '',
					"h6_letterspacing" => '',
					"h6_texttransform" => '',
					"text_color" => '',
					"text_google_fonts" => '-1',
					"text_fontsize" => '',
					"text_lineheight" => '',
					"text_fontstyle" => '',
					"text_fontweight" => '',
					"text_margin" => '',
					"link_color" => '',
					"link_hovercolor" => '',
					"link_fontstyle" => '',
					"link_fontweight" => '',
					"link_fontdecoration" => '',
					"lists_unsorted_fontsize" => '',
					"lists_unsorted_lineheight" => '',
					"lists_unsorted_color" => '',
					"lists_unsorted_marginbottom" => '',
					"page_title_color" => '',
					"page_title_google_fonts" => '-1',
					"page_title_fontsize" => '',
					"page_title_lineheight" => '',
					"page_title_fontstyle" => '',
					"page_title_fontweight" => '',
					"page_title_texttransform" => '',
					"pricingtables_backgroundcolor" => '',
					"pricingtables_backgroundpatern" => '',
					"pricingtables_even_backgroundcolor" => '',
					"pricingtables_even_backgroundpatern" => '',
					"progressbar_horizontal_fontsize" => '',
					"progressbar_horizontal_fontweight" => '',
					"progressbar_horizontal_fontstyle" => '',
					"progressbar_horizontal_lineheight" => '',
					"progressbar_vertical_fontsize" => '',
					"progressbar_vertical_fontweight" => '',
					"progressbar_vertical_fontstyle" => '',
					"progressbar_vertical_lineheight" => '',
					"piecharts_fontsize" => '',
					"piecharts_fontweight" => '',
					"piecharts_fontstyle" => '',
					"piecharts_lineheight" => '',
					"menu_color" => '',
					"menu_hovercolor" => '',
					"menu_top_line_color" => '',
					"menu_google_fonts" => '-1',
					"menu_fontsize" => '',
					"menu_lineheight" => '',
					"menu_fontstyle" => '',
					"menu_fontweight" => '',
					"header_in_grid" => 'yes',
					"header_top_area" => 'no',
					"header_top_area_scroll" => 'no',
					"title_type" => 'standard_title',
					"enable_breadcrumbs" => 'no',
					"enable_search" => 'no',
					"header_bottom_appearance" => 'fixed',
					"header_style" => '',
					"menu_position" => '',
					"header_top_background_color" => '',
					"header_background_color" => '',
					"header_background_color_scroll" => '',
					"header_background_color_sticky" => '',
					"header_background_color_touch" => '',
					"header_background_transparency_initial" => '',
					"header_background_transparency_scroll" => '',
					"header_background_transparency_sticky" => '',
					"logo_image" => SOHO_QODE_ROOT."/img/logo.png",
					"logo_image_light" => SOHO_QODE_ROOT."/img/logo_white.png",
					"logo_image_dark" => SOHO_QODE_ROOT."/img/logo_black.png",
					"logo_image_sticky" => SOHO_QODE_ROOT."/img/logo_black.png",
					"center_logo_image" => 'no',
					"header_height" => '',
					"header_height_scroll" => '',
					"header_height_sticky" => '',
					"scroll_amount_for_sticky" => '',
					"dropdown_animation" => '',
					"dropdown_background_color" => '',
					"dropdown_background_separator_color" => '',
					"dropdown_background_transparency" => '',
					"dropdown_background_pattern" => '',
					"dropdown_color" => '',
					"dropdown_hovercolor" => '',
					"dropdown_google_fonts" => '-1',
					"dropdown_fontsize" => '',
					"dropdown_lineheight" => '',
					"dropdown_fontstyle" => '',
					"dropdown_fontweight" => '',
					"dropdown_color_thirdlvl" => '',
					"dropdown_hovercolor_thirdlvl" => '',
					"dropdown_google_fonts_thirdlvl" => '-1',
					"fixed_google_fonts" => '-1',
					"dropdown_fontsize_thirdlvl" => '',
					"dropdown_lineheight_thirdlvl" => '',
					"dropdown_fontstyle_thirdlvl" => '',
					"dropdown_fontweight_thirdlvl" => '',
					"sticky_color" => '',
					"sticky_hovercolor" => '',
					"sticky_google_fonts" => '-1',
					"sticky_fontsizel" => '',
					"sticky_lineheight" => '',
					"sticky_fontstyle" => '',
					"sticky_fontweight" => '',
					"tabs_color" =>'',
					"tabs_color_hover" =>'',
					"tabs_backgroundcolor" =>'',
					"tabs_backgroundcolor_hover" =>'',
					"tabs_bordercolor" =>'',
					"tabs_bordercolor_hover" =>'',
					"tabs_fontsize" =>'',
					"tabs_lineheight" =>'',
					"tabs_fontweight" =>'',
					"testimonials_fontsize" =>'',
					"testimonials_fontweight" =>'',
					"testimonials_lineheight" =>'',
					"testimonials_autor_fontsize" =>'',
					"testimonials_autor_fontweight" =>'',
					"testimonials_autor_lineheight" =>'',
					"messagebox_color" => '',
					"messagebox_fontsize" => '',
					"messagebox_fontweight" => '',
					"messagebox_fontstyle" => '',
					"messagebox_lineheight" => '',
					"messagebox_backgroundcolor" => '',
					"messagebox_icon_color" => '',
					"messagebox_icon_fontsize" => '',
					"mobile_main_color" => '',
					"mobile_main_hovercolor" => '',
					"mobile_main_google_fonts" => '-1',
					"mobile_main_fontsize" => '',
					"mobile_main_lineheight" => '',
					"mobile_main_fontstyle" => '',
					"mobile_main_fontweight" => '',
					"mobile_main_letter_spacing" => '',
					"mobile_main_texttransform" => '',
					"mobile_color" => '',
					"mobile_hovercolor" => '',
					"mobile_google_fonts" => '-1',
					"mobile_fontsize" => '',
					"mobile_lineheight" => '',
					"mobile_fontstyle" => '',
					"mobile_fontweight" => '',
					"mobile_letter_spacing" => '',
					"mobile_separator_color" => '',
					"mobile_background_color" => '',
					"animate_title_area" => 'no',
					"title_text_shadow" => 'no',
					"responsive_title_image" => '',
					"fixed_title_image" => '',
					"title_image" => '',
					"title_image_pattern" => '',
					"title_overlay_image" => '',
					"title_height" => '',
					"page_title_position" => 'center',
					"title_background_color" => '',
					"page_title_text_background" => 'yes',
					"page_title_text_background_color" => '',
					"header_buttons_color" => '',
					"header_buttons_hovercolor" => '',
					"header_buttons_font_size" => '',
					"uncovering_footer" => 'no',
					"footer_in_grid" => 'no',
					"footer_text" => 'yes',
					"show_footer_top" => 'yes',
					"footer_top_columns" => '5',
					"footer_separator_color" => '',
					"footer_top_title_color" => '',
					"footer_top_text_color" => '',
					"footer_link_color" => '',
					"footer_link_hover_color" => '',
					"footer_top_background_color" => '',
					"footer_top_background_image" => '',
					"footer_bottom_text_color" => '',
					"footer_bottom_background_color" => '',
					"vertical_area" => "no",
					"vertical_area_transparency" => "no",
					"vertical_area_background" => "",
					"vertical_area_background_image" => "",
					"vertical_area_text_color" => "",
					"vertical_dropdown_animation" => '',
					"vertical_dropdown_background_color" => '',
					"vertical_dropdown_background_separator_color" => '',
					"vertical_dropdown_background_transparency" => '',
					"vertical_dropdown_background_pattern" => '',
					"vertical_menu_color" => "",
					"vertical_menu_hovercolor" => "",
					"vertical_menu_google_fonts" => "",
					"vertical_menu_fontsize" => "",
					"vertical_menu_lineheight" => "",
					"vertical_menu_fontstyle" => "",
					"vertical_menu_fontweight" => "",
					"vertical_dropdown_color" => "",
					"vertical_dropdown_hovercolor" => "",
					"vertical_dropdown_google_fonts" => "",
					"vertical_dropdown_fontsize" => "",
					"vertical_dropdown_lineheight" => "",
					"vertical_dropdown_fontstyle" => "",
					"vertical_dropdown_fontweight" => "",
					"vertical_dropdown_color_thirdlvl" => "",
					"vertical_dropdown_hovercolor_thirdlvl" => "",
					"vertical_dropdown_google_fonts_thirdlvl" => "",
					"vertical_dropdown_fontsize_thirdlvl" => "",
					"vertical_dropdown_lineheight_thirdlvl" => "",
					"vertical_dropdown_fontstyle_thirdlvl" => "",
					"vertical_dropdown_fontweight_thirdlvl" => "",
					"separator_color" => '',
					"separator_thickness" => '',
					"separator_topmargin" => '',
					"separator_bottommargin" => '',
					"button_title_color" => '',
					"button_title_hovercolor" => '',
					"button_backgroundcolor" => '',
					"button_backgroundcolor_hover" => '',
					"button_bordercolor" => '',
					"button_bordercolor_hover" => '',
					"button_title_google_fonts" => '-1',
					"button_title_fontsize" => '',
					"button_title_lineheight" => '',
					"button_title_fontstyle" => '',
					"button_title_fontweight" => '',
					"button_texttransform" => '',
					"enable_side_area" => 'yes',
					"side_area_title" => '',
					"side_area_background_color" => '',
					"side_area_text_color" => '',
					"side_area_title_color" => '',
					"enable_popup_menu" => 'no',
					"logo_image_popup" => SOHO_QODE_ROOT."/img/logo_black.png",
					"popup_menu_color" => '',
					"popup_menu_hover_color" => '',
					"popup_menu_hover_background_color" => '',
					"popup_menu_google_fonts" => '-1',
					"popup_menu_fontsize" => '',
					"popup_menu_lineheight" => '',
					"popup_menu_fontstyle" => '',
					"popup_menu_fontweight" => '',
					"popup_menu_letterspacing" => '',
					"popup_menu_color_2nd" => '',
					"popup_menu_hover_color_2nd" => '',
					"popup_menu_hover_background_color_2nd" => '',
					"popup_menu_google_fonts_2nd" => '-1',
					"popup_menu_fontsize_2nd" => '',
					"popup_menu_lineheight_2nd" => '',
					"popup_menu_fontstyle_2nd" => '',
					"popup_menu_fontweight_2nd" => '',
					"popup_menu_letterspacing_2nd" => '',
					"popup_menu_background_color" => '',
					"popup_menu_background_transparency" => '',
					"portfolio_qode_like" => 'on',
					"portfolio_style" => '1',
					"lightbox_single_project" => 'no',
					"portfolio_columns_number" => '2',
					"portfolio_single_slug" => '',
					"portfolio_categories" => '',
					"portfolio_text_follow" => 'portfolio_single_follow',
					"wp_read_more" => 'off',
					"pagination" => '1',
					"pagination_masonry" => 'pagination',
					"blog_masonry_filter" => '',
					"blog_style" => '1',
					"category_blog_sidebar" => 'default',
					"blog_hide_comments" => 'no',
					"blog_page_range" => '',
					"number_of_chars" => '45',
					"number_of_chars_masonry" => '',
					"blog_hide_post_title" => 'no',
					"blog_single_sidebar" => 'default',
					"blog_single_sidebar_custom_display" => '',
					"qode_like" => 'on',
					"blog_author_info" => 'no',
					"receive_mail" => '',
					"enable_contact_form" => 'no',
					"email_from" => '',
					"email_subject" => '',
					"use_recaptcha" => 'no',
					"recaptcha_public_key" => '',
					"recaptcha_private_key" => '',
					"contact_heading_above" => '',
					"enable_google_map" => 'no',
					"google_maps_pin_image" => SOHO_QODE_ROOT."/img/pin.png",
					"google_maps_address" => '',
					"google_maps_address2" => '',
					"google_maps_address3" => '',
					"google_maps_address4" => '',
					"google_maps_address5" => '',
					"google_maps_zoom" => '12',
					"google_maps_height" => '750',
					"google_maps_style" => 'yes',
					"google_maps_color" => '',
					"google_maps_saturation" => '',
					"google_maps_lightness" => '',
					"google_maps_scroll_wheel" => 'no',
					"google_maps_iframe" => '',
					"404_title" => '',
					"404_text" => '',
					"404_backlabel" => '',
					"enable_social_share" => 'no',
					"enable_facebook_share" => 'no',
					"enable_twitter_share" => 'no',
					"enable_google_plus" => 'no',
					"enable_linkedin" => 'no',
					"enable_tumblr" => 'no',
					"enable_pinterest" => 'no',
					"enable_vk" => 'no',
					"facebook_icon" => '',
					"twitter_icon" => '',
					"google_plus_icon" => '',
					"linkedin_icon" => '',
					"tumblr_icon" => '',
					"pinterest_icon" => '',
					"vk_icon" => '',
					"twitter_via" => ''
				)
			);
		}
	}

	function register_qode_theme_settings() {
		register_setting( 'qode_options_theme18_page', 'qode_options_theme18', array(&$this, 'validate_options') );
	}

	/*** Add Option to admin sidebar ***/
	function qode_admin_menu() {
		$this->init_qode_theme_options();
		$this->pagehook = add_menu_page('Select Theme', esc_html__('Select Options', 'soho-core'), 'manage_options', 'qode_options_theme18_page', array(&$this, 'qode_generate_options_page'));
		add_action('load-'.$this->pagehook, array(&$this, 'on_load_page'));
	}

	function on_load_page() {

		/*** add default wordpress meta boxes ***/
		add_meta_box('qode-general-options-metabox', esc_html__('Options', 'soho-core'), array(&$this, 'general_options_contentbox'), $this->pagehook, 'normal', 'core');

	}

	function qode_generate_options_page() {

		/***  Option for number of columns ***/
		global $screen_layout_columns, $qode_options_soho;

		/*** Saved options message ***/
		if ( isset($_REQUEST['settings-updated']) || isset($_REQUEST['updated'] )) {
			echo '<div id="message" class="updated fade"><p><strong>'.esc_html__('Settings saved.', 'soho-core').'</strong></p></div>';

		}

        do_action( 'soho_qode_action_after_theme_option_save' );

		?>
		<div id="qode-metaboxes-general" class="wrap">
			<div style="float:left; padding:10px 10px 10px 0;"></div>
			<?php $current_theme = wp_get_theme(); ?>
			<h2 style="padding-top:25px;"><?php echo $current_theme->get('Name').' - '.esc_html__('Theme Options - Version').' '.$current_theme->get('Version'); ?></h2>

			<form method="post" action="options.php">
				<?php			settings_fields( 'qode_options_theme18_page' );
				$options = get_option('qode_options_theme18');
				wp_nonce_field('closedpostboxes', 'closedpostboxesnonce', false );
				wp_nonce_field('meta-box-order', 'meta-box-order-nonce', false ); ?>

				<div id="poststuff" class="metabox-holder<?php echo 2 == $screen_layout_columns ? ' has-right-sidebar' : ''; ?>">
					<div id="post-body" class="has-sidebar">
						<div id="post-body-content" class="has-sidebar-content">
							<?php					    do_meta_boxes($this->pagehook, 'normal', $options); ?>
							<?php					    do_meta_boxes($this->pagehook, 'additional', $options); ?>
							<fieldset style="margin:2px 0 0;"><legend class="screen-reader-text"><span><?php esc_attr_e('Reset to defaults', 'soho-core') ?></span></legend>
								<label for="reset_to_defaults">
									<input name="qode_options_theme18[reset_to_defaults]" type="checkbox" id="reset_to_defaults" value="yes" />
									<?php esc_attr_e('Reset to defaults', 'soho-core') ?>
								</label>
							</fieldset>
							<p class="submit">
								<input type="hidden" id="qode_submit" value="1" name="qode_submit" />
								<input class="button-primary" type="submit" name="submit" value="<?php esc_attr_e('Save Changes', 'soho-core') ?>" />
							</p>
						</div>
					</div>
					<br class="clear"/>
				</div>
			</form>
		</div>
		<script type="text/javascript">
			//<![CDATA[
			jQuery(document).ready( function($) {
				// close qode postboxes
				$('.if-js-closed').removeClass('if-js-closed').addClass('closed');
				// qode postboxes setup
				postboxes.add_postbox_toggles('<?php echo $this->pagehook; ?>');
			});
			//]]>
		</script>
	<?php	}

	/***  Validate number option  ***/
	function validate_options( $input ) {
		global $qode_options_soho;
		$input['number_of_chars'] = is_numeric( $input['number_of_chars'] ) ? absint($input['number_of_chars']) : $qode_options_soho['number_of_chars'];
		return $input;
	}

	/*** Fields and html for meta boxes ***/

	function general_options_contentbox( $options ) {
		global $fontArrays;
		?>

		<div class="sections">
			<h3><?php esc_html_e( 'Global options', 'soho-core' ); ?></h3>
			<div>
				<table class="form-table">
					<tbody>
					<tr valign="top">
						<td scope="row" width="150"><?php esc_html_e('First main color', 'soho-core'); ?></td>
						<td>
							<div>
								<?php esc_html_e('Text color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if ($options['first_color']){ echo 'background-color:'.esc_attr($options['first_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[first_color]" type="text" value="<?php if ($options['first_color']) { echo esc_attr($options['first_color']); } ?>" size="30" maxlength="100" />
								<?php esc_html_e('Default text color', 'soho-core'); ?>
								<div class="inline" style="vertical-align:middle; margin: 0 10px;"><span style="width: 20px; height: 20px; display: inline-block; background-color: #f07474;" title="#f07474"></span></div>
							</div>
							<br/>
							<div>
								<?php esc_html_e('Area color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['first_area_color'])) { echo 'background-color:'.esc_attr($options['first_area_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[first_area_color]" type="text" value="<?php if (isset($options['first_area_color'])) { echo esc_attr($options['first_area_color']); } ?>" size="30" maxlength="100" />
								<?php esc_html_e('Default area color', 'soho-core'); ?>
								<div class="inline" style="vertical-align:middle; margin: 0 10px;"><span style="width: 20px; height: 20px; display: inline-block; background-color: #f07474;" title="#f07474"></span></div>
							</div>
						</td>
					</tr>
					<tr valign="top">
						<td scope="row" width="150"><?php esc_html_e('Second main color', 'soho-core'); ?></td>
						<td>
							<div>
								<?php esc_html_e('Text color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if ($options['second_color']){ echo 'background-color:'.esc_attr($options['second_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[second_color]" type="text" value="<?php if ($options['second_color']) { echo esc_attr($options['second_color']); } ?>" size="30" maxlength="100" />
								<?php esc_html_e('Default second main color', 'soho-core'); ?>
								<div class="inline" style="vertical-align:middle; margin: 0 10px;"><span style="width: 20px; height: 20px; display: inline-block; background-color: #363636;" title="#363636"></span></div>
							</div>
							<br/>
							<div>
								<?php esc_html_e('Area color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['second_area_color'])) { echo 'background-color:'.esc_attr($options['second_area_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[second_area_color]" type="text" value="<?php if (isset($options['second_area_color'])) { echo esc_attr($options['second_area_color']); } ?>" size="30" maxlength="100" />
								<?php esc_html_e('Default area color', 'soho-core'); ?>
								<div class="inline" style="vertical-align:middle; margin: 0 10px;"><span style="width: 20px; height: 20px; display: inline-block; background-color: #363636;" title="#363636"></span></div>
							</div>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Background color (content)', 'soho-core'); ?></td>
						<td>
							<div class="colorSelector"><div style="<?php if ($options['background_color']){ echo 'background-color:'.esc_attr($options['background_color']).';'; } ?>"></div></div>
							<input name="qode_options_theme18[background_color]" type="text" value="<?php if ($options['background_color']) { echo esc_attr($options['background_color']); } ?>" size="30" maxlength="500" />
							<?php esc_html_e('Default background color', 'soho-core'); ?>
							<div class="inline" style="vertical-align:middle; margin: 0 0 0 10px;"><span style="width: 20px; height: 20px; display: inline-block; border: 1px solid #ddd; background-color: #fff;" title="#fff"></span></div>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Background color (body)', 'soho-core'); ?></td>
						<td>
							<div class="colorSelector"><div style="<?php if ($options['background_color_box']){ echo 'background-color:'.esc_attr($options['background_color_box']).';'; } ?>"></div></div>
							<input name="qode_options_theme18[background_color_box]" type="text" value="<?php if (isset($options['background_color_box'])) { echo esc_attr($options['background_color_box']); } ?>" size="30" maxlength="500" />
							<?php esc_html_e('Default boxed background color', 'soho-core'); ?>
							<div class="inline" style="vertical-align:middle; margin: 0 0 0 10px;"><span style="width: 20px; height: 20px; display: inline-block; border: 1px solid #ddd; background-color: #F4F4F4;" title="#F4F4F4"></span></div>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Highlight color', 'soho-core'); ?></td>
						<td>
							<div class="colorSelector"><div style="<?php if ($options['highlight_color']){ echo 'background-color:'.esc_attr($options['highlight_color']).';'; } ?>"></div></div>
							<input name="qode_options_theme18[highlight_color]" type="text"  value="<?php if ($options['highlight_color']) { echo esc_attr($options['highlight_color']); } ?>" size="30" maxlength="500" />
							<?php esc_html_e('Default highlight color', 'soho-core'); ?>
							<div class="inline" style="vertical-align:middle; margin: 0 0 0 10px;"><span style="width: 20px; height: 20px; display: inline-block; background-color: #363636;" title="#363636"></span></div>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Selection color', 'soho-core'); ?></td>
						<td>
							<div class="colorSelector"><div style="<?php if ($options['selection_color']){ echo 'background-color:'.esc_attr($options['selection_color']).';'; } ?>"></div></div>
							<input name="qode_options_theme18[selection_color]" type="text"  value="<?php if ($options['selection_color']) { echo esc_attr($options['selection_color']); } ?>" size="30" maxlength="500" />
							<?php esc_html_e('Default selection color', 'soho-core'); ?>
							<div class="inline" style="vertical-align:middle; margin: 0 0 0 10px;"><span style="width: 20px; height: 20px; display: inline-block; background-color: #363636;" title="#363636"></span></div>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Content background image', 'soho-core'); ?></td>
						<td>
							<div class="inline" style="width: 705px;">
								<input type="text" id="content_background_image" name="qode_options_theme18[content_background_image]" class="content_background_image" value="<?php if (isset($options['content_background_image'])) { echo esc_attr($options['content_background_image']); } ?>" size="70">
								<input class="upload_button" type="button" value="Upload file">
							</div>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Body background image', 'soho-core'); ?></td>
						<td>
							<div class="inline" style="width: 705px;">
								<input type="text" id="background_image" name="qode_options_theme18[background_image]" class="background_image" value="<?php if (isset($options['background_image'])) { echo esc_attr($options['background_image']); } ?>" size="70">
								<input class="upload_button" type="button" value="Upload file">
							</div>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Body pattern background image', 'soho-core'); ?></td>
						<td>
							<div class="inline" style="width: 705px;">
								<input type="text" id="pattern_background_image" name="qode_options_theme18[pattern_background_image]" class="pattern_background_image" value="<?php if (isset($options['pattern_background_image'])) { echo esc_attr($options['pattern_background_image']); } ?>" size="70">
								<input class="upload_button" type="button" value="Upload file">
							</div>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Favicon image', 'soho-core'); ?></td>
						<td>
							<div class="inline" style="width: 705px;">
								<input type="text" id="favicon_image" name="qode_options_theme18[favicon_image]" class="favicon_image" value="<?php if ($options['favicon_image']) { echo esc_attr($options['favicon_image']); } else { echo SOHO_QODE_ROOT."/img/favicon.ico"; } ?>" size="70">
								<input class="upload_button" type="button" value="Upload file">
							</div>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Page transition', 'soho-core'); ?></td>
						<td>
							<select name="qode_options_theme18[page_transitions]">
								<option <?php if ($options['page_transitions'] == 0) { echo "selected='selected'"; } ?> value="0"><?php esc_html_e( 'No animation', 'soho-core' ); ?></option>
								<option <?php if ($options['page_transitions'] == 1) { echo "selected='selected'"; } ?> value="1"><?php esc_html_e( 'Up/Down', 'soho-core' ); ?></option>
								<option <?php if ($options['page_transitions'] == 2) { echo "selected='selected'"; } ?> value="2"><?php esc_html_e( 'Fade', 'soho-core' ); ?></option>
								<option <?php if ($options['page_transitions'] == 3) { echo "selected='selected'"; } ?> value="3"><?php esc_html_e( 'Up/Down (In) / Fade (Out)', 'soho-core' ); ?></option>
								<option <?php if ($options['page_transitions'] == 4) { echo "selected='selected'"; } ?> value="4"><?php esc_html_e( 'Left/Right', 'soho-core' ); ?></option>
							</select>
							<?php esc_html_e('In order for animation to work properly, you must choose "Post name" in permalinks settings', 'soho-core'); ?>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Boxed', 'soho-core'); ?></td>
						<td>
							<select name="qode_options_theme18[boxed]">
								<option <?php if(isset($options['boxed'])){ $boxed = $options['boxed']; if ($boxed == 'no') { echo "selected='selected'"; } }  ?> value="no"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
								<option <?php if(isset($options['boxed'])){ $boxed = $options['boxed']; if ($boxed == 'yes') { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
							</select>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Loading animation', 'soho-core'); ?></td>
						<td>
							<select name="qode_options_theme18[loading_animation]">
								<option <?php if (isset($options['loading_animation'])){ $loading_animation = $options['loading_animation']; if ($loading_animation == 'yes') { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
								<option <?php if (isset($options['loading_animation'])){ $loading_animation = $options['loading_animation']; if ($loading_animation == 'no') { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
							</select>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Loading image', 'soho-core'); ?></td>
						<td>
							<div class="inline" style="width: 705px;">
								<input type="text" id="loading_image" name="qode_options_theme18[loading_image]" class="loading_image" value="<?php if (isset($options['loading_image']) && $options['loading_image'] != "") { echo esc_attr($options['loading_image']); } else { echo ""; } ?>" size="70">
								<input class="upload_button" type="button" value="Upload file">
							</div>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Smooth scroll', 'soho-core'); ?></td>
						<td>
							<select name="qode_options_theme18[smooth_scroll]">
								<option <?php if(isset($options['smooth_scroll'])){ $smooth_scroll = $options['smooth_scroll']; if ($smooth_scroll == 'yes') { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
								<option <?php if(isset($options['smooth_scroll'])){ $smooth_scroll = $options['smooth_scroll']; if ($smooth_scroll == 'no') { echo "selected='selected'"; } }  ?> value="no"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
							</select>
							<?php esc_html_e('For Chrome and Opera browsers', 'soho-core'); ?>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Responsiveness', 'soho-core'); ?></td>
						<td>
							<select name="qode_options_theme18[responsiveness]">
								<option <?php if(isset($options['responsiveness'])){ $responsiveness = $options['responsiveness']; if ($responsiveness == 'yes') { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
								<option <?php if(isset($options['responsiveness'])){ $responsiveness = $options['responsiveness']; if ($responsiveness == 'no') { echo "selected='selected'"; } }  ?> value="no"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
							</select>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Show back button', 'soho-core'); ?></td>
						<td>
							<select name="qode_options_theme18[show_back_button]">
								<option <?php if(isset($options['show_back_button'])){ $show_back_button = $options['show_back_button']; if ($show_back_button == 'no') { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
								<option <?php if(isset($options['show_back_button'])){ $show_back_button = $options['show_back_button']; if ($show_back_button == 'yes') { echo "selected='selected'"; } }  ?> value="yes"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
							</select>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Elements css animation on mobile/touch devices', 'soho-core'); ?></td>
						<td>
							<select name="qode_options_theme18[elements_animation_on_touch]">
								<option <?php if(isset($options['elements_animation_on_touch'])){ $elements_animation_on_touch = $options['elements_animation_on_touch']; if ($elements_animation_on_touch == 'no') { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
								<option <?php if(isset($options['elements_animation_on_touch'])){ $elements_animation_on_touch = $options['elements_animation_on_touch']; if ($elements_animation_on_touch == 'yes') { echo "selected='selected'"; } }  ?> value="yes"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
							</select>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Google Analytics Account ID', 'soho-core'); ?></td>
						<td>
							<input name="qode_options_theme18[google_analytics_code]" type="text" value="<?php if (isset($options['google_analytics_code'])) { echo esc_attr($options['google_analytics_code']); } ?>" size="63" maxlength="500" />
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Google Maps API key', 'soho-core'); ?></td>
						<td>
							<input name="qode_options_theme18[google_maps_api_key]" type="text" value="<?php if (isset($options['google_maps_api_key'])) { echo esc_attr($options['google_maps_api_key']); } ?>" size="63" maxlength="500" />
						</td>
					</tr>
					<tr valign="top">
						<td valign="top"><?php esc_html_e('List of internal URLs loaded without AJAX (separated with comma)', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<textarea id="internal_no_ajax_links" name="qode_options_theme18[internal_no_ajax_links]" cols="60" rows="5"><?php if (isset($options['internal_no_ajax_links'])) { echo esc_attr($options['internal_no_ajax_links']); } ?></textarea>
							</div>

						</td>
					</tr>
					<tr valign="top">
						<td valign="top"><?php esc_html_e('Custom css', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<textarea id="custom_css" name="qode_options_theme18[custom_css]" cols="60" rows="5"><?php if ($options['custom_css']) { echo esc_attr($options['custom_css']); } ?></textarea>
							</div>

						</td>
					</tr>
					<tr valign="top">
						<td valign="top"><?php esc_html_e('Custom js', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<textarea id="custom_js" name="qode_options_theme18[custom_js]" cols="60" rows="5"><?php if ($options['custom_js']) { echo esc_attr($options['custom_js']); } ?></textarea>
							</div><br/>
							<?php esc_html_e('jQuery selector is "$j" because of the conflict mode', 'soho-core'); ?>
						</td>
					</tr>
					<tr valign="top">
						<td valign="top"><?php esc_html_e('Meta Keywords', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<textarea id="meta_keywords" name="qode_options_theme18[meta_keywords]" cols="60" rows="5"><?php if ($options['meta_keywords']) { echo esc_attr($options['meta_keywords']); } ?></textarea>
							</div>
						</td>
					</tr>
					<tr valign="top">
						<td valign="top"><?php esc_html_e('Meta Description', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<textarea id="meta_description" name="qode_options_theme18[meta_description]" cols="60" rows="5"><?php if ($options['meta_description']) { echo esc_attr($options['meta_description']); } ?></textarea>
							</div>
						</td>
					</tr>
					<tr valign="top">
						<td scope="row" width="150"><?php esc_html_e('Disable Select SEO', 'soho-core'); ?></td>
						<td>
							<select name="qode_options_theme18[disable_qode_seo]">
								<option <?php if(isset($options['disable_qode_seo'])){ $disable_qode_seo = $options['disable_qode_seo']; if ($disable_qode_seo == 'no') { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
								<option <?php if(isset($options['disable_qode_seo'])){ $disable_qode_seo = $options['disable_qode_seo']; if ($disable_qode_seo == 'yes') { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
							</select>
						</td>
					</tr>
					</tbody>
				</table>
				<?php		display_save_changes_button(); ?>
			</div>
			<h3><?php esc_html_e( 'General font options', 'soho-core' ); ?></h3>
			<div>
				<table class="form-table">
					<tbody>
					<tr><td colspan='2'><h2><?php esc_html_e( 'Global Font', 'soho-core' ); ?></h2></td></tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Google fonts', 'soho-core'); ?></td>
						<td>
							<select name="qode_options_theme18[google_fonts]">
								<option value="-1"><?php esc_html_e( 'Default', 'soho-core' ); ?></option>
								<?php foreach($fontArrays as $fontArray) { ?>
									<option <?php if ($options['google_fonts'] == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo  $fontArray["family"]; ?></option>
								<?php } ?>
							</select>
						</td>
					</tr>
					<tr><td colspan='2'><h2><?php esc_html_e( 'Headings', 'soho-core' ); ?></h2></td></tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('H1 style', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if ($options['h1_color']){ echo 'background-color:'.esc_attr($options['h1_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[h1_color]" type="text" value="<?php if ($options['h1_color']) { echo esc_attr($options['h1_color']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font family', 'soho-core'); ?>
								<select name="qode_options_theme18[h1_google_fonts]">
									<option value="-1"><?php esc_html_e( 'Default', 'soho-core' ); ?></option>
									<?php foreach($fontArrays as $fontArray) { ?>
										<option <?php if ($options['h1_google_fonts'] == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo  $fontArray["family"]; ?></option>
									<?php } ?>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font size (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[h1_fontsize]" type="text" value="<?php if ($options['h1_fontsize']) { echo esc_attr($options['h1_fontsize']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Line height (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[h1_lineheight]" type="text" value="<?php if ($options['h1_lineheight']) { echo esc_attr($options['h1_lineheight']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font style', 'soho-core'); ?>
								<select name="qode_options_theme18[h1_fontstyle]">
									<option <?php if ($options['h1_fontstyle'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if ($options['h1_fontstyle'] == "normal") { echo "selected='selected'"; } ?> value="normal"><?php esc_html_e( 'normal', 'soho-core' ); ?></option>
									<option <?php if ($options['h1_fontstyle'] == "italic") { echo "selected='selected'"; } ?> value="italic"><?php esc_html_e( 'italic', 'soho-core' ); ?></option>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font weight', 'soho-core'); ?>
								<select name="qode_options_theme18[h1_fontweight]">
									<option <?php if ($options['h1_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if ($options['h1_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200">200</option>
									<option <?php if ($options['h1_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300">300</option>
									<option <?php if ($options['h1_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400">400</option>
									<option <?php if ($options['h1_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500">500</option>
									<option <?php if ($options['h1_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600">600</option>
									<option <?php if ($options['h1_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700">700</option>
									<option <?php if ($options['h1_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800">800</option>
									<option <?php if ($options['h1_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900">900</option>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Letter spacing (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[h1_letterspacing]" type="text" value="<?php if (isset($options['h1_letterspacing']) && $options['h1_letterspacing']) { echo esc_attr($options['h1_letterspacing']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Text Transform', 'soho-core'); ?>
								<select name="qode_options_theme18[h1_texttransform]">
									<option <?php if (isset($options['h1_texttransform']) && $options['h1_texttransform'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if (isset($options['h1_texttransform']) && $options['h1_texttransform'] == "none") { echo "selected='selected'"; } ?> value="none"><?php esc_html_e( 'None', 'soho-core' ); ?></option>
									<option <?php if (isset($options['h1_texttransform']) && $options['h1_texttransform'] == "capitalize") { echo "selected='selected'"; } ?> value="capitalize"><?php esc_html_e( 'Capitalize', 'soho-core' ); ?></option>
									<option <?php if (isset($options['h1_texttransform']) && $options['h1_texttransform'] == "uppercase") { echo "selected='selected'"; } ?> value="uppercase"><?php esc_html_e( 'Uppercase', 'soho-core' ); ?></option>
									<option <?php if (isset($options['h1_texttransform']) && $options['h1_texttransform'] == "lowercase") { echo "selected='selected'"; } ?> value="lowercase"><?php esc_html_e( 'Lowercase', 'soho-core' ); ?></option>
								</select>
							</div>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('H2 style', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if ($options['h2_color']){ echo 'background-color:'.esc_attr($options['h2_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[h2_color]" type="text" value="<?php if ($options['h2_color']) { echo esc_attr($options['h2_color']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font family', 'soho-core'); ?>
								<select name="qode_options_theme18[h2_google_fonts]">
									<option value="-1"><?php esc_html_e( 'Default', 'soho-core' ); ?></option>
									<?php foreach($fontArrays as $fontArray) { ?>
										<option <?php if ($options['h2_google_fonts'] == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo  $fontArray["family"]; ?></option>
									<?php } ?>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font size (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[h2_fontsize]" type="text" value="<?php if ($options['h2_fontsize']) { echo esc_attr($options['h2_fontsize']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Line height (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[h2_lineheight]" type="text" value="<?php if ($options['h2_lineheight']) { echo esc_attr($options['h2_lineheight']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font style', 'soho-core'); ?>
								<select name="qode_options_theme18[h2_fontstyle]">
									<option <?php if ($options['h2_fontstyle'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if ($options['h2_fontstyle'] == "normal") { echo "selected='selected'"; } ?> value="normal"><?php esc_html_e( 'normal', 'soho-core' ); ?></option>
									<option <?php if ($options['h2_fontstyle'] == "italic") { echo "selected='selected'"; } ?> value="italic"><?php esc_html_e( 'italic', 'soho-core' ); ?></option>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font weight', 'soho-core'); ?>
								<select name="qode_options_theme18[h2_fontweight]">
									<option <?php if ($options['h2_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if ($options['h2_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200">200</option>
									<option <?php if ($options['h2_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300">300</option>
									<option <?php if ($options['h2_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400">400</option>
									<option <?php if ($options['h2_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500">500</option>
									<option <?php if ($options['h2_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600">600</option>
									<option <?php if ($options['h2_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700">700</option>
									<option <?php if ($options['h2_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800">800</option>
									<option <?php if ($options['h2_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900">900</option>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Letter spacing (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[h2_letterspacing]" type="text" value="<?php if (isset($options['h2_letterspacing']) && $options['h2_letterspacing']) { echo esc_attr($options['h2_letterspacing']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Text Transform', 'soho-core'); ?>
								<select name="qode_options_theme18[h2_texttransform]">
									<option <?php if (isset($options['h2_texttransform']) && $options['h2_texttransform'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if (isset($options['h2_texttransform']) && $options['h2_texttransform'] == "none") { echo "selected='selected'"; } ?> value="none"><?php esc_html_e( 'None', 'soho-core' ); ?></option>
									<option <?php if (isset($options['h2_texttransform']) && $options['h2_texttransform'] == "capitalize") { echo "selected='selected'"; } ?> value="capitalize"><?php esc_html_e( 'Capitalize', 'soho-core' ); ?></option>
									<option <?php if (isset($options['h2_texttransform']) && $options['h2_texttransform'] == "uppercase") { echo "selected='selected'"; } ?> value="uppercase"><?php esc_html_e( 'Uppercase', 'soho-core' ); ?></option>
									<option <?php if (isset($options['h2_texttransform']) && $options['h2_texttransform'] == "lowercase") { echo "selected='selected'"; } ?> value="lowercase"><?php esc_html_e( 'Lowercase', 'soho-core' ); ?></option>
								</select>
							</div>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('H3 style', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if ($options['h3_color']){ echo 'background-color:'.esc_attr($options['h3_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[h3_color]" type="text" value="<?php if ($options['h3_color']) { echo esc_attr($options['h3_color']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font family', 'soho-core'); ?>
								<select name="qode_options_theme18[h3_google_fonts]">
									<option value="-1"><?php esc_html_e( 'Default', 'soho-core' ); ?></option>
									<?php foreach($fontArrays as $fontArray) { ?>
										<option <?php if ($options['h3_google_fonts'] == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo  $fontArray["family"]; ?></option>
									<?php } ?>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font size (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[h3_fontsize]" type="text" value="<?php if ($options['h3_fontsize']) { echo esc_attr($options['h3_fontsize']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Line height (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[h3_lineheight]" type="text" value="<?php if ($options['h3_lineheight']) { echo esc_attr($options['h3_lineheight']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font style', 'soho-core'); ?>
								<select name="qode_options_theme18[h3_fontstyle]">
									<option <?php if ($options['h3_fontstyle'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if ($options['h3_fontstyle'] == "normal") { echo "selected='selected'"; } ?> value="normal"><?php esc_html_e( 'normal', 'soho-core' ); ?></option>
									<option <?php if ($options['h3_fontstyle'] == "italic") { echo "selected='selected'"; } ?> value="italic"><?php esc_html_e( 'italic', 'soho-core' ); ?></option>

								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font weight', 'soho-core'); ?>
								<select name="qode_options_theme18[h3_fontweight]">
									<option <?php if ($options['h3_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if ($options['h3_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200">200</option>
									<option <?php if ($options['h3_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300">300</option>
									<option <?php if ($options['h3_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400">400</option>
									<option <?php if ($options['h3_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500">500</option>
									<option <?php if ($options['h3_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600">600</option>
									<option <?php if ($options['h3_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700">700</option>
									<option <?php if ($options['h3_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800">800</option>
									<option <?php if ($options['h3_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900">900</option>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Letter spacing (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[h3_letterspacing]" type="text" value="<?php if (isset($options['h3_letterspacing']) && $options['h3_letterspacing']) { echo esc_attr($options['h3_letterspacing']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Text Transform', 'soho-core'); ?>
								<select name="qode_options_theme18[h3_texttransform]">
									<option <?php if (isset($options['h3_texttransform']) && $options['h3_texttransform'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if (isset($options['h3_texttransform']) && $options['h3_texttransform'] == "none") { echo "selected='selected'"; } ?> value="none"><?php esc_html_e( 'None', 'soho-core' ); ?></option>
									<option <?php if (isset($options['h3_texttransform']) && $options['h3_texttransform'] == "capitalize") { echo "selected='selected'"; } ?> value="capitalize"><?php esc_html_e( 'Capitalize', 'soho-core' ); ?></option>
									<option <?php if (isset($options['h3_texttransform']) && $options['h3_texttransform'] == "uppercase") { echo "selected='selected'"; } ?> value="uppercase"><?php esc_html_e( 'Uppercase', 'soho-core' ); ?></option>
									<option <?php if (isset($options['h3_texttransform']) && $options['h3_texttransform'] == "lowercase") { echo "selected='selected'"; } ?> value="lowercase"><?php esc_html_e( 'Lowercase', 'soho-core' ); ?></option>
								</select>
							</div>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('H4 style', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if ($options['h4_color']){ echo 'background-color:'.esc_attr($options['h4_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[h4_color]" type="text" value="<?php if ($options['h4_color']) { echo esc_attr($options['h4_color']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font family', 'soho-core'); ?>
								<select name="qode_options_theme18[h4_google_fonts]">
									<option value="-1"><?php esc_html_e( 'Default', 'soho-core' ); ?></option>
									<?php foreach($fontArrays as $fontArray) { ?>
										<option <?php if ($options['h4_google_fonts'] == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo  $fontArray["family"]; ?></option>
									<?php } ?>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font size (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[h4_fontsize]" type="text" value="<?php if ($options['h4_fontsize']) { echo esc_attr($options['h4_fontsize']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Line height (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[h4_lineheight]" type="text" value="<?php if ($options['h4_lineheight']) { echo esc_attr($options['h4_lineheight']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font style', 'soho-core'); ?>
								<select name="qode_options_theme18[h4_fontstyle]">
									<option <?php if ($options['h4_fontstyle'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if ($options['h4_fontstyle'] == "normal") { echo "selected='selected'"; } ?> value="normal"><?php esc_html_e( 'normal', 'soho-core' ); ?></option>
									<option <?php if ($options['h4_fontstyle'] == "italic") { echo "selected='selected'"; } ?> value="italic"><?php esc_html_e( 'italic', 'soho-core' ); ?></option>

								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font weight', 'soho-core'); ?>
								<select name="qode_options_theme18[h4_fontweight]">
									<option <?php if ($options['h4_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if ($options['h4_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200">200</option>
									<option <?php if ($options['h4_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300">300</option>
									<option <?php if ($options['h4_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400">400</option>
									<option <?php if ($options['h4_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500">500</option>
									<option <?php if ($options['h4_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600">600</option>
									<option <?php if ($options['h4_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700">700</option>
									<option <?php if ($options['h4_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800">800</option>
									<option <?php if ($options['h4_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900">900</option>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Letter spacing (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[h4_letterspacing]" type="text" value="<?php if (isset($options['h4_letterspacing']) && $options['h4_letterspacing']) { echo esc_attr($options['h4_letterspacing']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Text Transform', 'soho-core'); ?>
								<select name="qode_options_theme18[h4_texttransform]">
									<option <?php if (isset($options['h4_texttransform']) && $options['h4_texttransform'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if (isset($options['h4_texttransform']) && $options['h4_texttransform'] == "none") { echo "selected='selected'"; } ?> value="none"><?php esc_html_e( 'None', 'soho-core' ); ?></option>
									<option <?php if (isset($options['h4_texttransform']) && $options['h4_texttransform'] == "capitalize") { echo "selected='selected'"; } ?> value="capitalize"><?php esc_html_e( 'Capitalize', 'soho-core' ); ?></option>
									<option <?php if (isset($options['h4_texttransform']) && $options['h4_texttransform'] == "uppercase") { echo "selected='selected'"; } ?> value="uppercase"><?php esc_html_e( 'Uppercase', 'soho-core' ); ?></option>
									<option <?php if (isset($options['h4_texttransform']) && $options['h4_texttransform'] == "lowercase") { echo "selected='selected'"; } ?> value="lowercase"><?php esc_html_e( 'Lowercase', 'soho-core' ); ?></option>
								</select>
							</div>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('H5 style', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if ($options['h5_color']){ echo 'background-color:'.esc_attr($options['h5_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[h5_color]" type="text" value="<?php if ($options['h5_color']) { echo esc_attr($options['h5_color']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font family', 'soho-core'); ?>
								<select name="qode_options_theme18[h5_google_fonts]">
									<option value="-1"><?php esc_html_e( 'Default', 'soho-core' ); ?></option>
									<?php foreach($fontArrays as $fontArray) { ?>
										<option <?php if ($options['h5_google_fonts'] == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo  $fontArray["family"]; ?></option>
									<?php } ?>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font size (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[h5_fontsize]" type="text" value="<?php if ($options['h5_fontsize']) { echo esc_attr($options['h5_fontsize']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Line height (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[h5_lineheight]" type="text" value="<?php if ($options['h5_lineheight']) { echo esc_attr($options['h5_lineheight']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font style', 'soho-core'); ?>
								<select name="qode_options_theme18[h5_fontstyle]">
									<option <?php if ($options['h5_fontstyle'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if ($options['h5_fontstyle'] == "normal") { echo "selected='selected'"; } ?> value="normal"><?php esc_html_e( 'normal', 'soho-core' ); ?></option>
									<option <?php if ($options['h5_fontstyle'] == "italic") { echo "selected='selected'"; } ?> value="italic"><?php esc_html_e( 'italic', 'soho-core' ); ?></option>

								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font weight', 'soho-core'); ?>
								<select name="qode_options_theme18[h5_fontweight]">
									<option <?php if ($options['h5_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if ($options['h5_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200">200</option>
									<option <?php if ($options['h5_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300">300</option>
									<option <?php if ($options['h5_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400">400</option>
									<option <?php if ($options['h5_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500">500</option>
									<option <?php if ($options['h5_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600">600</option>
									<option <?php if ($options['h5_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700">700</option>
									<option <?php if ($options['h5_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800">800</option>
									<option <?php if ($options['h5_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900">900</option>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Letter spacing (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[h5_letterspacing]" type="text" value="<?php if (isset($options['h5_letterspacing']) && $options['h5_letterspacing']) { echo esc_attr($options['h5_letterspacing']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Text Transform', 'soho-core'); ?>
								<select name="qode_options_theme18[h5_texttransform]">
									<option <?php if (isset($options['h5_texttransform']) && $options['h5_texttransform'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if (isset($options['h5_texttransform']) && $options['h5_texttransform'] == "none") { echo "selected='selected'"; } ?> value="none"><?php esc_html_e( 'None', 'soho-core' ); ?></option>
									<option <?php if (isset($options['h5_texttransform']) && $options['h5_texttransform'] == "capitalize") { echo "selected='selected'"; } ?> value="capitalize"><?php esc_html_e( 'Capitalize', 'soho-core' ); ?></option>
									<option <?php if (isset($options['h5_texttransform']) && $options['h5_texttransform'] == "uppercase") { echo "selected='selected'"; } ?> value="uppercase"><?php esc_html_e( 'Uppercase', 'soho-core' ); ?></option>
									<option <?php if (isset($options['h5_texttransform']) && $options['h5_texttransform'] == "lowercase") { echo "selected='selected'"; } ?> value="lowercase"><?php esc_html_e( 'Lowercase', 'soho-core' ); ?></option>
								</select>
							</div>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('H6 style', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if ($options['h6_color']){ echo 'background-color:'.esc_attr($options['h6_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[h6_color]" type="text" value="<?php if ($options['h6_color']) { echo esc_attr($options['h6_color']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font family', 'soho-core'); ?>
								<select name="qode_options_theme18[h6_google_fonts]">
									<option value="-1"><?php esc_html_e( 'Default', 'soho-core' ); ?></option>
									<?php foreach($fontArrays as $fontArray) { ?>
										<option <?php if ($options['h6_google_fonts'] == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo  $fontArray["family"]; ?></option>
									<?php } ?>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font size (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[h6_fontsize]" type="text" value="<?php if ($options['h6_fontsize']) { echo esc_attr($options['h6_fontsize']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Line height (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[h6_lineheight]" type="text" value="<?php if ($options['h6_lineheight']) { echo esc_attr($options['h6_lineheight']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font style', 'soho-core'); ?>
								<select name="qode_options_theme18[h6_fontstyle]">
									<option <?php if ($options['h6_fontstyle'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if ($options['h6_fontstyle'] == "normal") { echo "selected='selected'"; } ?> value="normal"><?php esc_html_e( 'normal', 'soho-core' ); ?></option>
									<option <?php if ($options['h6_fontstyle'] == "italic") { echo "selected='selected'"; } ?> value="italic"><?php esc_html_e( 'italic', 'soho-core' ); ?></option>

								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font weight', 'soho-core'); ?>
								<select name="qode_options_theme18[h6_fontweight]">
									<option <?php if ($options['h6_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if ($options['h6_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200">200</option>
									<option <?php if ($options['h6_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300">300</option>
									<option <?php if ($options['h6_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400">400</option>
									<option <?php if ($options['h6_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500">500</option>
									<option <?php if ($options['h6_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600">600</option>
									<option <?php if ($options['h6_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700">700</option>
									<option <?php if ($options['h6_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800">800</option>
									<option <?php if ($options['h6_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900">900</option>

								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Letter spacing (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[h6_letterspacing]" type="text" value="<?php if (isset($options['h6_letterspacing']) && $options['h6_letterspacing']) { echo esc_attr($options['h6_letterspacing']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Text Transform', 'soho-core'); ?>
								<select name="qode_options_theme18[h6_texttransform]">
									<option <?php if (isset($options['h6_texttransform']) && $options['h6_texttransform'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if (isset($options['h6_texttransform']) && $options['h6_texttransform'] == "none") { echo "selected='selected'"; } ?> value="none"><?php esc_html_e( 'None', 'soho-core' ); ?></option>
									<option <?php if (isset($options['h6_texttransform']) && $options['h6_texttransform'] == "capitalize") { echo "selected='selected'"; } ?> value="capitalize"><?php esc_html_e( 'Capitalize', 'soho-core' ); ?></option>
									<option <?php if (isset($options['h6_texttransform']) && $options['h6_texttransform'] == "uppercase") { echo "selected='selected'"; } ?> value="uppercase"><?php esc_html_e( 'Uppercase', 'soho-core' ); ?></option>
									<option <?php if (isset($options['h6_texttransform']) && $options['h6_texttransform'] == "lowercase") { echo "selected='selected'"; } ?> value="lowercase"><?php esc_html_e( 'Lowercase', 'soho-core' ); ?></option>
								</select>
							</div>
						</td>
					</tr>
					<tr><td colspan='2'><h2><?php esc_html_e( 'Text', 'soho-core' ); ?></h2></td></tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Text style', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if ($options['text_color']){ echo 'background-color:'.esc_attr($options['text_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[text_color]" type="text" value="<?php if ($options['text_color']) { echo esc_attr($options['text_color']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font family', 'soho-core'); ?>
								<select name="qode_options_theme18[text_google_fonts]">
									<option value="-1"><?php esc_html_e( 'Default', 'soho-core' ); ?></option>
									<?php foreach($fontArrays as $fontArray) { ?>
										<option <?php if ($options['text_google_fonts'] == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo  $fontArray["family"]; ?></option>
									<?php } ?>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font size (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[text_fontsize]" type="text" value="<?php if ($options['text_fontsize']) { echo esc_attr($options['text_fontsize']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Line height (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[text_lineheight]" type="text" value="<?php if ($options['text_lineheight']) { echo esc_attr($options['text_lineheight']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font style', 'soho-core'); ?>
								<select name="qode_options_theme18[text_fontstyle]">
									<option <?php if ($options['text_fontstyle'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if ($options['text_fontstyle'] == "normal") { echo "selected='selected'"; } ?> value="normal"><?php esc_html_e( 'normal', 'soho-core' ); ?></option>
									<option <?php if ($options['text_fontstyle'] == "italic") { echo "selected='selected'"; } ?> value="italic"><?php esc_html_e( 'italic', 'soho-core' ); ?></option>

								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font weight', 'soho-core'); ?>
								<select name="qode_options_theme18[text_fontweight]">
									<option <?php if ($options['text_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if ($options['text_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200">200</option>
									<option <?php if ($options['text_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300">300</option>
									<option <?php if ($options['text_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400">400</option>
									<option <?php if ($options['text_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500">500</option>
									<option <?php if ($options['text_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600">600</option>
									<option <?php if ($options['text_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700">700</option>
									<option <?php if ($options['text_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800">800</option>
									<option <?php if ($options['text_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900">900</option>

								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Top/Bottom margin (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[text_margin]" type="text" value="<?php if (isset($options['text_margin'])) { echo esc_attr($options['text_margin']); } ?>" size="10" maxlength="10" />
							</div>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Link style', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if ($options['link_color']){ echo 'background-color:'.esc_attr($options['link_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[link_color]" type="text" value="<?php if ($options['link_color']) { echo esc_attr($options['link_color']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Hover color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if ($options['link_hovercolor']){ echo 'background-color:'.esc_attr($options['link_hovercolor']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[link_hovercolor]" type="text" value="<?php if ($options['link_hovercolor']) { echo esc_attr($options['link_hovercolor']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font style', 'soho-core'); ?>
								<select name="qode_options_theme18[link_fontstyle]">
									<option <?php if ($options['link_fontstyle'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if ($options['link_fontstyle'] == "normal") { echo "selected='selected'"; } ?> value="normal"><?php esc_html_e( 'normal', 'soho-core' ); ?></option>
									<option <?php if ($options['link_fontstyle'] == "italic") { echo "selected='selected'"; } ?> value="italic"><?php esc_html_e( 'italic', 'soho-core' ); ?></option>

								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font weight', 'soho-core'); ?>
								<select name="qode_options_theme18[link_fontweight]">
									<option <?php if ($options['link_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if ($options['link_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200">200</option>
									<option <?php if ($options['link_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300">300</option>
									<option <?php if ($options['link_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400">400</option>
									<option <?php if ($options['link_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500">500</option>
									<option <?php if ($options['link_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600">600</option>
									<option <?php if ($options['link_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700">700</option>
									<option <?php if ($options['link_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800">800</option>
									<option <?php if ($options['link_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900">900</option>

								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font decoration', 'soho-core'); ?>
								<select name="qode_options_theme18[link_fontdecoration]">
									<option <?php if ($options['link_fontdecoration'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if ($options['link_fontdecoration'] == "none") { echo "selected='selected'"; } ?> value="none"><?php esc_html_e( 'none', 'soho-core' ); ?></option>
									<option <?php if ($options['link_fontdecoration'] == "bold") { echo "selected='selected'"; } ?> value="underline"><?php esc_html_e( 'underline', 'soho-core' ); ?></option>

								</select>
							</div>
						</td>
					</tr>
					<tr><td colspan='2'><h2><?php esc_html_e( 'Header Menu', 'soho-core' ); ?></h2></td></tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('1st level menu style', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if ($options['menu_color']){ echo 'background-color:'.esc_attr($options['menu_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[menu_color]" type="text" value="<?php if ($options['menu_color']) { echo esc_attr($options['menu_color']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Hover/Active color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['menu_hovercolor'])){ echo 'background-color:'.esc_attr($options['menu_hovercolor']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[menu_hovercolor]" type="text" value="<?php if (isset($options['menu_hovercolor'])) { echo esc_attr($options['menu_hovercolor']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Top line color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['menu_top_line_color'])){ echo 'background-color:'.esc_attr($options['menu_top_line_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[menu_top_line_color]" type="text" value="<?php if (isset($options['menu_top_line_color'])) { echo esc_attr($options['menu_top_line_color']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font family', 'soho-core'); ?>
								<select name="qode_options_theme18[menu_google_fonts]">
									<option value="-1"><?php esc_html_e( 'Default', 'soho-core' ); ?></option>
									<?php foreach($fontArrays as $fontArray) { ?>
										<option <?php if ($options['menu_google_fonts'] == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo  $fontArray["family"]; ?></option>
									<?php } ?>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font size (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[menu_fontsize]" type="text" value="<?php if ($options['menu_fontsize']) { echo esc_attr($options['menu_fontsize']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Line height (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[menu_lineheight]" type="text" value="<?php if ($options['menu_lineheight']) { echo esc_attr($options['menu_lineheight']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font style', 'soho-core'); ?>
								<select name="qode_options_theme18[menu_fontstyle]">
									<option <?php if ($options['menu_fontstyle'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if ($options['menu_fontstyle'] == "normal") { echo "selected='selected'"; } ?> value="normal"><?php esc_html_e( 'normal', 'soho-core' ); ?></option>
									<option <?php if ($options['menu_fontstyle'] == "italic") { echo "selected='selected'"; } ?> value="italic"><?php esc_html_e( 'italic', 'soho-core' ); ?></option>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font weight', 'soho-core'); ?>
								<select name="qode_options_theme18[menu_fontweight]">
									<option <?php if ($options['menu_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if ($options['menu_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200">200</option>
									<option <?php if ($options['menu_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300">300</option>
									<option <?php if ($options['menu_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400">400</option>
									<option <?php if ($options['menu_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500">500</option>
									<option <?php if ($options['menu_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600">600</option>
									<option <?php if ($options['menu_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700">700</option>
									<option <?php if ($options['menu_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800">800</option>
									<option <?php if ($options['menu_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900">900</option>
								</select>
							</div>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('2nd level menu style', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['dropdown_color'])){ echo 'background-color:'.esc_attr($options['dropdown_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[dropdown_color]" type="text" value="<?php if (isset($options['dropdown_color'])) { echo esc_attr($options['dropdown_color']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Hover/Active color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['dropdown_hovercolor'])){ echo 'background-color:'.esc_attr($options['dropdown_hovercolor']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[dropdown_hovercolor]" type="text" value="<?php if (isset($options['dropdown_hovercolor'])) { echo esc_attr($options['dropdown_hovercolor']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font family', 'soho-core'); ?>
								<select name="qode_options_theme18[dropdown_google_fonts]">
									<option value="-1"><?php esc_html_e( 'Default', 'soho-core' ); ?></option>
									<?php foreach($fontArrays as $fontArray) { ?>
										<option <?php if ($options['dropdown_google_fonts'] == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo  $fontArray["family"]; ?></option>
									<?php } ?>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font size (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[dropdown_fontsize]" type="text" value="<?php if ($options['dropdown_fontsize']) { echo esc_attr($options['dropdown_fontsize']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Line height (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[dropdown_lineheight]" type="text" value="<?php if ($options['dropdown_lineheight']) { echo esc_attr($options['dropdown_lineheight']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font style', 'soho-core'); ?>
								<select name="qode_options_theme18[dropdown_fontstyle]">
									<option <?php if ($options['dropdown_fontstyle'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if ($options['dropdown_fontstyle'] == "normal") { echo "selected='selected'"; } ?> value="normal"><?php esc_html_e( 'normal', 'soho-core' ); ?></option>
									<option <?php if ($options['dropdown_fontstyle'] == "italic") { echo "selected='selected'"; } ?> value="italic"><?php esc_html_e( 'italic', 'soho-core' ); ?></option>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font weight', 'soho-core'); ?>
								<select name="qode_options_theme18[dropdown_fontweight]">
									<option <?php if ($options['dropdown_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if ($options['dropdown_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200">200</option>
									<option <?php if ($options['dropdown_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300">300</option>
									<option <?php if ($options['dropdown_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400">400</option>
									<option <?php if ($options['dropdown_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500">500</option>
									<option <?php if ($options['dropdown_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600">600</option>
									<option <?php if ($options['dropdown_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700">700</option>
									<option <?php if ($options['dropdown_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800">800</option>
									<option <?php if ($options['dropdown_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900">900</option>
								</select>
							</div>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('3rd level menu style', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['dropdown_color_thirdlvl'])){ echo 'background-color:'.esc_attr($options['dropdown_color_thirdlvl']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[dropdown_color_thirdlvl]" type="text" value="<?php if (isset($options['dropdown_color_thirdlvl'])) { echo esc_attr($options['dropdown_color_thirdlvl']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Hover/Active color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['dropdown_hovercolor_thirdlvl'])){ echo 'background-color:'.esc_attr($options['dropdown_hovercolor_thirdlvl']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[dropdown_hovercolor_thirdlvl]" type="text" value="<?php if (isset($options['dropdown_hovercolor_thirdlvl'])) { echo esc_attr($options['dropdown_hovercolor_thirdlvl']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font family', 'soho-core'); ?>
								<select name="qode_options_theme18[dropdown_google_fonts_thirdlvl]">
									<option value="-1"><?php esc_html_e( 'Default', 'soho-core' ); ?></option>
									<?php foreach($fontArrays as $fontArray) { ?>
										<option <?php if(isset($options['dropdown_google_fonts_thirdlvl'])){ $dropdown_google_fonts_thirdlvl = $options['dropdown_google_fonts_thirdlvl']; if ($dropdown_google_fonts_thirdlvl == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo  $fontArray["family"]; ?></option>
									<?php } ?>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font size (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[dropdown_fontsize_thirdlvl]" type="text" value="<?php if (isset($options['dropdown_fontsize_thirdlvl'])) { echo esc_attr($options['dropdown_fontsize_thirdlvl']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Line height (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[dropdown_lineheight_thirdlvl]" type="text" value="<?php if (isset($options['dropdown_lineheight_thirdlvl'])) { echo esc_attr($options['dropdown_lineheight_thirdlvl']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font style', 'soho-core'); ?>
								<select name="qode_options_theme18[dropdown_fontstyle_thirdlvl]">
									<option <?php if(isset($options['dropdown_fontstyle_thirdlvl'])){ $dropdown_fontstyle_thirdlvl = $options['dropdown_fontstyle_thirdlvl']; if ($dropdown_fontstyle_thirdlvl == '') { echo "selected='selected'"; } } ?> value=""></option>
									<option <?php if(isset($options['dropdown_fontstyle_thirdlvl'])){ $dropdown_fontstyle_thirdlvl = $options['dropdown_fontstyle_thirdlvl']; if ($dropdown_fontstyle_thirdlvl == 'normal') { echo "selected='selected'"; } } ?> value="normal"><?php esc_html_e( 'normal', 'soho-core' ); ?></option>
									<option <?php if(isset($options['dropdown_fontstyle_thirdlvl'])){ $dropdown_fontstyle_thirdlvl = $options['dropdown_fontstyle_thirdlvl']; if ($dropdown_fontstyle_thirdlvl == 'italic') { echo "selected='selected'"; } } ?> value="italic"><?php esc_html_e( 'italic', 'soho-core' ); ?></option>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font weight', 'soho-core'); ?>
								<select name="qode_options_theme18[dropdown_fontweight_thirdlvl]">
									<option <?php if(isset($options['dropdown_fontweight_thirdlvl'])){ $dropdown_fontweight_thirdlvl = $options['dropdown_fontweight_thirdlvl']; if ($dropdown_fontweight_thirdlvl == '') { echo "selected='selected'"; } } ?> value=""></option>
									<option <?php if(isset($options['dropdown_fontweight_thirdlvl'])){ $dropdown_fontweight_thirdlvl = $options['dropdown_fontweight_thirdlvl']; if ($dropdown_fontweight_thirdlvl == '200') { echo "selected='selected'"; } } ?> value="200">200</option>
									<option <?php if(isset($options['dropdown_fontweight_thirdlvl'])){ $dropdown_fontweight_thirdlvl = $options['dropdown_fontweight_thirdlvl']; if ($dropdown_fontweight_thirdlvl == '300') { echo "selected='selected'"; } } ?> value="300">300</option>
									<option <?php if(isset($options['dropdown_fontweight_thirdlvl'])){ $dropdown_fontweight_thirdlvl = $options['dropdown_fontweight_thirdlvl']; if ($dropdown_fontweight_thirdlvl == '400') { echo "selected='selected'"; } } ?> value="400">400</option>
									<option <?php if(isset($options['dropdown_fontweight_thirdlvl'])){ $dropdown_fontweight_thirdlvl = $options['dropdown_fontweight_thirdlvl']; if ($dropdown_fontweight_thirdlvl == '500') { echo "selected='selected'"; } } ?> value="500">500</option>
									<option <?php if(isset($options['dropdown_fontweight_thirdlvl'])){ $dropdown_fontweight_thirdlvl = $options['dropdown_fontweight_thirdlvl']; if ($dropdown_fontweight_thirdlvl == '600') { echo "selected='selected'"; } } ?> value="600">600</option>
									<option <?php if(isset($options['dropdown_fontweight_thirdlvl'])){ $dropdown_fontweight_thirdlvl = $options['dropdown_fontweight_thirdlvl']; if ($dropdown_fontweight_thirdlvl == '700') { echo "selected='selected'"; } } ?> value="700">700</option>
									<option <?php if(isset($options['dropdown_fontweight_thirdlvl'])){ $dropdown_fontweight_thirdlvl = $options['dropdown_fontweight_thirdlvl']; if ($dropdown_fontweight_thirdlvl == '800') { echo "selected='selected'"; } } ?> value="800">800</option>
									<option <?php if(isset($options['dropdown_fontweight_thirdlvl'])){ $dropdown_fontweight_thirdlvl = $options['dropdown_fontweight_thirdlvl']; if ($dropdown_fontweight_thirdlvl == '900') { echo "selected='selected'"; } } ?> value="900">900</option>
								</select>
							</div>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Fixed menu', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['fixed_color'])){ echo 'background-color:'.esc_attr($options['fixed_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[fixed_color]" type="text" value="<?php if (isset($options['fixed_color'])) { echo esc_attr($options['fixed_color']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Hover/Active color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['fixed_hovercolor'])){ echo 'background-color:'.esc_attr($options['fixed_hovercolor']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[fixed_hovercolor]" type="text" value="<?php if (isset($options['fixed_hovercolor'])) { echo esc_attr($options['fixed_hovercolor']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font family', 'soho-core'); ?>
								<select name="qode_options_theme18[fixed_google_fonts]">
									<option value="-1"><?php esc_html_e( 'Default', 'soho-core' ); ?></option>
									<?php foreach($fontArrays as $fontArray) { ?>
										<option <?php if(isset($options['fixed_google_fonts'])){ $fixed_google_fonts = $options['fixed_google_fonts']; if ($fixed_google_fonts == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo  $fontArray["family"]; ?></option>
									<?php } ?>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font size (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[fixed_fontsize]" type="text" value="<?php if (isset($options['fixed_fontsize'])) { echo esc_attr($options['fixed_fontsize']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Line height (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[fixed_lineheight]" type="text" value="<?php if (isset($options['fixed_lineheight'])) { echo esc_attr($options['fixed_lineheight']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font style', 'soho-core'); ?>
								<select name="qode_options_theme18[fixed_fontstyle]">
									<option <?php if(isset($options['fixed_fontstyle'])){ $fixed_fontstyle = $options['fixed_fontstyle']; if ($fixed_fontstyle == '') { echo "selected='selected'"; } } ?> value=""></option>
									<option <?php if(isset($options['fixed_fontstyle'])){ $fixed_fontstyle = $options['fixed_fontstyle']; if ($fixed_fontstyle == 'normal') { echo "selected='selected'"; } } ?> value="normal"><?php esc_html_e( 'normal', 'soho-core' ); ?></option>
									<option <?php if(isset($options['fixed_fontstyle'])){ $fixed_fontstyle = $options['fixed_fontstyle']; if ($fixed_fontstyle == 'italic') { echo "selected='selected'"; } } ?> value="italic"><?php esc_html_e( 'italic', 'soho-core' ); ?></option>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font weight', 'soho-core'); ?>
								<select name="qode_options_theme18[fixed_fontweight]">
									<option <?php if(isset($options['fixed_fontweight'])){ $fixed_fontweight = $options['fixed_fontweight']; if ($fixed_fontweight == '') { echo "selected='selected'"; } } ?> value=""></option>
									<option <?php if(isset($options['fixed_fontweight'])){ $fixed_fontweight = $options['fixed_fontweight']; if ($fixed_fontweight == '200') { echo "selected='selected'"; } } ?> value="200">200</option>
									<option <?php if(isset($options['fixed_fontweight'])){ $fixed_fontweight = $options['fixed_fontweight']; if ($fixed_fontweight == '300') { echo "selected='selected'"; } } ?> value="300">300</option>
									<option <?php if(isset($options['fixed_fontweight'])){ $fixed_fontweight = $options['fixed_fontweight']; if ($fixed_fontweight == '400') { echo "selected='selected'"; } } ?> value="400">400</option>
									<option <?php if(isset($options['fixed_fontweight'])){ $fixed_fontweight = $options['fixed_fontweight']; if ($fixed_fontweight == '500') { echo "selected='selected'"; } } ?> value="500">500</option>
									<option <?php if(isset($options['fixed_fontweight'])){ $fixed_fontweight = $options['fixed_fontweight']; if ($fixed_fontweight == '600') { echo "selected='selected'"; } } ?> value="600">600</option>
									<option <?php if(isset($options['fixed_fontweight'])){ $fixed_fontweight = $options['fixed_fontweight']; if ($fixed_fontweight == '700') { echo "selected='selected'"; } } ?> value="700">700</option>
									<option <?php if(isset($options['fixed_fontweight'])){ $fixed_fontweight = $options['fixed_fontweight']; if ($fixed_fontweight == '800') { echo "selected='selected'"; } } ?> value="800">800</option>
									<option <?php if(isset($options['fixed_fontweight'])){ $fixed_fontweight = $options['fixed_fontweight']; if ($fixed_fontweight == '900') { echo "selected='selected'"; } } ?> value="900">900</option>
								</select>
							</div>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Sticky menu', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['sticky_color'])){ echo 'background-color:'.esc_attr($options['sticky_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[sticky_color]" type="text" value="<?php if (isset($options['sticky_color'])) { echo esc_attr($options['sticky_color']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Hover/Active color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['sticky_hovercolor'])){ echo 'background-color:'.esc_attr($options['sticky_hovercolor']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[sticky_hovercolor]" type="text" value="<?php if (isset($options['sticky_hovercolor'])) { echo esc_attr($options['sticky_hovercolor']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font family', 'soho-core'); ?>
								<select name="qode_options_theme18[sticky_google_fonts]">
									<option value="-1"><?php esc_html_e( 'Default', 'soho-core' ); ?></option>
									<?php foreach($fontArrays as $fontArray) { ?>
										<option <?php if(isset($options['sticky_google_fonts'])){ $sticky_google_fonts = $options['sticky_google_fonts']; if ($sticky_google_fonts == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo  $fontArray["family"]; ?></option>
									<?php } ?>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font size (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[sticky_fontsize]" type="text" value="<?php if (isset($options['sticky_fontsize'])) { echo esc_attr($options['sticky_fontsize']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Line height (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[sticky_lineheight]" type="text" value="<?php if (isset($options['sticky_lineheight'])) { echo esc_attr($options['sticky_lineheight']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font style', 'soho-core'); ?>
								<select name="qode_options_theme18[sticky_fontstyle]">
									<option <?php if(isset($options['sticky_fontstyle'])){ $sticky_fontstyle = $options['sticky_fontstyle']; if ($sticky_fontstyle == '') { echo "selected='selected'"; } } ?> value=""></option>
									<option <?php if(isset($options['sticky_fontstyle'])){ $sticky_fontstyle = $options['sticky_fontstyle']; if ($sticky_fontstyle == 'normal') { echo "selected='selected'"; } } ?> value="normal"><?php esc_html_e( 'normal', 'soho-core' ); ?></option>
									<option <?php if(isset($options['sticky_fontstyle'])){ $sticky_fontstyle = $options['sticky_fontstyle']; if ($sticky_fontstyle == 'italic') { echo "selected='selected'"; } } ?> value="italic"><?php esc_html_e( 'italic', 'soho-core' ); ?></option>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font weight', 'soho-core'); ?>
								<select name="qode_options_theme18[sticky_fontweight]">
									<option <?php if(isset($options['sticky_fontweight'])){ $sticky_fontweight = $options['sticky_fontweight']; if ($sticky_fontweight == '') { echo "selected='selected'"; } } ?> value=""></option>
									<option <?php if(isset($options['sticky_fontweight'])){ $sticky_fontweight = $options['sticky_fontweight']; if ($sticky_fontweight == '200') { echo "selected='selected'"; } } ?> value="200">200</option>
									<option <?php if(isset($options['sticky_fontweight'])){ $sticky_fontweight = $options['sticky_fontweight']; if ($sticky_fontweight == '300') { echo "selected='selected'"; } } ?> value="300">300</option>
									<option <?php if(isset($options['sticky_fontweight'])){ $sticky_fontweight = $options['sticky_fontweight']; if ($sticky_fontweight == '400') { echo "selected='selected'"; } } ?> value="400">400</option>
									<option <?php if(isset($options['sticky_fontweight'])){ $sticky_fontweight = $options['sticky_fontweight']; if ($sticky_fontweight == '500') { echo "selected='selected'"; } } ?> value="500">500</option>
									<option <?php if(isset($options['sticky_fontweight'])){ $sticky_fontweight = $options['sticky_fontweight']; if ($sticky_fontweight == '600') { echo "selected='selected'"; } } ?> value="600">600</option>
									<option <?php if(isset($options['sticky_fontweight'])){ $sticky_fontweight = $options['sticky_fontweight']; if ($sticky_fontweight == '700') { echo "selected='selected'"; } } ?> value="700">700</option>
									<option <?php if(isset($options['sticky_fontweight'])){ $sticky_fontweight = $options['sticky_fontweight']; if ($sticky_fontweight == '800') { echo "selected='selected'"; } } ?> value="800">800</option>
									<option <?php if(isset($options['sticky_fontweight'])){ $sticky_fontweight = $options['sticky_fontweight']; if ($sticky_fontweight == '900') { echo "selected='selected'"; } } ?> value="900">900</option>
								</select>
							</div>
						</td>
					</tr>
					<tr><td colspan='2'><h2><?php esc_html_e( 'Mobile Menu', 'soho-core' ); ?></h2></td></tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Mobile menu style', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Separator color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['mobile_separator_color'])){ echo 'background-color:'.esc_attr($options['mobile_separator_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[mobile_separator_color]" type="text" value="<?php if (isset($options['mobile_separator_color'])) { echo esc_attr($options['mobile_separator_color']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Background color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['mobile_background_color'])){ echo 'background-color:'.esc_attr($options['mobile_background_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[mobile_background_color]" type="text" value="<?php if (isset($options['mobile_background_color'])) { echo esc_attr($options['mobile_background_color']); } ?>" size="10" maxlength="10" />
							</div>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('1st level style', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['mobile_main_color'])){ echo 'background-color:'.esc_attr($options['mobile_main_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[mobile_main_color]" type="text" value="<?php if (isset($options['mobile_main_color'])) { echo esc_attr($options['mobile_main_color']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Hover/Active color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['mobile_main_hovercolor'])){ echo 'background-color:'.esc_attr($options['mobile_main_hovercolor']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[mobile_main_hovercolor]" type="text" value="<?php if (isset($options['mobile_main_hovercolor'])) { echo esc_attr($options['mobile_main_hovercolor']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font family', 'soho-core'); ?>
								<select name="qode_options_theme18[mobile_main_google_fonts]">
									<option value="-1"><?php esc_html_e( 'Default', 'soho-core' ); ?></option>
									<?php foreach($fontArrays as $fontArray) { ?>
										<option <?php if(isset($options['mobile_main_google_fonts'])){ $mobile_google_fonts = $options['mobile_main_google_fonts']; if ($mobile_google_fonts == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo  $fontArray["family"]; ?></option>
									<?php } ?>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font size (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[mobile_main_fontsize]" type="text" value="<?php if (isset($options['mobile_main_fontsize'])) { echo esc_attr($options['mobile_main_fontsize']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Line height (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[mobile_main_lineheight]" type="text" value="<?php if (isset($options['mobile_main_lineheight'])) { echo esc_attr($options['mobile_main_lineheight']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font style', 'soho-core'); ?>
								<select name="qode_options_theme18[mobile_main_fontstyle]">
									<option <?php if(isset($options['mobile_main_fontstyle'])){ $mobile_fontstyle = $options['mobile_main_fontstyle']; if ($mobile_fontstyle == '') { echo "selected='selected'"; } } ?> value=""></option>
									<option <?php if(isset($options['mobile_main_fontstyle'])){ $mobile_fontstyle = $options['mobile_main_fontstyle']; if ($mobile_fontstyle == 'normal') { echo "selected='selected'"; } } ?> value="normal"><?php esc_html_e( 'normal', 'soho-core' ); ?></option>
									<option <?php if(isset($options['mobile_main_fontstyle'])){ $mobile_fontstyle = $options['mobile_main_fontstyle']; if ($mobile_fontstyle == 'italic') { echo "selected='selected'"; } } ?> value="italic"><?php esc_html_e( 'italic', 'soho-core' ); ?></option>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font weight', 'soho-core'); ?>
								<select name="qode_options_theme18[mobile_main_fontweight]">
									<option <?php if(isset($options['mobile_main_fontweight'])){ $mobile_fontweight = $options['mobile_main_fontweight']; if ($mobile_fontweight == '') { echo "selected='selected'"; } } ?> value=""></option>
									<option <?php if(isset($options['mobile_main_fontweight'])){ $mobile_fontweight = $options['mobile_main_fontweight']; if ($mobile_fontweight == '200') { echo "selected='selected'"; } } ?> value="200">200</option>
									<option <?php if(isset($options['mobile_main_fontweight'])){ $mobile_fontweight = $options['mobile_main_fontweight']; if ($mobile_fontweight == '300') { echo "selected='selected'"; } } ?> value="300">300</option>
									<option <?php if(isset($options['mobile_main_fontweight'])){ $mobile_fontweight = $options['mobile_main_fontweight']; if ($mobile_fontweight == '400') { echo "selected='selected'"; } } ?> value="400">400</option>
									<option <?php if(isset($options['mobile_main_fontweight'])){ $mobile_fontweight = $options['mobile_main_fontweight']; if ($mobile_fontweight == '500') { echo "selected='selected'"; } } ?> value="500">500</option>
									<option <?php if(isset($options['mobile_main_fontweight'])){ $mobile_fontweight = $options['mobile_main_fontweight']; if ($mobile_fontweight == '600') { echo "selected='selected'"; } } ?> value="600">600</option>
									<option <?php if(isset($options['mobile_main_fontweight'])){ $mobile_fontweight = $options['mobile_main_fontweight']; if ($mobile_fontweight == '700') { echo "selected='selected'"; } } ?> value="700">700</option>
									<option <?php if(isset($options['mobile_main_fontweight'])){ $mobile_fontweight = $options['mobile_main_fontweight']; if ($mobile_fontweight == '800') { echo "selected='selected'"; } } ?> value="800">800</option>
									<option <?php if(isset($options['mobile_main_fontweight'])){ $mobile_fontweight = $options['mobile_main_fontweight']; if ($mobile_fontweight == '900') { echo "selected='selected'"; } } ?> value="900">900</option>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Letter spacing (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[mobile_main_letter_spacing]" type="text" value="<?php if (isset($options['mobile_main_letter_spacing'])) { echo esc_attr($options['mobile_main_letter_spacing']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Text Transform', 'soho-core'); ?>
								<select name="qode_options_theme18[mobile_main_texttransform]">
									<option <?php if (isset($options['mobile_main_texttransform']) && $options['mobile_main_texttransform'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if (isset($options['mobile_main_texttransform']) && $options['mobile_main_texttransform'] == "none") { echo "selected='selected'"; } ?> value="none"><?php esc_html_e( 'None', 'soho-core' ); ?></option>
									<option <?php if (isset($options['mobile_main_texttransform']) && $options['mobile_main_texttransform'] == "capitalize") { echo "selected='selected'"; } ?> value="capitalize"><?php esc_html_e( 'Capitalize', 'soho-core' ); ?></option>
									<option <?php if (isset($options['mobile_main_texttransform']) && $options['mobile_main_texttransform'] == "uppercase") { echo "selected='selected'"; } ?> value="uppercase"><?php esc_html_e( 'Uppercase', 'soho-core' ); ?></option>
									<option <?php if (isset($options['mobile_main_texttransform']) && $options['mobile_main_texttransform'] == "lowercase") { echo "selected='selected'"; } ?> value="lowercase"><?php esc_html_e( 'Lowercase', 'soho-core' ); ?></option>
								</select>
							</div>
						</td>
					</tr>
					<tr class="middle">
						<td scope="row" width="150"><?php esc_html_e('Other level style', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['mobile_color'])){ echo 'background-color:'.esc_attr($options['mobile_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[mobile_color]" type="text" value="<?php if (isset($options['mobile_color'])) { echo esc_attr($options['mobile_color']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Hover/Active color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['mobile_hovercolor'])){ echo 'background-color:'.esc_attr($options['mobile_hovercolor']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[mobile_hovercolor]" type="text" value="<?php if (isset($options['mobile_hovercolor'])) { echo esc_attr($options['mobile_hovercolor']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font family', 'soho-core'); ?>
								<select name="qode_options_theme18[mobile_google_fonts]">
									<option value="-1"><?php esc_html_e( 'Default', 'soho-core' ); ?></option>
									<?php foreach($fontArrays as $fontArray) { ?>
										<option <?php if(isset($options['mobile_google_fonts'])){ $mobile_google_fonts = $options['mobile_google_fonts']; if ($mobile_google_fonts == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo  $fontArray["family"]; ?></option>
									<?php } ?>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font size (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[mobile_fontsize]" type="text" value="<?php if (isset($options['mobile_fontsize'])) { echo esc_attr($options['mobile_fontsize']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Line height (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[mobile_lineheight]" type="text" value="<?php if (isset($options['mobile_lineheight'])) { echo esc_attr($options['mobile_lineheight']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font style', 'soho-core'); ?>
								<select name="qode_options_theme18[mobile_fontstyle]">
									<option <?php if(isset($options['mobile_fontstyle'])){ $mobile_fontstyle = $options['mobile_fontstyle']; if ($mobile_fontstyle == '') { echo "selected='selected'"; } } ?> value=""></option>
									<option <?php if(isset($options['mobile_fontstyle'])){ $mobile_fontstyle = $options['mobile_fontstyle']; if ($mobile_fontstyle == 'normal') { echo "selected='selected'"; } } ?> value="normal"><?php esc_html_e( 'normal', 'soho-core' ); ?></option>
									<option <?php if(isset($options['mobile_fontstyle'])){ $mobile_fontstyle = $options['mobile_fontstyle']; if ($mobile_fontstyle == 'italic') { echo "selected='selected'"; } } ?> value="italic"><?php esc_html_e( 'italic', 'soho-core' ); ?></option>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font weight', 'soho-core'); ?>
								<select name="qode_options_theme18[mobile_fontweight]">
									<option <?php if(isset($options['mobile_fontweight'])){ $mobile_fontweight = $options['mobile_fontweight']; if ($mobile_fontweight == '') { echo "selected='selected'"; } } ?> value=""></option>
									<option <?php if(isset($options['mobile_fontweight'])){ $mobile_fontweight = $options['mobile_fontweight']; if ($mobile_fontweight == '200') { echo "selected='selected'"; } } ?> value="200">200</option>
									<option <?php if(isset($options['mobile_fontweight'])){ $mobile_fontweight = $options['mobile_fontweight']; if ($mobile_fontweight == '300') { echo "selected='selected'"; } } ?> value="300">300</option>
									<option <?php if(isset($options['mobile_fontweight'])){ $mobile_fontweight = $options['mobile_fontweight']; if ($mobile_fontweight == '400') { echo "selected='selected'"; } } ?> value="400">400</option>
									<option <?php if(isset($options['mobile_fontweight'])){ $mobile_fontweight = $options['mobile_fontweight']; if ($mobile_fontweight == '500') { echo "selected='selected'"; } } ?> value="500">500</option>
									<option <?php if(isset($options['mobile_fontweight'])){ $mobile_fontweight = $options['mobile_fontweight']; if ($mobile_fontweight == '600') { echo "selected='selected'"; } } ?> value="600">600</option>
									<option <?php if(isset($options['mobile_fontweight'])){ $mobile_fontweight = $options['mobile_fontweight']; if ($mobile_fontweight == '700') { echo "selected='selected'"; } } ?> value="700">700</option>
									<option <?php if(isset($options['mobile_fontweight'])){ $mobile_fontweight = $options['mobile_fontweight']; if ($mobile_fontweight == '800') { echo "selected='selected'"; } } ?> value="800">800</option>
									<option <?php if(isset($options['mobile_fontweight'])){ $mobile_fontweight = $options['mobile_fontweight']; if ($mobile_fontweight == '900') { echo "selected='selected'"; } } ?> value="900">900</option>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Letter spacing (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[mobile_letter_spacing]" type="text" value="<?php if (isset($options['mobile_letter_spacing'])) { echo esc_attr($options['mobile_letter_spacing']); } ?>" size="10" maxlength="10" />
							</div>
						</td>
					</tr>
					<tr><td colspan='2'><h2><?php esc_html_e( 'Left Menu', 'soho-core' ); ?></h2></td></tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('1st level menu style', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['vertical_menu_color'])){ echo 'background-color:'.esc_attr($options['vertical_menu_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[vertical_menu_color]" type="text" value="<?php if (isset($options['vertical_menu_color'])) { echo esc_attr($options['vertical_menu_color']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Hover/Active color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['vertical_menu_hovercolor'])){ echo 'background-color:'.esc_attr($options['vertical_menu_hovercolor']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[vertical_menu_hovercolor]" type="text" value="<?php if (isset($options['vertical_menu_hovercolor'])) { echo esc_attr($options['vertical_menu_hovercolor']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font family', 'soho-core'); ?>
								<select name="qode_options_theme18[vertical_menu_google_fonts]">
									<option value="-1"><?php esc_html_e( 'Default', 'soho-core' ); ?></option>
									<?php foreach($fontArrays as $fontArray) { ?>
										<option <?php if (isset($options['vertical_menu_google_fonts']) && $options['vertical_menu_google_fonts'] == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo  $fontArray["family"]; ?></option>
									<?php } ?>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font size (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[vertical_menu_fontsize]" type="text" value="<?php if (isset($options['vertical_menu_fontsize']) && $options['vertical_menu_fontsize']) { echo esc_attr($options['vertical_menu_fontsize']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Line height (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[vertical_menu_lineheight]" type="text" value="<?php if (isset($options['vertical_menu_lineheight']) && $options['vertical_menu_lineheight']) { echo esc_attr($options['vertical_menu_lineheight']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font style', 'soho-core'); ?>
								<select name="qode_options_theme18[vertical_menu_fontstyle]">
									<option <?php if (isset($options['vertical_menu_fontstyle']) && $options['vertical_menu_fontstyle'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if (isset($options['vertical_menu_fontstyle']) && $options['vertical_menu_fontstyle'] == "normal") { echo "selected='selected'"; } ?> value="normal"><?php esc_html_e( 'normal', 'soho-core' ); ?></option>
									<option <?php if (isset($options['vertical_menu_fontstyle']) && $options['vertical_menu_fontstyle'] == "italic") { echo "selected='selected'"; } ?> value="italic"><?php esc_html_e( 'italic', 'soho-core' ); ?></option>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font weight', 'soho-core'); ?>
								<select name="qode_options_theme18[vertical_menu_fontweight]">
									<option <?php if (isset($options['vertical_menu_fontweight']) && $options['vertical_menu_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if (isset($options['vertical_menu_fontweight']) && $options['vertical_menu_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200">200</option>
									<option <?php if (isset($options['vertical_menu_fontweight']) && $options['vertical_menu_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300">300</option>
									<option <?php if (isset($options['vertical_menu_fontweight']) && $options['vertical_menu_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400">400</option>
									<option <?php if (isset($options['vertical_menu_fontweight']) && $options['vertical_menu_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500">500</option>
									<option <?php if (isset($options['vertical_menu_fontweight']) && $options['vertical_menu_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600">600</option>
									<option <?php if (isset($options['vertical_menu_fontweight']) && $options['vertical_menu_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700">700</option>
									<option <?php if (isset($options['vertical_menu_fontweight']) && $options['vertical_menu_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800">800</option>
									<option <?php if (isset($options['vertical_menu_fontweight']) && $options['vertical_menu_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900">900</option>
								</select>
							</div>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('2nd level menu style', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['vertical_dropdown_color'])){ echo 'background-color:'.esc_attr($options['vertical_dropdown_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[vertical_dropdown_color]" type="text" value="<?php if (isset($options['vertical_dropdown_color'])) { echo esc_attr($options['vertical_dropdown_color']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Hover/Active color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['vertical_dropdown_hovercolor'])){ echo 'background-color:'.esc_attr($options['vertical_dropdown_hovercolor']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[vertical_dropdown_hovercolor]" type="text" value="<?php if (isset($options['vertical_dropdown_hovercolor'])) { echo esc_attr($options['vertical_dropdown_hovercolor']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font family', 'soho-core'); ?>
								<select name="qode_options_theme18[vertical_dropdown_google_fonts]">
									<option value="-1"><?php esc_html_e( 'Default', 'soho-core' ); ?></option>
									<?php foreach($fontArrays as $fontArray) { ?>
										<option <?php if (isset($options['vertical_dropdown_google_fonts']) && $options['vertical_dropdown_google_fonts'] == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo  $fontArray["family"]; ?></option>
									<?php } ?>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font size (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[vertical_dropdown_fontsize]" type="text" value="<?php if (isset($options['vertical_dropdown_fontsize']) && $options['vertical_dropdown_fontsize']) { echo esc_attr($options['vertical_dropdown_fontsize']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Line height (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[vertical_dropdown_lineheight]" type="text" value="<?php if (isset($options['vertical_dropdown_lineheight']) && $options['vertical_dropdown_lineheight']) { echo esc_attr($options['vertical_dropdown_lineheight']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font style', 'soho-core'); ?>
								<select name="qode_options_theme18[vertical_dropdown_fontstyle]">
									<option <?php if (isset($options['vertical_dropdown_fontstyle']) && $options['vertical_dropdown_fontstyle'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if (isset($options['vertical_dropdown_fontstyle']) && $options['vertical_dropdown_fontstyle'] == "normal") { echo "selected='selected'"; } ?> value="normal"><?php esc_html_e( 'normal', 'soho-core' ); ?></option>
									<option <?php if (isset($options['vertical_dropdown_fontstyle']) && $options['vertical_dropdown_fontstyle'] == "italic") { echo "selected='selected'"; } ?> value="italic"><?php esc_html_e( 'italic', 'soho-core' ); ?></option>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font weight', 'soho-core'); ?>
								<select name="qode_options_theme18[vertical_dropdown_fontweight]">
									<option <?php if (isset($options['vertical_dropdown_fontweight']) && $options['vertical_dropdown_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if (isset($options['vertical_dropdown_fontweight']) && $options['vertical_dropdown_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200">200</option>
									<option <?php if (isset($options['vertical_dropdown_fontweight']) && $options['vertical_dropdown_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300">300</option>
									<option <?php if (isset($options['vertical_dropdown_fontweight']) && $options['vertical_dropdown_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400">400</option>
									<option <?php if (isset($options['vertical_dropdown_fontweight']) && $options['vertical_dropdown_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500">500</option>
									<option <?php if (isset($options['vertical_dropdown_fontweight']) && $options['vertical_dropdown_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600">600</option>
									<option <?php if (isset($options['vertical_dropdown_fontweight']) && $options['vertical_dropdown_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700">700</option>
									<option <?php if (isset($options['vertical_dropdown_fontweight']) && $options['vertical_dropdown_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800">800</option>
									<option <?php if (isset($options['vertical_dropdown_fontweight']) && $options['vertical_dropdown_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900">900</option>
								</select>
							</div>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('3rd level menu style', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['vertical_dropdown_color_thirdlvl'])){ echo 'background-color:'.esc_attr($options['vertical_dropdown_color_thirdlvl']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[vertical_dropdown_color_thirdlvl]" type="text" value="<?php if (isset($options['vertical_dropdown_color_thirdlvl'])) { echo esc_attr($options['vertical_dropdown_color_thirdlvl']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Hover/Active color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['vertical_dropdown_hovercolor_thirdlvl'])){ echo 'background-color:'.esc_attr($options['vertical_dropdown_hovercolor_thirdlvl']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[vertical_dropdown_hovercolor_thirdlvl]" type="text" value="<?php if (isset($options['vertical_dropdown_hovercolor_thirdlvl'])) { echo esc_attr($options['vertical_dropdown_hovercolor_thirdlvl']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font family', 'soho-core'); ?>
								<select name="qode_options_theme18[vertical_dropdown_google_fonts_thirdlvl]">
									<option value="-1"><?php esc_html_e( 'Default', 'soho-core' ); ?></option>
									<?php foreach($fontArrays as $fontArray) { ?>
										<option <?php if(isset($options['vertical_dropdown_google_fonts_thirdlvl'])){ $vertical_dropdown_google_fonts_thirdlvl = $options['vertical_dropdown_google_fonts_thirdlvl']; if ($vertical_dropdown_google_fonts_thirdlvl == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo  $fontArray["family"]; ?></option>
									<?php } ?>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font size (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[vertical_dropdown_fontsize_thirdlvl]" type="text" value="<?php if (isset($options['vertical_dropdown_fontsize_thirdlvl'])) { echo esc_attr($options['vertical_dropdown_fontsize_thirdlvl']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Line height (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[vertical_dropdown_lineheight_thirdlvl]" type="text" value="<?php if (isset($options['vertical_dropdown_lineheight_thirdlvl'])) { echo esc_attr($options['vertical_dropdown_lineheight_thirdlvl']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font style', 'soho-core'); ?>
								<select name="qode_options_theme18[vertical_dropdown_fontstyle_thirdlvl]">
									<option <?php if(isset($options['vertical_dropdown_fontstyle_thirdlvl'])){ $vertical_dropdown_fontstyle_thirdlvl = $options['vertical_dropdown_fontstyle_thirdlvl']; if ($vertical_dropdown_fontstyle_thirdlvl == '') { echo "selected='selected'"; } } ?> value=""></option>
									<option <?php if(isset($options['vertical_dropdown_fontstyle_thirdlvl'])){ $vertical_dropdown_fontstyle_thirdlvl = $options['vertical_dropdown_fontstyle_thirdlvl']; if ($vertical_dropdown_fontstyle_thirdlvl == 'normal') { echo "selected='selected'"; } } ?> value="normal"><?php esc_html_e( 'normal', 'soho-core' ); ?></option>
									<option <?php if(isset($options['vertical_dropdown_fontstyle_thirdlvl'])){ $vertical_dropdown_fontstyle_thirdlvl = $options['vertical_dropdown_fontstyle_thirdlvl']; if ($vertical_dropdown_fontstyle_thirdlvl == 'italic') { echo "selected='selected'"; } } ?> value="italic"><?php esc_html_e( 'italic', 'soho-core' ); ?></option>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font weight', 'soho-core'); ?>
								<select name="qode_options_theme18[vertical_dropdown_fontweight_thirdlvl]">
									<option <?php if(isset($options['vertical_dropdown_fontweight_thirdlvl'])){ $vertical_dropdown_fontweight_thirdlvl = $options['vertical_dropdown_fontweight_thirdlvl']; if ($vertical_dropdown_fontweight_thirdlvl == '') { echo "selected='selected'"; } } ?> value=""></option>
									<option <?php if(isset($options['vertical_dropdown_fontweight_thirdlvl'])){ $vertical_dropdown_fontweight_thirdlvl = $options['vertical_dropdown_fontweight_thirdlvl']; if ($vertical_dropdown_fontweight_thirdlvl == '200') { echo "selected='selected'"; } } ?> value="200">200</option>
									<option <?php if(isset($options['vertical_dropdown_fontweight_thirdlvl'])){ $vertical_dropdown_fontweight_thirdlvl = $options['vertical_dropdown_fontweight_thirdlvl']; if ($vertical_dropdown_fontweight_thirdlvl == '300') { echo "selected='selected'"; } } ?> value="300">300</option>
									<option <?php if(isset($options['vertical_dropdown_fontweight_thirdlvl'])){ $vertical_dropdown_fontweight_thirdlvl = $options['vertical_dropdown_fontweight_thirdlvl']; if ($vertical_dropdown_fontweight_thirdlvl == '400') { echo "selected='selected'"; } } ?> value="400">400</option>
									<option <?php if(isset($options['vertical_dropdown_fontweight_thirdlvl'])){ $vertical_dropdown_fontweight_thirdlvl = $options['vertical_dropdown_fontweight_thirdlvl']; if ($vertical_dropdown_fontweight_thirdlvl == '500') { echo "selected='selected'"; } } ?> value="500">500</option>
									<option <?php if(isset($options['vertical_dropdown_fontweight_thirdlvl'])){ $vertical_dropdown_fontweight_thirdlvl = $options['vertical_dropdown_fontweight_thirdlvl']; if ($vertical_dropdown_fontweight_thirdlvl == '600') { echo "selected='selected'"; } } ?> value="600">600</option>
									<option <?php if(isset($options['vertical_dropdown_fontweight_thirdlvl'])){ $vertical_dropdown_fontweight_thirdlvl = $options['vertical_dropdown_fontweight_thirdlvl']; if ($vertical_dropdown_fontweight_thirdlvl == '700') { echo "selected='selected'"; } } ?> value="700">700</option>
									<option <?php if(isset($options['vertical_dropdown_fontweight_thirdlvl'])){ $vertical_dropdown_fontweight_thirdlvl = $options['vertical_dropdown_fontweight_thirdlvl']; if ($vertical_dropdown_fontweight_thirdlvl == '800') { echo "selected='selected'"; } } ?> value="800">800</option>
									<option <?php if(isset($options['vertical_dropdown_fontweight_thirdlvl'])){ $vertical_dropdown_fontweight_thirdlvl = $options['vertical_dropdown_fontweight_thirdlvl']; if ($vertical_dropdown_fontweight_thirdlvl == '900') { echo "selected='selected'"; } } ?> value="900">900</option>
								</select>
							</div>
						</td>
					</tr>
					</tbody>
				</table>
				<?php		display_save_changes_button(); ?>
			</div>
			<h3><?php esc_html_e( 'Header and Footer', 'soho-core' ); ?></h3>
			<div>
				<table class="form-table">
					<tbody>
					<tr><td colspan='2'><h2><?php esc_html_e( 'Header', 'soho-core' ); ?></h2></td></tr>
					<tr>
						<td valign="middle" width="150"><?php esc_html_e('Header in grid', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<select name="qode_options_theme18[header_in_grid]">
									<option <?php if(isset($options['header_in_grid'])){ if ($options['header_in_grid'] == "no") { echo "selected='selected'"; }} ?> value="no"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
									<option <?php if(isset($options['header_in_grid'])){ if ($options['header_in_grid'] == "yes") { echo "selected='selected'"; }} ?> value="yes"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
								</select>
							</div>
						</td>
					</tr>
					<tr>
						<td valign="middle" width="150"><?php esc_html_e('Show header top area', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<select name="qode_options_theme18[header_top_area]">
									<option <?php if(isset($options['header_top_area'])){ if ($options['header_top_area'] == "no") { echo "selected='selected'"; }} ?> value="no"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
									<option <?php if(isset($options['header_top_area'])){ if ($options['header_top_area'] == "yes") { echo "selected='selected'"; }} ?> value="yes"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
								</select>
							</div>
						</td>
					</tr>
					<tr>
						<td valign="middle" width="150"><?php esc_html_e('Scroll header top area', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<select name="qode_options_theme18[header_top_area_scroll]">
									<option <?php if(isset($options['header_top_area_scroll'])){ if ($options['header_top_area_scroll'] == "no") { echo "selected='selected'"; }} ?> value="no"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
									<option <?php if(isset($options['header_top_area_scroll'])){ if ($options['header_top_area_scroll'] == "yes") { echo "selected='selected'"; }} ?> value="yes"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
								</select>
							</div>
						</td>
					</tr>
					<tr>
						<td valign="middle" width="150"><?php esc_html_e('Header bottom appearance', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<select name="qode_options_theme18[header_bottom_appearance]">
									<option <?php if(isset($options['header_bottom_appearance'])){ if ($options['header_bottom_appearance'] == "regular") { echo "selected='selected'"; }} ?> value="regular"><?php esc_html_e( 'Regular', 'soho-core' ); ?></option>
									<option <?php if(isset($options['header_bottom_appearance'])){ if ($options['header_bottom_appearance'] == "fixed") { echo "selected='selected'"; }} ?> value="fixed"><?php esc_html_e( 'Fixed', 'soho-core' ); ?></option>
									<option <?php if(isset($options['header_bottom_appearance'])){ if ($options['header_bottom_appearance'] == "stick") { echo "selected='selected'"; }} ?> value="stick"><?php esc_html_e( 'Sticky', 'soho-core' ); ?></option>
									<option <?php if(isset($options['header_bottom_appearance'])){ if ($options['header_bottom_appearance'] == "stick menu_bottom") { echo "selected='selected'"; }} ?> value="stick menu_bottom"><?php esc_html_e( 'Sticky with menu on bottom', 'soho-core' ); ?></option>
								</select>
							</div>
						</td>
					</tr>
					<tr valign="top">
						<td scope="row" width="150"><?php esc_html_e('Scroll amount for sticky appear (px)', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<input name="qode_options_theme18[scroll_amount_for_sticky]" type="text" value="<?php if (isset($options['scroll_amount_for_sticky'])) { echo esc_attr($options['scroll_amount_for_sticky']); } ?>" size="10" maxlength="10" />
							</div>
						</td>
					</tr>
					<tr>
						<td valign="middle" width="150"><?php esc_html_e('Header style', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<select name="qode_options_theme18[header_style]">
									<option <?php if(isset($options['header_style'])){ if ($options['header_style'] == "") { echo "selected='selected'"; }} ?> value=""></option>
									<option <?php if(isset($options['header_style'])){ if ($options['header_style'] == "light") { echo "selected='selected'"; }} ?> value="light"><?php esc_html_e( 'Light', 'soho-core' ); ?></option>
									<option <?php if(isset($options['header_style'])){ if ($options['header_style'] == "dark") { echo "selected='selected'"; }} ?> value="dark"><?php esc_html_e( 'Dark', 'soho-core' ); ?></option>
								</select>
							</div>
						</td>
					</tr>
					<tr valign="top">
						<td scope="row" width="150"><?php esc_html_e('Header height', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Initial (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[header_height]" type="text" value="<?php if (isset($options['header_height'])) { echo esc_attr($options['header_height']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Scrolled - fixed style (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[header_height_scroll]" type="text" value="<?php if (isset($options['header_height_scroll'])) { echo esc_attr($options['header_height_scroll']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Sticky (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[header_height_sticky]" type="text" value="<?php if (isset($options['header_height_sticky'])) { echo esc_attr($options['header_height_sticky']); } ?>" size="10" maxlength="10" />
							</div>
						</td>
					</tr>
					<tr valign="top">
						<td valign="top" width="150"><?php esc_html_e('Logo', 'soho-core'); ?></td>
						<td>
							<div class="inline" style="width: 700px;">
								<?php esc_html_e('Logo image - normal', 'soho-core'); ?><br/>
								<input type="text" id="logo_image" name="qode_options_theme18[logo_image]" class="logo_image" value="<?php if (isset($options['logo_image'])) { echo esc_attr($options['logo_image']); } else { echo SOHO_QODE_ROOT."/img/logo.png"; } ?>" size="70">
								<input class="upload_button" type="button" value="Upload file">
							</div><br/><br/>
							<div class="inline" style="width: 700px;">
								<?php esc_html_e('Logo image - light', 'soho-core'); ?><br/>
								<input type="text" id="logo_image_light" name="qode_options_theme18[logo_image_light]" class="logo_image_light" value="<?php if (isset($options['logo_image_light'])) { echo esc_attr($options['logo_image_light']); } else { echo SOHO_QODE_ROOT."/img/logo_white.png"; } ?>" size="70">
								<input class="upload_button" type="button" value="Upload file">
							</div><br/><br/>
							<div class="inline" style="width: 700px;">
								<?php esc_html_e('Logo image - dark', 'soho-core'); ?><br/>
								<input type="text" id="logo_image_dark" name="qode_options_theme18[logo_image_dark]" class="logo_image_dark" value="<?php if (isset($options['logo_image_dark'])) { echo esc_attr($options['logo_image_dark']); } else { echo SOHO_QODE_ROOT."/img/logo_black.png"; } ?>" size="70">
								<input class="upload_button" type="button" value="Upload file">
							</div><br/><br/>
							<div class="inline" style="width: 700px;">
								<?php esc_html_e('Logo image - sticky header', 'soho-core'); ?><br/>
								<input type="text" id="logo_image_sticky" name="qode_options_theme18[logo_image_sticky]" class="logo_image_sticky" value="<?php if (isset($options['logo_image_sticky'])) { echo esc_attr($options['logo_image_sticky']); } else { echo SOHO_QODE_ROOT."/img/logo_black.png"; } ?>" size="70">
								<input class="upload_button" type="button" value="Upload file">
							</div>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Center logo', 'soho-core'); ?></td>
						<td>
							<select name="qode_options_theme18[center_logo_image]">
								<option <?php if(isset($options['center_logo_image'])){ $center_logo_image = $options['center_logo_image']; if ($center_logo_image == 'no') { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
								<option <?php if(isset($options['center_logo_image'])){ $center_logo_image = $options['center_logo_image']; if ($center_logo_image == 'yes') { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
							</select>
						</td>
					</tr>
					<tr>
						<td valign="middle" width="150"><?php esc_html_e('Menu position', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<select name="qode_options_theme18[menu_position]">
									<option <?php if(isset($options['menu_position'])){ if ($options['menu_position'] == "") { echo "selected='selected'"; }} ?> value=""><?php esc_html_e( 'Deafult', 'soho-core' ); ?></option>
									<option <?php if(isset($options['menu_position'])){ if ($options['menu_position'] == "center") { echo "selected='selected'"; }} ?> value="center"><?php esc_html_e( 'Center', 'soho-core' ); ?></option>
								</select>
							</div>
						</td>
					</tr>
					<tr>
						<td scope="row" width="150"><?php esc_html_e('Top background color', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Background Color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if ($options['header_top_background_color']){ echo 'background-color:'.esc_attr($options['header_top_background_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[header_top_background_color]" type="text" value="<?php if (isset($options['header_top_background_color'])) { echo esc_attr($options['header_top_background_color']); } ?>" size="10" maxlength="10" />
							</div>
						</td>
					</tr>
					<tr>
						<td scope="row" width="150"><?php esc_html_e('Bottom background color', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Initial', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if ($options['header_background_color']){ echo 'background-color:'.esc_attr($options['header_background_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[header_background_color]" type="text" value="<?php if (isset($options['header_background_color'])) { echo esc_attr($options['header_background_color']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Scrolled (fixed style)', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['header_background_color_scroll'])) { if($options['header_background_color_scroll']){ echo 'background-color:'.esc_attr($options['header_background_color_scroll']).';'; } }?>"></div></div>
								<input name="qode_options_theme18[header_background_color_scroll]" type="text" value="<?php if (isset($options['header_background_color_scroll'])) { echo esc_attr($options['header_background_color_scroll']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Sticky', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['header_background_color_sticky'])) { if($options['header_background_color_sticky']){ echo 'background-color:'.esc_attr($options['header_background_color_sticky']).';'; } }?>"></div></div>
								<input name="qode_options_theme18[header_background_color_sticky]" type="text" value="<?php if (isset($options['header_background_color_sticky'])) { echo esc_attr($options['header_background_color_sticky']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Mobile', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['header_background_color_touch'])) { if($options['header_background_color_touch']){ echo 'background-color:'.esc_attr($options['header_background_color_touch']).';'; } }?>"></div></div>
								<input name="qode_options_theme18[header_background_color_touch]" type="text" value="<?php if (isset($options['header_background_color_touch'])) { echo esc_attr($options['header_background_color_touch']); } ?>" size="10" maxlength="10" />
							</div>
						</td>
					</tr>
					<tr>
						<td scope="row" width="150"><?php esc_html_e('Transparency', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Initial (Default value is 0)', 'soho-core'); ?>
								<input name="qode_options_theme18[header_background_transparency_initial]" type="text" value="<?php if (isset($options['header_background_transparency_initial'])) { echo esc_attr($options['header_background_transparency_initial']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Scrolled (fixed style)', 'soho-core'); ?>
								<input name="qode_options_theme18[header_background_transparency_scroll]" type="text" value="<?php if (isset($options['header_background_transparency_scroll'])) { echo esc_attr($options['header_background_transparency_scroll']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Sticky (Default value is 1)', 'soho-core'); ?>
								<input name="qode_options_theme18[header_background_transparency_sticky]" type="text" value="<?php if (isset($options['header_background_transparency_sticky'])) { echo esc_attr($options['header_background_transparency_sticky']); } ?>" size="10" maxlength="10" />
							</div>
							<?php esc_html_e('(from 0 to 1)', 'soho-core'); ?>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Dropdown main menu', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Animate', 'soho-core'); ?>
								<select name="qode_options_theme18[dropdown_animation]">
									<option <?php if(isset($options['dropdown_animation'])){ if ($options['dropdown_animation'] == "no") { echo "selected='selected'"; }} ?> value="no"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
									<option <?php if(isset($options['dropdown_animation'])){ if ($options['dropdown_animation'] == "yes") { echo "selected='selected'"; }} ?> value="yes"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Background color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['dropdown_background_color'])){ echo 'background-color:'.esc_attr($options['dropdown_background_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[dropdown_background_color]" type="text" value="<?php if (isset($options['dropdown_background_color'])) { echo esc_attr($options['dropdown_background_color']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Separator color (wide type)', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['dropdown_background_separator_color'])){ echo 'background-color:'.esc_attr($options['dropdown_background_separator_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[dropdown_background_separator_color]" type="text" value="<?php if (isset($options['dropdown_background_separator_color'])) { echo esc_attr($options['dropdown_background_separator_color']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Transparency (From 0 to 1)', 'soho-core'); ?>
								<input name="qode_options_theme18[dropdown_background_transparency]" type="text" value="<?php if (isset($options['dropdown_background_transparency'])) { echo esc_attr($options['dropdown_background_transparency']); } ?>" size="10" maxlength="10" />
							</div>
						</td>
					</tr>
					<tr valign="top">
						<td valign="top" width="150"></td>
						<td>
							<div class="inline" style="width: 700px;">
								<?php esc_html_e('Pattern background image', 'soho-core'); ?><br/>
								<input type="text" id="dropdown_background_pattern" name="qode_options_theme18[dropdown_background_pattern]" class="qode_upload_field" value="<?php if (isset($options['dropdown_background_pattern'])) { echo esc_attr($options['dropdown_background_pattern']); } ?>" size="70">
								<input class="upload_button" type="button" value="Upload file">
							</div>
						</td>
					</tr>
					<tr>
						<td valign="middle" width="150"><?php esc_html_e('Enable Select search', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<select name="qode_options_theme18[enable_search]">
									<option <?php if(isset($options['enable_search'])){ if ($options['enable_search'] == "no") { echo "selected='selected'"; }} ?> value="no"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
									<option <?php if(isset($options['enable_search'])){ if ($options['enable_search'] == "yes") { echo "selected='selected'"; }} ?> value="yes"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
								</select>
							</div>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Header Buttons (Select Search icon, Side Area icon and Mobile Menu icon) style', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if ($options['header_buttons_color']){ echo 'background-color:'.esc_attr($options['header_buttons_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[header_buttons_color]" type="text" value="<?php if (isset($options['header_buttons_color']) && $options['header_buttons_color']) { echo esc_attr($options['header_buttons_color']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Hover color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if ($options['header_buttons_hovercolor']){ echo 'background-color:'.esc_attr($options['header_buttons_hovercolor']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[header_buttons_hovercolor]" type="text" value="<?php if (isset($options['header_buttons_hovercolor']) && $options['header_buttons_hovercolor']) { echo esc_attr($options['header_buttons_hovercolor']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font Size (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[header_buttons_font_size]" type="text" value="<?php if (isset($options['header_buttons_font_size']) && $options['header_buttons_font_size']) { echo esc_attr($options['header_buttons_font_size']); } ?>" size="10" maxlength="10" />
							</div>
						</td>
					</tr>
					<tr><td colspan='2'><h2><?php esc_html_e( 'Footer', 'soho-core' ); ?></h2></td></tr>
					<tr>
						<td valign="middle" width="150"><?php esc_html_e('Uncovering footer', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<select name="qode_options_theme18[uncovering_footer]">
									<option <?php if(isset($options['uncovering_footer'])) { if ($options['uncovering_footer'] == "yes") { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
									<option <?php if(isset($options['uncovering_footer'])) { if ($options['uncovering_footer'] == "no") { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
								</select>
							</div>
						</td>
					</tr>
					<tr>
						<td valign="middle" width="150"><?php esc_html_e('Footer in grid', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<select name="qode_options_theme18[footer_in_grid]">
									<option <?php if(isset($options['footer_in_grid'])) { if ($options['footer_in_grid'] == "no") { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
									<option <?php if(isset($options['footer_in_grid'])) { if ($options['footer_in_grid'] == "yes") { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
								</select>
							</div>
						</td>
					</tr>
					<tr>
						<td valign="middle" width="150"><?php esc_html_e('Show footer top', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<select name="qode_options_theme18[show_footer_top]">
									<option <?php if(isset($options['show_footer_top'])) { if ($options['show_footer_top'] == "yes") { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
									<option <?php if(isset($options['show_footer_top'])) { if ($options['show_footer_top'] == "no") { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
								</select>
							</div>
						</td>
					</tr>
					<tr>
						<td valign="middle" width="150"><?php esc_html_e('Footer top columns', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<select name="qode_options_theme18[footer_top_columns]">
									<option <?php if(isset($options['footer_top_columns'])) { if ($options['footer_top_columns'] == "1") { echo "selected='selected'"; } } ?> value="1">1</option>
									<option <?php if(isset($options['footer_top_columns'])) { if ($options['footer_top_columns'] == "2") { echo "selected='selected'"; } } ?> value="2">2</option>
									<option <?php if(isset($options['footer_top_columns'])) { if ($options['footer_top_columns'] == "3") { echo "selected='selected'"; } } ?> value="3">3</option>
									<option <?php if(isset($options['footer_top_columns'])) { if ($options['footer_top_columns'] == "5") { echo "selected='selected'"; } } ?> value="5">3(25%+25%+50%)</option>
									<option <?php if(isset($options['footer_top_columns'])) { if ($options['footer_top_columns'] == "6") { echo "selected='selected'"; } } ?> value="6">3(50%+25%+25%)</option>
									<option <?php if(isset($options['footer_top_columns'])) { if ($options['footer_top_columns'] == "4") { echo "selected='selected'"; } } ?> value="4">4</option>
								</select>
							</div>
						</td>
					</tr>
					<tr>
						<td valign="middle" width="150"><?php esc_html_e('Show footer bottom', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<select name="qode_options_theme18[footer_text]">
									<option <?php if ($options['footer_text'] == "no") { echo "selected='selected'"; } ?> value="no"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
									<option <?php if ($options['footer_text'] == "yes") { echo "selected='selected'"; } ?> value="yes"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>

								</select>
							</div>
						</td>
					</tr>
					<tr>
						<td valign="middle" width="150"><?php esc_html_e('Footer separator color', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<div class="colorSelector"><div style="<?php if (isset($options['footer_separator_color']) && $options['footer_separator_color']){ echo 'background-color:'.esc_attr($options['footer_separator_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[footer_separator_color]" type="text" value="<?php if (isset($options['footer_separator_color']) && $options['footer_separator_color']) { echo esc_attr($options['footer_separator_color']); } ?>" size="10" maxlength="10" />
							</div>
						</td>
					</tr>
					<tr>
						<td scope="row" width="150"><?php esc_html_e('Footer top colors', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Title color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if ($options['footer_top_title_color']){ echo 'background-color:'.esc_attr($options['footer_top_title_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[footer_top_title_color]" type="text" value="<?php if ($options['footer_top_title_color']) { echo esc_attr($options['footer_top_title_color']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Text color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if ($options['footer_top_text_color']){ echo 'background-color:'.esc_attr($options['footer_top_text_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[footer_top_text_color]" type="text" value="<?php if ($options['footer_top_text_color']) { echo esc_attr($options['footer_top_text_color']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Link color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['footer_link_color'])){ echo 'background-color:'.esc_attr($options['footer_link_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[footer_link_color]" type="text" value="<?php if (isset($options['footer_link_color'])) { echo esc_attr($options['footer_link_color']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Link hover color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['footer_link_hover_color'])){ echo 'background-color:'.esc_attr($options['footer_link_hover_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[footer_link_hover_color]" type="text" value="<?php if (isset($options['footer_link_hover_color'])){ echo esc_attr($options['footer_link_hover_color']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Background color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if ($options['footer_top_background_color']){ echo 'background-color:'.esc_attr($options['footer_top_background_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[footer_top_background_color]" type="text" value="<?php if ($options['footer_top_background_color']) { echo esc_attr($options['footer_top_background_color']); } ?>" size="10" maxlength="10" />
							</div>
						</td>
					</tr>
					<tr valign="top">
						<td valign="top" width="150"><?php esc_html_e('Footer top background image', 'soho-core'); ?></td>
						<td>
							<div class="inline" style="width: 700px;">
								<input type="text" id="footer_top_background_image" name="qode_options_theme18[footer_top_background_image]" class="qode_upload_field" value="<?php if (isset($options['footer_top_background_image'])) { echo esc_attr($options['footer_top_background_image']); } else { echo SOHO_QODE_ROOT."/img/footer_background.jpg"; } ?>" size="70">
								<input class="upload_button" type="button" value="Upload file">
							</div>
						</td>
					</tr>
					<tr>
						<td scope="row" width="150"><?php esc_html_e('Footer bottom colors', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Text color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if ($options['footer_bottom_text_color']){ echo 'background-color:'.esc_attr($options['footer_bottom_text_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[footer_bottom_text_color]" type="text" value="<?php if ($options['footer_bottom_text_color']) { echo esc_attr($options['footer_bottom_text_color']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Background color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if ($options['footer_bottom_background_color']){ echo 'background-color:'.esc_attr($options['footer_bottom_background_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[footer_bottom_background_color]" type="text" value="<?php if (isset($options['footer_bottom_background_color'])) { echo esc_attr($options['footer_bottom_background_color']); } ?>" size="10" maxlength="10" />
							</div>
						</td>
					</tr>
					</tbody>
				</table>
				<?php		display_save_changes_button(); ?>
			</div>
			<h3><?php esc_html_e( 'Title', 'soho-core' ); ?></h3>
			<div>
				<table class="form-table">
					<tbody>
					<tr valign="middle">
						<td>
							<div class="inline">
								<?php esc_html_e('Title Type', 'soho-core'); ?>
								<select name="qode_options_theme18[title_type]">
									<option <?php if(isset($options['title_type'])){ if ($options['title_type'] == "standard_title") { echo "selected='selected'"; }} ?> value="standard_title"><?php esc_html_e( 'Standard', 'soho-core' ); ?></option>
									<option <?php if(isset($options['title_type'])){ if ($options['title_type'] == "breadcrumbs_title") { echo "selected='selected'"; }} ?> value="breadcrumbs_title"><?php esc_html_e( 'Breadcrumbs', 'soho-core' ); ?></option>
								</select>
							</div>
						</td>
					</tr>
					<tr valign="middle">
						<td>
							<div class="inline">
								<?php esc_html_e('Enable breadcrumbs', 'soho-core'); ?>
								<select name="qode_options_theme18[enable_breadcrumbs]">
									<option <?php if(isset($options['enable_breadcrumbs'])){ if ($options['enable_breadcrumbs'] == "no") { echo "selected='selected'"; }} ?> value="no"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
									<option <?php if(isset($options['enable_breadcrumbs'])){ if ($options['enable_breadcrumbs'] == "yes") { echo "selected='selected'"; }} ?> value="yes"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
								</select>
								<?php esc_html_e('Only if title type is Standard', 'soho-core'); ?>
							</div>
						</td>
					</tr>
					<tr valign="middle">
						<td>
							<div class="inline">
								<?php esc_html_e('Title height (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[title_height]" type="text" value="<?php if (isset($options['title_height'])) { echo esc_attr($options['title_height']); } ?>" size="10" maxlength="10" />
								<?php esc_html_e('Only if title image is not responsive', 'soho-core'); ?>
							</div>
						</td>
					</tr>
					<tr valign="middle">
						<td>
							<div class="inline">
								<?php esc_html_e('Animate title area', 'soho-core'); ?>
								<select name="qode_options_theme18[animate_title_area]">
									<option <?php if(isset($options['animate_title_area'])){ $animate_title_area = $options['animate_title_area']; if ($animate_title_area == 'no') { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No animation', 'soho-core' ); ?></option>
									<option <?php if(isset($options['animate_title_area'])){ $animate_title_area = $options['animate_title_area']; if ($animate_title_area == 'text_right_left') { echo "selected='selected'"; } } ?> value="text_right_left"><?php esc_html_e( 'Text right to left', 'soho-core' ); ?></option>
									<option <?php if(isset($options['animate_title_area'])){ $animate_title_area = $options['animate_title_area']; if ($animate_title_area == 'fade_in_title_text') { echo "selected='selected'"; } } ?> value="fade_in_title_text"><?php esc_html_e( 'Fade in title text', 'soho-core' ); ?></option>
									<option <?php if(isset($options['animate_title_area'])){ $animate_title_area = $options['animate_title_area']; if ($animate_title_area == 'area_top_bottom') { echo "selected='selected'"; } } ?> value="area_top_bottom"><?php esc_html_e( 'Title area top to bottom', 'soho-core' ); ?></option>
									<option <?php if(isset($options['animate_title_area'])){ $animate_title_area = $options['animate_title_area']; if ($animate_title_area == 'area_top_bottom_with_title_fade_in') { echo "selected='selected'"; } } ?> value="area_top_bottom_with_title_fade_in"><?php esc_html_e( 'Title area top to bottom with fade in title text', 'soho-core' ); ?></option>
								</select>
							</div>
						</td>
					</tr>
					<tr valign="middle">
						<td>
							<div class="inline">
								<?php esc_html_e('Title position', 'soho-core'); ?>
								<select name="qode_options_theme18[page_title_position]">
									<option <?php if ($options['page_title_position'] == 'left') { echo "selected='selected'"; } ?> value="left"><?php esc_html_e( 'Left', 'soho-core' ); ?></option>
									<!--										<option --><?php //if ($options['page_title_position'] == 'left_image') { echo "selected='selected'"; } ?><!-- value="left_image"><?php esc_html_e( 'Left with image', 'soho-core' ); ?></option>-->
									<option <?php if ($options['page_title_position'] == 'center') { echo "selected='selected'"; } ?> value="center"><?php esc_html_e( 'Center', 'soho-core' ); ?></option>
								</select>
							</div>
						</td>
					</tr>
					<tr valign="middle">
						<td>
							<div class="inline">
								<?php esc_html_e('Title Background color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['title_background_color'])){ echo 'background-color:'.esc_attr($options['title_background_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[title_background_color]" type="text" value="<?php if (isset($options['title_background_color'])) { echo esc_attr($options['title_background_color']); } ?>" size="10" maxlength="10" />
							</div>
						</td>
					</tr>
					<tr valign="middle">
						<td>
							<div class="inline">
								<?php esc_html_e('Title text background', 'soho-core'); ?>
								<select name="qode_options_theme18[page_title_text_background]">
									<option <?php if ($options['page_title_text_background'] == 'yes') { echo "selected='selected'"; } ?> value="yes"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
									<option <?php if ($options['page_title_text_background'] == 'no') { echo "selected='selected'"; } ?> value="no"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Title text background color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['page_title_text_background_color'])){ echo 'background-color:'.esc_attr($options['page_title_text_background_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[page_title_text_background_color]" type="text" value="<?php if (isset($options['page_title_text_background_color'])) { echo esc_attr($options['page_title_text_background_color']); } ?>" size="10" maxlength="10" />
							</div>
						</td>
					</tr>
					<tr valign="middle">
						<td>
							<div class="inline" style="width: 780px;">
								<?php esc_html_e('Title image', 'soho-core'); ?>
								<input type="text" id="title_image" name="qode_options_theme18[title_image]" class="title_image" value="<?php if (isset($options['title_image'])) { echo esc_attr($options['title_image']); } ?>" size="70">
								<input class="upload_button" type="button" value="Upload file">
							</div>
						</td>
					</tr>
					<tr valign="middle">
						<td>
							<div class="inline">
								<?php esc_html_e('Use title image as pattern', 'soho-core'); ?>
								<select name="qode_options_theme18[title_image_pattern]">
									<option <?php if(isset($options['title_image_pattern'])){ $title_image_pattern = $options['title_image_pattern']; if ($title_image_pattern == '') { echo "selected='selected'"; } } ?> value=""></option>
									<option <?php if(isset($options['title_image_pattern'])){ $title_image_pattern = $options['title_image_pattern']; if ($title_image_pattern == 'no') { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
									<option <?php if(isset($options['title_image_pattern'])){ $title_image_pattern = $options['title_image_pattern']; if ($title_image_pattern == 'yes') { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
								</select>
								<?php esc_html_e('Only if title image is not responsive', 'soho-core'); ?>
							</div>
						</td>
					</tr>
					<tr valign="middle">
						<td>
							<div class="inline" style="width: 880px;">
								<?php esc_html_e('Title pattern overlay image', 'soho-core'); ?>
								<input type="text" id="title_overlay_image" name="qode_options_theme18[title_overlay_image]" class="title_overlay_image" value="<?php if (isset($options['title_overlay_image'])) { echo esc_attr($options['title_overlay_image']); } ?>" size="70">
								<input class="upload_button" type="button" value="Upload file">
							</div>
						</td>
					</tr>
					<tr valign="middle">
						<td>
							<div class="inline">
								<?php esc_html_e('Responsive title image', 'soho-core'); ?>
								<select name="qode_options_theme18[responsive_title_image]">
									<option <?php if(isset($options['responsive_title_image'])){ $responsive_title_image = $options['responsive_title_image']; if ($responsive_title_image == 'no') { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
									<option <?php if(isset($options['responsive_title_image'])){ $responsive_title_image = $options['responsive_title_image']; if ($responsive_title_image == 'yes') { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
								</select>
							</div>
						</td>
					</tr>
					<tr valign="middle">
						<td>
							<div class="inline">
								<?php esc_html_e('Parallax title image', 'soho-core'); ?>
								<select name="qode_options_theme18[fixed_title_image]">
									<option <?php if(isset($options['fixed_title_image'])){ $fixed_title_image = $options['fixed_title_image']; if ($fixed_title_image == 'no') { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
									<option <?php if(isset($options['fixed_title_image'])){ $fixed_title_image = $options['fixed_title_image']; if ($fixed_title_image == 'yes') { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
									<option <?php if(isset($options['fixed_title_image'])){ $fixed_title_image = $options['fixed_title_image']; if ($fixed_title_image == 'yes_zoom') { echo "selected='selected'"; } } ?> value="yes_zoom"><?php esc_html_e( 'Yes, with zoom out', 'soho-core' ); ?></option>
								</select>
								<?php esc_html_e('Only if title image is not responsive', 'soho-core'); ?>
							</div>
						</td>
					</tr>
					<tr valign="middle">
						<td>
							<div class="inline">
								<?php esc_html_e('Page title style', 'soho-core'); ?>&nbsp;&nbsp;&nbsp;
							</div>
							<div class="inline">
								<?php esc_html_e('Color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if ($options['page_title_color']){ echo 'background-color:'.esc_attr($options['page_title_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[page_title_color]" type="text" value="<?php if ($options['page_title_color']) { echo esc_attr($options['page_title_color']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font family', 'soho-core'); ?>
								<select name="qode_options_theme18[page_title_google_fonts]">
									<option value="-1"><?php esc_html_e( 'Default', 'soho-core' ); ?></option>
									<?php foreach($fontArrays as $fontArray) { ?>
										<option <?php if ($options['page_title_google_fonts'] == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo  $fontArray["family"]; ?></option>
									<?php } ?>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font size (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[page_title_fontsize]" type="text" value="<?php if ($options['page_title_fontsize']) { echo esc_attr($options['page_title_fontsize']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Line height (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[page_title_lineheight]" type="text" value="<?php if ($options['page_title_lineheight']) { echo esc_attr($options['page_title_lineheight']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font style', 'soho-core'); ?>
								<select name="qode_options_theme18[page_title_fontstyle]">
									<option <?php if ($options['page_title_fontstyle'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if ($options['page_title_fontstyle'] == "normal") { echo "selected='selected'"; } ?> value="normal"><?php esc_html_e( 'normal', 'soho-core' ); ?></option>
									<option <?php if ($options['page_title_fontstyle'] == "italic") { echo "selected='selected'"; } ?> value="italic"><?php esc_html_e( 'italic', 'soho-core' ); ?></option>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font weight', 'soho-core'); ?>
								<select name="qode_options_theme18[page_title_fontweight]">
									<option <?php if ($options['page_title_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if ($options['page_title_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200">200</option>
									<option <?php if ($options['page_title_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300">300</option>
									<option <?php if ($options['page_title_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400">400</option>
									<option <?php if ($options['page_title_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500">500</option>
									<option <?php if ($options['page_title_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600">600</option>
									<option <?php if ($options['page_title_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700">700</option>
									<option <?php if ($options['page_title_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800">800</option>
									<option <?php if ($options['page_title_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900">900</option>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Text Transform', 'soho-core'); ?>
								<select name="qode_options_theme18[page_title_texttransform]">
									<option <?php if (isset($options['page_title_texttransform']) && $options['page_title_texttransform'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if (isset($options['page_title_texttransform']) && $options['page_title_texttransform'] == "none") { echo "selected='selected'"; } ?> value="none"><?php esc_html_e( 'None', 'soho-core' ); ?></option>
									<option <?php if (isset($options['page_title_texttransform']) && $options['page_title_texttransform'] == "capitalize") { echo "selected='selected'"; } ?> value="capitalize"><?php esc_html_e( 'Capitalize', 'soho-core' ); ?></option>
									<option <?php if (isset($options['page_title_texttransform']) && $options['page_title_texttransform'] == "uppercase") { echo "selected='selected'"; } ?> value="uppercase"><?php esc_html_e( 'Uppercase', 'soho-core' ); ?></option>
									<option <?php if (isset($options['page_title_texttransform']) && $options['page_title_texttransform'] == "lowercase") { echo "selected='selected'"; } ?> value="lowercase"><?php esc_html_e( 'Lowercase', 'soho-core' ); ?></option>
								</select>
							</div>
						</td>
					</tr>
					<tr valign="middle">
						<td>
							<div class="inline">
								<?php esc_html_e('Text shadow', 'soho-core'); ?>
								<select name="qode_options_theme18[title_text_shadow]">
									<option <?php if(isset($options['title_text_shadow'])){ $title_text_shadow = $options['title_text_shadow']; if ($title_text_shadow == 'no') { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
									<option <?php if(isset($options['title_text_shadow'])){ $title_text_shadow = $options['title_text_shadow']; if ($title_text_shadow == 'yes') { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
								</select>
							</div>
						</td>
					</tr>
					</tbody>
				</table>
				<?php display_save_changes_button(); ?>
			</div>
			<h3><?php esc_html_e( 'Left Menu Area', 'soho-core' ); ?></h3>
			<div>
				<table class="form-table">
					<tbody>
					<tr>
						<td valign="middle" width="150"><?php esc_html_e('Enable left menu area', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<select name="qode_options_theme18[vertical_area]">
									<option <?php if(isset($options['vertical_area'])){ if (isset($options['vertical_area']) && $options['vertical_area'] == "no") { echo "selected='selected'"; }} ?> value="no"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
									<option <?php if(isset($options['vertical_area'])){ if (isset($options['vertical_area']) && $options['vertical_area'] == "yes") { echo "selected='selected'"; }} ?> value="yes"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
								</select>
							</div>
						</td>
					</tr>
					<tr>
						<td valign="middle" width="150"><?php esc_html_e('Enable transparent left menu area', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<select name="qode_options_theme18[vertical_area_transparency]">
									<option <?php if(isset($options['vertical_area_transparency'])){ if (isset($options['vertical_area_transparency']) && $options['vertical_area_transparency'] == "no") { echo "selected='selected'"; }} ?> value="no"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
									<option <?php if(isset($options['vertical_area_transparency'])){ if (isset($options['vertical_area_transparency']) && $options['vertical_area_transparency'] == "yes") { echo "selected='selected'"; }} ?> value="yes"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
								</select>
							</div>
						</td>
					</tr>
					<tr>
						<td valign="middle" width="150"><?php esc_html_e('Left menu area background', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<div class="colorSelector"><div style="<?php if (isset($options['vertical_area_background']) && $options['vertical_area_background']){ echo 'background-color:'.esc_attr($options['vertical_area_background']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[vertical_area_background]" type="text" value="<?php if (isset($options['vertical_area_background'])) { echo esc_attr($options['vertical_area_background']); } ?>" size="12" maxlength="12" />
							</div>
						</td>
					</tr>
					<tr>
						<td valign="middle" width="150"><?php esc_html_e('Left menu area background image', 'soho-core'); ?></td>
						<td>
							<div class="inline" style="width: 700px;">
								<input type="text" id="vertical_area_background_image" name="qode_options_theme18[vertical_area_background_image]" class="qode_upload_field" value="<?php if (isset($options['vertical_area_background_image'])) { echo esc_attr($options['vertical_area_background_image']); } ?>" size="70">
								<input class="upload_button" type="button" value="Upload file">
							</div>
						</td>
					</tr>
					<tr>
						<td valign="middle" width="150"><?php esc_html_e('Left menu area text color (for widgets)', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<div class="colorSelector"><div style="<?php if (isset($options['vertical_area_text_color']) && $options['vertical_area_text_color']){ echo 'background-color:'.esc_attr($options['vertical_area_text_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[vertical_area_text_color]" type="text" value="<?php if (isset($options['vertical_area_text_color'])) { echo esc_attr($options['vertical_area_text_color']); } ?>" size="12" maxlength="12" />
							</div>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Left menu area dropdown', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Animate', 'soho-core'); ?>
								<select name="qode_options_theme18[vertical_dropdown_animation]">
									<option <?php if(isset($options['vertical_dropdown_animation'])){ if ($options['vertical_dropdown_animation'] == "no") { echo "selected='selected'"; }} ?> value="no"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
									<option <?php if(isset($options['vertical_dropdown_animation'])){ if ($options['vertical_dropdown_animation'] == "yes") { echo "selected='selected'"; }} ?> value="yes"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Background color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['vertical_dropdown_background_color'])){ echo 'background-color:'.esc_attr($options['vertical_dropdown_background_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[vertical_dropdown_background_color]" type="text" value="<?php if (isset($options['vertical_dropdown_background_color'])) { echo esc_attr($options['vertical_dropdown_background_color']); } ?>" size="12" maxlength="12" />
							</div>
							<div class="inline">
								<?php esc_html_e('Separator color (wide type)', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['vertical_dropdown_background_separator_color'])){ echo 'background-color:'.esc_attr($options['vertical_dropdown_background_separator_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[vertical_dropdown_background_separator_color]" type="text" value="<?php if (isset($options['vertical_dropdown_background_separator_color'])) { echo esc_attr($options['vertical_dropdown_background_separator_color']); } ?>" size="12" maxlength="12" />
							</div>
							<div class="inline">
								<?php esc_html_e('Transparency (From 0 to 1)', 'soho-core'); ?>
								<input name="qode_options_theme18[vertical_dropdown_background_transparency]" type="text" value="<?php if (isset($options['vertical_dropdown_background_transparency'])) { echo esc_attr($options['vertical_dropdown_background_transparency']); } ?>" size="12" maxlength="12" />
							</div>
						</td>
					</tr>
					<tr valign="top">
						<td valign="top" width="150"></td>
						<td>
							<div class="inline" style="width: 700px;">
								<?php esc_html_e('Pattern background image', 'soho-core'); ?><br/>
								<input type="text" id="vertical_dropdown_background_pattern" name="qode_options_theme18[vertical_dropdown_background_pattern]" class="qode_upload_field" value="<?php if (isset($options['vertical_dropdown_background_pattern'])) { echo esc_attr($options['vertical_dropdown_background_pattern']); } ?>" size="70">
								<input class="upload_button" type="button" value="Upload file">
							</div>
						</td>
					</tr>
					</tbody>
				</table>
				<?php display_save_changes_button(); ?>
			</div>
			<h3><?php esc_html_e( 'Elements', 'soho-core' ); ?></h3>
			<div>
				<table class="form-table">
					<tbody>

					<tr><td colspan='2'><h2><?php esc_html_e( 'Accordion', 'soho-core' ); ?></h2></td></tr>
					<tr valign="middle">
						<td valign="middle"></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['accordion_color'])){ echo 'background-color:'.esc_attr($options['accordion_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[accordion_color]" type="text" value="<?php if (isset($options['accordion_color'])) { echo esc_attr($options['accordion_color']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Hover color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['accordion_color_hover'])){ echo 'background-color:'.esc_attr($options['accordion_color_hover']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[accordion_color_hover]" type="text" value="<?php if (isset($options['accordion_color_hover'])) { echo esc_attr($options['accordion_color_hover']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Background color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['accordion_backgroundcolor'])){ echo 'background-color:'.esc_attr($options['accordion_backgroundcolor']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[accordion_backgroundcolor]" type="text" value="<?php if (isset($options['accordion_backgroundcolor'])) { echo esc_attr($options['accordion_backgroundcolor']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Hover background  color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['accordion_backgroundcolor_hover'])){ echo 'background-color:'.esc_attr($options['accordion_backgroundcolor_hover']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[accordion_backgroundcolor_hover]" type="text" value="<?php if (isset($options['accordion_backgroundcolor_hover'])) { echo esc_attr($options['accordion_backgroundcolor_hover']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Border color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['accordion_bordercolor'])){ echo 'background-color:'.esc_attr($options['accordion_bordercolor']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[accordion_bordercolor]" type="text" value="<?php if (isset($options['accordion_bordercolor'])) { echo esc_attr($options['accordion_bordercolor']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Hover border color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['accordion_bordercolor_hover'])){ echo 'background-color:'.esc_attr($options['accordion_bordercolor_hover']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[accordion_bordercolor_hover]" type="text" value="<?php if (isset($options['accordion_bordercolor_hover'])) { echo esc_attr($options['accordion_bordercolor_hover']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font size (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[accordion_fontsize]" type="text" value="<?php if (isset($options['accordion_fontsize'])) { echo esc_attr($options['accordion_fontsize']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Line height (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[accordion_lineheight]" type="text" value="<?php if (isset($options['accordion_lineheight'])) { echo esc_attr($options['accordion_lineheight']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font weight', 'soho-core'); ?>
								<select name="qode_options_theme18[accordion_fontweight]">
									<option <?php if ($options['accordion_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if ($options['accordion_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200">200</option>
									<option <?php if ($options['accordion_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300">300</option>
									<option <?php if ($options['accordion_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400">400</option>
									<option <?php if ($options['accordion_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500">500</option>
									<option <?php if ($options['accordion_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600">600</option>
									<option <?php if ($options['accordion_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700">700</option>
									<option <?php if ($options['accordion_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800">800</option>
									<option <?php if ($options['accordion_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900">900</option>
								</select>
							</div>
						</td>
					</tr>
					<tr><td colspan='2'><h2><?php esc_html_e( 'Blockquote', 'soho-core' ); ?></h2></td></tr>
					<tr valign="middle">
						<td valign="middle"></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Font size (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[blockquote_fontsize]" type="text" value="<?php if (isset($options['blockquote_fontsize'])) { echo esc_attr($options['blockquote_fontsize']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['blockquote_color'])){ echo 'background-color:'.esc_attr($options['blockquote_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[blockquote_color]" type="text" value="<?php if (isset($options['blockquote_color'])) { echo esc_attr($options['blockquote_color']); } ?>" size="10" maxlength="10" />
							</div>
						</td>
					</tr>
					<tr><td colspan='2'><h2><?php esc_html_e( 'Buttons', 'soho-core' ); ?></h2></td></tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Button style', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if ($options['button_title_color']){ echo 'background-color:'.esc_attr($options['button_title_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[button_title_color]" type="text" value="<?php if ($options['button_title_color']) { echo esc_attr($options['button_title_color']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Hover color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if ($options['button_title_hovercolor']){ echo 'background-color:'.esc_attr($options['button_title_hovercolor']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[button_title_hovercolor]" type="text" value="<?php if ($options['button_title_hovercolor']) { echo esc_attr($options['button_title_hovercolor']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Background color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['button_backgroundcolor']) && $options['button_backgroundcolor']){ echo 'background-color:'.esc_attr($options['button_backgroundcolor']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[button_backgroundcolor]" type="text" value="<?php if (isset($options['button_backgroundcolor']) && $options['button_backgroundcolor']) { echo esc_attr($options['button_backgroundcolor']); } ?>" size="12" maxlength="12" />
							</div>
							<div class="inline">
								<?php esc_html_e('Hover background color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['button_backgroundcolor_hover']) && $options['button_backgroundcolor_hover']){ echo 'background-color:'.esc_attr($options['button_backgroundcolor_hover']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[button_backgroundcolor_hover]" type="text" value="<?php if (isset($options['button_backgroundcolor_hover']) && $options['button_backgroundcolor_hover']) { echo esc_attr($options['button_backgroundcolor_hover']); } ?>" size="12" maxlength="12" />
							</div>
							<div class="inline">
								<?php esc_html_e('Border color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['button_bordercolor']) && $options['button_bordercolor']){ echo 'background-color:'.esc_attr($options['button_bordercolor']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[button_bordercolor]" type="text" value="<?php if (isset($options['button_bordercolor']) && $options['button_bordercolor']) { echo esc_attr($options['button_bordercolor']); } ?>" size="12" maxlength="12" />
							</div>
							<div class="inline">
								<?php esc_html_e('Hover border color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['button_bordercolor_hover']) && $options['button_bordercolor_hover']){ echo 'background-color:'.esc_attr($options['button_bordercolor_hover']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[button_bordercolor_hover]" type="text" value="<?php if (isset($options['button_bordercolor_hover']) && $options['button_bordercolor_hover']) { echo esc_attr($options['button_bordercolor_hover']); } ?>" size="12" maxlength="12" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font family', 'soho-core'); ?>
								<select name="qode_options_theme18[button_title_google_fonts]">
									<option value="-1"><?php esc_html_e( 'Default', 'soho-core' ); ?></option>
									<?php foreach($fontArrays as $fontArray) { ?>
										<option <?php if ($options['button_title_google_fonts'] == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo  $fontArray["family"]; ?></option>
									<?php } ?>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font size (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[button_title_fontsize]" type="text" value="<?php if ($options['button_title_fontsize']) { echo esc_attr($options['button_title_fontsize']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Line height (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[button_title_lineheight]" type="text" value="<?php if ($options['button_title_lineheight']) { echo esc_attr($options['button_title_lineheight']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font style', 'soho-core'); ?>
								<select name="qode_options_theme18[button_title_fontstyle]">
									<option <?php if ($options['button_title_fontstyle'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if ($options['button_title_fontstyle'] == "normal") { echo "selected='selected'"; } ?> value="normal"><?php esc_html_e( 'normal', 'soho-core' ); ?></option>
									<option <?php if ($options['button_title_fontstyle'] == "italic") { echo "selected='selected'"; } ?> value="italic"><?php esc_html_e( 'italic', 'soho-core' ); ?></option>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font weight', 'soho-core'); ?>
								<select name="qode_options_theme18[button_title_fontweight]">
									<option <?php if ($options['button_title_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if ($options['button_title_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200">200</option>
									<option <?php if ($options['button_title_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300">300</option>
									<option <?php if ($options['button_title_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400">400</option>
									<option <?php if ($options['button_title_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500">500</option>
									<option <?php if ($options['button_title_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600">600</option>
									<option <?php if ($options['button_title_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700">700</option>
									<option <?php if ($options['button_title_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800">800</option>
									<option <?php if ($options['button_title_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900">900</option>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Button Text Transform', 'soho-core'); ?>
								<select name="qode_options_theme18[button_texttransform]">
									<option <?php if (isset($options['button_texttransform']) && $options['button_texttransform'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if (isset($options['button_texttransform']) && $options['button_texttransform'] == "none") { echo "selected='selected'"; } ?> value="none"><?php esc_html_e( 'None', 'soho-core' ); ?></option>
									<option <?php if (isset($options['button_texttransform']) && $options['button_texttransform'] == "capitalize") { echo "selected='selected'"; } ?> value="capitalize"><?php esc_html_e( 'Capitalize', 'soho-core' ); ?></option>
									<option <?php if (isset($options['button_texttransform']) && $options['button_texttransform'] == "uppercase") { echo "selected='selected'"; } ?> value="uppercase"><?php esc_html_e( 'Uppercase', 'soho-core' ); ?></option>
									<option <?php if (isset($options['button_texttransform']) && $options['button_texttransform'] == "lowercase") { echo "selected='selected'"; } ?> value="lowercase"><?php esc_html_e( 'Lowercase', 'soho-core' ); ?></option>
								</select>
							</div>
						</td>
					</tr>
					<tr><td colspan='2'><h2><?php esc_html_e( 'Content input fields', 'soho-core' ); ?></h2></td></tr>
					<tr valign="middle">
						<td valign="middle"></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['content_input_fields_color'])){ echo 'background-color:'.esc_attr($options['content_input_fields_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[content_input_fields_color]" type="text" value="<?php if (isset($options['content_input_fields_color'])) { echo esc_attr($options['content_input_fields_color']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Background Color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['content_input_fields_backgroundcolor'])){ echo 'background-color:'.esc_attr($options['content_input_fields_backgroundcolor']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[content_input_fields_backgroundcolor]" type="text" value="<?php if (isset($options['content_input_fields_backgroundcolor'])) { echo esc_attr($options['content_input_fields_backgroundcolor']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Border Color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['content_input_fields_bordercolor'])){ echo 'background-color:'.esc_attr($options['content_input_fields_bordercolor']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[content_input_fields_bordercolor]" type="text" value="<?php if (isset($options['content_input_fields_bordercolor'])) { echo esc_attr($options['content_input_fields_bordercolor']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Hover Color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['content_input_fields_hover_color'])){ echo 'background-color:'.esc_attr($options['content_input_fields_hover_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[content_input_fields_hover_color]" type="text" value="<?php if (isset($options['content_input_fields_hover_color'])) { echo esc_attr($options['content_input_fields_hover_color']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Hover Background Color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['content_input_fields_hover_backgroundcolor'])){ echo 'background-color:'.esc_attr($options['content_input_fields_hover_backgroundcolor']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[content_input_fields_hover_backgroundcolor]" type="text" value="<?php if (isset($options['content_input_fields_hover_backgroundcolor'])) { echo esc_attr($options['content_input_fields_hover_backgroundcolor']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Hover Border Color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['content_input_fields_hover_bordercolor'])){ echo 'background-color:'.esc_attr($options['content_input_fields_hover_bordercolor']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[content_input_fields_hover_bordercolor]" type="text" value="<?php if (isset($options['content_input_fields_hover_bordercolor'])) { echo esc_attr($options['content_input_fields_hover_bordercolor']); } ?>" size="10" maxlength="10" />
							</div>
						</td>
					</tr>
					<tr><td colspan='2'><h2><?php esc_html_e( 'Lists - Unordered', 'soho-core' ); ?></h2></td></tr>
					<tr valign="middle">
						<td valign="middle"></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Font size (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[lists_unsorted_fontsize]" type="text" value="<?php if (isset($options['lists_unsorted_fontsize'])) { echo esc_attr($options['lists_unsorted_fontsize']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Line height (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[lists_unsorted_lineheight]" type="text" value="<?php if (isset($options['lists_unsorted_lineheight'])) { echo esc_attr($options['lists_unsorted_lineheight']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['lists_unsorted_color'])){ echo 'background-color:'.esc_attr($options['lists_unsorted_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[lists_unsorted_color]" type="text" value="<?php if (isset($options['lists_unsorted_color'])) { echo esc_attr($options['lists_unsorted_color']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Margin bottom (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[lists_unsorted_marginbottom]" type="text" value="<?php if (isset($options['lists_unsorted_marginbottom'])) { echo esc_attr($options['lists_unsorted_marginbottom']); } ?>" size="10" maxlength="10" />
							</div>

						</td>
					</tr>
					<tr><td colspan='2'><h2><?php esc_html_e( 'Message box', 'soho-core' ); ?></h2></td></tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Message box text style', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['messagebox_color'])){ echo 'background-color:'.esc_attr($options['messagebox_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[messagebox_color]" type="text" value="<?php if (isset($options['messagebox_color'])) { echo esc_attr($options['messagebox_color']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font size (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[messagebox_fontsize]" type="text" value="<?php if ($options['messagebox_fontsize']) { echo esc_attr($options['messagebox_fontsize']); } ?>" size="12" maxlength="12" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font weight', 'soho-core'); ?>
								<select name="qode_options_theme18[messagebox_fontweight]">
									<option <?php if ($options['messagebox_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if ($options['messagebox_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200">200</option>
									<option <?php if ($options['messagebox_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300">300</option>
									<option <?php if ($options['messagebox_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400">400</option>
									<option <?php if ($options['messagebox_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500">500</option>
									<option <?php if ($options['messagebox_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600">600</option>
									<option <?php if ($options['messagebox_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700">700</option>
									<option <?php if ($options['messagebox_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800">800</option>
									<option <?php if ($options['messagebox_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900">900</option>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font style', 'soho-core'); ?>
								<select name="qode_options_theme18[messagebox_fontstyle]">
									<option <?php if ($options['messagebox_fontstyle'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if ($options['messagebox_fontstyle'] == "normal") { echo "selected='selected'"; } ?> value="normal"><?php esc_html_e( 'normal', 'soho-core' ); ?></option>
									<option <?php if ($options['messagebox_fontstyle'] == "italic") { echo "selected='selected'"; } ?> value="italic"><?php esc_html_e( 'italic', 'soho-core' ); ?></option>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Line height (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[messagebox_lineheight]" type="text" value="<?php if ($options['messagebox_lineheight']) { echo esc_attr($options['messagebox_lineheight']); } ?>" size="12" maxlength="12" />
							</div>
							<div class="inline">
								<?php esc_html_e('Background color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['messagebox_backgroundcolor'])){ echo 'background-color:'.esc_attr($options['messagebox_backgroundcolor']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[messagebox_backgroundcolor]" type="text" value="<?php if (isset($options['messagebox_backgroundcolor'])) { echo esc_attr($options['messagebox_backgroundcolor']); } ?>" size="10" maxlength="10" />
							</div>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Message box icon style', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['messagebox_icon_color'])){ echo 'background-color:'.esc_attr($options['messagebox_icon_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[messagebox_icon_color]" type="text" value="<?php if (isset($options['messagebox_icon_color'])) { echo esc_attr($options['messagebox_icon_color']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font size (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[messagebox_icon_fontsize]" type="text" value="<?php if ($options['messagebox_icon_fontsize']) { echo esc_attr($options['messagebox_icon_fontsize']); } ?>" size="12" maxlength="12" />
							</div>
						</td>
					</tr>
					<tr><td colspan='2'><h2><?php esc_html_e( 'Pricing tables', 'soho-core' ); ?></h2></td></tr>
					<tr valign="middle">
						<td valign="middle"><?php esc_html_e( 'Odd elements', 'soho-core' ); ?></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Background color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['pricingtables_backgroundcolor'])){ echo 'background-color:'.esc_attr($options['pricingtables_backgroundcolor']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[pricingtables_backgroundcolor]" type="text" value="<?php if (isset($options['pricingtables_backgroundcolor'])) { echo esc_attr($options['pricingtables_backgroundcolor']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline" style="width: 570px;">
								<?php esc_html_e('Background pattern', 'soho-core'); ?>
								<input type="text" id="pricingtables_backgroundpatern" name="qode_options_theme18[pricingtables_backgroundpatern]" class="pricingtables_backgroundpatern" value="<?php if (isset($options['pricingtables_backgroundpatern'])) { echo esc_attr($options['pricingtables_backgroundpatern']); } ?>" size="40">
								<input class="upload_button" type="button" value="Upload file">
							</div>
						</td>
					</tr>
					<tr valign="middle">
						<td valign="middle"><?php esc_html_e( 'Even elements and price box', 'soho-core' ); ?></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Background color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['pricingtables_even_backgroundcolor'])){ echo 'background-color:'.esc_attr($options['pricingtables_even_backgroundcolor']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[pricingtables_even_backgroundcolor]" type="text" value="<?php if (isset($options['pricingtables_even_backgroundcolor'])) { echo esc_attr($options['pricingtables_even_backgroundcolor']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline" style="width: 570px;">
								<?php esc_html_e('Background pattern', 'soho-core'); ?>
								<input type="text" id="pricingtables_even_backgroundpatern" name="qode_options_theme18[pricingtables_even_backgroundpatern]" class="pricingtables_even_backgroundpatern" value="<?php if (isset($options['pricingtables_even_backgroundpatern'])) { echo esc_attr($options['pricingtables_even_backgroundpatern']); } ?>" size="40">
								<input class="upload_button" type="button" value="Upload file">
							</div>
						</td>
					</tr>
					<tr><td colspan='2'><h2><?php esc_html_e( 'Progress bar horizontal', 'soho-core' ); ?></h2></td></tr>
					<tr valign="middle">
						<td valign="middle"></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Font size (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[progressbar_horizontal_fontsize]" type="text" value="<?php if ($options['progressbar_horizontal_fontsize']) { echo esc_attr($options['progressbar_horizontal_fontsize']); } ?>" size="12" maxlength="12" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font weight', 'soho-core'); ?>
								<select name="qode_options_theme18[progressbar_horizontal_fontweight]">
									<option <?php if ($options['progressbar_horizontal_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if ($options['progressbar_horizontal_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200">200</option>
									<option <?php if ($options['progressbar_horizontal_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300">300</option>
									<option <?php if ($options['progressbar_horizontal_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400">400</option>
									<option <?php if ($options['progressbar_horizontal_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500">500</option>
									<option <?php if ($options['progressbar_horizontal_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600">600</option>
									<option <?php if ($options['progressbar_horizontal_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700">700</option>
									<option <?php if ($options['progressbar_horizontal_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800">800</option>
									<option <?php if ($options['progressbar_horizontal_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900">900</option>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font style', 'soho-core'); ?>
								<select name="qode_options_theme18[progressbar_horizontal_fontstyle]">
									<option <?php if ($options['progressbar_horizontal_fontstyle'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if ($options['progressbar_horizontal_fontstyle'] == "normal") { echo "selected='selected'"; } ?> value="normal"><?php esc_html_e( 'normal', 'soho-core' ); ?></option>
									<option <?php if ($options['progressbar_horizontal_fontstyle'] == "italic") { echo "selected='selected'"; } ?> value="italic"><?php esc_html_e( 'italic', 'soho-core' ); ?></option>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Line height (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[progressbar_horizontal_lineheight]" type="text" value="<?php if ($options['progressbar_horizontal_lineheight']) { echo esc_attr($options['progressbar_horizontal_lineheight']); } ?>" size="12" maxlength="12" />
							</div>
						</td>
					</tr>
					<tr><td colspan='2'><h2><?php esc_html_e( 'Progress bar vertical', 'soho-core' ); ?></h2></td></tr>
					<tr valign="middle">
						<td valign="middle"></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Font size (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[progressbar_vertical_fontsize]" type="text" value="<?php if ($options['progressbar_vertical_fontsize']) { echo esc_attr($options['progressbar_vertical_fontsize']); } ?>" size="12" maxlength="12" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font weight', 'soho-core'); ?>
								<select name="qode_options_theme18[progressbar_vertical_fontweight]">
									<option <?php if ($options['progressbar_vertical_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if ($options['progressbar_vertical_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200">200</option>
									<option <?php if ($options['progressbar_vertical_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300">300</option>
									<option <?php if ($options['progressbar_vertical_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400">400</option>
									<option <?php if ($options['progressbar_vertical_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500">500</option>
									<option <?php if ($options['progressbar_vertical_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600">600</option>
									<option <?php if ($options['progressbar_vertical_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700">700</option>
									<option <?php if ($options['progressbar_vertical_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800">800</option>
									<option <?php if ($options['progressbar_vertical_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900">900</option>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font style', 'soho-core'); ?>
								<select name="qode_options_theme18[progressbar_vertical_fontstyle]">
									<option <?php if ($options['progressbar_vertical_fontstyle'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if ($options['progressbar_vertical_fontstyle'] == "normal") { echo "selected='selected'"; } ?> value="normal"><?php esc_html_e( 'normal', 'soho-core' ); ?></option>
									<option <?php if ($options['progressbar_vertical_fontstyle'] == "italic") { echo "selected='selected'"; } ?> value="italic"><?php esc_html_e( 'italic', 'soho-core' ); ?></option>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Line height (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[progressbar_vertical_lineheight]" type="text" value="<?php if ($options['progressbar_vertical_lineheight']) { echo esc_attr($options['progressbar_vertical_lineheight']); } ?>" size="12" maxlength="12" />
							</div>
						</td>
					</tr>
					<tr><td colspan='2'><h2><?php esc_html_e( 'Pie charts', 'soho-core' ); ?></h2></td></tr>
					<tr valign="middle">
						<td valign="middle"></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Font size (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[piecharts_fontsize]" type="text" value="<?php if ($options['piecharts_fontsize']) { echo esc_attr($options['piecharts_fontsize']); } ?>" size="12" maxlength="12" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font weight', 'soho-core'); ?>
								<select name="qode_options_theme18[piecharts_fontweight]">
									<option <?php if ($options['piecharts_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if ($options['piecharts_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200">200</option>
									<option <?php if ($options['piecharts_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300">300</option>
									<option <?php if ($options['piecharts_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400">400</option>
									<option <?php if ($options['piecharts_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500">500</option>
									<option <?php if ($options['piecharts_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600">600</option>
									<option <?php if ($options['piecharts_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700">700</option>
									<option <?php if ($options['piecharts_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800">800</option>
									<option <?php if ($options['piecharts_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900">900</option>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font style', 'soho-core'); ?>
								<select name="qode_options_theme18[piecharts_fontstyle]">
									<option <?php if ($options['piecharts_fontstyle'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if ($options['piecharts_fontstyle'] == "normal") { echo "selected='selected'"; } ?> value="normal"><?php esc_html_e( 'normal', 'soho-core' ); ?></option>
									<option <?php if ($options['piecharts_fontstyle'] == "italic") { echo "selected='selected'"; } ?> value="italic"><?php esc_html_e( 'italic', 'soho-core' ); ?></option>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Line height (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[piecharts_lineheight]" type="text" value="<?php if ($options['piecharts_lineheight']) { echo esc_attr($options['piecharts_lineheight']); } ?>" size="12" maxlength="12" />
							</div>
						</td>
					</tr>
					<tr><td colspan='2'><h2><?php esc_html_e( 'Separator', 'soho-core' ); ?></h2></td></tr>
					<tr valign="middle">
						<td valign="middle"></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['separator_color'])){ echo 'background-color:'.esc_attr($options['separator_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[separator_color]" type="text" value="<?php if (isset($options['separator_color'])) { echo esc_attr($options['separator_color']); } ?>" size="12" maxlength="12" />
							</div>
							<div class="inline">
								<?php esc_html_e('Thickness (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[separator_thickness]" type="text" value="<?php if ($options['separator_thickness']) { echo esc_attr($options['separator_thickness']); } ?>" size="12" maxlength="12" />
							</div>
							<div class="inline">
								<?php esc_html_e('Top margin (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[separator_topmargin]" type="text" value="<?php if ($options['separator_topmargin']) { echo esc_attr($options['separator_topmargin']); } ?>" size="12" maxlength="12" />
							</div>
							<div class="inline">
								<?php esc_html_e('Bottom margin (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[separator_bottommargin]" type="text" value="<?php if ($options['separator_bottommargin']) { echo esc_attr($options['separator_bottommargin']); } ?>" size="12" maxlength="12" />
							</div>
						</td>
					</tr>
					<tr><td colspan='2'><h2><?php esc_html_e( 'Tabs', 'soho-core' ); ?></h2></td></tr>
					<tr valign="middle">
						<td valign="middle"></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['tabs_color'])){ echo 'background-color:'.esc_attr($options['tabs_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[tabs_color]" type="text" value="<?php if (isset($options['tabs_color'])) { echo esc_attr($options['tabs_color']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Hover color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['tabs_color_hover'])){ echo 'background-color:'.esc_attr($options['tabs_color_hover']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[tabs_color_hover]" type="text" value="<?php if (isset($options['tabs_color_hover'])) { echo esc_attr($options['tabs_color_hover']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Background color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['tabs_backgroundcolor'])){ echo 'background-color:'.esc_attr($options['tabs_backgroundcolor']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[tabs_backgroundcolor]" type="text" value="<?php if (isset($options['tabs_backgroundcolor'])) { echo esc_attr($options['tabs_backgroundcolor']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Hover background  color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['tabs_backgroundcolor_hover'])){ echo 'background-color:'.esc_attr($options['tabs_backgroundcolor_hover']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[tabs_backgroundcolor_hover]" type="text" value="<?php if (isset($options['tabs_backgroundcolor_hover'])) { echo esc_attr($options['tabs_backgroundcolor_hover']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Border color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['tabs_bordercolor'])){ echo 'background-color:'.esc_attr($options['tabs_bordercolor']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[tabs_bordercolor]" type="text" value="<?php if (isset($options['tabs_bordercolor'])) { echo esc_attr($options['tabs_bordercolor']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Hover border color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['tabs_bordercolor_hover'])){ echo 'background-color:'.esc_attr($options['tabs_bordercolor_hover']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[tabs_bordercolor_hover]" type="text" value="<?php if (isset($options['tabs_bordercolor_hover'])) { echo esc_attr($options['tabs_bordercolor_hover']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font size (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[tabs_fontsize]" type="text" value="<?php if (isset($options['tabs_fontsize'])) { echo esc_attr($options['tabs_fontsize']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Line height (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[tabs_lineheight]" type="text" value="<?php if (isset($options['tabs_lineheight'])) { echo esc_attr($options['tabs_lineheight']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font weight', 'soho-core'); ?>
								<select name="qode_options_theme18[tabs_fontweight]">
									<option <?php if ($options['tabs_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if ($options['tabs_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200">200</option>
									<option <?php if ($options['tabs_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300">300</option>
									<option <?php if ($options['tabs_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400">400</option>
									<option <?php if ($options['tabs_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500">500</option>
									<option <?php if ($options['tabs_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600">600</option>
									<option <?php if ($options['tabs_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700">700</option>
									<option <?php if ($options['tabs_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800">800</option>
									<option <?php if ($options['tabs_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900">900</option>
								</select>
							</div>
						</td>
					</tr>
					<tr><td colspan='2'><h2><?php esc_html_e( 'Testimonials', 'soho-core' ); ?></h2></td></tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Testimonial text style', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Font size (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[testimonials_fontsize]" type="text" value="<?php if (isset($options['testimonials_fontsize'])) { echo esc_attr($options['testimonials_fontsize']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font weight', 'soho-core'); ?>
								<select name="qode_options_theme18[testimonials_fontweight]">
									<option <?php if ($options['testimonials_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if ($options['testimonials_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200">200</option>
									<option <?php if ($options['testimonials_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300">300</option>
									<option <?php if ($options['testimonials_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400">400</option>
									<option <?php if ($options['testimonials_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500">500</option>
									<option <?php if ($options['testimonials_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600">600</option>
									<option <?php if ($options['testimonials_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700">700</option>
									<option <?php if ($options['testimonials_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800">800</option>
									<option <?php if ($options['testimonials_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900">900</option>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Line height (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[testimonials_lineheight]" type="text" value="<?php if (isset($options['testimonials_lineheight'])) { echo esc_attr($options['testimonials_lineheight']); } ?>" size="10" maxlength="10" />
							</div>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Testimonial author style', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Font size (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[testimonials_autor_fontsize]" type="text" value="<?php if (isset($options['testimonials_autor_fontsize'])) { echo esc_attr($options['testimonials_autor_fontsize']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font weight', 'soho-core'); ?>
								<select name="qode_options_theme18[testimonials_autor_fontweight]">
									<option <?php if ($options['testimonials_autor_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if ($options['testimonials_autor_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200">200</option>
									<option <?php if ($options['testimonials_autor_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300">300</option>
									<option <?php if ($options['testimonials_autor_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400">400</option>
									<option <?php if ($options['testimonials_autor_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500">500</option>
									<option <?php if ($options['testimonials_autor_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600">600</option>
									<option <?php if ($options['testimonials_autor_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700">700</option>
									<option <?php if ($options['testimonials_autor_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800">800</option>
									<option <?php if ($options['testimonials_autor_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900">900</option>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Line height (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[testimonials_autor_lineheight]" type="text" value="<?php if (isset($options['testimonials_autor_lineheight'])) { echo esc_attr($options['testimonials_autor_lineheight']); } ?>" size="10" maxlength="10" />
							</div>
						</td>
					</tr>

					</tbody>
				</table>
				<?php		display_save_changes_button(); ?>
			</div>
			<h3><?php esc_html_e( 'Side Area', 'soho-core' ); ?></h3>
			<div>
				<table class="form-table">
					<tbody>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Enable Side Area', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<select name="qode_options_theme18[enable_side_area]">
									<option <?php if ((isset($options['enable_side_area'])) && $options['enable_side_area'] == "yes") { echo "selected='selected'"; } ?> value="yes"><?php esc_html_e( 'yes', 'soho-core' ); ?></option>
									<option <?php if ((isset($options['enable_side_area'])) && $options['enable_side_area'] == "no") { echo "selected='selected'"; } ?> value="no"><?php esc_html_e( 'no', 'soho-core' ); ?></option>
								</select>
							</div>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Side Area Title', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<input name="qode_options_theme18[side_area_title]" type="text" value="<?php if(isset($options['side_area_title'])) { if ($options['side_area_title']) { echo esc_attr($options['side_area_title']); } } ?>" />
							</div>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Background Color', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<div class="colorSelector"><div style="<?php if (isset($options['side_area_background_color']) && $options['side_area_background_color']){ echo 'background-color:'.esc_attr($options['side_area_background_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[side_area_background_color]" type="text" value="<?php if(isset($options['side_area_background_color'])){ if ($options['side_area_background_color']) { echo esc_attr($options['side_area_background_color']); } } ?>" size="10" maxlength="10" />
							</div>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Text Color', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<div class="colorSelector"><div style="<?php if (isset($options['side_area_text_color']) && $options['side_area_text_color']){ echo 'background-color:'.esc_attr($options['side_area_text_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[side_area_text_color]" type="text" value="<?php if(isset($options['side_area_text_color'])){ if ($options['side_area_text_color']) { echo esc_attr($options['side_area_text_color']); } } ?>" size="10" maxlength="10" />
							</div>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Title Color', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<div class="colorSelector"><div style="<?php if (isset($options['side_area_title_color']) && $options['side_area_title_color']){ echo 'color:'.esc_attr($options['side_area_title_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[side_area_title_color]" type="text" value="<?php if(isset($options['side_area_title_color'])){ if ($options['side_area_title_color']) { echo esc_attr($options['side_area_title_color']); } } ?>" size="10" maxlength="10" />
							</div>
						</td>
					</tr>
					</tbody>
				</table>
				<?php		display_save_changes_button(); ?>
			</div>
			<h3><?php esc_html_e( 'Fullscreen Menu', 'soho-core' ); ?></h3>
			<div>
				<table class="form-table">
					<tbody>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Enable Fullscreen Menu', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<select name="qode_options_theme18[enable_popup_menu]">
									<option <?php if ((isset($options['enable_popup_menu'])) && $options['enable_popup_menu'] == "no") { echo "selected='selected'"; } ?> value="no"><?php esc_html_e( 'no', 'soho-core' ); ?></option>
									<option <?php if ((isset($options['enable_popup_menu'])) && $options['enable_popup_menu'] == "yes") { echo "selected='selected'"; } ?> value="yes"><?php esc_html_e( 'yes', 'soho-core' ); ?></option>
								</select>
							</div>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Logo image for Fullscreen menu', 'soho-core'); ?></td>
						<td>
							<div class="inline" style="width: 700px;">
								<input type="text" id="logo_image_popup" name="qode_options_theme18[logo_image_popup]" class="qode_upload_field" value="<?php if (isset($options['logo_image_popup'])) { echo esc_attr($options['logo_image_popup']); } else { echo SOHO_QODE_ROOT."/img/logo_black.png"; } ?>" size="70">
								<input class="upload_button" type="button" value="Upload file">
							</div>
						</td>
					</tr>
					<tr valign="top">
						<td scope="row" width="150"><?php esc_html_e('1st level style', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['popup_menu_color'])){ echo 'background-color:'.esc_attr($options['popup_menu_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[popup_menu_color]" type="text" value="<?php if (isset($options['popup_menu_color'])) { echo esc_attr($options['popup_menu_color']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Hover color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['popup_menu_hover_color'])){ echo 'background-color:'.esc_attr($options['popup_menu_hover_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[popup_menu_hover_color]" type="text" value="<?php if (isset($options['popup_menu_hover_color'])) { echo esc_attr($options['popup_menu_hover_color']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Background hover color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['popup_menu_hover_background_color'])){ echo 'background-color:'.esc_attr($options['popup_menu_hover_background_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[popup_menu_hover_background_color]" type="text" value="<?php if (isset($options['popup_menu_hover_background_color'])) { echo esc_attr($options['popup_menu_hover_background_color']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font family', 'soho-core'); ?>
								<select name="qode_options_theme18[popup_menu_google_fonts]">
									<option value="-1"><?php esc_html_e( 'Default', 'soho-core' ); ?></option>
									<?php foreach($fontArrays as $fontArray) { ?>
										<option <?php if (isset($options['popup_menu_google_fonts']) && $options['popup_menu_google_fonts'] == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo  $fontArray["family"]; ?></option>
									<?php } ?>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font size (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[popup_menu_fontsize]" type="text" value="<?php if (isset($options['popup_menu_fontsize']) && $options['popup_menu_fontsize']) { echo esc_attr($options['popup_menu_fontsize']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Line height (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[popup_menu_lineheight]" type="text" value="<?php if (isset($options['popup_menu_lineheight']) && $options['popup_menu_lineheight']) { echo esc_attr($options['popup_menu_lineheight']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font style', 'soho-core'); ?>
								<select name="qode_options_theme18[popup_menu_fontstyle]">
									<option <?php if (isset($options['popup_menu_fontstyle']) && $options['popup_menu_fontstyle'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if (isset($options['popup_menu_fontstyle']) && $options['popup_menu_fontstyle'] == "normal") { echo "selected='selected'"; } ?> value="normal"><?php esc_html_e( 'normal', 'soho-core' ); ?></option>
									<option <?php if (isset($options['popup_menu_fontstyle']) && $options['popup_menu_fontstyle'] == "italic") { echo "selected='selected'"; } ?> value="italic"><?php esc_html_e( 'italic', 'soho-core' ); ?></option>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font weight', 'soho-core'); ?>
								<select name="qode_options_theme18[popup_menu_fontweight]">
									<option <?php if (isset($options['popup_menu_fontweight']) && $options['popup_menu_fontweight'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if (isset($options['popup_menu_fontweight']) && $options['popup_menu_fontweight'] == "200") { echo "selected='selected'"; } ?> value="200">200</option>
									<option <?php if (isset($options['popup_menu_fontweight']) && $options['popup_menu_fontweight'] == "300") { echo "selected='selected'"; } ?> value="300">300</option>
									<option <?php if (isset($options['popup_menu_fontweight']) && $options['popup_menu_fontweight'] == "400") { echo "selected='selected'"; } ?> value="400">400</option>
									<option <?php if (isset($options['popup_menu_fontweight']) && $options['popup_menu_fontweight'] == "500") { echo "selected='selected'"; } ?> value="500">500</option>
									<option <?php if (isset($options['popup_menu_fontweight']) && $options['popup_menu_fontweight'] == "600") { echo "selected='selected'"; } ?> value="600">600</option>
									<option <?php if (isset($options['popup_menu_fontweight']) && $options['popup_menu_fontweight'] == "700") { echo "selected='selected'"; } ?> value="700">700</option>
									<option <?php if (isset($options['popup_menu_fontweight']) && $options['popup_menu_fontweight'] == "800") { echo "selected='selected'"; } ?> value="800">800</option>
									<option <?php if (isset($options['popup_menu_fontweight']) && $options['popup_menu_fontweight'] == "900") { echo "selected='selected'"; } ?> value="900">900</option>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Letter spacing (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[popup_menu_letterspacing]" type="text" value="<?php if (isset($options['popup_menu_letterspacing']) && $options['popup_menu_letterspacing'] !== '') { echo esc_attr($options['popup_menu_letterspacing']); } ?>" size="10" maxlength="10" />
							</div>
						</td>
					</tr>
					<tr valign="top">
						<td scope="row" width="150"><?php esc_html_e('2nd level style', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['popup_menu_color_2nd'])){ echo 'background-color:'.esc_attr($options['popup_menu_color_2nd']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[popup_menu_color_2nd]" type="text" value="<?php if (isset($options['popup_menu_color_2nd'])) { echo esc_attr($options['popup_menu_color_2nd']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Hover color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['popup_menu_hover_color_2nd'])){ echo 'background-color:'.esc_attr($options['popup_menu_hover_color_2nd']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[popup_menu_hover_color_2nd]" type="text" value="<?php if (isset($options['popup_menu_hover_color_2nd'])) { echo esc_attr($options['popup_menu_hover_color_2nd']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Background hover color', 'soho-core'); ?>
								<div class="colorSelector"><div style="<?php if (isset($options['popup_menu_hover_background_color_2nd'])){ echo 'background-color:'.esc_attr($options['popup_menu_hover_background_color_2nd']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[popup_menu_hover_background_color_2nd]" type="text" value="<?php if (isset($options['popup_menu_hover_background_color_2nd'])) { echo esc_attr($options['popup_menu_hover_background_color_2nd']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font family', 'soho-core'); ?>
								<select name="qode_options_theme18[popup_menu_google_fonts_2nd]">
									<option value="-1"><?php esc_html_e( 'Default', 'soho-core' ); ?></option>
									<?php foreach($fontArrays as $fontArray) { ?>
										<option <?php if (isset($options['popup_menu_google_fonts_2nd']) && $options['popup_menu_google_fonts_2nd'] == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } ?>  value="<?php echo str_replace(' ', '+', $fontArray["family"]); ?>"><?php echo  $fontArray["family"]; ?></option>
									<?php } ?>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font size (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[popup_menu_fontsize_2nd]" type="text" value="<?php if (isset($options['popup_menu_fontsize_2nd']) && $options['popup_menu_fontsize_2nd']) { echo esc_attr($options['popup_menu_fontsize_2nd']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Line height (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[popup_menu_lineheight_2nd]" type="text" value="<?php if (isset($options['popup_menu_lineheight_2nd']) && $options['popup_menu_lineheight_2nd']) { echo esc_attr($options['popup_menu_lineheight_2nd']); } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Font style', 'soho-core'); ?>
								<select name="qode_options_theme18[popup_menu_fontstyle_2nd]">
									<option <?php if (isset($options['popup_menu_fontstyle_2nd']) && $options['popup_menu_fontstyle_2nd'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if (isset($options['popup_menu_fontstyle_2nd']) && $options['popup_menu_fontstyle_2nd'] == "normal") { echo "selected='selected'"; } ?> value="normal"><?php esc_html_e( 'normal', 'soho-core' ); ?></option>
									<option <?php if (isset($options['popup_menu_fontstyle_2nd']) && $options['popup_menu_fontstyle_2nd'] == "italic") { echo "selected='selected'"; } ?> value="italic"><?php esc_html_e( 'italic', 'soho-core' ); ?></option>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Font weight', 'soho-core'); ?>
								<select name="qode_options_theme18[popup_menu_fontweight_2nd]">
									<option <?php if (isset($options['popup_menu_fontweight_2nd']) && $options['popup_menu_fontweight_2nd'] == "") { echo "selected='selected'"; } ?> value=""></option>
									<option <?php if (isset($options['popup_menu_fontweight_2nd']) && $options['popup_menu_fontweight_2nd'] == "200") { echo "selected='selected'"; } ?> value="200">200</option>
									<option <?php if (isset($options['popup_menu_fontweight_2nd']) && $options['popup_menu_fontweight_2nd'] == "300") { echo "selected='selected'"; } ?> value="300">300</option>
									<option <?php if (isset($options['popup_menu_fontweight_2nd']) && $options['popup_menu_fontweight_2nd'] == "400") { echo "selected='selected'"; } ?> value="400">400</option>
									<option <?php if (isset($options['popup_menu_fontweight_2nd']) && $options['popup_menu_fontweight_2nd'] == "500") { echo "selected='selected'"; } ?> value="500">500</option>
									<option <?php if (isset($options['popup_menu_fontweight_2nd']) && $options['popup_menu_fontweight_2nd'] == "600") { echo "selected='selected'"; } ?> value="600">600</option>
									<option <?php if (isset($options['popup_menu_fontweight_2nd']) && $options['popup_menu_fontweight_2nd'] == "700") { echo "selected='selected'"; } ?> value="700">700</option>
									<option <?php if (isset($options['popup_menu_fontweight_2nd']) && $options['popup_menu_fontweight_2nd'] == "800") { echo "selected='selected'"; } ?> value="800">800</option>
									<option <?php if (isset($options['popup_menu_fontweight_2nd']) && $options['popup_menu_fontweight_2nd'] == "900") { echo "selected='selected'"; } ?> value="900">900</option>
								</select>
							</div>
							<div class="inline">
								<?php esc_html_e('Letter spacing (px)', 'soho-core'); ?>
								<input name="qode_options_theme18[popup_menu_letterspacing_2nd]" type="text" value="<?php if (isset($options['popup_menu_letterspacing_2nd']) && $options['popup_menu_letterspacing_2nd'] !== '') { echo esc_attr($options['popup_menu_letterspacing_2nd']); } ?>" size="10" maxlength="10" />
							</div>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Background Color', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<div class="colorSelector"><div style="<?php if (isset($options['popup_menu_background_color']) && $options['popup_menu_background_color']){ echo 'background-color:'.esc_attr($options['popup_menu_background_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[popup_menu_background_color]" type="text" value="<?php if(isset($options['popup_menu_background_color'])){ if ($options['popup_menu_background_color']) { echo esc_attr($options['popup_menu_background_color']); } } ?>" size="10" maxlength="10" />
							</div>
							<div class="inline">
								<?php esc_html_e('Transparency (From 0 to 1)', 'soho-core'); ?>
								<input name="qode_options_theme18[popup_menu_background_transparency]" type="text" value="<?php if (isset($options['popup_menu_background_transparency'])) { echo esc_attr($options['popup_menu_background_transparency']); } ?>" size="10" maxlength="10" />
							</div>
						</td>
					</tr>
					</tbody>
				</table>
				<?php		display_save_changes_button(); ?>
			</div>
			<h3><?php esc_html_e( 'Content Bottom Area', 'soho-core' ); ?></h3>
			<div>
				<table class="form-table">
					<tbody>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Enable Content Bottom Area', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<select name="qode_options_theme18[enable_content_bottom_area]">
									<option <?php if ((isset($options['enable_content_bottom_area'])) && $options['enable_content_bottom_area'] == "yes") { echo "selected='selected'"; } ?> value="yes"><?php esc_html_e( 'yes', 'soho-core' ); ?></option>
									<option <?php if ((isset($options['enable_content_bottom_area'])) && $options['enable_content_bottom_area'] == "no") { echo "selected='selected'"; } ?> value="no"><?php esc_html_e( 'no', 'soho-core' ); ?></option>
								</select>
							</div>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Content bottom sidebar to display', 'soho-core'); ?></td>
						<td>
							<select name="qode_options_theme18[content_bottom_sidebar_custom_display]">
								<option value="" <?php if(isset($options['content_bottom_sidebar_custom_display'])){ $content_bottom_sidebar_custom_display = $options['content_bottom_sidebar_custom_display'];  if ($content_bottom_sidebar_custom_display == "" ) { echo "selected='selected'";  } }?>></option>
								<?php
								foreach ( $GLOBALS['wp_registered_sidebars'] as $sidebar ) {
									if(soho_qode_is_user_made_sidebar(ucwords($sidebar['name']))){
										?>
										<option value="<?php echo ucwords( $sidebar['id'] ); ?>" <?php if(isset($options['content_bottom_sidebar_custom_display'])){ $content_bottom_sidebar_custom_display = $options['content_bottom_sidebar_custom_display'];  if ($content_bottom_sidebar_custom_display == ucwords( $sidebar['id'] ) ) { echo "selected='selected'";  } }?>>
											<?php echo ucwords( $sidebar['name'] ); ?>
										</option>
										<?php
									}
								}
								?>
							</select>
						</td>
					</tr>
					<tr valign="middle">
						<td valign="middle" width="150"><?php esc_html_e('Content bottom in grid', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<select name="qode_options_theme18[content_bottom_in_grid]">
									<option <?php if(isset($options['content_bottom_in_grid'])){ if ($options['content_bottom_in_grid'] == "no") { echo "selected='selected'"; }} ?> value="no"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
									<option <?php if(isset($options['content_bottom_in_grid'])){ if ($options['content_bottom_in_grid'] == "yes") { echo "selected='selected'"; }} ?> value="yes"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
								</select>
							</div>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Background Color', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<div class="colorSelector"><div style="<?php if (isset($options['content_bottom_background_color']) && $options['content_bottom_background_color']){ echo 'background-color:'.esc_attr($options['content_bottom_background_color']).';'; } ?>"></div></div>
								<input name="qode_options_theme18[content_bottom_background_color]" type="text" value="<?php if(isset($options['content_bottom_background_color'])){ if ($options['content_bottom_background_color']) { echo esc_attr($options['content_bottom_background_color']); } } ?>" size="10" maxlength="10" />
							</div>
						</td>
					</tr>
					</tbody>
				</table>
				<?php		display_save_changes_button(); ?>
			</div>
			<h3><?php esc_html_e( 'Parallax', 'soho-core' ); ?></h3>
			<div>
				<table class="form-table">
					<tbody>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Parallax on touch devices', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<select name="qode_options_theme18[parallax_onoff]">
									<option <?php if ($options['parallax_onoff'] == "on") { echo "selected='selected'"; } ?> value="on"><?php esc_html_e( 'on', 'soho-core' ); ?></option>
									<option <?php if ($options['parallax_onoff'] == "off") { echo "selected='selected'"; } ?> value="off"><?php esc_html_e( 'off', 'soho-core' ); ?></option>
								</select>
							</div>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Parallax min height (px)', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<input name="qode_options_theme18[parallax_minheight]" type="text" value="<?php if ($options['parallax_minheight']) { echo esc_attr($options['parallax_minheight']); } ?>" size="10" maxlength="10" />
								<?php esc_html_e('Set min-height for last two stages', 'soho-core'); ?>
							</div>
						</td>
					</tr>
					</tbody>
				</table>
			</div>
			<h3><?php esc_html_e( 'Portfolio', 'soho-core' ); ?></h3>
			<div>
				<table class="form-table">
					<tbody>
					<tr><td colspan='2'><h2><?php esc_html_e( 'Portfolio list', 'soho-core' ); ?></h2></td></tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Show Portfolio Select Like', 'soho-core'); ?></td>
						<td>
							<select name="qode_options_theme18[portfolio_qode_like]">
								<option <?php if (isset($options['portfolio_qode_like'])){ $portfolio_qode_like = $options['portfolio_qode_like']; if ($portfolio_qode_like == 'on') { echo "selected='selected'"; } } ?> value="on"><?php esc_html_e( 'On', 'soho-core' ); ?></option>
								<option <?php if (isset($options['portfolio_qode_like'])){ $portfolio_qode_like = $options['portfolio_qode_like']; if ($portfolio_qode_like == 'off') { echo "selected='selected'"; } } ?> value="off"><?php esc_html_e( 'Off', 'soho-core' ); ?></option>
							</select>
						</td>
					</tr>
					<tr><td colspan='2'><h2><?php esc_html_e( 'Portfolio single', 'soho-core' ); ?></h2></td></tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Portfolio style', 'soho-core'); ?></td>
						<td>
							<select name="qode_options_theme18[portfolio_style]">
								<option <?php if ($options['portfolio_style'] == 1) { echo "selected='selected'"; } ?> value="1"><?php esc_html_e( 'Portfolio small images', 'soho-core' ); ?></option>
								<option <?php if ($options['portfolio_style'] == 2) { echo "selected='selected'"; } ?> value="2"><?php esc_html_e( 'Portfolio small slider', 'soho-core' ); ?></option>
								<option <?php if ($options['portfolio_style'] == 5) { echo "selected='selected'"; } ?> value="5"><?php esc_html_e( 'Portfolio big images', 'soho-core' ); ?></option>
								<option <?php if ($options['portfolio_style'] == 3) { echo "selected='selected'"; } ?> value="3"><?php esc_html_e( 'Portfolio big slider', 'soho-core' ); ?></option>
								<option <?php if ($options['portfolio_style'] == 4) { echo "selected='selected'"; } ?> value="4"><?php esc_html_e( 'Portfolio custom', 'soho-core' ); ?></option>
								<option <?php if ($options['portfolio_style'] == 7) { echo "selected='selected'"; } ?> value="7"><?php esc_html_e( 'Portfolio full width custom', 'soho-core' ); ?></option>
								<option <?php if ($options['portfolio_style'] == 6) { echo "selected='selected'"; } ?> value="6"><?php esc_html_e( 'Portfolio gallery', 'soho-core' ); ?></option>
							</select>
						</td>
					</tr>
					<tr>
						<td valign="middle" width="150"><?php esc_html_e('Enable lightbox for Single Project', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<select name="qode_options_theme18[lightbox_single_project]">
									<option <?php if(isset($options['lightbox_single_project'])){ $lightbox_single_project = $options['lightbox_single_project']; if ($lightbox_single_project == 'no') { echo "selected='selected'"; } }  ?> value="no"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
									<option <?php if(isset($options['lightbox_single_project'])){ $lightbox_single_project = $options['lightbox_single_project']; if ($lightbox_single_project == 'yes') { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
								</select>
							</div>
						</td>
					</tr>
					<tr>
						<td valign="middle" width="150"><?php esc_html_e('Number of columns for Portfolio Gallery style', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<select name="qode_options_theme18[portfolio_columns_number]">
									<option <?php if(isset($options['portfolio_columns_number'])){ $portfolio_columns_number = $options['portfolio_columns_number']; if ($options['portfolio_columns_number'] == 2) { echo "selected='selected'"; } } ?> value="2"><?php esc_html_e( '2 columns', 'soho-core' ); ?></option>
									<option <?php if(isset($options['portfolio_columns_number'])){ $portfolio_columns_number = $options['portfolio_columns_number']; if ($options['portfolio_columns_number'] == 3) { echo "selected='selected'"; } } ?> value="3"><?php esc_html_e( '3 columns', 'soho-core' ); ?></option>
									<option <?php if(isset($options['portfolio_columns_number'])){ $portfolio_columns_number = $options['portfolio_columns_number']; if ($options['portfolio_columns_number'] == 4) { echo "selected='selected'"; } } ?> value="4"><?php esc_html_e( '4 columns', 'soho-core' ); ?></option>
								</select>
							</div>
						</td>
					</tr>
					<tr>
						<td valign="middle" width="150"><?php esc_html_e('Portfolio single slug', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<input name="qode_options_theme18[portfolio_single_slug]" type="text" value="<?php if (isset($options['portfolio_single_slug']) && $options['portfolio_single_slug'] != "") { echo esc_attr($options['portfolio_single_slug']); } ?>" />
								<?php echo sprintf(esc_html__('When you put the slug for portfolio page, you should navigate to ','soho-core').'<code>%s</code>'.esc_html__(' and click save button.','soho-core'), '<a href="'. admin_url('options-permalink.php') .'">'. esc_html__('Settings -> Permalinks','soho-core') .'</a>'); ?>
							</div>
						</td>
					</tr>
					<tr>
						<td valign="middle" width="150"><?php esc_html_e('Show categories', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<select name="qode_options_theme18[portfolio_categories]">
									<option <?php if(isset($options['portfolio_categories'])){ $portfolio_categories = $options['portfolio_categories']; if ($portfolio_categories == '') { echo "selected='selected'"; } }  ?> value=""></option>
									<option <?php if(isset($options['portfolio_categories'])){ $portfolio_categories = $options['portfolio_categories']; if ($portfolio_categories == 'no') { echo "selected='selected'"; } }  ?> value="no"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
									<option <?php if(isset($options['portfolio_categories'])){ $portfolio_categories = $options['portfolio_categories']; if ($portfolio_categories == 'yes') { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
								</select>
							</div>
						</td>
					</tr>
					<tr>
						<td valign="middle" width="150"><?php esc_html_e('Enable Portfolio text following', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<select name="qode_options_theme18[portfolio_text_follow]">
									<option <?php if(isset($options['portfolio_text_follow'])){ $portfolio_text_follow = $options['portfolio_text_follow']; if ($portfolio_text_follow == 'portfolio_single_follow') { echo "selected='selected'"; } }  ?> value="portfolio_single_follow"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
									<option <?php if(isset($options['portfolio_text_follow'])){ $portfolio_text_follow = $options['portfolio_text_follow']; if ($portfolio_text_follow == 'portfolio_single_no_follow') { echo "selected='selected'"; } } ?> value="portfolio_single_no_follow"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
								</select>
							</div>
						</td>
					</tr>
					</tbody>
				</table>
				<?php		display_save_changes_button(); ?>
			</div>
			<h3><?php esc_html_e( 'Blog', 'soho-core' ); ?></h3>
			<div>
				<table class="form-table">
					<tbody>
					<tr><td colspan='2'><h2><?php esc_html_e( 'Blog list', 'soho-core' ); ?></h2></td></tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Enable wordpress read more tag', 'soho-core'); ?></td>
						<td>
							<select name="qode_options_theme18[wp_read_more]">
								<option <?php if (isset($options['wp_read_more'])){ $wp_read_more = $options['wp_read_more']; if ($wp_read_more == 'off') { echo "selected='selected'"; } } ?> value="off"><?php esc_html_e( 'Off', 'soho-core' ); ?></option>
								<option <?php if (isset($options['wp_read_more'])){ $wp_read_more = $options['wp_read_more']; if ($wp_read_more == 'on') { echo "selected='selected'"; } } ?> value="on"><?php esc_html_e( 'On', 'soho-core' ); ?></option>
							</select>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Pagination', 'soho-core'); ?></td>
						<td>
							<select name="qode_options_theme18[pagination]">
								<option <?php if ($options['pagination'] == 0) { echo "selected='selected'"; } ?> value="0"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
								<option <?php if ($options['pagination'] == 1) { echo "selected='selected'"; } ?> value="1"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
							</select>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Choose Pagination on Masonry type', 'soho-core'); ?></td>
						<td>
							<select name="qode_options_theme18[pagination_masonry]">
								<option <?php if (isset($options['pagination_masonry'])){ $pagination_masonry = $options['pagination_masonry']; if ($pagination_masonry == 'pagination') { echo "selected='selected'"; } } ?> value="pagination"><?php esc_html_e( 'Pagination', 'soho-core' ); ?></option>
								<option <?php if (isset($options['pagination_masonry'])){ $pagination_masonry = $options['pagination_masonry']; if ($pagination_masonry == 'load_more') { echo "selected='selected'"; } } ?> value="load_more"><?php esc_html_e( 'Load More', 'soho-core' ); ?></option>
								<option <?php if (isset($options['pagination_masonry'])){ $pagination_masonry = $options['pagination_masonry']; if ($pagination_masonry == 'infinite_scroll') { echo "selected='selected'"; } } ?> value="infinite_scroll"><?php esc_html_e( 'Infinite Scroll', 'soho-core' ); ?></option>
							</select>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Show category filter on masonry style', 'soho-core'); ?></td>
						<td>
							<select name="qode_options_theme18[blog_masonry_filter]">
								<option <?php if (isset($options['blog_masonry_filter'])){ $blog_masonry_filter = $options['blog_masonry_filter']; if ($blog_masonry_filter == 'no') { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
								<option <?php if (isset($options['blog_masonry_filter'])){ $blog_masonry_filter = $options['blog_masonry_filter']; if ($blog_masonry_filter == 'yes') { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
							</select>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Choose blog layout (for archive and category)', 'soho-core'); ?></td>
						<td>
							<select name="qode_options_theme18[blog_style]">
								<option <?php if ($options['blog_style'] == 1) { echo "selected='selected'"; } ?> value="1"><?php esc_html_e('Blog Large Image', 'soho-core'); ?></option>
								<option <?php if ($options['blog_style'] == 2) { echo "selected='selected'"; } ?> value="2"><?php esc_html_e('Blog Large Image Whole Post', 'soho-core'); ?></option>
								<option <?php if ($options['blog_style'] == 3) { echo "selected='selected'"; } ?> value="3"><?php esc_html_e('Blog Masonry', 'soho-core'); ?></option>
								<option <?php if ($options['blog_style'] == 4) { echo "selected='selected'"; } ?> value="4"><?php esc_html_e('Blog Masonry Full Width', 'soho-core'); ?></option>
								<option <?php if ($options['blog_style'] == 5) { echo "selected='selected'"; } ?> value="5"><?php esc_html_e('Blog Large Image Wide', 'soho-core'); ?></option>
								<option <?php if ($options['blog_style'] == 6) { echo "selected='selected'"; } ?> value="6"><?php esc_html_e('Blog Large Image Wide Whole Post', 'soho-core'); ?></option>
								<option <?php if ($options['blog_style'] == 7) { echo "selected='selected'"; } ?> value="7"><?php esc_html_e('Blog Medium Image', 'soho-core'); ?></option>
								<option <?php if ($options['blog_style'] == 8) { echo "selected='selected'"; } ?> value="8"><?php esc_html_e('Blog Medium Image Whole Post', 'soho-core'); ?></option>
							</select>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Blog Sidebar', 'soho-core'); ?></td>
						<td>
							<select name="qode_options_theme18[category_blog_sidebar]">
								<option <?php if ($options['category_blog_sidebar'] == "default") { echo "selected='selected'"; } ?> value="default"><?php esc_html_e( 'No Sidebar', 'soho-core' ); ?></option>
								<option <?php if ($options['category_blog_sidebar'] == 1) { echo "selected='selected'"; } ?> value="1"><?php esc_html_e( 'Sidebar 1/3 right', 'soho-core' ); ?></option>
								<option <?php if ($options['category_blog_sidebar'] == 2) { echo "selected='selected'"; } ?> value="2"><?php esc_html_e( 'Sidebar 1/4 right', 'soho-core' ); ?></option>
								<option <?php if ($options['category_blog_sidebar'] == 3) { echo "selected='selected'"; } ?> value="3"><?php esc_html_e( 'Sidebar 1/3 left', 'soho-core' ); ?></option>
								<option <?php if ($options['category_blog_sidebar'] == 4) { echo "selected='selected'"; } ?> value="4"><?php esc_html_e( 'Sidebar 1/4 left', 'soho-core' ); ?></option>
							</select>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Hide comments', 'soho-core'); ?></td>
						<td>
							<select name="qode_options_theme18[blog_hide_comments]">
								<option <?php if(isset($options['blog_hide_comments'])){ $blog_hide_comments = $options['blog_hide_comments']; if ($blog_hide_comments == 'no') { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
								<option <?php if(isset($options['blog_hide_comments'])){ $blog_hide_comments = $options['blog_hide_comments']; if ($blog_hide_comments == 'yes') { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
							</select>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Page Range For Pagination', 'soho-core'); ?></td>
						<td>
							<input name="qode_options_theme18[blog_page_range]" type="text" value="<?php if (isset($options['blog_page_range']) && $options['blog_page_range']) { echo esc_attr($options['blog_page_range']); } ?>" size="10" maxlength="10" />
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Number of words', 'soho-core'); ?></td>
						<td>
							<input name="qode_options_theme18[number_of_chars]" type="text" value="<?php if (isset($options['number_of_chars']) && $options['number_of_chars']) { echo esc_attr($options['number_of_chars']); } ?>" size="10" maxlength="10" />
							<?php esc_html_e('Number of words in blog listing', 'soho-core'); ?>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Number of words in masonry blog template', 'soho-core'); ?></td>
						<td>
							<input name="qode_options_theme18[number_of_chars_masonry]" type="text" value="<?php if (isset($options['number_of_chars_masonry']) && $options['number_of_chars_masonry']) { echo esc_attr($options['number_of_chars_masonry']); } ?>" size="10" maxlength="10" />
						</td>
					</tr>
					<tr><td colspan='2'><h2><?php esc_html_e( 'Blog single', 'soho-core' ); ?></h2></td></tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Hide post title', 'soho-core'); ?></td>
						<td>
							<select name="qode_options_theme18[blog_hide_post_title]">
								<option <?php if(isset($options['blog_hide_post_title'])){ $blog_hide_post_title = $options['blog_hide_post_title']; if ($blog_hide_post_title == 'no') { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
								<option <?php if(isset($options['blog_hide_post_title'])){ $blog_hide_post_title = $options['blog_hide_post_title']; if ($blog_hide_post_title == 'yes') { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
							</select>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Sidebar layout', 'soho-core'); ?></td>
						<td>
							<select name="qode_options_theme18[blog_single_sidebar]">
								<option <?php if(isset($options['blog_single_sidebar'])){$blog_single_sidebar = $options['blog_single_sidebar']; if ($blog_single_sidebar == "default") { echo "selected='selected'"; } } ?> value="default"><?php esc_html_e( 'No Sidebar', 'soho-core' ); ?></option>
								<option <?php if(isset($options['blog_single_sidebar'])){$blog_single_sidebar = $options['blog_single_sidebar']; if ($blog_single_sidebar == 1) { echo "selected='selected'"; } } ?> value="1"><?php esc_html_e( 'Sidebar 1/3 right', 'soho-core' ); ?></option>
								<option <?php if(isset($options['blog_single_sidebar'])){$blog_single_sidebar = $options['blog_single_sidebar']; if ($blog_single_sidebar == 2) { echo "selected='selected'"; } } ?> value="2"><?php esc_html_e( 'Sidebar 1/4 right', 'soho-core' ); ?></option>
								<option <?php if(isset($options['blog_single_sidebar'])){$blog_single_sidebar = $options['blog_single_sidebar']; if ($blog_single_sidebar == 3) { echo "selected='selected'"; } } ?> value="3"><?php esc_html_e( 'Sidebar 1/3 left', 'soho-core' ); ?></option>
								<option <?php if(isset($options['blog_single_sidebar'])){$blog_single_sidebar = $options['blog_single_sidebar']; if ($blog_single_sidebar == 4) { echo "selected='selected'"; } } ?> value="4"><?php esc_html_e( 'Sidebar 1/4 left', 'soho-core' ); ?></option>

							</select>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Sidebar to display', 'soho-core'); ?></td>
						<td>
							<select name="qode_options_theme18[blog_single_sidebar_custom_display]">
								<option value="" <?php if(isset($options['blog_single_sidebar_custom_display'])){ $blog_single_sidebar_custom_display = $options['blog_single_sidebar_custom_display'];  if ($blog_single_sidebar_custom_display == "" ) { echo "selected='selected'";  } }?>></option>
								<?php
								foreach ( $GLOBALS['wp_registered_sidebars'] as $sidebar ) {
									if(soho_qode_is_user_made_sidebar(ucwords($sidebar['name']))){
										?>
										<option value="<?php echo ucwords( $sidebar['id'] ); ?>" <?php if(isset($options['blog_single_sidebar_custom_display'])){ $blog_single_sidebar_custom_display = $options['blog_single_sidebar_custom_display'];  if ($blog_single_sidebar_custom_display == ucwords( $sidebar['id'] ) ) { echo "selected='selected'";  } }?>>
											<?php echo ucwords( $sidebar['name'] ); ?>
										</option>
										<?php
									}
								}
								?>
							</select>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Blog Select Like', 'soho-core'); ?></td>
						<td>
							<select name="qode_options_theme18[qode_like]">
								<option <?php if (isset($options['qode_like'])){ $qode_like = $options['qode_like']; if ($qode_like == 'on') { echo "selected='selected'"; } } ?> value="on"><?php esc_html_e( 'On', 'soho-core' ); ?></option>
								<option <?php if (isset($options['qode_like'])){ $qode_like = $options['qode_like']; if ($qode_like == 'off') { echo "selected='selected'"; } } ?> value="off"><?php esc_html_e( 'Off', 'soho-core' ); ?></option>
							</select>
						</td>
					</tr>
					<tr valign="middle">
						<td scope="row" width="150"><?php esc_html_e('Show Blog Author', 'soho-core'); ?></td>
						<td>
							<select name="qode_options_theme18[blog_author_info]">
								<option <?php if(isset($options['blog_author_info'])){$blog_author_info = $options['blog_author_info']; if ($blog_author_info == "no") { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
								<option <?php if(isset($options['blog_author_info'])){$blog_author_info = $options['blog_author_info']; if ($blog_author_info == "yes") { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
							</select>

						</td>
					</tr>
					</tbody>
				</table>
				<?php		display_save_changes_button(); ?>
			</div>
			<h3><?php esc_html_e( 'Contact page', 'soho-core' ); ?></h3>
			<div>
				<table class="form-table">
					<tbody>
					<tr valign="top">
						<td scope="row" width="150"><?php esc_html_e('Mail send to', 'soho-core'); ?></td>
						<td>
							<input name="qode_options_theme18[receive_mail]" type="text" value="<?php if ($options['receive_mail']) { echo esc_attr($options['receive_mail']); } ?>"  />
						</td>
					</tr>
					<tr valign="top">
						<td scope="row" width="150"><?php esc_html_e('Enable Contact Form', 'soho-core'); ?></td>
						<td>
							<select name="qode_options_theme18[enable_contact_form]">
								<option <?php if ($options['enable_contact_form'] == "no") { echo "selected='selected'"; } ?> value="no"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
								<option <?php if ($options['enable_contact_form'] == "yes") { echo "selected='selected'"; } ?> value="yes"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
							</select>
						</td>
					</tr>
					<tr valign="top">
						<td scope="row" width="150"><?php esc_html_e('Email From', 'soho-core'); ?></td>
						<td>
							<input name="qode_options_theme18[email_from]" type="text" value="<?php if ($options['email_from']) { echo esc_attr($options['email_from']); } ?>"  />
						</td>
					</tr>
					<tr valign="top">
						<td scope="row" width="150"><?php esc_html_e('Email Subject', 'soho-core'); ?></td>
						<td>
							<input name="qode_options_theme18[email_subject]" type="text" value="<?php if ($options['email_subject']) { echo esc_attr($options['email_subject']); } ?>"  />
						</td>
					</tr>
					<tr valign="top">
						<td scope="row" width="150"><?php esc_html_e('Use reCaptcha', 'soho-core'); ?></td>
						<td>
							<select name="qode_options_theme18[use_recaptcha]">
								<option <?php if ($options['use_recaptcha'] == "no") { echo "selected='selected'"; } ?> value="no"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
								<option <?php if ($options['use_recaptcha'] == "yes") { echo "selected='selected'"; } ?> value="yes"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
							</select>
						</td>
					</tr>
					<tr valign="top">
						<td scope="row" width="150"><?php esc_html_e('ReCaptcha public key', 'soho-core'); ?></td>
						<td>
							<input name="qode_options_theme18[recaptcha_public_key]" type="text" value="<?php if ($options['recaptcha_public_key']) { echo esc_attr($options['recaptcha_public_key']); } ?>"  />

						</td>
					</tr>
					<tr valign="top">
						<td scope="row" width="150"><?php esc_html_e('ReCaptcha private key', 'soho-core'); ?></td>
						<td>
							<input name="qode_options_theme18[recaptcha_private_key]" type="text" value="<?php if ($options['recaptcha_private_key']) { echo esc_attr($options['recaptcha_private_key']); } ?>"  />
						</td>
					</tr>
					<tr valign="top">
						<td scope="row" width="150"><?php esc_html_e('Heading above contact form', 'soho-core'); ?></td>
						<td>
							<input name="qode_options_theme18[contact_heading_above]" type="text" value="<?php if ($options['contact_heading_above']) { echo esc_attr($options['contact_heading_above']); } ?>"  />
						</td>
					</tr>
					<tr valign="top">
						<td scope="row" width="150"><?php esc_html_e('Enable Google Map', 'soho-core'); ?></td>
						<td>
							<select name="qode_options_theme18[enable_google_map]">
								<option <?php if ($options['enable_google_map'] == "no") { echo "selected='selected'"; } ?> value="no"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
								<option <?php if ($options['enable_google_map'] == "yes") { echo "selected='selected'"; } ?> value="yes"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
							</select>
							<?php esc_html_e(' If you choose Yes and save, then come back to this section and you will get additional fields for google map settings.', 'soho-core'); ?>
						</td>
					</tr>
					<?php if($options['enable_google_map'] == "yes") : ?>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Pin image', 'soho-core'); ?></td>
							<td>
								<div class="inline" style="width: 705px;">
									<input type="text" id="google_maps_pin_image" name="qode_options_theme18[google_maps_pin_image]" class="google_maps_pin_image" value="<?php if (isset($options['google_maps_pin_image'])) { echo esc_attr($options['google_maps_pin_image']); } else { echo SOHO_QODE_ROOT."/img/pin.png"; } ?>" size="70">
									<input class="upload_button" type="button" value="Upload file">
								</div>
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Google map address', 'soho-core'); ?></td>
							<td>
								<input id="google_maps_address" name="qode_options_theme18[google_maps_address]" value="<?php if (isset($options['google_maps_address'])) { echo esc_attr($options['google_maps_address']); } ?>" size="130" />
								<?php esc_html_e('Example (Louvre Museum, Paris, France)', 'soho-core'); ?>
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Google map address 2', 'soho-core'); ?></td>
							<td>
								<input id="google_maps_address2" name="qode_options_theme18[google_maps_address2]" value="<?php if (isset($options['google_maps_address2'])) { echo esc_attr($options['google_maps_address2']); } ?>" size="130" />
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Google map address 3', 'soho-core'); ?></td>
							<td>
								<input id="google_maps_address3" name="qode_options_theme18[google_maps_address3]" value="<?php if (isset($options['google_maps_address3'])) { echo esc_attr($options['google_maps_address3']); } ?>" size="130" />
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Google map address 4', 'soho-core'); ?></td>
							<td>
								<input id="google_maps_address4" name="qode_options_theme18[google_maps_address4]" value="<?php if (isset($options['google_maps_address4'])) { echo esc_attr($options['google_maps_address4']); } ?>" size="130" />
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Google map address 5', 'soho-core'); ?></td>
							<td>
								<input id="google_maps_address5" name="qode_options_theme18[google_maps_address5]" value="<?php if (isset($options['google_maps_address5'])) { echo esc_attr($options['google_maps_address5']); } ?>" size="130" />
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Google map zoom', 'soho-core'); ?></td>
							<td>
								<input id="google_maps_zoom" name="qode_options_theme18[google_maps_zoom]" value="<?php if (isset($options['google_maps_zoom'])) { echo esc_attr($options['google_maps_zoom']); } ?>" size="10" maxlength="10" />
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Google map height (px)', 'soho-core'); ?></td>
							<td>
								<input id="google_maps_height" name="qode_options_theme18[google_maps_height]" value="<?php if (isset($options['google_maps_height'])) { echo esc_attr($options['google_maps_height']); } ?>" size="10" maxlength="10" />
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Google map style', 'soho-core'); ?></td>
							<td>
								<select name="qode_options_theme18[google_maps_style]">
									<option <?php if(isset($options['google_maps_style'])){ $google_maps_style = $options['google_maps_style']; if ($google_maps_style == 'no') { echo "selected='selected'"; } }  ?> value="no"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
									<option <?php if(isset($options['google_maps_style'])){ $google_maps_style = $options['google_maps_style']; if ($google_maps_style == 'yes') { echo "selected='selected'"; } }  ?> value="yes"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
								</select>
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Google map color', 'soho-core'); ?></td>
							<td>
								<div class="inline">
									<div class="colorSelector"><div style="<?php if ($options['google_maps_color']){ echo 'background-color:'.esc_attr($options['google_maps_color']).';'; } ?>"></div></div>
									<input name="qode_options_theme18[google_maps_color]" type="text" value="<?php if(isset($options['google_maps_color'])){ if ($options['google_maps_color']) { echo esc_attr($options['google_maps_color']); } } ?>" size="10" maxlength="10" />
								</div>
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Google map saturation (-100 to 100)', 'soho-core'); ?></td>
							<td>
								<input id="google_maps_saturation" name="qode_options_theme18[google_maps_saturation]" value="<?php if (isset($options['google_maps_saturation'])) { echo esc_attr($options['google_maps_saturation']); } ?>" size="10" maxlength="10" />
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Google map lightness (-100 to 100)', 'soho-core'); ?></td>
							<td>
								<input id="google_maps_lightness" name="qode_options_theme18[google_maps_lightness]" value="<?php if (isset($options['google_maps_lightness'])) { echo esc_attr($options['google_maps_lightness']); } ?>" size="10" maxlength="10" />
							</td>
						</tr>
						<tr valign="top">
							<td scope="row" width="150"><?php esc_html_e('Google map scroll on mouse wheel', 'soho-core'); ?></td>
							<td>
								<select name="qode_options_theme18[google_maps_scroll_wheel]">
									<option <?php if(isset($options['google_maps_scroll_wheel'])){ $google_maps_scroll_wheel = $options['google_maps_scroll_wheel']; if ($google_maps_scroll_wheel == 'no') { echo "selected='selected'"; } }  ?> value="no"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
									<option <?php if(isset($options['google_maps_scroll_wheel'])){ $google_maps_scroll_wheel = $options['google_maps_scroll_wheel']; if ($google_maps_scroll_wheel == 'yes') { echo "selected='selected'"; } }  ?> value="yes"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
								</select>
							</td>
						</tr>
					<?php endif; ?>
					</tbody>
				</table>
				<?php		display_save_changes_button(); ?>
			</div>
			<h3><?php esc_html_e( '404 page', 'soho-core' ); ?></h3>
			<div>
				<table class="form-table">
					<tbody>
					<tr valign="top">
						<td scope="row" width="150"><?php esc_html_e('Title', 'soho-core'); ?></td>
						<td>
							<input name="qode_options_theme18[404_title]" type="text" value="<?php if ($options['404_title']) { echo esc_attr($options['404_title']); } ?>"  />
						</td>
					</tr>
					<tr valign="top">
						<td scope="row" width="150"><?php esc_html_e('Text', 'soho-core'); ?></td>
						<td>
							<input name="qode_options_theme18[404_text]" type="text" value="<?php if ($options['404_text']) { echo esc_attr($options['404_text']); } ?>"  />
						</td>
					</tr>
					<tr valign="top">
						<td scope="row" width="150"><?php esc_html_e('Back to home label', 'soho-core'); ?></td>
						<td>
							<input name="qode_options_theme18[404_backlabel]" type="text" value="<?php if ($options['404_backlabel']) { echo esc_attr($options['404_backlabel']); } ?>"  />
						</td>
					</tr>
					</tbody>
				</table>
				<?php		display_save_changes_button(); ?>
			</div>
			<h3><?php esc_html_e( 'Social Share', 'soho-core' ); ?></h3>
			<div>
				<table class="form-table">
					<tbody>
					<tr valign="top">
						<td scope="row" width="150"><?php esc_html_e('Enable Social Share', 'soho-core'); ?></td>
						<td>
							<select name="qode_options_theme18[enable_social_share]">
								<option <?php if(isset($options['enable_social_share'])){ $enable_social_share = $options['enable_social_share']; if ($enable_social_share == "no") { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
								<option <?php if(isset($options['enable_social_share'])){ $enable_social_share = $options['enable_social_share']; if ($enable_social_share == "yes") { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
							</select>
						</td>
					</tr>
					<tr valign="top">
						<td scope="row" width="150"><?php esc_html_e('Facebook', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Enable Facebook', 'soho-core'); ?>
								<select name="qode_options_theme18[enable_facebook_share]">
									<option <?php if(isset($options['enable_facebook_share'])){ $enable_facebook_share = $options['enable_facebook_share']; if ($enable_facebook_share == "no") { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
									<option <?php if(isset($options['enable_facebook_share'])){ $enable_facebook_share = $options['enable_facebook_share']; if ($enable_facebook_share == "yes") { echo "selected='selected'"; } }?> value="yes"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
								</select>
							</div>
							<div class="inline" style="width: 780px;">
								<?php esc_html_e('Share Icon', 'soho-core'); ?>
								<input type="text" id="facebook_icon" name="qode_options_theme18[facebook_icon]" class="facebook_icon" value="<?php if (isset($options['facebook_icon'])) { echo esc_attr($options['facebook_icon']); } ?>" size="70">
								<input class="upload_button" type="button" value="Upload file">
							</div>
						</td>
					</tr>
					<tr valign="top">
						<td scope="row" width="150"><?php esc_html_e('Twitter', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Enable Twitter', 'soho-core'); ?>
								<select name="qode_options_theme18[enable_twitter_share]">
									<option <?php if(isset($options['enable_twitter_share'])){ $enable_twitter_share = $options['enable_twitter_share']; if ($enable_twitter_share == "no") { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
									<option <?php if(isset($options['enable_twitter_share'])){ $enable_twitter_share = $options['enable_twitter_share']; if ($enable_twitter_share == "yes") { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
								</select>
							</div>
							<div class="inline" style="width: 780px;">
								<?php esc_html_e('Share Icon', 'soho-core'); ?>
								<input type="text" id="twitter_icon" name="qode_options_theme18[twitter_icon]" class="twitter_icon" value="<?php if (isset($options['twitter_icon'])) { echo esc_attr($options['twitter_icon']); } ?>" size="70">
								<input class="upload_button" type="button" value="Upload file">
							</div>
							<div class="inline">
								<?php esc_html_e('Via', 'soho-core'); ?>
								<input name="qode_options_theme18[twitter_via]" type="text" value="<?php if (isset($options['twitter_via'])) { echo esc_attr($options['twitter_via']); } ?>"  />
							</div>
						</td>
					</tr>
					<tr valign="top">
						<td scope="row" width="150"><?php esc_html_e('Google +', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Enable Google +', 'soho-core'); ?>
								<select name="qode_options_theme18[enable_google_plus]">
									<option <?php if(isset($options['enable_google_plus'])){ $enable_google_plus = $options['enable_google_plus']; if ($enable_google_plus == "no") { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
									<option <?php if(isset($options['enable_google_plus'])){ $enable_google_plus = $options['enable_google_plus']; if ($enable_google_plus == "yes") { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
								</select>
							</div>
							<div class="inline" style="width: 780px;">
								<?php esc_html_e('Share Icon', 'soho-core'); ?>
								<input type="text" id="google_plus_icon" name="qode_options_theme18[google_plus_icon]" class="google_plus_icon" value="<?php if (isset($options['google_plus_icon'])) { echo esc_attr($options['google_plus_icon']); } ?>" size="70">
								<input class="upload_button" type="button" value="Upload file">
							</div>
						</td>
					</tr>
					<tr valign="top">
						<td scope="row" width="150"><?php esc_html_e('LinkedIn', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Enable LinkedIn', 'soho-core'); ?>
								<select name="qode_options_theme18[enable_linkedin]">
									<option <?php if(isset($options['enable_linkedin'])){ $enable_linkedin = $options['enable_linkedin']; if ($enable_linkedin == "no") { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
									<option <?php if(isset($options['enable_linkedin'])){ $enable_linkedin = $options['enable_linkedin']; if ($enable_linkedin == "yes") { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
								</select>
							</div>
							<div class="inline" style="width: 780px;">
								<?php esc_html_e('Share Icon', 'soho-core'); ?>
								<input type="text" id="linkedin_icon" name="qode_options_theme18[linkedin_icon]" class="linkedin_icon" value="<?php if (isset($options['linkedin_icon'])) { echo esc_attr($options['linkedin_icon']); } ?>" size="70">
								<input class="upload_button" type="button" value="Upload file">
							</div>
						</td>
					</tr>
					<tr valign="top">
						<td scope="row" width="150"><?php esc_html_e('Tumblr', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Enable Tumblr', 'soho-core'); ?>
								<select name="qode_options_theme18[enable_tumblr]">
									<option <?php if(isset($options['enable_tumblr'])){ $enable_tumblr = $options['enable_tumblr']; if ($enable_tumblr == "no") { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
									<option <?php if(isset($options['enable_tumblr'])){ $enable_tumblr = $options['enable_tumblr']; if ($enable_tumblr == "yes") { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
								</select>
							</div>
							<div class="inline" style="width: 780px;">
								<?php esc_html_e('Tumblr Icon', 'soho-core'); ?>
								<input type="text" id="tumblr_icon" name="qode_options_theme18[tumblr_icon]" class="tumblr_icon" value="<?php if (isset($options['tumblr_icon'])) { echo esc_attr($options['tumblr_icon']); } ?>" size="70">
								<input class="upload_button" type="button" value="Upload file">
							</div>
						</td>
					</tr>
					<tr valign="top">
						<td scope="row" width="150"><?php esc_html_e('Pinterest', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Enable Pinterest', 'soho-core'); ?>
								<select name="qode_options_theme18[enable_pinterest]">
									<option <?php if(isset($options['enable_pinterest'])){ $enable_pinterest = $options['enable_pinterest']; if ($enable_pinterest == "no") { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
									<option <?php if(isset($options['enable_pinterest'])){ $enable_pinterest = $options['enable_pinterest']; if ($enable_pinterest == "yes") { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
								</select>
							</div>
							<div class="inline" style="width: 780px;">
								<?php esc_html_e('Pinterest Icon', 'soho-core'); ?>
								<input type="text" id="pinterest_icon" name="qode_options_theme18[pinterest_icon]" class="pinterest_icon" value="<?php if (isset($options['pinterest_icon'])) { echo esc_attr($options['pinterest_icon']); } ?>" size="70">
								<input class="upload_button" type="button" value="Upload file">
							</div>
						</td>
					</tr>
					<tr valign="top">
						<td scope="row" width="150"><?php esc_html_e('VK', 'soho-core'); ?></td>
						<td>
							<div class="inline">
								<?php esc_html_e('Enable VK', 'soho-core'); ?>
								<select name="qode_options_theme18[enable_vk]">
									<option <?php if(isset($options['enable_vk'])){ $enable_vk = $options['enable_vk']; if ($enable_vk == "no") { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
									<option <?php if(isset($options['enable_vk'])){ $enable_vk = $options['enable_vk']; if ($enable_vk == "yes") { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
								</select>
							</div>
							<div class="inline" style="width: 780px;">
								<?php esc_html_e('VK Icon', 'soho-core'); ?>
								<input type="text" id="vk_icon" name="qode_options_theme18[vk_icon]" class="vk_icon" value="<?php if (isset($options['vk_icon'])) { echo esc_attr($options['vk_icon']); } ?>" size="70">
								<input class="upload_button" type="button" value="Upload file">
							</div>
						</td>
					</tr>
					<tr valign="top">
						<td scope="row" width="150"><?php esc_html_e('Show For', 'soho-core'); ?></td>
						<td>
							<?php
							$args_post_types = array(
								'public'   => true
							);
							$post_types = get_post_types($args_post_types);
							foreach ($post_types as $post_type ) {

								$post_type_object = get_post_type_object($post_type );
								?>
								<input type="checkbox" value="<?php echo $post_type; ?>" <?php if (isset($options["post_types_names_$post_type"]) && ($options["post_types_names_$post_type"] == "$post_type")){ echo "checked='checked'"; }?> name="qode_options_theme18[post_types_names_<?php echo $post_type; ?>]" /><?php echo " " . $post_type_object->labels->singular_name;  ?><br /><br />

							<?php } ?>
						</td>
					</tr>
					</tbody>
				</table>
				<?php		display_save_changes_button(); ?>
			</div>
			<?php if(function_exists("is_woocommerce")){ ?>
				<h3><?php esc_html_e( 'WooCommerce', 'soho-core' ); ?></h3>
				<div>
					<table class="form-table">
						<tbody>
						<tr><td colspan='2'><h2><?php esc_html_e( 'Shop', 'soho-core' ); ?></h2></td></tr>
						<tr valign="middle">
							<td scope="row" width="170"><?php esc_html_e('Content Top Padding (px)', 'soho-core'); ?></td>
							<td>
								<div class="inline">
									<input name="qode_options_theme18[woocommerce_content_top_padding]" type="text" value="<?php if(isset($options['woocommerce_content_top_padding'])) { if ($options['woocommerce_content_top_padding']) { echo esc_attr($options['woocommerce_content_top_padding']); } } ?>" />
								</div>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="150"><?php esc_html_e('Separator Color for Product items (Between title and price)', 'soho-core'); ?></td>
							<td>
								<div class="inline">
									<div class="colorSelector"><div style="<?php if (isset($options['woocommerce_separator_color']) && $options['woocommerce_separator_color']){ echo 'background-color:'.esc_attr($options['woocommerce_separator_color']).';'; } ?>"></div></div>
									<input name="qode_options_theme18[woocommerce_separator_color]" type="text" value="<?php if(isset($options['woocommerce_separator_color'])){ if ($options['woocommerce_separator_color']) { echo esc_attr($options['woocommerce_separator_color']); } } ?>" size="10" maxlength="10" />
								</div>
							</td>
						</tr>
						<tr><td colspan='2'><h2><?php esc_html_e( 'Shop Single', 'soho-core' ); ?></h2></td></tr>
						<tr valign="middle">
							<td scope="row" width="170"><?php esc_html_e('Hide Title for Single Product', 'soho-core'); ?></td>
							<td>
								<div class="inline">
									<select name="qode_options_theme18[woocommerce_single_hide_title]">
										<option <?php if(isset($options['woocommerce_single_hide_title'])){ $woo_single_hide_title = $options['woocommerce_single_hide_title']; if ($woo_single_hide_title == "no") { echo "selected='selected'"; } } ?> value="no"><?php esc_html_e( 'No', 'soho-core' ); ?></option>
										<option <?php if(isset($options['woocommerce_single_hide_title'])){ $woo_single_hide_title = $options['woocommerce_single_hide_title']; if ($woo_single_hide_title == "yes") { echo "selected='selected'"; } } ?> value="yes"><?php esc_html_e( 'Yes', 'soho-core' ); ?></option>
									</select>
								</div>
							</td>
						</tr>
						<tr valign="middle">
							<td scope="row" width="170"><?php esc_html_e('Single Product Content Top Padding (px)', 'soho-core'); ?></td>
							<td>
								<div class="inline">
									<input name="qode_options_theme18[woocommerce_single_content_top_padding]" type="text" value="<?php if(isset($options['woocommerce_single_content_top_padding'])) { if ($options['woocommerce_single_content_top_padding']) { echo esc_attr($options['woocommerce_single_content_top_padding']); } } ?>" />
								</div>
							</td>
						</tr>
						</tbody>
					</table>
					<?php		display_save_changes_button(); ?>
				</div>
			<?php } ?>
		</div>
	<?php	}
}

function display_save_changes_button() {
	echo ('
		    <table class="form-table">
			<tbody>
			    <tr valign="middle">
				<th scope="row" width="150">&nbsp;</th>
				<td>
				    <div class="submit" style="padding:10px 0 0 80px; float:right; clear:both;">
					<input type="hidden" id="qode_submit" value="1" name="qode_submit"/>
					<input class="button-primary" type="submit" name="submit" value="'.esc_attr__('Save Changes', 'soho-core').'" />
				    </div>
				</td>
			    </tr>
			</tbody>
		    </table>');
}

$my_Qode_Theme_Options = new Qode_Theme_Options();


//set default values if they are not initialized - start//
if(!isset( $qode_options_soho['popup_menu_google_fonts'])){
	$qode_options_soho['popup_menu_google_fonts'] = '-1';
}

if(!isset( $qode_options_soho['popup_menu_google_fonts_2nd'])){
	$qode_options_soho['popup_menu_google_fonts_2nd'] = '-1';
}

//set default values if they are not initialized - end//

if(isset($qode_toolbar)):
	if(!session_id()) {
		session_start();
	}
	if (isset($_SESSION['qode_theme18_header_type'])) {
		if ($_SESSION['qode_theme18_header_type'] == "big") {
			$qode_options_soho["header_bottom_appearance"] = "stick menu_bottom";
		}
	}
	if (isset($_SESSION['qode_theme18_page_transitions'])) {
		$qode_options_soho["page_transitions"] = $_SESSION['qode_theme18_page_transitions'];
	}
endif;