<?php

/* Create Portfolio, Testimonial, Slider and Carousel post type */
if (!function_exists('soho_core_create_post_type')) {
    function soho_core_create_post_type() {
        global $qode_options_soho;
        $slug = 'portfolio_page';
        if (isset($qode_options_soho['portfolio_single_slug'])) {
            if ($qode_options_soho['portfolio_single_slug'] != "") {
                $slug = $qode_options_soho['portfolio_single_slug'];
            }
        }
        register_post_type('portfolio_page',
            array(
                'labels' => array(
                    'name' => esc_html__('Portfolio', 'soho-core'),
                    'singular_name' => esc_html__('Portfolio Item', 'soho-core'),
                    'add_item' => esc_html__('New Portfolio Item', 'soho-core'),
                    'add_new_item' => esc_html__('Add New Portfolio Item', 'soho-core'),
                    'edit_item' => esc_html__('Edit Portfolio Item', 'soho-core')
                ),
                'public' => true,
                'has_archive' => true,
                'rewrite' => array('slug' => $slug),
                'menu_position' => 4,
                'show_ui' => true,
                'supports' => array('author', 'title', 'editor', 'thumbnail', 'excerpt', 'page-attributes')
            )
        );
        register_post_type('testimonials',
            array(
                'labels' => array(
                    'name' => esc_html__('Testimonials', 'soho-core'),
                    'singular_name' => esc_html__('Testimonial', 'soho-core'),
                    'add_item' => esc_html__('New Testimonial', 'soho-core'),
                    'add_new_item' => esc_html__('Add New Testimonial', 'soho-core'),
                    'edit_item' => esc_html__('Edit Testimonial', 'soho-core')
                ),
                'public' => false,
                'show_in_menu' => true,
                'rewrite' => array('slug' => 'testimonials'),
                'menu_position' => 4,
                'show_ui' => true,
                'has_archive' => false,
                'exclude_from_search' => true,
                'hierarchical' => false,
                'supports' => array('title', 'thumbnail')
            )
        );

        register_post_type('slides',
            array(
                'labels' => array(
                    'name' => esc_html__('Select Slider', 'soho-core'),
                    'menu_name' => esc_html__('Select Slider', 'soho-core'),
                    'all_items' => esc_html__('Slides', 'soho-core'),
                    'add_new' => esc_html__('Add New Slide', 'soho-core'),
                    'singular_name' => esc_html__('Slide', 'soho-core'),
                    'add_item' => esc_html__('New Slide', 'soho-core'),
                    'add_new_item' => esc_html__('Add New Slide', 'soho-core'),
                    'edit_item' => esc_html__('Edit Slide', 'soho-core')
                ),
                'public' => false,
                'show_in_menu' => true,
                'rewrite' => array('slug' => 'slides'),
                'menu_position' => 4,
                'show_ui' => true,
                'has_archive' => false,
                'exclude_from_search' => true,
                'hierarchical' => false,
                'supports' => array('title', 'thumbnail', 'page-attributes'),
                'menu_icon' => SOHO_QODE_ROOT . '/img/favicon.ico'
            )
        );

        register_post_type('carousels',
            array(
                'labels' => array(
                    'name' => esc_html__('Select Carousel', 'soho-core'),
                    'menu_name' => esc_html__('Select Carousel', 'soho-core'),
                    'all_items' => esc_html__('Carousel Items', 'soho-core'),
                    'add_new' => esc_html__('Add New Carousel Item', 'soho-core'),
                    'singular_name' => esc_html__('Carousel Item', 'soho-core'),
                    'add_item' => esc_html__('New Carousel Item', 'soho-core'),
                    'add_new_item' => esc_html__('Add New Carousel Item', 'soho-core'),
                    'edit_item' => esc_html__('Edit Carousel Item', 'soho-core')
                ),
                'public' => false,
                'show_in_menu' => true,
                'rewrite' => array('slug' => 'carousels'),
                'menu_position' => 4,
                'show_ui' => true,
                'has_archive' => false,
                'exclude_from_search' => true,
                'hierarchical' => false,
                'supports' => array('title'),
                'menu_icon' => SOHO_QODE_ROOT . '/img/favicon.ico'
            )
        );

        /* Create Portfolio Categories */

        $labels = array(
            'name' => esc_html__('Portfolio Categories', 'soho-core'),
            'singular_name' => esc_html__('Portfolio Category', 'soho-core'),
            'search_items' => esc_html__('Search Portfolio Categories', 'soho-core'),
            'all_items' => esc_html__('All Portfolio Categories', 'soho-core'),
            'parent_item' => esc_html__('Parent Portfolio Category', 'soho-core'),
            'parent_item_colon' => esc_html__('Parent Portfolio Category:', 'soho-core'),
            'edit_item' => esc_html__('Edit Portfolio Category', 'soho-core'),
            'update_item' => esc_html__('Update Portfolio Category', 'soho-core'),
            'add_new_item' => esc_html__('Add New Portfolio Category', 'soho-core'),
            'new_item_name' => esc_html__('New Portfolio Category Name', 'soho-core'),
            'menu_name' => esc_html__('Portfolio Categories', 'soho-core'),
        );

        register_taxonomy('portfolio_category', array('portfolio_page'), array(
            'hierarchical' => true,
            'labels' => $labels,
            'show_ui' => true,
            'query_var' => true,
            'rewrite' => array('slug' => 'portfolio-category'),
        ));


        /* Create Testimonials Category */

        $labels = array(
            'name' => esc_html__('Testimonials Categories', 'soho-core'),
            'singular_name' => esc_html__('Testimonial Category', 'soho-core'),
            'search_items' => esc_html__('Search Testimonials Categories', 'soho-core'),
            'all_items' => esc_html__('All Testimonials Categories', 'soho-core'),
            'parent_item' => esc_html__('Parent Testimonial Category', 'soho-core'),
            'parent_item_colon' => esc_html__('Parent Testimonial Category:', 'soho-core'),
            'edit_item' => esc_html__('Edit Testimonials Category', 'soho-core'),
            'update_item' => esc_html__('Update Testimonials Category', 'soho-core'),
            'add_new_item' => esc_html__('Add New Testimonials Category', 'soho-core'),
            'new_item_name' => esc_html__('New Testimonials Category Name', 'soho-core'),
            'menu_name' => esc_html__('Testimonials Categories', 'soho-core'),
        );

        register_taxonomy('testimonials_category', array('testimonials'), array(
            'hierarchical' => true,
            'labels' => $labels,
            'show_ui' => true,
            'query_var' => true,
            'show_admin_column' => true,
            'rewrite' => array('slug' => 'testimonials-category'),
        ));


        /* Create Slider Category */

        $labels = array(
            'name' => esc_html__('Sliders', 'soho-core'),
            'singular_name' => esc_html__('Slider', 'soho-core'),
            'search_items' => esc_html__('Search Sliders', 'soho-core'),
            'all_items' => esc_html__('All Sliders', 'soho-core'),
            'parent_item' => esc_html__('Parent Slider', 'soho-core'),
            'parent_item_colon' => esc_html__('Parent Slider:', 'soho-core'),
            'edit_item' => esc_html__('Edit Slider', 'soho-core'),
            'update_item' => esc_html__('Update Slider', 'soho-core'),
            'add_new_item' => esc_html__('Add New Slider', 'soho-core'),
            'new_item_name' => esc_html__('New Slider Name', 'soho-core'),
            'menu_name' => esc_html__('Sliders', 'soho-core'),
        );

        register_taxonomy('slides_category', array('slides'), array(
            'hierarchical' => true,
            'labels' => $labels,
            'show_ui' => true,
            'query_var' => true,
            'show_admin_column' => true,
            'rewrite' => array('slug' => 'slides-category'),
        ));

        /* Create Carousel Category */

        $labels = array(
            'name' => esc_html__('Carousels', 'soho-core'),
            'singular_name' => esc_html__('Carousel', 'soho-core'),
            'search_items' => esc_html__('Search Carousels', 'soho-core'),
            'all_items' => esc_html__('All Carousels', 'soho-core'),
            'parent_item' => esc_html__('Parent Carousel', 'soho-core'),
            'parent_item_colon' => esc_html__('Parent Carousel:', 'soho-core'),
            'edit_item' => esc_html__('Edit Carousel', 'soho-core'),
            'update_item' => esc_html__('Update Carousel', 'soho-core'),
            'add_new_item' => esc_html__('Add New Carousel', 'soho-core'),
            'new_item_name' => esc_html__('New Carousel Name', 'soho-core'),
            'menu_name' => esc_html__('Carousels', 'soho-core'),
        );

        register_taxonomy('carousels_category', array('carousels'), array(
            'hierarchical' => true,
            'labels' => $labels,
            'show_ui' => true,
            'query_var' => true,
            'show_admin_column' => true,
            'rewrite' => array('slug' => 'carousels-category'),
        ));

    }

    add_action('init', 'soho_core_create_post_type', 0);
}