<?php

get_header();

$soho_qode_options = soho_qode_return_global_options();

if($soho_qode_options['enable_google_map'] == "yes"){
	$container_class= " full_map";
} else {
	$container_class= "";
}

?>

<?php if (have_posts()) : while (have_posts()) : the_post(); ?>


	<?php get_template_part( 'title' ); ?>
	<?php if($soho_qode_options['enable_google_map'] == "yes"){ ?>
		<div class="q_google_map_holder">
			<?php
			$google_maps_scroll_wheel = false;
			if(isset($soho_qode_options['google_maps_scroll_wheel'])){
				if ($soho_qode_options['google_maps_scroll_wheel'] == "yes")
					$google_maps_scroll_wheel = true;
			}
			if(!$google_maps_scroll_wheel){
				?>
				<div class="q_google_map_ovrlay"></div>
			<?php } ?>
			<div class="q_google_map" id="map_canvas"></div>
		</div>
	<?php } ?>
	<div class="container">
		<div class="container_inner<?php echo esc_attr( $container_class ); ?> clearfix">
			<div class="contact_detail">

				<?php the_content(); ?>

				<?php if($soho_qode_options['enable_contact_form'] == "yes"){ ?>
					<div class="contact_form">

						<h5><?php if($soho_qode_options['contact_heading_above'] != "") { echo soho_qode_get_module_part( $soho_qode_options['contact_heading_above'] );  } else { ?><?php esc_html_e('Contact Us', 'soho'); ?><?php } ?></h5>

						<form id="contact-form" method="post" action="">

							<div class="three_columns clearfix">
								<div class="column1">
									<div class="column_inner">
										<input type="text" class="requiredField" name="fname" id="fname" value="" placeholder="<?php esc_html_e('First Name *', 'soho'); ?>" />
									</div>
								</div>
								<div class="column2">
									<div class="column_inner">
										<input type="text" class="requiredField" name="lname" id="lname" value="" placeholder="<?php esc_html_e('Last Name *', 'soho'); ?>" />
									</div>
								</div>
								<div class="column3">
									<div class="column_inner">
										<input type="text" class="requiredField email" name="email" id="email" value="" placeholder="<?php esc_html_e('Email *', 'soho'); ?>" />
									</div>
								</div>
							</div>

							<textarea name="message" id="message" rows="10" placeholder="<?php esc_html_e('Write Your Message Here', 'soho'); ?>"></textarea>

							<?php
							if($soho_qode_options['use_recaptcha'] == "yes" && soho_qode_is_core_installed() ) :
								require_once( SOHO_CORE_MODULES_URL_PATH .  '/recaptchalib.php');
								if($soho_qode_options['recaptcha_public_key']) {
									$publickey = $soho_qode_options['recaptcha_public_key'];
								} else {
									$publickey = "6Ld5VOASAAAAABUGCt9ZaNuw3IF-BjUFLujP6C8L";
								}
								if($soho_qode_options['recaptcha_private_key']) {
									$privatekey = $soho_qode_options['recaptcha_private_key'];
								} else {
									$privatekey = "6Ld5VOASAAAAAKQdKVcxZ321VM6lkhBsoT6lXe9Z";
								}

							if($soho_qode_options['page_transitions'] != ""){ ?>
								<script type="text/javascript">
									var RecaptchaOptions = {theme: 'clean'};
									Recaptcha.create("<?php echo soho_qode_get_module_part( $publickey ); ?>","captchaHolder",{theme: "clean",callback: Recaptcha.focus_response_field});
								</script>
							<?php } ?>
								<p id="captchaHolder"><?php echo recaptcha_get_html($publickey); ?></p>
								<p id="captchaStatus">&nbsp;</p>
							<?php endif; ?>

							<span class="submit_button_contact">
									<input class="qbutton medium qode-contact-page-button" type="submit" value="<?php esc_html_e('SEND MESSAGE', 'soho'); ?>" />
								</span>
						</form>
					</div>
				<?php } ?>
			</div>
		</div>
	</div>

<?php endwhile; ?>
<?php endif; ?>
<script type="text/javascript">
	jQuery(document).ready(function($){
		$j('form#contact-form').submit(function(){
			$j('form#contact-form .contact-error').remove();
			var hasError = false;
			$j('form#contact-form .requiredField').each(function() {
				if(jQuery.trim($j(this).val()) == '' || jQuery.trim($j(this).val()) == jQuery.trim($j(this).attr('placeholder'))){
					$j(this).parent().append('<strong class="contact-error"><?php esc_html_e('This is a required field', 'soho'); ?></strong>');
					$j(this).addClass('inputError');
					hasError = true;
				} else { //else 1
					if($j(this).hasClass('email')) { //if hasClass('email')
						var emailReg = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;
						if(!emailReg.test(jQuery.trim($j(this).val()))){
							$j(this).parent().append('<strong class="contact-error"><?php esc_html_e('Please enter a valid email address.', 'soho'); ?></strong>');
							$j(this).addClass('inputError');
							hasError = true;
						}
					} //end of if hasClass('email')

				} // end of else 1
			}); //end of each()

			if(!hasError){
				var challengeField = $j("input#recaptcha_challenge_field").val();
				var responseField = $j("input#recaptcha_response_field").val();
				var name =  $j("input#fname").val();
				var lastname =  $j("input#lname").val();
				var email =  $j("input#email").val();
				var message =  $j("textarea#message").val();

				var html = $j.ajax({
					type: "POST",
					url: "<?php echo SOHO_CORE_MODULES_URL_PATH ?>/ajax_mail.php",
					data: "recaptcha_challenge_field=" + challengeField + "&recaptcha_response_field=" + responseField + "&name=" + name + "&lastname=" + lastname + "&email=" + email + "&message=" + message,
					async: false
				}).responseText;

				if(html === "success"){
					var formInput = $j(this).serialize();

					$j("form#contact-form").before('<div class="contact-success"><strong><?php esc_html_e('THANK YOU!', 'soho'); ?></strong><p><?php esc_html_e('Your email was successfully sent. We will contact you as soon as possible.', 'soho'); ?></p></div>');
					$j("form#contact-form").hide();
					$j.post($j(this).attr('action'),formInput);
					hasError = false;
					return false;
				} else {
					<?php
					if ($soho_qode_options['use_recaptcha'] == "yes"){
					?>
					$j("#recaptcha_response_field").parent().append('<span class="contact-error extra-padding"><?php esc_html_e('Invalid Captcha', 'soho'); ?></span>');
					Recaptcha.reload();
					<?php
					} else {
					?>
					$j("form#contact-form").before('<div class="contact-success"><strong><?php esc_html_e("Email server problem", 'soho'); ?></strong></p></div>');
					<?php
					}
					?>
					return false;
				}
			}
			return false;
		});
	});
</script>

<?php get_footer(); ?>