<?php

if ( ! function_exists( 'soho_core_is_installed' ) ) {
	/**
	 * Function that checks if forward module installed
	 *
	 * @param $name string - module name
	 *
	 * @return bool
	 */
	function soho_core_is_installed( $name ) {
		
		switch ( $name ) {
			case 'theme';
				return defined( 'SOHO_QODE' );
				break;
			case 'woocommerce';
				return function_exists( 'is_woocommerce' );
				break;
			case 'gutenberg-editor';
				return function_exists( 'register_block_type' );
				break;
			default:
				return false;
		}
	}
}


if (!function_exists('soho_core_get_carousel_slider_array')){
    function soho_core_get_carousel_slider_array() {
        $carousel_output = array("" => "");
        $terms = get_terms('carousels_category' );

        if(is_array($terms) && count($terms) > 0){
            foreach ( $terms as $term ):
                $carousel_output[$term->name] = $term->slug;
            endforeach;
        }

        return $carousel_output;
    }

    add_action('init', 'soho_core_get_carousel_slider_array', 0);
}