<?php

// Adds theme support for woocommerce
add_theme_support('woocommerce');

//Disable the default WooCommerce stylesheet.
add_filter( 'woocommerce_enqueue_styles', '__return_false' );

if(!function_exists('soho_qode_woo_related_products_args')) {
    /**
     * Function that sets number of displayed related products. Hooks to woocommerce_output_related_products_args filter
     * @param $args array array of args for the query
     * @return mixed array of changed args
     */
    function soho_qode_woo_related_products_args( $args ) {
        $args['posts_per_page'] = 4;
        return $args;
    }

    add_filter( 'woocommerce_output_related_products_args', 'soho_qode_woo_related_products_args' );
}

// Redefine woocommerce_output_upsell_products()
if(!function_exists('soho_qode_woo_product_per_page')) {
    /**
     * Function that sets number of products per page. Default is 12
     * @return int number of products to be shown per page
     */
    function soho_qode_woo_product_per_page() {
        global $qode_options;

        $products_per_page = 12;
        if(isset($qode_options['woo_products_per_page']) && $qode_options['woo_products_per_page']) {
            $products_per_page = $qode_options['woo_products_per_page'];
        }

        return $products_per_page;
    }

    add_filter('loop_shop_per_page', 'soho_qode_woo_product_per_page', 20);
}

// Define number of products per page.
if(!function_exists('soho_qode_woo_product_per_page')) {
    /**
     * Function that sets number of products per page. Default is 12
     * @return int number of products to be shown per page
     */
    function soho_qode_woo_product_per_page() {
        global $qode_options;

        $products_per_page = 12;
        if(isset($qode_options['woo_products_per_page']) && $qode_options['woo_products_per_page']) {
            $products_per_page = $qode_options['woo_products_per_page'];
        }

        return $products_per_page;
    }

    add_filter('loop_shop_per_page', 'soho_qode_woo_product_per_page', 20);
}

// Hook in
add_filter('woocommerce_checkout_fields', 'soho_qode_custom_override_checkout_fields');

/**
 * Remove add to cart function from woocommerce_after_shop_loop_item_title hook
 * and hook it in woocommerce_before_shop_loop_item_title
 */

remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );
add_action('woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_add_to_cart', 10);

/**
 * Overrides placeholder values for checkout fields
 * @param array all checkout fields
 * @return array checkout fields with overriden values
 */
function soho_qode_custom_override_checkout_fields($fields) {
    //billing fields
    $args_billing = array(
        'first_name' => esc_html__('First name','soho'),
        'last_name'  => esc_html__('Last name','soho'),
        'company'    => esc_html__('Company name','soho'),
        'address_1'  => esc_html__('Address','soho'),
        'email'      => esc_html__('Email','soho'),
        'phone'      => esc_html__('Phone','soho'),
        'postcode'   => esc_html__('Postcode / ZIP','soho'),
        'city'   => esc_html__('City','soho'),
        'state'   => esc_html__('State','soho')
    );
    
    //shipping fields
    $args_shipping = array(
        'first_name' => esc_html__('First name','soho'),
        'last_name'  => esc_html__('Last name','soho'),
        'company'    => esc_html__('Company name','soho'),
        'address_1'  => esc_html__('Address','soho'),
        'postcode'   => esc_html__('Postcode / ZIP','soho'),
        'city'   => esc_html__('City','soho')
    );
    
    //override billing placeholder values
    foreach ($args_billing as $key => $value) {
        $fields["billing"]["billing_{$key}"]["placeholder"] = $value;
    }
    
    //override shipping placeholder values
    foreach ($args_shipping as $key => $value) {
        $fields["shipping"]["shipping_{$key}"]["placeholder"] = $value;
    }

    return $fields;
}

if (!function_exists('soho_qode_woocommerce_content')){

    /**
     * Output WooCommerce content.
     *
     * This function is only used in the optional 'woocommerce.php' template
     * which people can add to their themes to add basic woocommerce support
     * without hooks or modifying core templates.
     *
     * @access public
     * @return void
     */
    function soho_qode_woocommerce_content() {

        if ( is_singular( 'product' ) ) {

            while ( have_posts() ) : the_post();

                wc_get_template_part( 'content', 'single-product' );

            endwhile;

        } else {

            ?>

            <?php do_action( 'woocommerce_archive_description' ); ?>

            <?php if ( have_posts() ) : ?>

                <?php do_action('woocommerce_before_shop_loop'); ?>

                <?php woocommerce_product_loop_start(); ?>

                    <?php woocommerce_product_subcategories(); ?>

                    <?php while ( have_posts() ) : the_post(); ?>

                        <?php wc_get_template_part( 'content', 'product' ); ?>

                    <?php endwhile; // end of the loop. ?>

                <?php woocommerce_product_loop_end(); ?>

                <?php do_action('woocommerce_after_shop_loop'); ?>

            <?php elseif ( ! woocommerce_product_subcategories( array( 'before' => woocommerce_product_loop_start( false ), 'after' => woocommerce_product_loop_end( false ) ) ) ) : ?>

                <?php wc_get_template( 'loop/no-products-found.php' ); ?>

            <?php endif;

        }
    }
}
if ( ! function_exists('soho_qode_woocommerce_output_product_data_tabs_after') ) {

	/**
	 * Output the product tabs.
	 *
	 * @access public
	 * @subpackage	Product/Tabs
	 * @return void
	 */
	function soho_qode_woocommerce_output_product_data_tabs_after() {
            echo '</div>';
	}

	add_action('woocommerce_after_single_product_summary', 'soho_qode_woocommerce_output_product_data_tabs_after', 15);
}


if(!function_exists('soho_qode_woocommerce_change_actions_priorities')) {
    /**
     * Function that changes woocommerce actions priorities.
     * Used in product listing to put product rating bellow product price
     */
    function soho_qode_woocommerce_change_actions_priorities() {
        $actions = array(
            array(
                'tag' => 'woocommerce_after_shop_loop_item_title',
                'action' => 'woocommerce_template_loop_price',
                'priority' => 10,
                'priority_to_set' => 10
            ),
            array(
                'tag' => 'woocommerce_after_shop_loop_item_title',
                'action' => 'woocommerce_template_loop_rating',
                'priority' => 5,
                'priority_to_set' => 11
            )
        );
        
        foreach($actions as $action) {
            //actions which priorities needs to be changed
            remove_action($action['tag'], $action['action'], $action['priority']);
            
            //new priorities
            add_action($action['tag'], $action['action'], $action['priority_to_set']);
        }
    }
    
    add_action('woocommerce_change_priorities', 'soho_qode_woocommerce_change_actions_priorities');
    do_action('woocommerce_change_priorities');
}

if(!function_exists('soho_qode_woocommerce_share')) {
    function soho_qode_woocommerce_share() { ?>
    <div class="share_title"><?php esc_html_e('Share on: ','soho'); ?></div>
        <?php
        if( soho_qode_is_core_installed() ) {
            echo do_shortcode('[social_share_simple]');
        }
    }

    add_action('woocommerce_product_meta_end', 'soho_qode_woocommerce_share');
}

/*Removing double link around product image*/
remove_action('woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10);

if ( ! function_exists( 'soho_qode_woocommerce_product_thumbnail_column_size' ) ) {
    /**
     * Function that sets number of thumbnails on single product page per row. Default is 4
     * @return int number of thumbnails to be shown on single product page per row
     */
    function soho_qode_woocommerce_product_thumbnail_column_size() {
        return apply_filters( 'number_of_thumbnails_per_row_single_product', 3 );
    }

    add_filter( 'woocommerce_product_thumbnails_columns', 'soho_qode_woocommerce_product_thumbnail_column_size', 10 );
}

if ( ! function_exists( 'soho_qode_set_number_of_columns_woo_product_list' ) ) {
    function soho_qode_set_number_of_columns_woo_product_list() {
        global $woocommerce_loop;

        $woocommerce_loop['columns'] = 3;
    }
}