<?php
$output = $title = $icon = $icon_color = $title_color = $background_color = $el_id = '';

extract(shortcode_atts(array(
	'title'            => esc_html__("Accordion Title", "soho"),
	'icon_pack'        => "",
	'fa_icon'          => "",
	'fe_icon'          => "",
	'icon_color'       => "",
	'title_color'      => "",
	'border_color'     => "",
    'background_color' => "",
    'title_tag'        => "h5",
	'el_id' => ''
), $atts));


$css_class = apply_filters(VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, 'wpb_accordion_section group', $this->settings['base']);
	$heading_styles = '';
	
	if($title_color != "") {
        $heading_styles .= "color: ".$title_color.";";
    }

    if($border_color != "") {
        $heading_styles .= " border-color: ".$border_color.";";
    }

    if($background_color != "") {
        $heading_styles .= " background-color: ".$background_color.";";
    }

	if($title_tag == ""){
		$title_tag = 'h5';
	}

    $output .= "\n\t\t\t\t" . '<'.$title_tag.' class="clearfix title-holder" style="'.$heading_styles.'">';
    $no_icon    = '';
    $icon_style = '';

    if($icon_pack == "") {
    	$no_icon = 'no_icon';
    }
	if($icon_pack != "") {

		if($icon_color != ""){
			$icon_style .= "color: ".$icon_color.";";
		}

        if($icon_pack == 'font_awesome' && $fa_icon != ''){
            $output .= '<span class="icon-wrapper">';
            $output .= '<i class="fa ' . $fa_icon . '" style="'.$icon_style.'"></i>';
            $output .= '</span>';
            }
        elseif($icon_pack == 'font_elegant' && $fe_icon != ''){
            $output .= '<span class="icon-wrapper">';
            $output .= '<span class="q_font_elegant_icon '.$fe_icon.'" aria-hidden="true" style="'.$icon_style.'"></span>';
            $output .= '</span>';
        }
	}
	$output .= '<span class="tab-title">'.$title.'</span>';

	$output .= '</'.$title_tag.'>';
    $output .= "\n\t\t\t\t" . '<div ' . ( isset( $el_id ) && ! empty( $el_id ) ? "id='" . esc_attr( $el_id ) . "'" : "" ) . ' class="accordion_content '.$no_icon.'">';
		$output .= "\n\t\t\t" . '<div class="accordion_content_inner">';
			$output .= ($content=='' || $content==' ') ? esc_html__("Empty section. Edit page to add content here.", "soho") : "\n\t\t\t\t" . wpb_js_remove_wpautop($content);
			$output .= "\n\t\t\t" . '</div>';
		 $output .= "\n\t\t\t\t" . '</div>' . $this->endBlockComment('.wpb_accordion_section') . "\n";

echo soho_qode_get_module_part( $output );