<?php
$soho_qode_options = soho_qode_return_global_options();
/* Set id on -1 beacause archive page id can have same id as some post and settings is not good */
$soho_qode_id = soho_qode_get_page_id();

if(get_post_meta($soho_qode_id, "qode_responsive-title-image", true) != ""){
    $soho_qode_responsive_title_image = get_post_meta($soho_qode_id, "qode_responsive-title-image", true);
}else{
    $soho_qode_responsive_title_image = $soho_qode_options['responsive_title_image'];
}

if(get_post_meta($soho_qode_id, "qode_fixed-title-image", true) != ""){
    $soho_qode_fixed_title_image = get_post_meta($soho_qode_id, "qode_fixed-title-image", true);
}else{
    $soho_qode_fixed_title_image = $soho_qode_options['fixed_title_image'];
}

if(get_post_meta($soho_qode_id, "qode_title-image", true) != ""){
    $soho_qode_title_image = get_post_meta($soho_qode_id, "qode_title-image", true);
}else{
    $soho_qode_title_image = $soho_qode_options['title_image'];
}
$soho_qode_title_image_height = "";
$soho_qode_title_image_width = "";
if(!empty($soho_qode_title_image)){

    $soho_qode_image_dimension = soho_qode_get_image_dimensions( $soho_qode_title_image );

    if ( ! empty( $soho_qode_image_dimension ) ) {
        $soho_qode_title_image_height  = intval( $soho_qode_image_dimension['height'] );
        $soho_qode_title_image_width = intval( $soho_qode_image_dimension['width'] );
    }

}

if(get_post_meta($soho_qode_id, "qode_title-overlay-image", true) != ""){
    $soho_qode_title_overlay_image = get_post_meta($soho_qode_id, "qode_title-overlay-image", true);
}else{
    $soho_qode_title_overlay_image = $soho_qode_options['title_overlay_image'];
}

$soho_qode_header_height_padding = 0;
if (!empty($soho_qode_options['header_height'])) {
    $soho_qode_header_height = intval( $soho_qode_options['header_height'] );
} else {
    $soho_qode_header_height = 110;
}
if (isset($soho_qode_options['header_bottom_border_color']) && !empty($soho_qode_options['header_bottom_border_color'])) {
    $soho_qode_header_height = $soho_qode_header_height + 1;
}
if($soho_qode_options['header_bottom_appearance'] == 'stick menu_bottom'){
    $soho_qode_menu_bottom = '46';
    if(is_active_sidebar('header_fixed_right')){
        $soho_qode_menu_bottom = $soho_qode_menu_bottom + 22;
    }
} else {
    $soho_qode_menu_bottom = 0;
}
$soho_qode_nav_font_size = 7;
if(isset($soho_qode_options['menu_fontsize']) && $soho_qode_options['menu_fontsize'] != ""){
    $soho_qode_nav_font_size = $soho_qode_options['menu_fontsize'] / 2;
}
$soho_qode_header_top = 0;
if (isset($_SESSION['qode_theme18_header_top']) && $_SESSION['qode_theme18_header_top'] == 'yes') {
    $soho_qode_header_top = 36;
}elseif(isset($soho_qode_options['header_top_area']) && $soho_qode_options['header_top_area'] == "yes"){
    $soho_qode_header_top = 36;
}
$soho_qode_header_height_padding = $soho_qode_header_height + $soho_qode_menu_bottom + $soho_qode_header_top;
if (isset($soho_qode_options['center_logo_image']) && $soho_qode_options['center_logo_image'] == "yes") {
    if(isset($soho_qode_options['logo_image'])){
        $soho_qode_logo_width = 0;
        $soho_qode_logo_height = 0;
        if (!empty($soho_qode_options['logo_image'])) {
            $logo_image_dimension = soho_qode_get_image_dimensions( $soho_qode_options['logo_image'] );
            if ( ! empty( $logo_image_dimension ) ) {
                $soho_qode_logo_height = intval($logo_image_dimension['height']);
                $soho_qode_logo_width = intval($logo_image_dimension['width']);
            }
        }
    }
    if($soho_qode_options['header_bottom_appearance'] == 'stick menu_bottom'){
        $soho_qode_header_height_padding = $soho_qode_logo_height + 30 + $soho_qode_menu_bottom + $soho_qode_header_top; // 30 is top and bottom margin of centered logo
    } else {
        $soho_qode_header_height_padding = $soho_qode_logo_height + 30 + $soho_qode_header_height + $soho_qode_header_top; // 30 is top and bottom margin of centered logo
    }
}

$soho_qode_title_type = "standard_title";
if(get_post_meta($soho_qode_id, "qode_page_title_type", true) != ""){
    $soho_qode_title_type = get_post_meta($soho_qode_id, "qode_page_title_type", true);
}else if(is_404()){
    $soho_qode_title_type = "breadcrumbs_title";
}else{
    $soho_qode_title_type = $soho_qode_options['title_type'];
}

$soho_qode_title_image_class = "";
if(get_post_meta($soho_qode_id, "qode_title-image-pattern", true) != ""){
    $soho_qode_title_image_class = " use_pattern_image";
}else if($soho_qode_options['title_image_pattern'] == "yes"){
    $soho_qode_title_image_class = " use_pattern_image";
}

$soho_qode_title_height = 430; // default title height without header height
if($soho_qode_title_type == "breadcrumbs_title") {
    $soho_qode_title_height = 102;
}

if(get_post_meta($soho_qode_id, "qode_title-height", true) != ""){
    $soho_qode_title_height = intval( get_post_meta($soho_qode_id, "qode_title-height", true) );
}else if($soho_qode_options['title_height'] != ''){
    $soho_qode_title_height = intval( $soho_qode_options['title_height'] );
}else {
    if (isset($soho_qode_options['center_logo_image']) && $soho_qode_options['center_logo_image'] == "yes") {
        if($soho_qode_options['header_bottom_appearance'] == 'stick menu_bottom'){
            $soho_qode_title_height = $soho_qode_title_height + $soho_qode_logo_height + 30 + $soho_qode_menu_bottom + $soho_qode_header_top; // 30 is top and bottom margin of centered logo
        } else {
            $soho_qode_title_height = $soho_qode_header_height + $soho_qode_title_height + $soho_qode_logo_height + 30 + $soho_qode_header_top; // 30 is top and bottom margin of centered logo
        }
    } else {
        $soho_qode_title_height = $soho_qode_title_height + $soho_qode_header_height + $soho_qode_menu_bottom + $soho_qode_header_top;
    }
}
if(get_post_meta($soho_qode_id, "qode_fixed-title-image", true) != ""){
    $soho_qode_fixed_title_image = get_post_meta($soho_qode_id, "qode_fixed-title-image", true);
}else{
    $soho_qode_fixed_title_image = $soho_qode_options['fixed_title_image'];
}

$soho_qode_title_background_color = '';
if(get_post_meta($soho_qode_id, "qode_page-title-background-color", true) != ""){
    $soho_qode_title_background_color = get_post_meta($soho_qode_id, "qode_page-title-background-color", true);
}else{
    $soho_qode_title_background_color = $soho_qode_options['title_background_color'];
}

$soho_qode_show_title_image = true;
if(get_post_meta($soho_qode_id, "qode_show-page-title-image", true)) {
    $soho_qode_show_title_image = false;
}
$soho_qode_page_title_style = "standard";
if(get_post_meta($soho_qode_id, "qode_page_title_style", true) != ""){
    $soho_qode_page_title_style = get_post_meta($soho_qode_id, "qode_page_title_style", true);
}else{
    if(isset($soho_qode_options['title_style'])) {
        $soho_qode_page_title_style = $soho_qode_options['title_style'];
    } else {
        $soho_qode_page_title_style = "standard";
    }
}

$soho_qode_animate_title_area = '';
if(get_post_meta($soho_qode_id, "qode_animate-page-title", true) != ""){
    $soho_qode_animate_title_area = get_post_meta($soho_qode_id, "qode_animate-page-title", true);
}else{
    $soho_qode_animate_title_area = $soho_qode_options['animate_title_area'];
}

if($soho_qode_animate_title_area == "text_right_left") {
    $animate_title_class = "animate_title_text";
}elseif($soho_qode_animate_title_area == "fade_in_title_text"){
    $animate_title_class = "fade_in_title_text";
}elseif($soho_qode_animate_title_area == "area_top_bottom"){
    $animate_title_class = "animate_title_area";
} elseif($soho_qode_animate_title_area == "area_top_bottom_with_title_fade_in"){
    $animate_title_class = "animate_title_area with_fade_in_text";
}else {
    $animate_title_class = "title_without_animation";
}

//init variables
$soho_qode_title_subtitle_padding 	= '';
$soho_qode_header_transparency 		= '';
$soho_qode_is_header_transparent  	= false;
$soho_qode_transparent_values_array 	= array('0.00', '0');
$soho_qode_solid_values_array			= array('', '1');
$soho_qode_header_bottom_border		= '';

//is header transparent not set on current page?
if(get_post_meta($soho_qode_id, "qode_header_color_transparency_per_page", true) === "") {
    //take global value set in Qode Options
    $soho_qode_header_transparency = $soho_qode_options['header_background_transparency_initial'];
} else {
    //take value set for current page
    $soho_qode_header_transparency = get_post_meta($soho_qode_id, "qode_header_color_transparency_per_page", true);
}

//is border bottom color for header set in Qode Options?
if(isset($soho_qode_options['header_bottom_border_color']) && !empty($soho_qode_options['header_bottom_border_color'])) {
    $soho_qode_header_bottom_border = $soho_qode_options['header_bottom_border_color'];
}

//is header completely transparent?
$soho_qode_is_header_transparent 	= in_array($soho_qode_header_transparency, $soho_qode_transparent_values_array);

//is header solid?
$soho_qode_is_header_solid		= in_array($soho_qode_header_transparency, $soho_qode_solid_values_array);

//is header solid?
if($soho_qode_is_header_solid) {
    $soho_qode_title_holder_height = 'style="padding-top:' . $soho_qode_header_height_padding . 'px; height:' . ($soho_qode_title_height - $soho_qode_header_height_padding) . 'px;"';
    $soho_qode_title_subtitle_padding = 'style="padding-top:' . $soho_qode_header_height_padding . 'px;"';
} else {

    //is border for header bottom set?
    if ($soho_qode_header_bottom_border != '') {

        //center title between header and end of title section
        $soho_qode_title_holder_height = 'style="padding-top:' . $soho_qode_header_height_padding . 'px; height:' . ($soho_qode_title_height - $soho_qode_header_height_padding) . 'px;"';
        $soho_qode_title_subtitle_padding = 'style="padding-top:' . $soho_qode_header_height_padding . 'px;"';
    } else {

        //is header semi-transparent?
        if(!$soho_qode_is_header_transparent) {
            //center title between border and end of title section
            $soho_qode_title_holder_height = 'style="padding-top:' . $soho_qode_header_height_padding . 'px; height:' . ($soho_qode_title_height - $soho_qode_header_height_padding) . 'px;"';
            $soho_qode_title_subtitle_padding = 'style="padding-top:' . $soho_qode_header_height_padding . 'px;"';
        } else {
            //header is transparent. Center it between main menu item's text beginning and end of title section
            $soho_qode_title_holder_height = 'style="padding-top:'.(($soho_qode_header_height/2 - $soho_qode_nav_font_size) + $soho_qode_header_top) .'px; height:' . ($soho_qode_title_height - ($soho_qode_header_height/2 - $soho_qode_nav_font_size + $soho_qode_header_top)) . 'px;"';
            $soho_qode_title_subtitle_padding = 'style="padding-top:'.(($soho_qode_header_height/2 - $soho_qode_nav_font_size) + $soho_qode_header_top) .'px;"';
        }
    }
}

//is vertical menu activated in Qode Options?
if(isset($soho_qode_options['vertical_area']) && $soho_qode_options['vertical_area'] =='yes'){
    $soho_qode_title_subtitle_padding = 0;
    $soho_qode_title_holder_height = 430;
    if($soho_qode_title_type == "breadcrumbs_title") {
        $soho_qode_title_holder_height = 102;
    }
    $soho_qode_title_height = 430; // default title height without header height
    if($soho_qode_title_type == "breadcrumbs_title") {
        $soho_qode_title_height = 102;
    }
    if(get_post_meta($soho_qode_id, "qode_title-height", true) != ""){
        $soho_qode_title_holder_height = intval( get_post_meta($soho_qode_id, "qode_title-height", true) );
        $soho_qode_title_height = intval( get_post_meta($soho_qode_id, "qode_title-height", true) );
    }else if($soho_qode_options['title_height'] != ''){
        $soho_qode_title_holder_height = intval( $soho_qode_options['title_height'] );
        $soho_qode_title_height = intval( $soho_qode_options['title_height'] );
    }
    $soho_qode_title_holder_height = 'style="height:' . $soho_qode_title_holder_height . 'px;"';
}

$soho_qode_page_title_position = 'left';
if(get_post_meta($soho_qode_id, "qode_page_title_position", true) != ""){
    $soho_qode_page_title_position = " position_" . get_post_meta($soho_qode_id, "qode_page_title_position", true);
}else{
    $soho_qode_page_title_position = " position_" . $soho_qode_options['page_title_position'];
}

$soho_qode_enable_breadcrumbs = 'no';
if(get_post_meta($soho_qode_id, "qode_enable_breadcrumbs", true) != ""){
    $soho_qode_enable_breadcrumbs = get_post_meta($soho_qode_id, "qode_enable_breadcrumbs", true);
}elseif(isset($soho_qode_options['enable_breadcrumbs'])){
    $soho_qode_enable_breadcrumbs = $soho_qode_options['enable_breadcrumbs'];
}

$soho_qode_title_text_shadow = '';
if(get_post_meta($soho_qode_id, "qode_title_text_shadow", true) != ""){
    if(get_post_meta($soho_qode_id, "qode_title_text_shadow", true) == "yes"){
        $soho_qode_title_text_shadow = ' title_text_shadow';
    }
}else{
    if($soho_qode_options['title_text_shadow'] == "yes"){
        $soho_qode_title_text_shadow = ' title_text_shadow';
    }
}

$soho_qode_title_text_background_class = '';
if(get_post_meta($soho_qode_id, "qode_page-title-text-background", true) != ""){
    if(get_post_meta($soho_qode_id, "qode_page-title-text-background", true) == "yes"){
        $soho_qode_title_text_background_class = ' title_text_background';
    }
}else{
    if($soho_qode_options['page_title_text_background'] == "yes"){
        $soho_qode_title_text_background_class = ' title_text_background';
    }
}

$soho_qode_title_color = "";
if(get_post_meta($soho_qode_id, "qode_page-title-color", true) != '') {
    $soho_qode_title_color = 'color:'.get_post_meta($soho_qode_id, "qode_page-title-color", true).';';
}

$soho_qode_title_text_background_color = '';
if(get_post_meta($soho_qode_id, "qode_page-title-text-background-color", true) != '') {
    $soho_qode_title_background_color_rgb = soho_qode_hex2rgb(get_post_meta($soho_qode_id, "qode_page-title-text-background-color", true));
    $soho_qode_title_text_background_color = 'background-color:rgba('.$soho_qode_title_background_color_rgb[0].','.$soho_qode_title_background_color_rgb[1].','.$soho_qode_title_background_color_rgb[2].',0.8);';
}else{
    if($soho_qode_options['page_title_text_background_color'] != ""){
        $soho_qode_title_background_color_rgb = soho_qode_hex2rgb($soho_qode_options['page_title_text_background_color']);
        $soho_qode_title_text_background_color = 'background-color:rgba('.$soho_qode_title_background_color_rgb[0].','.$soho_qode_title_background_color_rgb[1].','.$soho_qode_title_background_color_rgb[2].',0.8);';
    }
}

$soho_qode_title_font_style = "";
if(get_post_meta($soho_qode_id, "qode_page_title_font_style", true) != '') {
    $soho_qode_title_font_style = 'font-style:'.get_post_meta($soho_qode_id, "qode_page_title_font_style", true).';';
}

$soho_qode_title_font_style = "";
if($soho_qode_title_color != "" || $soho_qode_title_font_style != "" || $soho_qode_title_text_background_color != ""){
    $soho_qode_title_font_style = 'style="'.$soho_qode_title_color.$soho_qode_title_text_background_color.$soho_qode_title_font_style.'"';
}

$soho_qode_subtitle_color ="";
if(get_post_meta($soho_qode_id, "qode_page_subtitle_color", true) != ""){
    $soho_qode_subtitle_color = " style='color:" . get_post_meta($soho_qode_id, "qode_page_subtitle_color", true) . "';";
} else {
    $soho_qode_subtitle_color = "";
}

if (is_tag()) {
    $soho_qode_title = single_term_title("", false)." Tag";
}elseif (is_date()) {
    $soho_qode_title = get_the_time('F Y');
}elseif (is_author()){
    $soho_qode_title = "Author: ".get_the_author();
}elseif (is_category()){
    $soho_qode_title = single_cat_title('', false);
}elseif (is_home()){
    $soho_qode_title = get_option('blogname');
}elseif (is_search()){
    $soho_qode_title = esc_html__('Search', 'soho');
}elseif (is_404()){
    if($soho_qode_options['404_title'] != "") {
        $soho_qode_title = $soho_qode_options['404_title'];
    } else {
        $soho_qode_title = esc_html__('404 - Page not found', 'soho');
    }
}elseif(function_exists("is_woocommerce") && (is_shop() || is_singular('product'))){
    $shop_id = soho_qode_get_woo_shop_page_id();
    $soho_qode_title   = ! empty( $shop_id ) ? get_the_title( $shop_id ) : esc_html__( 'Shop', 'soho' );
}elseif(function_exists("is_woocommerce") && (is_product_category() || is_product_tag())){
    $tax = get_queried_object();

    if ( ! empty( $tax ) ) {
        $soho_qode_title = $tax->name ;
    }
}elseif (is_archive()){
    $soho_qode_title = esc_html__('Archive','soho');
}else {
    $soho_qode_title = get_the_title($soho_qode_id);
}
if(!get_post_meta($soho_qode_id, "qode_show-page-title", true)) { ?>
    <div class="title_outer <?php echo esc_attr( $animate_title_class.$soho_qode_title_text_shadow ); if($soho_qode_responsive_title_image == 'yes' && $soho_qode_show_title_image == true){ echo ' with_image'; }?>" <?php echo 'data-height="'.$soho_qode_title_height.'"'; if($soho_qode_title_height != '' && ($soho_qode_animate_title_area == 'area_top_bottom' || $soho_qode_animate_title_area == 'area_top_bottom_with_title_fade_in')){ echo 'style="opacity:0;height:' . $soho_qode_header_height_padding .'px;"'; } ?>>
        <div class="title <?php echo esc_attr( $soho_qode_page_title_position.' '.$soho_qode_title_type.$soho_qode_title_image_class ); if($soho_qode_responsive_title_image == 'no' && $soho_qode_title_image != "" && ($soho_qode_fixed_title_image == "yes" || $soho_qode_fixed_title_image == "yes_zoom") && $soho_qode_show_title_image == true){ echo ' has_fixed_background '; if($soho_qode_fixed_title_image == "yes_zoom"){ echo 'zoom_out '; } } if($soho_qode_responsive_title_image == 'no' && $soho_qode_title_image != "" && $soho_qode_fixed_title_image == "no" && $soho_qode_show_title_image == true){ echo ' has_background'; }  ?> <?php echo esc_attr( $soho_qode_title_text_background_class ); ?>" style="<?php if($soho_qode_responsive_title_image == 'no' && $soho_qode_title_image != "" && $soho_qode_show_title_image == true){ if($soho_qode_title_image_width != ''){ echo 'background-size:'.$soho_qode_title_image_width.'px auto;'; } echo 'background-image:url('.$soho_qode_title_image.');';  } if($soho_qode_title_height != ''){ echo 'height:'.$soho_qode_title_height.'px;'; } if($soho_qode_title_background_color != ''){ echo 'background-color:'.$soho_qode_title_background_color.';'; } ?>">
            
            <div class="image <?php if($soho_qode_responsive_title_image == 'yes' && $soho_qode_title_image != "" && $soho_qode_show_title_image == true){ echo "responsive"; }else{ echo "not_responsive"; } ?>"><?php if($soho_qode_title_image != ""){ ?><img src="<?php echo esc_url( $soho_qode_title_image ); ?>" alt="&nbsp;" /> <?php } ?></div>
            <?php if($soho_qode_title_overlay_image != ""){ ?>
                <div class="title_overlay" style="background-image:url('<?php echo esc_url( $soho_qode_title_overlay_image ); ?>');"></div>
            <?php } ?>

            <?php if(!get_post_meta($soho_qode_id, "qode_show-page-title-text", true)) { ?>
                <div class="title_holder" <?php if($soho_qode_responsive_title_image != 'yes' && get_post_meta($soho_qode_id, "qode_show-page-title-image", true) == ""){ echo soho_qode_get_module_part( $soho_qode_title_holder_height ); }?>>
                    <div class="container">
                        <div class="container_inner clearfix">
                            <div class="title_subtitle_holder" <?php if($soho_qode_responsive_title_image == 'yes' && $soho_qode_show_title_image == true){ echo soho_qode_get_module_part( $soho_qode_title_subtitle_padding ); }?>>
                                <?php if(($soho_qode_responsive_title_image == 'yes' && $soho_qode_show_title_image == true) || ($soho_qode_fixed_title_image == "yes" || $soho_qode_fixed_title_image == "yes_zoom") || ($soho_qode_responsive_title_image == 'no' && $soho_qode_title_image != "" && $soho_qode_fixed_title_image == "no" && $soho_qode_show_title_image == true)){ ?>
                                    <div class="title_subtitle_holder_inner">
                                <?php } ?>

                                        <?php if($soho_qode_title_type != "breadcrumbs_title") { ?>

                                            <h1 <?php echo soho_qode_get_module_part( $soho_qode_title_font_style ); ?>><span><?php echo esc_attr( $soho_qode_title ); ?></span></h1>

                                            <?php if(get_post_meta($soho_qode_id, "qode_page_subtitle", true) != ""){ ?>
                                                <h3 class="subtitle" <?php echo soho_qode_get_module_part( $soho_qode_subtitle_color ); ?>><?php echo get_post_meta($soho_qode_id, "qode_page_subtitle", true); ?></h3>
                                            <?php } ?>
                                            <?php if (function_exists('soho_qode_custom_breadcrumbs') && $soho_qode_enable_breadcrumbs == "yes") { ?>
                                                <div class="breadcrumb"> <?php soho_qode_custom_breadcrumbs(); ?></div>
                                            <?php } ?>

                                        <?php } else { ?>

                                            <div class="breadcrumb"> <?php soho_qode_custom_breadcrumbs(); ?></div>

                                        <?php } ?>
                                
                                <?php if(($soho_qode_responsive_title_image == 'yes' && $soho_qode_show_title_image == true)  || ($soho_qode_fixed_title_image == "yes" || $soho_qode_fixed_title_image == "yes_zoom") || ($soho_qode_responsive_title_image == 'no' && $soho_qode_title_image != "" && $soho_qode_fixed_title_image == "no" && $soho_qode_show_title_image == true)){ ?>
                                    </div>
                                <?php } ?>
                            </div>    
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>
    </div>
<?php } ?>
