<?php 
	$soho_qode_blog_query = soho_qode_get_blog_query_posts();
	$soho_qode_options = soho_qode_return_global_options();
    $soho_qode_template_name = get_page_template_slug( soho_qode_get_page_id() );

	if ( get_query_var('paged') ) { $paged = get_query_var('paged'); }
	elseif ( get_query_var('page') ) { $paged = get_query_var('page'); }
	else { $paged = 1; }

	if(isset($soho_qode_options['blog_page_range']) && $soho_qode_options['blog_page_range'] != ""){
		$blog_page_range = $soho_qode_options['blog_page_range'];
	} else{
		$blog_page_range = $soho_qode_blog_query->max_num_pages;
	}

	$blog_style = $soho_qode_options['blog_style'];
	$blog_list = "";
	if($soho_qode_template_name != "") {
		if($soho_qode_template_name == "blog-large-image.php"){
			$blog_list = "blog_large_image";
			$blog_list_class = "blog_large_image";
		}elseif($soho_qode_template_name == "blog-large-image-whole-post.php"){
			$blog_list = "blog_large_image_whole_post";	
			$blog_list_class = "blog_large_image blog_whole_post";	
		}elseif($soho_qode_template_name == "blog-masonry.php"){
			$blog_list = "blog_masonry";
			$blog_list_class = "masonry";
		}elseif($soho_qode_template_name == "blog-masonry-full-width.php"){
			$blog_list = "blog_masonry";	
			$blog_list_class = "masonry_full_width";	
		} elseif($soho_qode_template_name == "blog-large-image-wide.php"){
			$blog_list = "blog_large_image_wide";	
			$blog_list_class = "blog_large_image wide_image";
		} elseif($soho_qode_template_name == "blog-large-image-whole-post-wide.php"){
			$blog_list = "blog_large_image_whole_post_wide";	
			$blog_list_class = "blog_large_image wide_image blog_whole_post";	
		} elseif($soho_qode_template_name == "blog-small-image.php"){
			$blog_list = "blog_small_image";	
			$blog_list_class = "blog_small_image";		
		} elseif($soho_qode_template_name == "blog-small-image-whole-post.php"){
			$blog_list = "blog_small_image_whole_post";	
			$blog_list_class = "blog_small_image blog_whole_post";			
		} else{
			$blog_list = "blog_large_image";
			$blog_list_class = "blog_large_image";
		}
	} else {
		if($blog_style=="1"){
			$blog_list = "blog_large_image";
			$blog_list_class = "blog_large_image";
		}elseif($blog_style=="2"){
			$blog_list = "blog_large_image_whole_post";	
			$blog_list_class = "blog_large_image blog_whole_post";	
		} elseif($blog_style=="3"){
			$blog_list = "blog_masonry";	
			$blog_list_class = "masonry";	
		}  elseif($blog_style=="4"){
			$blog_list = "blog_masonry";	
			$blog_list_class = "masonry_full_width";	
		} elseif($blog_style=="5"){
			$blog_list = "blog_large_image_wide";	
			$blog_list_class = "blog_large_image wide_image";
		} elseif($blog_style=="6"){
			$blog_list = "blog_large_image_whole_post_wide";	
			$blog_list_class = "blog_large_image wide_image blog_whole_post";	
		} elseif($blog_style=="7"){
			$blog_list = "blog_small_image";
			$blog_list_class = "blog_small_image";
		} elseif($blog_style=="8"){
			$blog_list = "blog_small_image_whole_post";
			$blog_list_class = "blog_small_image blog_whole_post";
		} else {
			$blog_list = "blog_large_image";
			$blog_list_class = "blog_large_image";
		}
	}

	$filter = "no";

	if(isset($soho_qode_options['blog_masonry_filter'])){
		$filter = $soho_qode_options['blog_masonry_filter'];
	}

    $pagination_masonry = "pagination";

    if(isset($soho_qode_options['pagination_masonry'])){
       $pagination_masonry = $soho_qode_options['pagination_masonry'];
	   if($blog_list == "blog_masonry") { 
		$blog_list_class .= " masonry_" . $pagination_masonry;
		}
    }

	if($blog_list == "blog_masonry" && $filter == "yes") {
		get_template_part('templates/blog/blog_masonry_filter', 'loop');
	}
?>
<div class="blog_holder <?php echo esc_attr( $blog_list_class ); ?>">
	<?php if($soho_qode_blog_query->have_posts()) : while ( $soho_qode_blog_query->have_posts() ) : $soho_qode_blog_query->the_post(); ?>
		<?php 
			get_template_part('templates/blog/'.$blog_list, 'loop');
		?>
	<?php endwhile; ?>
	<?php if($blog_list != "blog_masonry") { ?>
		<?php if($soho_qode_options['pagination'] != "0") : ?>
			<?php soho_qode_get_blog_pagination( $soho_qode_blog_query ); ?>
		<?php endif; ?>
	<?php } ?>
	<?php else: //If no posts are present ?>
	<div class="entry">                        
		<p><?php esc_html_e('No posts were found.', 'soho'); ?></p>
	</div>
	<?php endif; ?>
    <?php wp_reset_postdata(); ?>
</div>
<?php if($blog_list == "blog_masonry") { ?>
	<?php if($pagination_masonry == "load_more") { 
		if ( $soho_qode_blog_query->max_num_pages > 1 ) { ?>
			<div class="blog_load_more_button">
				<span rel="<?php echo esc_attr( $soho_qode_blog_query->max_num_pages ); ?>"><?php echo get_next_posts_link(esc_html__('Show more', 'soho'), $soho_qode_blog_query->max_num_pages); ?></span>
			</div>
		<?php } ?>
	<?php } elseif ($pagination_masonry == "infinite_scroll") { ?>
		<div class="blog_infinite_scroll_button">
            <span rel="<?php echo esc_attr( $soho_qode_blog_query->max_num_pages ); ?>">
                <?php echo get_next_posts_link(esc_html__('Show more', 'soho'), $soho_qode_blog_query->max_num_pages); ?>
            </span>
        </div>
        <div class="soho-infinite-scroll-loading-label"><?php echo esc_html__('Loading new posts...', 'bridge'); ?></div>
        <div class="soho-infinite-scroll-finished-label"><?php echo esc_html__('No more posts', 'bridge'); ?></div>
	<?php }else { ?>
		<?php if($soho_qode_options['pagination'] != "0") : ?>
            <?php soho_qode_get_blog_pagination( $soho_qode_blog_query ); ?>
		<?php endif; ?>
	<?php } ?>
<?php } ?>