<?php
$soho_qode_page_id = soho_qode_get_page_id();
$soho_qode_options = soho_qode_return_global_options();

$soho_qode_filter = "no";

if(isset($soho_qode_options['blog_masonry_filter'])){
	$soho_qode_filter = $soho_qode_options['blog_masonry_filter'];
}

$soho_qode_page_category = get_post_meta($soho_qode_page_id, "qode_choose-blog-category", true);

if(is_category()){
	$soho_qode_page_category = get_query_var( 'cat' );
}

if ($soho_qode_page_category == "" && !is_category()) {
	$args = array(
	    'parent' => 0
	);

	$soho_qode_categories = get_categories( $args );
} else {
	$args = array(
	    'parent' => $soho_qode_page_category
	);
	$soho_qode_categories = get_categories( $args );
}

if ($soho_qode_filter == "yes" && count($soho_qode_categories) > 0) { ?>

	<div class="filter_holder blog_masonry_filter v<?php echo count($soho_qode_categories)+1; ?>">
		<ul>
			<li class="filter" data-filter="*"><span><?php esc_html_e('All', 'soho'); ?></span></li>
			<?php foreach ($soho_qode_categories as $category) { ?>
				 <li class="filter" data-filter="<?php echo ".category-" . $category->slug; ?>"><span><?php echo esc_attr( $category->name ); ?></span></li>
			<?php } ?>
		</ul>
	</div>

<?php } ?>