<?php

$soho_qode_read_more = "off";
if (isset($qode_options_soho['wp_read_more'])) {
    $soho_qode_read_more = $qode_options_soho['wp_read_more'];
}

$soho_qode_post_format = get_post_format();
?>
<?php
	switch ($soho_qode_post_format) {
		case "video":
?>
		<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
			<div class="container_inner">
				<div class="post_info_holder">
					<div class="post_info">
						<div class="post_info_inner">
							<span class="post_date">
								<span class="post_info_large"><?php the_time('d'); ?></span>
								<span class="post_info_small">
									<span><?php the_time('F'); ?></span>
									<span ><?php the_time('Y'); ?></span>
								</span>
							</span>
							<span class="post_author">
								<span class="post_info_large"><?php esc_html_e('By', 'soho'); ?></span>
								<span class="post_info_small">
								<?php if(get_the_author_meta('first_name') == "" || get_the_author_meta('last_name') == "") { ?>
									<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('display_name'); ?></a></span>
								<?php } else {?>
									<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('first_name'); ?></a></span>
									<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('last_name'); ?></a></span>
								<?php } ?>
								</span>
							</span>
							<span class="post_category">
								<span class="post_info_large"><?php esc_html_e('In', 'soho'); ?></span>
								<span class="post_info_small">
									<span><?php the_category(' '); ?></span>
								</span>
							</span>
						</div>
					</div>
				</div>
			</div>
			<div class="post_image">
				<?php if ( has_post_thumbnail() ) { ?>
					<a href="<?php the_permalink(); ?>" target="_self" title="<?php the_title_attribute(); ?>">
						<?php the_post_thumbnail('soho-blog-wide'); ?>
					</a>
				<?php } ?>	
			</div>
			<div class="container_inner">
				<div class="post_text">
					<h2><a href="<?php the_permalink(); ?>" target="_self" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h2>
                    <?php
                    $link_page_exists = soho_qode_wp_link_pages_exist();

                    if ( empty( $link_page_exists ) ) {
                        if($soho_qode_read_more == "off"){
                            soho_qode_excerpt();
                            ?>
                            <span class="post_read_more">
                                <a href="<?php the_permalink(); ?>" class="qbutton transparent_button" target="_self"><?php esc_html_e('Read More', 'soho'); ?></a>
                            </span>
                            <?php
                        } else {
                            the_content('Read More');
                        }
                    } else {
                        soho_qode_wp_link_pages();
                    }
                    ?>
				</div>
			</div>
		</article>
<?php
		break;
		case "audio":
?>
		<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
			<div class="container_inner">
				<div class="post_info_holder">
					<div class="post_info">
						<div class="post_info_inner">
							<span class="post_date">
								<span class="post_info_large"><?php the_time('d'); ?></span>
								<span class="post_info_small">
									<span><?php the_time('F'); ?></span>
									<span ><?php the_time('Y'); ?></span>
								</span>
							</span>
							<span class="post_author">
								<span class="post_info_large"><?php esc_html_e('By', 'soho'); ?></span>
								<span class="post_info_small">
								<?php if(get_the_author_meta('first_name') == "" || get_the_author_meta('last_name') == "") { ?>
									<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('display_name'); ?></a></span>
								<?php } else {?>
									<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('first_name'); ?></a></span>
									<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('last_name'); ?></a></span>
								<?php } ?>
								</span>
							</span>
							<span class="post_category">
								<span class="post_info_large"><?php esc_html_e('In', 'soho'); ?></span>
								<span class="post_info_small">
									<span><?php the_category(' '); ?></span>
								</span>
							</span>
						</div>
					</div>
				</div>
			</div>
			<div class="post_image with_text">
				<?php $thumb_url = wp_get_attachment_url( get_post_thumbnail_id($post->ID) ); ?>
			
				<div class="post_box_holder" <?php if ( has_post_thumbnail() ) { ?> style="background-image: url('<?php echo esc_url( $thumb_url ); ?>')" <?php } ?>>
					<div class="post_box_table">
						<div class="post_box_text">
							<div class="container_inner">
								<audio class="blog_audio_holder" src="<?php echo get_post_meta(get_the_ID(), "audio_link", true) ?>" controls="controls">
									<?php esc_html_e("Your browser don't support audio player","soho"); ?>
								</audio>
							</div>	
						</div>	
					</div>
				</div>
			</div>
			<div class="container_inner">
				<div class="post_text">
					<h2><a href="<?php the_permalink(); ?>" target="_self" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h2>
                    <?php
                    if($soho_qode_read_more == "off"){
                        soho_qode_excerpt();
                    } else {
                        the_content('Read More');
                    }
                    ?>

                    <?php if($soho_qode_read_more == "off"){ ?>
                        <span class="post_read_more">
					    <a href="<?php the_permalink(); ?>" class="qbutton transparent_button" target="_self"><?php esc_html_e('Read More', 'soho'); ?></a>
				    </span>
                    <?php } ?>
				</div>
			</div>
		</article>
<?php
		break;
		case "link":
?>
		<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
			<div class="container_inner">
				<div class="post_info_holder">
					<div class="post_info">
						<div class="post_info_inner">
							<span class="post_date">
								<span class="post_info_large"><?php the_time('d'); ?></span>
								<span class="post_info_small">
									<span><?php the_time('F'); ?></span>
									<span ><?php the_time('Y'); ?></span>
								</span>
							</span>
							<span class="post_author">
								<span class="post_info_large"><?php esc_html_e('By', 'soho'); ?></span>
								<span class="post_info_small">
								<?php if(get_the_author_meta('first_name') == "" || get_the_author_meta('last_name') == "") { ?>
									<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('display_name'); ?></a></span>
								<?php } else {?>
									<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('first_name'); ?></a></span>
									<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('last_name'); ?></a></span>
								<?php } ?>
								</span>
							</span>
							<span class="post_category">
								<span class="post_info_large"><?php esc_html_e('In', 'soho'); ?></span>
								<span class="post_info_small">
									<span><?php the_category(' '); ?></span>
								</span>
							</span>
						</div>
					</div>
				</div>
			</div>
			<div class="post_image with_text">
				<?php $thumb_url = wp_get_attachment_url( get_post_thumbnail_id($post->ID) ); ?>
			
				<div class="post_box_holder" <?php if ( has_post_thumbnail() ) { ?> style="background-image: url('<?php echo esc_url( $thumb_url ); ?>')" <?php } ?>>
					<div class="post_box_table">
						<div class="post_box_text">	
							<div class="link_mark">
								<span class="icon_link" aria-hidden="true"></span>
							</div>
							<div class="post_title">
								<h4><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h4>
							</div>
						</div>	
					</div>
				</div>
			</div>
		</article>
<?php
		break;
		case "gallery":
?>
		<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
			<div class="container_inner">
				<div class="post_info_holder">
					<div class="post_info">
						<div class="post_info_inner">
							<span class="post_date">
								<span class="post_info_large"><?php the_time('d'); ?></span>
								<span class="post_info_small">
									<span><?php the_time('F'); ?></span>
									<span ><?php the_time('Y'); ?></span>
								</span>
							</span>
							<span class="post_author">
								<span class="post_info_large"><?php esc_html_e('By', 'soho'); ?></span>
								<span class="post_info_small">
								<?php if(get_the_author_meta('first_name') == "" || get_the_author_meta('last_name') == "") { ?>
									<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('display_name'); ?></a></span>
								<?php } else {?>
									<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('first_name'); ?></a></span>
									<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('last_name'); ?></a></span>
								<?php } ?>
								</span>
							</span>
							<span class="post_category">
								<span class="post_info_large"><?php esc_html_e('In', 'soho'); ?></span>
								<span class="post_info_small">
									<span><?php the_category(' '); ?></span>
								</span>
							</span>
						</div>
					</div>
				</div>
			</div>
			<div class="post_image">
				<div class="flexslider">
					<ul class="slides">
						<?php
							$post_content = get_the_content();
							preg_match('/\[gallery.*ids=.(.*).\]/', $post_content, $ids);
							$array_id = explode(",", $ids[1]);
							
						foreach($array_id as $img_id){ ?>
							<li><a href="<?php the_permalink(); ?>"><?php echo wp_get_attachment_image( $img_id, 'soho-blog-wide' ); ?></a></li>
						<?php } ?>
					</ul>
				</div>
			</div>
			<div class="container_inner">
				<div class="post_text">
					<h2><a href="<?php the_permalink(); ?>" target="_self" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h2>
                    <?php
                    if($soho_qode_read_more == "off"){
                        soho_qode_excerpt();
                    } else {
                        the_content('Read More');
                    }
                    ?>

                    <?php if($soho_qode_read_more == "off"){ ?>
                        <span class="post_read_more">
					    <a href="<?php the_permalink(); ?>" class="qbutton transparent_button" target="_self"><?php esc_html_e('Read More', 'soho'); ?></a>
				    </span>
                    <?php } ?>
				</div>
			</div>
		</article>
<?php
		break;
		case "quote":
?>
			<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
			<div class="container_inner">
				<div class="post_info_holder">
					<div class="post_info">
						<div class="post_info_inner">
							<span class="post_date">
								<span class="post_info_large"><?php the_time('d'); ?></span>
								<span class="post_info_small">
									<span><?php the_time('F'); ?></span>
									<span ><?php the_time('Y'); ?></span>
								</span>
							</span>
							<span class="post_author">
								<span class="post_info_large"><?php esc_html_e('By', 'soho'); ?></span>
								<span class="post_info_small">
								<?php if(get_the_author_meta('first_name') == "" || get_the_author_meta('last_name') == "") { ?>
									<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('display_name'); ?></a></span>
								<?php } else {?>
									<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('first_name'); ?></a></span>
									<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('last_name'); ?></a></span>
								<?php } ?>
								</span>
							</span>
							<span class="post_category">
								<span class="post_info_large"><?php esc_html_e('In', 'soho'); ?></span>
								<span class="post_info_small">
									<span><?php the_category(' '); ?></span>
								</span>
							</span>
						</div>
					</div>
				</div>
			</div>
			<div class="post_image with_text">
				<?php $thumb_url = wp_get_attachment_url( get_post_thumbnail_id($post->ID) ); ?>
				
				<div class="post_box_holder" <?php if ( has_post_thumbnail() ) { ?> style="background-image: url('<?php echo esc_url( $thumb_url ); ?>')" <?php } ?>>
					<div class="post_box_table">
						<div class="post_box_text">	
							<div class="qoute_mark">
								<span aria-hidden="true" class="icon_quotations"></span>
							</div>
							<div class="post_title">
								<h4><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php echo get_post_meta(get_the_ID(), "quote_format", true); ?></a></h4>
								<span class="quote_author">&mdash; <?php the_title(); ?></span>
							</div>
						</div>	
					</div>
				</div>
			</div>
			</article>
<?php
		break;
		default:
?>
		<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
			<div class="container_inner">
				<div class="post_info_holder">
					<div class="post_info">
						<div class="post_info_inner">
							<span class="post_date">
								<span class="post_info_large"><?php the_time('d'); ?></span>
								<span class="post_info_small">
									<span><?php the_time('F'); ?></span>
									<span ><?php the_time('Y'); ?></span>
								</span>
							</span>
							<span class="post_author">
								<span class="post_info_large"><?php esc_html_e('By', 'soho'); ?></span>
								<span class="post_info_small">
								<?php if(get_the_author_meta('first_name') == "" || get_the_author_meta('last_name') == "") { ?>
									<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('display_name'); ?></a></span>
								<?php } else {?>
									<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('first_name'); ?></a></span>
									<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author_meta('last_name'); ?></a></span>
								<?php } ?>
								</span>
							</span>
							<span class="post_category">
								<span class="post_info_large"><?php esc_html_e('In', 'soho'); ?></span>
								<span class="post_info_small">
									<span><?php the_category(' '); ?></span>
								</span>
							</span>
						</div>
					</div>
				</div>
			</div>
			<?php if ( has_post_thumbnail() ) { ?>
				<div class="post_image">
					<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
						<?php the_post_thumbnail('soho-blog-wide'); ?>
					</a>
				</div>
			<?php } ?>
			<div class="container_inner">
				<div class="post_text">
					<h2><a href="<?php the_permalink(); ?>" target="_self" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h2>
                    <?php
                    if($soho_qode_read_more == "off"){
                        soho_qode_excerpt();
                    } else {
                        the_content('Read More');
                    }
                    ?>

                    <?php if($soho_qode_read_more == "off"){ ?>
                        <span class="post_read_more">
					    <a href="<?php the_permalink(); ?>" class="qbutton transparent_button" target="_self"><?php esc_html_e('Read More', 'soho'); ?></a>
				    </span>
                    <?php } ?>
				</div>
			</div>
		</article>
<?php
}
?>