<?php
if(!class_exists('SohoQodeWoocommerceDropdownCart')) {
    class SohoQodeWoocommerceDropdownCart extends WP_Widget {

        public function __construct()
        {
            parent::__construct(
                'woocommerce-dropdown-cart', // Base ID
                'Woocommerce Dropdown Cart', // Name
                array('description' => esc_html__('Woocommerce Dropdown Cart', 'soho'),) // Args
            );
        }

        public function widget($args, $instance)
        {
            global $post;
            extract($args);
            echo soho_qode_get_module_part( $before_widget );
            global $woocommerce; ?>
            <div class="shopping_cart_header">
                <a class="header_cart" href="<?php echo wc_get_cart_url(); ?>"><i
                            class="fa fa-2x simple_social fa-shopping-cart"></i></a>
                <div class="shopping_cart_dropdown">
                    <div class="shopping_cart_dropdown_inner">
                        <?php
                        $cart_is_empty = sizeof($woocommerce->cart->get_cart()) <= 0;
                        $list_class = array('cart_list', 'product_list_widget');
                        ?>
                        <ul class="<?php echo implode(' ', $list_class); ?>">

                            <?php if (!$cart_is_empty) : ?>

                                <?php foreach ($woocommerce->cart->get_cart() as $cart_item_key => $cart_item) :

                                    $_product = $cart_item['data'];

                                    // Only display if allowed
                                    if (!$_product->exists() || $cart_item['quantity'] == 0) {
                                        continue;
                                    }

                                    // Get price
                                    $product_price = get_option('woocommerce_tax_display_cart') == 'excl' ? wc_get_price_excluding_tax($_product) : wc_get_price_including_tax($_product);
                                    ?>

                                    <li class="woocommerce-mini-cart-item mini_cart_item">
                                        <?php
                                        echo apply_filters('woocommerce_cart_item_remove_link', sprintf(
                                            '<a href="%s" class="remove remove_from_cart_button" aria-label="%s" data-product_id="%s" data-cart_item_key="%s" data-product_sku="%s">&times;</a>',
                                            esc_url(wc_get_cart_remove_url($cart_item_key)),
                                            esc_html__('Remove this item', 'soho'),
                                            esc_attr($cart_item['product_id']),
                                            esc_attr($cart_item_key),
                                            esc_attr($_product->get_sku())
                                        ), $cart_item_key);
                                        ?>
                                        <a href="<?php echo get_permalink($cart_item['product_id']); ?>">

                                            <?php echo soho_qode_get_module_part( $_product->get_image() ); ?>

                                            <?php echo apply_filters('woocommerce_widget_cart_product_title', $_product->get_name(), $_product); ?>

                                        </a>

                                        <?php echo wc_get_formatted_cart_item_data($cart_item); ?>

                                        <?php echo apply_filters('woocommerce_widget_cart_item_quantity', '<span class="quantity">' . sprintf('%s &times; %s', $cart_item['quantity'], $product_price) . '</span>', $cart_item, $cart_item_key); ?>
                                    </li>

                                <?php endforeach; ?>

                            <?php else : ?>

                                <li><?php esc_html_e('No products in the cart.', 'soho'); ?></li>

                            <?php endif; ?>

                        </ul>
                    </div>
                    <div class="shopping_cart_dropdown_inner2">
                        <a href="<?php echo wc_get_cart_url(); ?>"
                           class="qbutton dark view-cart"><?php esc_html_e('Cart', 'soho'); ?> <i
                                    class="fa fa-shopping-cart"></i></a>
                        <span class="total"><?php esc_html_e('Total', 'soho'); ?>
                            :<span><?php echo soho_qode_get_module_part( $woocommerce->cart->get_cart_subtotal() ); ?></span></span>
                    </div>
                </div>
            </div>

            <?php
            echo soho_qode_get_module_part( $after_widget );
        }


        public function update($new_instance, $old_instance)
        {
            $instance = array();

            return $instance;
        }

    }
}
?>
<?php
if( ! function_exists('soho_qode_woocommerce_header_add_to_cart_fragment') ) {
    function soho_qode_woocommerce_header_add_to_cart_fragment($fragments){
        global $woocommerce;
        ob_start();
        ?>
        <span class="header_cart_span"><?php echo soho_qode_get_module_part($woocommerce->cart->cart_contents_count); ?></span>
        <?php
        $fragments['span.header_cart_span'] = ob_get_clean();
        return $fragments;
    }
    
    add_filter('woocommerce_add_to_cart_fragments', 'soho_qode_woocommerce_header_add_to_cart_fragment');
}