<?php
/*=================================================================================
 * #WooCommerce helper functions
 *=================================================================================*/

if(!function_exists('soho_qode_is_woocommerce_installed')) {
    /**
     * Function that checks if woocommerce is installed
     * @return bool
     */
    function soho_qode_is_woocommerce_installed() {
        return function_exists('is_woocommerce');
    }
}

if(!function_exists('soho_qode_is_woocommerce_page')) {
    /**
     * Function that checks if current page is woocommerce shop, product or product taxonomy
     * @return bool
     *
     * @see is_woocommerce()
     */
    function soho_qode_is_woocommerce_page() {
        return function_exists('is_woocommerce') && is_woocommerce();
    }
}

if(!function_exists('soho_qode_is_woocommerce_shop')) {
    /**
     * Function that checks if current page is shop or product page
     * @return bool
     *
     * @see is_shop()
     */
    function soho_qode_is_woocommerce_shop() {
        return function_exists('is_shop') && is_shop();
    }
}

if(!function_exists('soho_qode_get_woo_shop_page_id')) {
    /**
     * Function that returns shop page id that is set in WooCommerce settings page
     * @return int id of shop page
     */
    function soho_qode_get_woo_shop_page_id() {
        if(soho_qode_is_woocommerce_installed()) {
            return get_option('woocommerce_shop_page_id');
        }
    }
}

if(!function_exists('soho_qode_is_product_category')) {
    function soho_qode_is_product_category() {
        return function_exists('is_product_category') && is_product_category();
    }
}

if ( ! function_exists( 'soho_qode_return_global_options' ) ) {
    function soho_qode_return_global_options() {
        global $qode_options_soho;

        return $qode_options_soho;
    }
}

if ( ! function_exists( 'soho_qode_return_toolbar_variable' ) ) {
    function soho_qode_return_toolbar_variable() {
        global $qode_toolbar;

        return $qode_toolbar;
    }
}

if ( ! function_exists( 'soho_qode_return_global_template_name' ) ) {
    function soho_qode_return_global_template_name() {
        global $qode_template_name;

        return $qode_template_name;
    }
}

if ( ! function_exists( 'soho_qode_return_global_wp_query' ) ) {
    function soho_qode_return_global_wp_query() {
        global $wp_query;

        return $wp_query;
    }
}

if ( ! function_exists( 'soho_qode_get_module_part' ) ) {
    function soho_qode_get_module_part( $module ) {
        return $module;
    }
}

if ( ! function_exists( 'soho_qode_is_core_installed' ) ) {
    /**
     * Function that checks if Core plugin is installed
     * @return bool
     */
    function soho_qode_is_core_installed() {
        return class_exists( 'SohoCore' );
    }
}

if ( ! function_exists( 'soho_qode_get_sidebar_layout' ) ) {
    function soho_qode_get_sidebar_layout( $default_value = true ) {
        $global_options    = soho_qode_return_global_options();
        $qode_page_id      = soho_qode_get_page_id();
        $show_sidebar_meta = get_post_meta( $qode_page_id, "qode_show-sidebar", true );
        $sidebar           = $default_value ? $global_options['category_blog_sidebar'] : '';

        if ( ! empty( $show_sidebar_meta ) ) {
            $sidebar = $show_sidebar_meta;
        }

        if ( is_singular( 'post' ) && ( $show_sidebar_meta === 'default' || empty( $show_sidebar_meta ) ) ) {
            $sidebar = $global_options['blog_single_sidebar'];
        }

        if ( ! empty( $sidebar ) && ! is_active_sidebar( soho_qode_get_sidebar_name() ) ) {
            $sidebar = '';
        }

        return $sidebar;
    }
}

if ( ! function_exists( 'soho_qode_get_sidebar_name' ) ) {
    function soho_qode_get_sidebar_name() {
        $soho_options = soho_qode_return_global_options();
        $page_id      = soho_qode_get_page_id();

        if ( get_post_meta( $page_id, 'qode_choose-sidebar', true ) != "" ) {
            $sidebar = get_post_meta( $page_id, 'qode_choose-sidebar', true );
        } else {
            if ( is_singular( "post" ) ) {
                if ( $soho_options['blog_single_sidebar_custom_display'] != "" ) {
                    $sidebar = $soho_options['blog_single_sidebar_custom_display'];
                } else {
                    $sidebar = 'sidebar';
                }
            } else {
                $sidebar = 'sidebar_page';
            }
        }

        return $sidebar;
    }
}

if ( ! function_exists( 'soho_qode_get_blog_query_posts' ) ) {
    function soho_qode_get_blog_query_posts() {
        $qode_page_id             = soho_qode_get_page_id();
        $category                 = get_post_meta( $qode_page_id, "qode_choose-blog-category", true );
        $number_of_posts_per_page = get_post_meta( $qode_page_id, "qode_show-posts-per-page", true );
        $post_number              = ! empty( $number_of_posts_per_page ) ? esc_attr( $number_of_posts_per_page ) : esc_attr( get_option( 'posts_per_page' ) );

        if ( get_query_var( 'paged' ) ) {
            $paged = get_query_var( 'paged' );
        } elseif ( get_query_var( 'page' ) ) {
            $paged = get_query_var( 'page' );
        } else {
            $paged = 1;
        }

        $query_array = array(
            'post_status'    => 'publish',
            'post_type'      => 'post',
            'paged'          => $paged,
            'cat'            => $category,
            'posts_per_page' => $post_number
        );

        $blog_query = new WP_Query( $query_array );
        if ( is_archive() ) {
            global $wp_query;
            $blog_query = $wp_query;
        }

        return $blog_query;
    }
}

if ( ! function_exists( 'soho_qode_wp_link_pages' ) ) {
    function soho_qode_wp_link_pages() {
        wp_link_pages();
    }
}

if ( ! function_exists( 'soho_qode_wp_link_pages_exist' ) ) {
    function soho_qode_wp_link_pages_exist() {
        $args_pages = array(
            'echo' => 0
        );

        return wp_link_pages( $args_pages );
    }
}

if ( ! function_exists( 'soho_qode_post_has_read_more' ) ) {
    /**
     * Function that checks if current post has read more tag set
     * @return int position of read more tag text. It will return false if read more tag isn't set
     */
    function soho_qode_post_has_read_more() {
        global $post;

        return strpos( $post->post_content, '<!--more-->' );
    }
}

if ( ! function_exists( 'soho_qode_get_blog_pagination' ) ) {
    function soho_qode_get_blog_pagination( $qode_blog_query ) {
        $global_options = soho_qode_return_global_options();

        if ( isset( $global_options['pagination'] ) && $global_options['pagination'] != "0" ) {

            if ( isset( $global_options['blog_page_range'] ) && $global_options['blog_page_range'] != "" ) {
                $blog_page_range = $global_options['blog_page_range'];
            } else {
                $blog_page_range = $qode_blog_query->max_num_pages;
            }

            if ( get_query_var( 'paged' ) ) {
                $paged = get_query_var( 'paged' );
            } elseif ( get_query_var( 'page' ) ) {
                $paged = get_query_var( 'page' );
            } else {
                $paged = 1;
            }

            soho_qode_get_blog_pagination_html( $qode_blog_query->max_num_pages, $blog_page_range, $paged );
        }
    }
}

/* Pagination */

if (!function_exists('soho_qode_get_blog_pagination_html')) {
    function soho_qode_get_blog_pagination_html($pages = '', $range = 4, $paged = 1){
        $showitems = $range + 1;

        if($pages == ''){
            global $wp_query;
            $pages = $wp_query->max_num_pages;
            if(!$pages){
                $pages = 1;
            }
        }

        if(1 != $pages){
            echo "<div class='pagination'><ul>";
            if($paged > 2 && $paged > $range+1 && $showitems < $pages) echo "<li class='first'><a href='".get_pagenum_link(1)."'><i class='fa fa-angle-double-left'></i></a></li>";
            echo "<li class='prev";
            if($paged > 2 && $paged > $range+1 && $showitems < $pages) {
                echo " prev_first";
            }
            echo "'><a href='".get_pagenum_link($paged - 1)."'><i class='fa fa-angle-left'></i></a></li>";

            for ($i=1; $i <= $pages; $i++){
                if (1 != $pages &&( !($i >= $paged+$range+1 || $i <= $paged-$range-1) || $pages <= $showitems )){
                    if($paged == $i) {
                        echo "<li class='active'><span>".$i."</span></li>";
                    } else {
                        echo "<li><a href='".get_pagenum_link($i)."' class='inactive'>".$i."</a></li>";
                    }
                }
            }

            echo "<li class='next";
            if ($paged < $pages-1 &&  $paged+$range-1 < $pages && $showitems < $pages){
                echo " next_last";
            }
            echo "'><a href=\"";
            if($pages > $paged){
                echo get_pagenum_link($paged + 1);
            } else {
                echo get_pagenum_link($paged);
            }
            echo "\"><i class='fa fa-angle-right'></i></a></li>";

            if ($paged < $pages-1 &&  $paged+$range-1 < $pages && $showitems < $pages) echo "<li class='last'><a href='".get_pagenum_link($pages)."'><i class='fa fa-angle-double-right'></i></a></li>";
            echo "</ul></div>\n";
        }
    }
}

if ( ! function_exists( 'soho_qode_is_like_enabled' ) ) {
    function soho_qode_is_like_enabled( $is_portfolio = false ) {
        $global_options = soho_qode_return_global_options();

        $is_enabled = "on";

        if ( isset( $global_options['soho_core_like'] ) && ! $is_portfolio ) {
            $is_enabled = $global_options['soho_core_like'];
        }

        if ( isset( $global_options['portfolio_qode_like'] ) && $is_portfolio ) {
            $is_enabled = $global_options['portfolio_qode_like'];
        }

        if ( ! soho_qode_is_core_installed() ) {
            $is_enabled = 'off';
        }

        return $is_enabled === 'on';
    }
}

if ( ! function_exists( 'soho_qode_is_comments_enabled' ) ) {
    function soho_qode_is_comments_enabled( $is_blog = true ) {
        $global_options = soho_qode_return_global_options();

        $is_disabled = "";

        if ( isset( $global_options['blog_hide_comments'] ) && $is_blog ) {
            $is_disabled = $global_options['blog_hide_comments'];
        }

        if ( ! comments_open() ) {
            $is_disabled = 'yes';
        }

        return $is_disabled !== 'yes';
    }
}

if ( ! function_exists( 'soho_qode_is_author_enabled' ) ) {
    function soho_qode_is_author_enabled() {

        $global_options = soho_qode_return_global_options();

        $is_enabled = "on";

        if ( isset( $global_options['blog_author_info'] ) ) {
            $is_enabled = $global_options['blog_author_info'];
        }

        return $is_enabled === 'on';
    }
}

if ( ! function_exists( 'soho_qode_get_attachment_id_from_url' ) ) {
    /**
     * Function that retrieves attachment id for passed attachment url
     *
     * @param $attachment_url
     *
     * @return null|string
     */
    function soho_qode_get_attachment_id_from_url( $attachment_url ) {
        global $wpdb;
        $attachment_id = '';

        //is attachment url set?
        if ( $attachment_url !== '' ) {
            //prepare query

            $query = $wpdb->prepare( "SELECT ID FROM {$wpdb->posts} WHERE guid=%s", $attachment_url );

            //get attachment id
            $attachment_id = $wpdb->get_var( $query );
        }

        //return id
        return $attachment_id;
    }
}

if(!function_exists('soho_qode_get_attachment_meta')) {
    /**
     * Function that returns attachment meta data from attachment id
     * @param $attachment_id
     * @param array $keys sub array of attachment meta
     * @return array|mixed
     */
    function soho_qode_get_attachment_meta($attachment_id, $keys = array()) {
        $meta_data = array();

        //is attachment id set?
        if(!empty($attachment_id)) {
            //get all post meta for given attachment id
            $meta_data = get_post_meta($attachment_id, '_wp_attachment_metadata', true);

            //is subarray of meta array keys set?
            if(is_array($keys) && count($keys) && is_array($meta_data) && count($meta_data)) {
                $sub_array = array();

                //for each defined key
                foreach($keys as $key) {
                    //check if that key exists in all meta array
                    if(array_key_exists($key, $meta_data)) {
                        //assign key from meta array for current key to meta subarray
                        $sub_array[$key] = $meta_data[$key];
                    }
                }

                //we want meta array to be subarray because that is what used wants to get
                $meta_data = $sub_array;
            }
        }

        //return meta array
        return $meta_data;
    }
}

if ( ! function_exists( 'soho_qode_get_attachment_meta_from_url' ) ) {
    /**
     * Function that returns meta array for give attachment url
     *
     * @param $attachment_url
     * @param array $keys sub array of attachment meta
     *
     * @return array|mixed
     *
     * @see soho_qode_get_attachment_id_from_url()
     * @see soho_qode_get_attachment_meta()
     *
     * @version 0.1
     */
    function soho_qode_get_attachment_meta_from_url( $attachment_url, $keys = array() ) {
        $attachment_meta = array();

        //get attachment id for attachment url
        $attachment_id = soho_qode_get_attachment_id_from_url( $attachment_url );

        //is attachment id set?
        if ( ! empty( $attachment_id ) ) {
            //get post meta
            $attachment_meta                  = soho_qode_get_attachment_meta( $attachment_id, $keys );
            $attachment_meta['attachment_id'] = $attachment_id;
        }

        //return post meta
        return $attachment_meta;
    }
}

if ( ! function_exists( 'soho_qode_get_image_dimensions' ) ) {
    /**
     * Function that returns image sizes array. First looks in post_meta table if attachment exists in the database,
     * if it does not than it uses getimagesize PHP function to get image sizes
     *
     * @param $url string url of the image
     *
     * @return array array of image sizes that contains height and width
     *
     * @see  soho_qode_get_attachment_meta_from_url()
     * @uses getimagesize
     *
     * @version 0.1
     */
    function soho_qode_get_image_dimensions( $url ) {
        $image_sizes = array();

        //is url passed?
        if ( $url !== '' ) {
            //get image sizes from posts meta if attachment exists
            $image_sizes = soho_qode_get_attachment_meta_from_url( $url, array( 'width', 'height' ) );

            //image does not exists in post table, we have to use PHP way of getting image size
            if ( ! count( $image_sizes ) ) {
                require_once( ABSPATH . 'wp-admin/includes/file.php' );

                //can we open file by url?
                if ( ini_get( 'allow_url_fopen' ) == 1 && file_exists( $url ) ) {
                    list( $width, $height, $type, $attr ) = getimagesize( $url );
                } else {
                    //we can't open file directly, have to locate it with relative path.
                    $image_obj           = parse_url( $url );
                    $image_relative_path = rtrim( get_home_path(), '/' ) . $image_obj['path'];

                    if ( file_exists( $image_relative_path ) ) {
                        list( $width, $height, $type, $attr ) = getimagesize( $image_relative_path );
                    }
                }

                //did we get width and height from some of above methods?
                if ( isset( $width ) && isset( $height ) ) {
                    //set them to our image sizes array
                    $image_sizes = array(
                        'width'  => $width,
                        'height' => $height
                    );
                }
            }
        }

        return $image_sizes;
    }
}

if ( ! function_exists( 'soho_qode_init_global_option' ) ) {
    function soho_qode_init_global_option() {

        if ( ! soho_qode_is_core_installed() ) {
            global $qode_options_soho;

            $qode_options_soho = array( // intitialize the 'qode_options_soho' array with the following key => value pairs:
                "reset_to_defaults" => "",
                "number_of_chars" => "45",
                "first_color" => "",
                "first_area_color" => "",
                "second_color" => "",
                "second_area_color" => "",
                "accordion_color" => "",
                "accordion_color_hover" => "",
                "accordion_backgroundcolor" => "",
                "accordion_backgroundcolor_hover" => "",
                "accordion_bordercolor" => "",
                "accordion_bordercolor_hover" => "",
                "accordion_fontsize" => "",
                "accordion_lineheight" => "",
                "accordion_fontweight" => "",
                "background_color" => "",
                "background_color_box" => "",
                "blockquote_color" => "",
                "blockquote_fontsize" => "",
                "content_input_fields_color" => "",
                "content_input_fields_backgroundcolor" => "",
                "content_input_fields_bordercolor" => "",
                "highlight_color" => "",
                "selection_color" => "",
                "favicon_image" => SOHO_QODE_ROOT . "/img/favicon.ico",
                "content_background_image" => "",
                "background_image" => "",
                "patern_background_image" => "",
                "google_fonts" => "-1",
                "page_transitions" => "0",
                "boxed" => "no",
                "loading_animation" => "yes",
                "loading_image" => "",
                "smooth_scroll" => "no",
                "responsiveness" => "yes",
                "show_back_button" => "yes",
                "elements_animation_on_touch" => "no",
                "parallax_minheight" => "400",
                "parallax_onoff" => "off",
                "internal_no_ajax_links" => "",
                "custom_css" => "",
                "custom_js" => "",
                "meta_keywords" => "",
                "meta_description" => "",
                "disable_qode_seo" => "no",
                "h1_color" => "",
                "h1_google_fonts" => "-1",
                "h1_fontsize" => "",
                "h1_lineheight" => "",
                "h1_fontstyle" => "",
                "h1_fontweight" => "",
                "h1_texttransform" => "",
                "h2_color" => "",
                "h2_google_fonts" => "-1",
                "h2_fontsize" => "",
                "h2_lineheight" => "",
                "h2_fontstyle" => "",
                "h2_fontweight" => "",
                "h2_texttransform" => "",
                "h3_color" => "",
                "h3_google_fonts" => "-1",
                "h3_fontsize" => "",
                "h3_lineheight" => "",
                "h3_fontstyle" => "",
                "h3_fontweight" => "",
                "h3_texttransform" => "",
                "h4_color" => "",
                "h4_google_fonts" => "-1",
                "h4_fontsize" => "",
                "h4_lineheight" => "",
                "h4_fontstyle" => "",
                "h4_fontweight" => "",
                "h4_texttransform" => "",
                "h5_color" => "",
                "h5_google_fonts" => "-1",
                "h5_fontsize" => "",
                "h5_lineheight" => "",
                "h5_fontstyle" => "",
                "h5_fontweight" => "",
                "h5_texttransform" => "",
                "h6_color" => "",
                "h6_google_fonts" => "-1",
                "h6_fontsize" => "",
                "h6_lineheight" => "",
                "h6_fontstyle" => "",
                "h6_fontweight" => "",
                "h6_letterspacing" => "",
                "h6_texttransform" => "",
                "text_color" => "",
                "text_google_fonts" => "-1",
                "text_fontsize" => "",
                "text_lineheight" => "",
                "text_fontstyle" => "",
                "text_fontweight" => "",
                "text_margin" => "",
                "link_color" => "",
                "link_hovercolor" => "",
                "link_fontstyle" => "",
                "link_fontweight" => "",
                "link_fontdecoration" => "",
                "lists_unsorted_fontsize" => "",
                "lists_unsorted_lineheight" => "",
                "lists_unsorted_color" => "",
                "lists_unsorted_marginbottom" => "",
                "page_title_color" => "",
                "page_title_google_fonts" => "-1",
                "page_title_fontsize" => "",
                "page_title_lineheight" => "",
                "page_title_fontstyle" => "",
                "page_title_fontweight" => "",
                "page_title_texttransform" => "",
                "pricingtables_backgroundcolor" => "",
                "pricingtables_backgroundpatern" => "",
                "pricingtables_even_backgroundcolor" => "",
                "pricingtables_even_backgroundpatern" => "",
                "progressbar_horizontal_fontsize" => "",
                "progressbar_horizontal_fontweight" => "",
                "progressbar_horizontal_fontstyle" => "",
                "progressbar_horizontal_lineheight" => "",
                "progressbar_vertical_fontsize" => "",
                "progressbar_vertical_fontweight" => "",
                "progressbar_vertical_fontstyle" => "",
                "progressbar_vertical_lineheight" => "",
                "piecharts_fontsize" => "",
                "piecharts_fontweight" => "",
                "piecharts_fontstyle" => "",
                "piecharts_lineheight" => "",
                "menu_color" => "",
                "menu_hovercolor" => "",
                "menu_top_line_color" => "",
                "menu_google_fonts" => "-1",
                "menu_fontsize" => "",
                "menu_lineheight" => "",
                "menu_fontstyle" => "",
                "menu_fontweight" => "",
                "header_in_grid" => "yes",
                "header_top_area" => "no",
                "header_top_area_scroll" => "no",
                "title_type" => "standard_title",
                "enable_breadcrumbs" => "no",
                "enable_search" => "no",
                "header_bottom_appearance" => "fixed",
                "header_style" => "",
                "menu_position" => "",
                "header_top_background_color" => "",
                "header_background_color" => "",
                "header_background_color_scroll" => "",
                "header_background_color_sticky" => "",
                "header_background_color_touch" => "",
                "header_background_transparency_initial" => "",
                "header_background_transparency_scroll" => "",
                "header_background_transparency_sticky" => "",
                "logo_image" => SOHO_QODE_ROOT . "/img/logo.png",
                "logo_image_light" => SOHO_QODE_ROOT . "/img/logo_white.png",
                "logo_image_dark" => SOHO_QODE_ROOT . "/img/logo_black.png",
                "logo_image_sticky" => SOHO_QODE_ROOT . "/img/logo_black.png",
                "center_logo_image" => "no",
                "header_height" => "",
                "header_height_scroll" => "",
                "header_height_sticky" => "",
                "scroll_amount_for_sticky" => "",
                "dropdown_animation" => "",
                "dropdown_background_color" => "",
                "dropdown_background_separator_color" => "",
                "dropdown_background_transparency" => "",
                "dropdown_background_pattern" => "",
                "dropdown_color" => "",
                "dropdown_hovercolor" => "",
                "dropdown_google_fonts" => "-1",
                "dropdown_fontsize" => "",
                "dropdown_lineheight" => "",
                "dropdown_fontstyle" => "",
                "dropdown_fontweight" => "",
                "dropdown_color_thirdlvl" => "",
                "dropdown_hovercolor_thirdlvl" => "",
                "dropdown_google_fonts_thirdlvl" => "-1",
                "fixed_google_fonts" => "-1",
                "dropdown_fontsize_thirdlvl" => "",
                "dropdown_lineheight_thirdlvl" => "",
                "dropdown_fontstyle_thirdlvl" => "",
                "dropdown_fontweight_thirdlvl" => "",
                "sticky_color" => "",
                "sticky_hovercolor" => "",
                "sticky_google_fonts" => "-1",
                "sticky_fontsizel" => "",
                "sticky_lineheight" => "",
                "sticky_fontstyle" => "",
                "sticky_fontweight" => "",
                "tabs_color" => "",
                "tabs_color_hover" => "",
                "tabs_backgroundcolor" => "",
                "tabs_backgroundcolor_hover" => "",
                "tabs_bordercolor" => "",
                "tabs_bordercolor_hover" => "",
                "tabs_fontsize" => "",
                "tabs_lineheight" => "",
                "tabs_fontweight" => "",
                "testimonials_fontsize" => "",
                "testimonials_fontweight" => "",
                "testimonials_lineheight" => "",
                "testimonials_autor_fontsize" => "",
                "testimonials_autor_fontweight" => "",
                "testimonials_autor_lineheight" => "",
                "messagebox_color" => "",
                "messagebox_fontsize" => "",
                "messagebox_fontweight" => "",
                "messagebox_fontstyle" => "",
                "messagebox_lineheight" => "",
                "messagebox_backgroundcolor" => "",
                "messagebox_icon_color" => "",
                "messagebox_icon_fontsize" => "",
                "mobile_main_color" => "",
                "mobile_main_hovercolor" => "",
                "mobile_main_google_fonts" => "-1",
                "mobile_main_fontsize" => "",
                "mobile_main_lineheight" => "",
                "mobile_main_fontstyle" => "",
                "mobile_main_fontweight" => "",
                "mobile_main_letter_spacing" => "",
                "mobile_main_texttransform" => "",
                "mobile_color" => "",
                "mobile_hovercolor" => "",
                "mobile_google_fonts" => "-1",
                "mobile_fontsize" => "",
                "mobile_lineheight" => "",
                "mobile_fontstyle" => "",
                "mobile_fontweight" => "",
                "mobile_letter_spacing" => "",
                "mobile_separator_color" => "",
                "mobile_background_color" => "",
                "animate_title_area" => "no",
                "title_text_shadow" => "no",
                "responsive_title_image" => "",
                "fixed_title_image" => "",
                "title_image" => "",
                "title_image_pattern" => "",
                "title_overlay_image" => "",
                "title_height" => "",
                "page_title_position" => "center",
                "title_background_color" => "",
                "page_title_text_background" => "yes",
                "page_title_text_background_color" => "",
                "header_buttons_color" => "",
                "header_buttons_hovercolor" => "",
                "header_buttons_font_size" => "",
                "uncovering_footer" => "no",
                "footer_in_grid" => "no",
                "footer_text" => "yes",
                "show_footer_top" => "yes",
                "footer_top_columns" => "5",
                "footer_separator_color" => "",
                "footer_top_title_color" => "",
                "footer_top_text_color" => "",
                "footer_link_color" => "",
                "footer_link_hover_color" => "",
                "footer_top_background_color" => "",
                "footer_top_background_image" => "",
                "footer_bottom_text_color" => "",
                "footer_bottom_background_color" => "",
                "vertical_area" => "no",
                "vertical_area_transparency" => "no",
                "vertical_area_background" => "",
                "vertical_area_background_image" => "",
                "vertical_area_text_color" => "",
                "vertical_dropdown_animation" => "",
                "vertical_dropdown_background_color" => "",
                "vertical_dropdown_background_separator_color" => "",
                "vertical_dropdown_background_transparency" => "",
                "vertical_dropdown_background_pattern" => "",
                "vertical_menu_color" => "",
                "vertical_menu_hovercolor" => "",
                "vertical_menu_google_fonts" => "",
                "vertical_menu_fontsize" => "",
                "vertical_menu_lineheight" => "",
                "vertical_menu_fontstyle" => "",
                "vertical_menu_fontweight" => "",
                "vertical_dropdown_color" => "",
                "vertical_dropdown_hovercolor" => "",
                "vertical_dropdown_google_fonts" => "",
                "vertical_dropdown_fontsize" => "",
                "vertical_dropdown_lineheight" => "",
                "vertical_dropdown_fontstyle" => "",
                "vertical_dropdown_fontweight" => "",
                "vertical_dropdown_color_thirdlvl" => "",
                "vertical_dropdown_hovercolor_thirdlvl" => "",
                "vertical_dropdown_google_fonts_thirdlvl" => "",
                "vertical_dropdown_fontsize_thirdlvl" => "",
                "vertical_dropdown_lineheight_thirdlvl" => "",
                "vertical_dropdown_fontstyle_thirdlvl" => "",
                "vertical_dropdown_fontweight_thirdlvl" => "",
                "separator_color" => "",
                "separator_thickness" => "",
                "separator_topmargin" => "",
                "separator_bottommargin" => "",
                "button_title_color" => "",
                "button_title_hovercolor" => "",
                "button_backgroundcolor" => "",
                "button_backgroundcolor_hover" => "",
                "button_bordercolor" => "",
                "button_bordercolor_hover" => "",
                "button_title_google_fonts" => "-1",
                "button_title_fontsize" => "",
                "button_title_lineheight" => "",
                "button_title_fontstyle" => "",
                "button_title_fontweight" => "",
                "button_texttransform" => "",
                "enable_side_area" => "yes",
                "side_area_title" => "",
                "side_area_background_color" => "",
                "side_area_text_color" => "",
                "side_area_title_color" => "",
                "enable_popup_menu" => "no",
                "logo_image_popup" => SOHO_QODE_ROOT . "/img/logo_black.png",
                "popup_menu_color" => "",
                "popup_menu_hover_color" => "",
                "popup_menu_hover_background_color" => "",
                "popup_menu_google_fonts" => "-1",
                "popup_menu_fontsize" => "",
                "popup_menu_lineheight" => "",
                "popup_menu_fontstyle" => "",
                "popup_menu_fontweight" => "",
                "popup_menu_letterspacing" => "",
                "popup_menu_color_2nd" => "",
                "popup_menu_hover_color_2nd" => "",
                "popup_menu_hover_background_color_2nd" => "",
                "popup_menu_google_fonts_2nd" => "-1",
                "popup_menu_fontsize_2nd" => "",
                "popup_menu_lineheight_2nd" => "",
                "popup_menu_fontstyle_2nd" => "",
                "popup_menu_fontweight_2nd" => "",
                "popup_menu_letterspacing_2nd" => "",
                "popup_menu_background_color" => "",
                "popup_menu_background_transparency" => "",
                "portfolio_qode_like" => "on",
                "portfolio_style" => "1",
                "lightbox_single_project" => "no",
                "portfolio_columns_number" => "2",
                "portfolio_single_slug" => "",
                "portfolio_categories" => "",
                "portfolio_text_follow" => "portfolio_single_follow",
                "wp_read_more" => "off",
                "pagination" => "1",
                "pagination_masonry" => "pagination",
                "blog_masonry_filter" => "",
                "blog_style" => "1",
                "category_blog_sidebar" => "default",
                "blog_hide_comments" => "no",
                "blog_page_range" => "",
                "number_of_chars_masonry" => "",
                "blog_hide_post_title" => "no",
                "blog_single_sidebar" => "default",
                "blog_single_sidebar_custom_display" => "",
                "qode_like" => "on",
                "blog_author_info" => "no",
                "receive_mail" => "",
                "enable_contact_form" => "no",
                "email_from" => "",
                "email_subject" => "",
                "use_recaptcha" => "no",
                "recaptcha_public_key" => "",
                "recaptcha_private_key" => "",
                "contact_heading_above" => "",
                "enable_google_map" => "no",
                "google_maps_pin_image" => SOHO_QODE_ROOT . "/img/pin.png",
                "google_maps_address" => "",
                "google_maps_address2" => "",
                "google_maps_address3" => "",
                "google_maps_address4" => "",
                "google_maps_address5" => "",
                "google_maps_zoom" => "12",
                "google_maps_height" => "750",
                "google_maps_style" => "yes",
                "google_maps_color" => "",
                "google_maps_saturation" => "",
                "google_maps_lightness" => "",
                "google_maps_scroll_wheel" => "no",
                "google_maps_iframe" => "",
                "404_title" => "",
                "404_text" => "",
                "404_backlabel" => "",
                "enable_social_share" => "no",
                "enable_facebook_share" => "no",
                "enable_twitter_share" => "no",
                "enable_google_plus" => "no",
                "enable_linkedin" => "no",
                "enable_tumblr" => "no",
                "enable_pinterest" => "no",
                "enable_vk" => "no",
                "facebook_icon" => "",
                "twitter_icon" => "",
                "google_plus_icon" => "",
                "linkedin_icon" => "",
                "tumblr_icon" => "",
                "pinterest_icon" => "",
                "vk_icon" => "",
                "twitter_via" => ""
            );
        }
    }

    add_action( 'after_setup_theme', 'soho_qode_init_global_option' );
}