<?php

/* Add class on body for ajax */

if (!function_exists('soho_qode_ajax_classes')) {
    function soho_qode_ajax_classes($classes) {
        global $qode_options_soho;
        $qode_animation="";
        if (isset($_SESSION['qode_animation'])) $qode_animation = $_SESSION['qode_animation'];
        if(($qode_options_soho['page_transitions'] === "0") && ($qode_animation == "no")) :
            $classes[] = '';
        elseif($qode_options_soho['page_transitions'] === "1" && (empty($qode_animation) || ($qode_animation != "no"))) :
            $classes[] = 'ajax_updown';
            $classes[] = 'page_not_loaded';
        elseif($qode_options_soho['page_transitions'] === "2" && (empty($qode_animation) || ($qode_animation != "no"))) :
            $classes[] = 'ajax_fade';
            $classes[] = 'page_not_loaded';
        elseif($qode_options_soho['page_transitions'] === "3" && (empty($qode_animation) || ($qode_animation != "no"))) :
            $classes[] = 'ajax_updown_fade';
            $classes[] = 'page_not_loaded';
        elseif($qode_options_soho['page_transitions'] === "4" && (empty($qode_animation) || ($qode_animation != "no"))) :
            $classes[] = 'ajax_leftright';
            $classes[] = 'page_not_loaded';
        elseif(!empty($qode_animation) && $qode_animation != "no") :
            $classes[] = 'page_not_loaded';
        else:
            $classes[] ="";
        endif;

        return $classes;
    }

    add_filter('body_class','soho_qode_ajax_classes');
}

/* Add class on body boxed layout */

if (!function_exists('boxed_class')) {
    function soho_qode_boxed_class($classes) {
        global $qode_options_soho;


        if(isset($qode_options_soho['boxed']) && $qode_options_soho['boxed'] == "yes") :
            $classes[] = 'boxed';
        else:
            $classes[] ="";
        endif;

        return $classes;
    }

    add_filter('body_class','soho_qode_boxed_class');
}


/* Add class on body for no elements animation on touch devices */

if (!function_exists('soho_qode_elements_animation_on_touch_class')) {
    function soho_qode_elements_animation_on_touch_class($classes)
    {
        global $qode_options_soho;

        $isMobile = (bool)preg_match('#\b(ip(hone|od|ad)|android|opera m(ob|in)i|windows (phone|ce)|blackberry|tablet' .
            '|s(ymbian|eries60|amsung)|p(laybook|alm|rofile/midp|laystation portable)|nokia|fennec|htc[\-_]' .
            '|mobile|up\.browser|[1-4][0-9]{2}x[1-4][0-9]{2})\b#i', getenv('HTTP_USER_AGENT'));

        if (isset($qode_options_soho['elements_animation_on_touch']) && $qode_options_soho['elements_animation_on_touch'] == "no" && $isMobile == true) :
            $classes[] = 'no_animation_on_touch';
        else:
            $classes[] = "";
        endif;

        return $classes;
    }

    add_filter('body_class','soho_qode_elements_animation_on_touch_class');
}

/* Add class on body for vertical menu */

if (!function_exists('vertical_menu_class')) {
    function soho_qode_vertical_menu_class($classes) {
        global $qode_options_soho;
        global $wp_query;

        if(isset($qode_options_soho['vertical_area']) && $qode_options_soho['vertical_area'] =='yes') :
            $classes[] = 'vertical_menu_enabled';
        endif;

        $id = $wp_query->get_queried_object_id();
        if(isset($qode_options_soho['vertical_area_transparency']) && $qode_options_soho['vertical_area_transparency'] =='yes' && get_post_meta($id, "qode_page_vertical_area_transparency", true) != "no"){
            $classes[] = ' vertical_menu_transparency vertical_menu_transparency_on';
        }else if(get_post_meta($id, "qode_page_vertical_area_transparency", true) == "yes"){
            $classes[] = ' vertical_menu_transparency vertical_menu_transparency_on';
        }
        return $classes;
    }

    add_filter('body_class','soho_qode_vertical_menu_class');
}