<?php

if (!function_exists('soho_qode_comment')) {
function soho_qode_comment($comment, $args, $depth) {

	$GLOBALS['comment'] = $comment;

    $is_pingback_comment = $comment->comment_type == 'pingback';

    $comment_class = 'comment';

    if ( $is_pingback_comment ) {
        $comment_class .= ' pingback-comment';
    }

	?>

<li>                        
	<div class="<?php echo esc_attr( $comment_class );?>">
        <?php if ( ! $is_pingback_comment ) { ?>
		<div class="image"> <?php echo get_avatar($comment, 160); ?> </div>
        <?php } ?>
		<div class="text_outer">
			<div class="text">
				<h4 class="name"><?php if ( $is_pingback_comment ) { esc_html_e( 'Pingback:', 'soho' ); } ?><?php echo get_comment_author_link(); ?> / <span class="comment_date"><?php comment_date('j F Y  g:i '); ?></span></h4>
				<div class="text_holder" id="comment-<?php echo comment_ID(); ?>">
					<?php comment_text(); ?>
				</div>
				<div class="read_more_reply">
					<span class="reply_holder"><i class="fa fa-share"></i><?php comment_reply_link( array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']) ) ); ?></span>
				</div>
			</div>
		</div>	
	</div>
                
<?php if ($comment->comment_approved == '0') : ?>
<p><em><?php esc_html_e('Your comment is awaiting moderation.', 'soho'); ?></em></p>
<?php endif; ?>
<?php 
}
}