<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<?php 
$global_options = soho_qode_return_global_options();
?>
<head>
<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=UA-142222667-1"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'UA-142222667-1');
</script>	
	
	
	

	<!-- Google Tag Manager -->
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-N3MT9KX');</script>
<!-- End Google Tag Manager -->
	
	
	
    <meta charset="<?php bloginfo( 'charset' ); ?>"/>

    <?php
    /**
     * soho_qode_action_header_meta hook
     *
     * @see soho_core_header_meta() - hooked with 10
     * @see soho_qode_user_scalable_meta() - hooked with 10
     */
    do_action( 'soho_qode_action_header_meta' );
    ?>

    <link rel="profile" href="http://gmpg.org/xfn/11"/>
    <?php if ( is_singular() && pings_open( get_queried_object() ) ) : ?>
        <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
    <?php endif; ?>

    <?php do_action('qode_header_meta'); ?>

	<link rel="profile" href="http://gmpg.org/xfn/11" />

	<?php wp_head(); ?>
	
</head>

<body <?php body_class(); ?>>
	
	<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-N3MT9KX"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->

    <?php get_template_part( 'includes/modules/preloader' ); ?>
    <?php get_template_part( 'includes/modules/sidearea' ); ?>

	<div class="wrapper">
	<div class="wrapper_inner">

        <?php do_action( 'soho_qode_after_wrapper_inner_begin' ); ?>

        <?php get_template_part( 'includes/modules/header' ); ?>
        <?php get_template_part( 'includes/modules/back-to-top' ); ?>

    <?php
        $soho_qode_toolbar = soho_qode_return_toolbar_variable();
        if(isset($soho_qode_toolbar)){
            include_once( SOHO_QODE_INCLUDES_ROOT_DIR . "/modules/toolbar_examples.php");
        }
    ?>

    <?php
       $content_class = "";

       $soho_qode_id = soho_qode_get_page_id();

       if(get_post_meta($soho_qode_id, "qode_revolution-slider", true) == "" && get_post_meta($soho_qode_id, "qode_show-page-title", true) != ""){
            $content_class = "content_top_margin";
       }

        $content_background_class = "";
        $content_background_image = "";
        if(isset($global_options['content_background_image']) && $global_options['content_background_image'] != ""){
            $content_background_class = " content_page_background";
            $content_background_image = "background-image:url(".$global_options['content_background_image'].");";
        }

        if(get_post_meta($soho_qode_id, "qode_page-background-image", true) != ""){
            $content_background_class = " content_page_background";
            $content_background_image = "background-image:url(".get_post_meta($soho_qode_id, "qode_page-background-image", true).");";
        }

        $background_color = "";
        if(get_post_meta($soho_qode_id, "qode_page_background_color", true) != ""){
            $background_color = "background-color:".get_post_meta($soho_qode_id, "qode_page_background_color", true).";";
        }

        $animation    = get_post_meta( $soho_qode_id, "qode_show-animation", true );

        if ( ! empty( $_SESSION['qode_animation'] ) && $animation == "" ) {
            $animation = $_SESSION['qode_animation'];
        }
    ?>

	<div class="content <?php echo esc_attr( $content_class ); ?>">
        <?php do_action( 'soho_qode_after_content_begin' ); ?>

			<div class="content_inner <?php echo esc_attr( $animation ); echo esc_attr( $content_background_class );?> " style="<?php echo soho_qode_get_module_part( $content_background_image.$background_color ); ?>">