<?php

require_once get_template_directory() . '/theme-includes.php';

if ( ! function_exists( 'soho_qode_rewrite_rules_on_theme_activation' ) ) {
	function soho_qode_rewrite_rules_on_theme_activation() {
		flush_rewrite_rules();
	}

	add_action( 'after_switch_theme', 'soho_qode_rewrite_rules_on_theme_activation' );
}

if ( ! function_exists( 'soho_qode_add_theme_support' ) ) {
	function soho_qode_add_theme_support() {
		//add support for feed links
		add_theme_support( 'automatic-feed-links' );

		//add theme support for post thumbnails
		add_theme_support( 'post-thumbnails' );

		//add theme support for title tag
		add_theme_support( 'title-tag' );

        //add theme support for post formats
        add_theme_support('post-formats', array('gallery', 'link', 'quote', 'video', 'audio'));

		//defined content width variable
		$GLOBALS['content_width'] = 1060;

        load_theme_textdomain( 'soho', get_template_directory().'/languages' );

		//add theme support for editor style
		add_editor_style( 'css/admin/editor-style.css' );

		add_image_size( 'soho-portfolio-list-square', 550, 550, true ); //for latest post boxes and portfolio list
		add_image_size( 'soho-portfolio-list-portrait', 550, 654, true ); //for blog masonry, latest post boxes and portfolio list
		add_image_size( 'soho-qode-gallery-thumbnail', 840, 470, true );
		add_image_size( 'soho-frame-slider-thumbnail', 645, 426, true );
		add_image_size( 'soho-blog-wide', 1920, 450, true );
		add_image_size( 'soho-blog-image-in-grid', 1100);
		add_image_size( 'soho-blog-small-image-in-grid', 990);

		register_nav_menus(
			array(
				'top-navigation'    => esc_html__( 'Top Navigation', 'soho' ),
				'popup-navigation'  => esc_html__( 'Fullscreen Navigation', 'soho')
			)
		);
	}

	add_action( 'after_setup_theme', 'soho_qode_add_theme_support' );
}



/* Add css */

if (!function_exists('soho_qode_styles')) {
    function soho_qode_styles() {
        global $qode_options_soho;
        global $qode_toolbar;
		global $is_chrome;
        global $is_safari;
		
        wp_enqueue_style("soho-default-style", SOHO_QODE_ROOT . "/style.css");

        wp_enqueue_style( 'wp-mediaelement' );

        do_action( 'soho_qode_action_enqueue_before_main_css' );

        wp_enqueue_style("soho-stylesheet", SOHO_QODE_ROOT . "/css/stylesheet.min.css");

        $responsiveness = "yes";
        if (isset($qode_options_soho['responsiveness'])) {
            $responsiveness = $qode_options_soho['responsiveness'];
        }

        if ($responsiveness != "no"):
            wp_enqueue_style("soho-responsive", SOHO_QODE_ROOT . "/css/responsive.min.css");
        endif;

        if ( soho_qode_is_woocommerce_installed() ) {
            wp_enqueue_style("soho-woocommerce", SOHO_QODE_ROOT . "/css/woocommerce.min.css");
            if ($responsiveness != "no"):
                wp_enqueue_style("soho-woocommerce-responsive", SOHO_QODE_ROOT . "/css/woocommerce_responsive.min.css");
            endif;
        }
		
		preg_match( "#Chrome/(.+?)\.#", getenv('HTTP_USER_AGENT'), $match );
		
		if(!empty($match)){
		    $version = $match[1];
		} else {
		    $version = 0;
		}

		$mac_os = strpos(getenv('HTTP_USER_AGENT'), "Macintosh; Intel Mac OS X");
		
		if($is_chrome && ($mac_os !== false) && ($version > 21)) {
		  wp_enqueue_style("soho-mac-stylesheet", SOHO_QODE_ROOT . "/css/mac_stylesheet.css");
		}

        if($is_chrome || $is_safari) {
            wp_enqueue_style("soho-webkit", SOHO_QODE_ROOT . "/css/webkit_stylesheet.css");
        }

        if ( file_exists( SOHO_QODE_CSS_ROOT_DIR . '/style_dynamic.css' ) && soho_qode_is_css_folder_writable() && ! is_multisite() ) {
            wp_enqueue_style( 'soho-style-dynamic', SOHO_QODE_CSS_ROOT . '/style_dynamic.css', array(), filemtime( SOHO_QODE_CSS_ROOT_DIR . '/style_dynamic.css' ) );
        } else if ( file_exists( SOHO_QODE_CSS_ROOT_DIR . '/style_dynamic_ms_id_' . soho_qode_get_multisite_blog_id() . '.css' ) && soho_qode_is_css_folder_writable() && is_multisite() ) {
            wp_enqueue_style( 'soho-style-dynamic', SOHO_QODE_CSS_ROOT . '/style_dynamic_ms_id_' . soho_qode_get_multisite_blog_id() . '.css', array(), filemtime( SOHO_QODE_CSS_ROOT_DIR . '/style_dynamic_ms_id_' . soho_qode_get_multisite_blog_id() . '.css' ) );
        } else {
            wp_enqueue_style( 'soho-style-dynamic', SOHO_QODE_CSS_ROOT . '/style_dynamic_callback.php' ); // Temporary case for Major update
        }

        $vertical_area = "no";
        if (isset($qode_options_soho['vertical_area'])){
            $vertical_area = $qode_options_soho['vertical_area'];
        }
        if($vertical_area == "yes" && $responsiveness != "no"){
            wp_enqueue_style("soho-vertical-responsive", SOHO_QODE_ROOT . "/css/vertical_responsive.css");
        }

        if (isset($qode_toolbar)):
            wp_enqueue_style("soho-toolbar", SOHO_QODE_ROOT . "/css/toolbar.css");
        endif;

        wp_enqueue_style( 'js_composer_front' );

        $custom_css = $qode_options_soho['custom_css'];

        if ( ! empty( $custom_css ) ) {
            wp_add_inline_style( 'soho-style-dynamic', $custom_css );
        }

        $font_weight_str = '200,300,300i,400,400i,600,600i,700,700i,800';
        $font_subset_str = 'latin,latin-ext';

        //default fonts
        $default_font_family = array(
            'Raleway'
        );

        $modified_default_font_family = array();
        foreach ( $default_font_family as $default_font ) {
            $modified_default_font_family[] = $default_font . ':' . str_replace( ' ', '', $font_weight_str );
        }

        $default_font_string = implode( '|', $modified_default_font_family );

        $available_font_options = array_filter( array(
            $qode_options_soho['google_fonts'],
            $qode_options_soho['page_title_google_fonts'],
            $qode_options_soho['h1_google_fonts'],
            $qode_options_soho['h2_google_fonts'],
            $qode_options_soho['h3_google_fonts'],
            $qode_options_soho['h4_google_fonts'],
            $qode_options_soho['h5_google_fonts'],
            $qode_options_soho['h6_google_fonts'],
            $qode_options_soho['text_google_fonts'],
            $qode_options_soho['menu_google_fonts'],
            $qode_options_soho['dropdown_google_fonts'],
            $qode_options_soho['dropdown_google_fonts_thirdlvl'],
            $qode_options_soho['fixed_google_fonts'],
            $qode_options_soho['sticky_google_fonts'],
            $qode_options_soho['mobile_google_fonts'],
            $qode_options_soho['mobile_main_google_fonts'],
            $qode_options_soho['button_title_google_fonts'],
            $qode_options_soho['vertical_menu_google_fonts'],
            $qode_options_soho['vertical_dropdown_google_fonts'],
            $qode_options_soho['vertical_dropdown_google_fonts_thirdlvl'],
            $qode_options_soho['popup_menu_google_fonts'],
            $qode_options_soho['popup_menu_google_fonts_2nd']
        ) );

        $additional_fonts_args  = array( 'post_status' => 'publish', 'post_type' => 'slides', 'posts_per_page' => - 1 );
        $additional_fonts_query = new WP_Query( $additional_fonts_args );

        if ( $additional_fonts_query->have_posts() ):
            while ( $additional_fonts_query->have_posts() ) : $additional_fonts_query->the_post();
                $post_id = get_the_ID();

                if ( get_post_meta( $post_id, "qode_slide-title-font-family", true ) != "" ) {
                    array_push( $available_font_options, get_post_meta( $post_id, "qode_slide-title-font-family", true ) );
                }
                if ( get_post_meta( $post_id, "qode_slide-text-font-family", true ) != "" ) {
                    array_push( $available_font_options, get_post_meta( $post_id, "qode_slide-text-font-family", true ) );
                }
            endwhile;
        endif;

        wp_reset_postdata();

        //define available font options array
        $fonts_array = array();
        if ( ! empty( $available_font_options ) ) {
            foreach ( $available_font_options as $font_option_value ) {
                $font_option_string = $font_option_value . ':' . $font_weight_str;

                if ( ! in_array( str_replace( '+', ' ', $font_option_value ), $default_font_family ) && ! in_array( $font_option_string, $fonts_array ) ) {
                    $fonts_array[] = $font_option_string;
                }
            }

            $fonts_array = array_diff( $fonts_array, array( '-1:' . $font_weight_str ) );
        }

        $google_fonts_string = implode( '|', $fonts_array );

        $protocol = is_ssl() ? 'https:' : 'http:';

        //is google font option checked anywhere in theme?
        if ( count( $fonts_array ) > 0 ) {

            //include all checked fonts
            $fonts_full_list      = $default_font_string . '|' . str_replace( '+', ' ', $google_fonts_string );
            $fonts_full_list_args = array(
                'family' => urlencode( $fonts_full_list ),
                'subset' => urlencode( $font_subset_str ),
            );

            $soho_global_fonts = add_query_arg( $fonts_full_list_args, $protocol . '//fonts.googleapis.com/css' );
            wp_enqueue_style( 'soho-google-fonts', esc_url_raw( $soho_global_fonts ), array(), '1.0.0' );

        } else {
            //include default google font that theme is using
            $default_fonts_args          = array(
                'family' => urlencode( $default_font_string ),
                'subset' => urlencode( $font_subset_str ),
            );
            $soho_global_fonts = add_query_arg( $default_fonts_args, $protocol . '//fonts.googleapis.com/css' );
            wp_enqueue_style( 'soho-google-fonts', esc_url_raw( $soho_global_fonts ), array(), '1.0.0' );
        }

    }

    add_action('wp_enqueue_scripts', 'soho_qode_styles');
}

/* Add js */

if (!function_exists('soho_qode_scripts')) {
    function soho_qode_scripts() {
        global $qode_options_soho;
        global $is_IE;
		global $is_chrome;
		global $is_opera;
        global $qode_toolbar;
        global $woocommerce;
		
		$smooth_scroll = true;
		if(isset($qode_options_soho['smooth_scroll']) && $qode_options_soho['smooth_scroll'] == "no"){
			$smooth_scroll = false;
		}


        wp_enqueue_script("doubleTapToGo", SOHO_QODE_ROOT."/js/plugins/doubletaptogo.js",array('jquery'),false,true);
        wp_enqueue_script("modernizr", SOHO_QODE_ROOT."/js/plugins/modernizr.min.js",array('jquery'),false,true);
        wp_enqueue_script("appear", SOHO_QODE_ROOT."/js/plugins/jquery.appear.js",array('jquery'),false,true);
        wp_enqueue_script("hoverIntent");
        wp_enqueue_script( 'jquery-ui-core' );
        wp_enqueue_script( 'jquery-ui-widget' );
        wp_enqueue_script( 'jquery-ui-mouse' );
        wp_enqueue_script( 'jquery-ui-draggable' );
        wp_enqueue_script( 'jquery-ui-droppable' );
        wp_enqueue_script( 'jquery-ui-resizable' );
        wp_enqueue_script( 'jquery-ui-selectable' );
        wp_enqueue_script( 'jquery-ui-sortable' );
        wp_enqueue_script( 'jquery-ui-accordion' );
        wp_enqueue_script( 'jquery-ui-autocomplete' );
        wp_enqueue_script( 'jquery-ui-button' );
        wp_enqueue_script( 'jquery-ui-datepicker' );
        wp_enqueue_script( 'jquery-ui-dialog' );
        wp_enqueue_script( 'jquery-effects-core' );
        wp_enqueue_script( 'jquery-effects-blind' );
        wp_enqueue_script( 'jquery-effects-bounce' );
        wp_enqueue_script( 'jquery-effects-clip' );
        wp_enqueue_script( 'jquery-effects-drop' );
        wp_enqueue_script( 'jquery-effects-explode' );
        wp_enqueue_script( 'jquery-effects-fade' );
        wp_enqueue_script( 'jquery-effects-fold' );
        wp_enqueue_script( 'jquery-effects-highlight' );
        wp_enqueue_script( 'jquery-effects-pulsate' );
        wp_enqueue_script( 'jquery-effects-scale' );
        wp_enqueue_script( 'jquery-effects-shake' );
        wp_enqueue_script( 'jquery-effects-slide' );
        wp_enqueue_script( 'jquery-effects-transfer' );
        wp_enqueue_script( 'jquery-ui-menu' );
        wp_enqueue_script( 'jquery-ui-position' );
        wp_enqueue_script( 'jquery-ui-progressbar' );
        wp_enqueue_script( 'jquery-ui-slider' );
        wp_enqueue_script( 'jquery-ui-spinner' );
        wp_enqueue_script( 'jquery-ui-tabs' );
        wp_enqueue_script( 'jquery-ui-tooltip' );
        wp_enqueue_script("absoluteCounter", SOHO_QODE_ROOT."/js/plugins/absoluteCounter.min.js",array('jquery'),false,true);
        wp_enqueue_script("easyPieChart", SOHO_QODE_ROOT."/js/plugins/easyPieChart.min.js",array('jquery'),false,true);
        wp_enqueue_script("mixItUp", SOHO_QODE_ROOT."/js/plugins/mixItUp.min.js",array('jquery'),false,true);
        wp_enqueue_script("prettyPhoto", SOHO_QODE_ROOT."/js/plugins/jquery.prettyPhoto.js",array('jquery'),false,true);
        wp_enqueue_script("fitVids", SOHO_QODE_ROOT."/js/plugins/jquery.fitvids.js",array('jquery'),false,true);
        wp_enqueue_script("flexSlider", SOHO_QODE_ROOT."/js/plugins/jquery.flexslider-min.js",array('jquery'),false,true);
        wp_enqueue_script( 'wp-mediaelement' );
        wp_enqueue_script("isotope", SOHO_QODE_ROOT."/js/plugins/jquery.isotope.js",array('jquery'),false,true);
        wp_enqueue_script("infiniteScroll", SOHO_QODE_ROOT."/js/plugins/infiniteScroll.min.js",array('jquery'),false,true);
        wp_enqueue_script("waitForImages", SOHO_QODE_ROOT."/js/plugins/jquery.waitforimages.js",array('jquery'),false,true);
        wp_enqueue_script( 'jquery-form' );
        wp_enqueue_script("waypoints", SOHO_QODE_ROOT."/js/plugins/waypoints.min.js",array('jquery'),false,true);
        wp_enqueue_script("jPlayer", SOHO_QODE_ROOT."/js/plugins/jplayer.min.js",array('jquery'),false,true);
        wp_enqueue_script("bootstrapCarousel", SOHO_QODE_ROOT."/js/plugins/bootstrap.carousel.js",array('jquery'),false,true);
        wp_enqueue_script("skrollr", SOHO_QODE_ROOT."/js/plugins/skrollr.js",array('jquery'),false,true);
        wp_enqueue_script("chart", SOHO_QODE_ROOT."/js/plugins/Chart.min.js",array('jquery'),false,true);
        wp_enqueue_script("easing", SOHO_QODE_ROOT."/js/plugins/jquery.easing.1.3.js",array('jquery'),false,true);



		wp_enqueue_script("carouFredSel", SOHO_QODE_ROOT."/js/plugins/jquery.carouFredSel-6.2.1.js",array('jquery'),false,true);
		wp_enqueue_script("mousewheel", SOHO_QODE_ROOT."/js/plugins/jquery.mousewheel.min.js",array('jquery'),false,true);
		wp_enqueue_script("touchSwipe", SOHO_QODE_ROOT."/js/plugins/jquery.touchSwipe.min.js",array('jquery'),false,true);
		
		if(($is_chrome || $is_opera) && $smooth_scroll){ 
			wp_enqueue_script("smoothScroll", SOHO_QODE_ROOT."/js/plugins/SmoothScroll.js",array('jquery'),false,true);
		}

        if ( $is_IE ) {
            wp_enqueue_script("html5", SOHO_QODE_ROOT."/js/plugins/html5.js",array('jquery'),false,false);
        }
        if($qode_options_soho['enable_google_map'] == "yes") :
            if(isset($qode_options_soho['google_maps_api_key']) && $qode_options_soho['google_maps_api_key'] != '') {
               $google_maps_api_key = $qode_options_soho['google_maps_api_key'];
               wp_enqueue_script("google_map_api", "https://maps.googleapis.com/maps/api/js?key=" . $google_maps_api_key,array('jquery'),false,true);
            }
        endif;

        if ( file_exists( SOHO_QODE_JS_ROOT_DIR . '/default_dynamic.js' ) && soho_qode_is_js_folder_writable() && ! is_multisite() ) {
            wp_enqueue_script( 'soho-default-dynamic', SOHO_QODE_JS_ROOT . '/default_dynamic.js', array('jquery'), filemtime( SOHO_QODE_JS_ROOT_DIR . '/default_dynamic.js' ), true );
        } else if ( file_exists( SOHO_QODE_JS_ROOT_DIR . '/default_dynamic_ms_id_' . soho_qode_get_multisite_blog_id() . '.js' ) && soho_qode_is_js_folder_writable() && is_multisite() ) {
            wp_enqueue_script( 'soho-default-dynamic', SOHO_QODE_JS_ROOT . '/default_dynamic_ms_id_' . soho_qode_get_multisite_blog_id() . '.js', array('jquery'), filemtime( SOHO_QODE_JS_ROOT_DIR . '/default_dynamic_ms_id_' . soho_qode_get_multisite_blog_id() . '.js' ), true );
        } else {
            wp_enqueue_script( 'soho-default-dynamic', SOHO_QODE_JS_ROOT . '/default_dynamic_callback.php', array('jquery'), false, true ); // Temporary case for Major update
        }

        wp_enqueue_script("soho-default", SOHO_QODE_ROOT."/js/default.min.js",array('jquery'),false,true);

        $custom_js = $qode_options_soho['custom_js'];
        if ( ! empty( $custom_js ) ) {
            wp_add_inline_script( 'soho-default', $custom_js );
        }

        global $wp_scripts;
        $wp_scripts->add_data('comment-reply', 'group', 1 );

        if ( is_singular() ) {
            wp_enqueue_script( "comment-reply");
        }

        $has_ajax = false;
        $qode_animation = "";

        if (isset($_SESSION['qode_theme18_page_transitions'])) {
            $qode_animation = $_SESSION['qode_theme18_page_transitions'];
        }

        if (($qode_options_soho['page_transitions'] != "0") && (empty($qode_animation) || ($qode_animation != "no"))) {
            $has_ajax = true;
        } elseif (!empty($qode_animation) && ($qode_animation != "no")) {
            $has_ajax = true;
        }

        if ($has_ajax) :
            wp_enqueue_script("soho-ajax", SOHO_QODE_ROOT."/js/ajax.min.js",array('jquery'),false,true);
        endif;
        wp_enqueue_script( 'wpb_composer_front_js' );

        if($qode_options_soho['use_recaptcha'] == "yes") :
        wp_enqueue_script("recaptcha_ajax", "http://www.google.com/recaptcha/api/js/recaptcha_ajax.js",array('jquery'),false,true);
        endif;

        if(isset($qode_toolbar)):
            wp_enqueue_script("soho-toolbar", SOHO_QODE_ROOT."/js/toolbar.js",array('jquery'),false,true);
        endif;

        if($woocommerce) {
            wp_enqueue_script("soho-woocommerce", SOHO_QODE_ROOT."/js/woocommerce.js",array('jquery'),false,true);
            wp_enqueue_script("select2", SOHO_QODE_ROOT."/js/plugins/select2.min.js",array('jquery'),false,true);
        }
    }

    add_action('wp_enqueue_scripts', 'soho_qode_scripts');
}

/* Add admin js and css */

if (!function_exists('soho_qode_admin_jquery')) {
    function soho_qode_admin_jquery() {
        wp_enqueue_script('jquery-ui-datepicker');
        wp_enqueue_script('jquery-ui-accordion');
        wp_enqueue_style('soho-admin-style', SOHO_QODE_ROOT.'/css/admin/admin-style.css', false, '1.0', 'screen');
        wp_enqueue_style('soho-admin-colorstyle', SOHO_QODE_ROOT.'/css/admin/colorpicker.css', false, '1.0', 'screen');
        wp_enqueue_script('color-pickers', SOHO_QODE_ROOT.'/js/admin/colorpicker.js', array('jquery'), '1.0.0', false );
        wp_enqueue_style('thickbox');
        wp_enqueue_script('thickbox');
        wp_enqueue_media();
        wp_enqueue_script('soho-admin-default', SOHO_QODE_ROOT.'/js/admin/default.js', array('jquery'), '1.0.0', false );
        wp_enqueue_script('common');
        wp_enqueue_script('wp-lists');
        wp_enqueue_script('postbox');
    }

    add_action('admin_enqueue_scripts', 'soho_qode_admin_jquery');
}

if ( ! function_exists( 'soho_qode_set_global_variables' ) ) {
    function soho_qode_set_global_variables() {
        $sticky_scroll_amount = get_post_meta( soho_qode_get_page_id(), "qode_page_scroll_amount_for_sticky", true );
        
        if ( $sticky_scroll_amount !== '' ) {
            wp_localize_script( 'soho-default', 'page_scroll_amount_for_sticky', $sticky_scroll_amount );
        }
    }

    add_action( 'wp_enqueue_scripts', 'soho_qode_set_global_variables' );
}

/* Excerpt more */

if (!function_exists('soho_qode_excerpt_more')) {
    function soho_qode_excerpt_more($more ) {
        return '...';
    }

    add_filter('excerpt_more', 'soho_qode_excerpt_more');
}

/* Excerpt lenght */

if (!function_exists('soho_qode_excerpt_length')) {
    function soho_qode_excerpt_length($length ) {
        global $qode_options_soho;
        if($qode_options_soho['number_of_chars']){
             return $qode_options_soho['number_of_chars'];
        } else {
            return 45;
        }
    }

    add_filter( 'excerpt_length', 'soho_qode_excerpt_length', 999 );
}

/* Social excerpt lenght */

if (!function_exists('soho_qode_the_excerpt_max_charlength')) {
    function soho_qode_the_excerpt_max_charlength($charlength) {
        global $qode_options_soho;

        if(isset($qode_options_soho['twitter_via']) && !empty($qode_options_soho['twitter_via'])) {
            $via = " via " . $qode_options_soho['twitter_via'] . " ";
        } else {
            $via = 	"";
        }

        $excerpt = get_the_excerpt();
        $charlength = 140 - (mb_strlen($via) + $charlength);

        if ( mb_strlen( $excerpt ) > $charlength ) {
            $subex = mb_substr( $excerpt, 0, $charlength);
            $exwords = explode( ' ', $subex );
            $excut = - ( mb_strlen( $exwords[ count( $exwords ) - 1 ] ) );
            if ( $excut < 0 ) {
                return mb_substr( $subex, 0, $excut );
            } else {
                return $subex;
            }
        } else {
            return $excerpt;
        }
    }
}

if(!function_exists('soho_qode_excerpt')) {
	/**
	* Function that cuts post excerpt to the number of word based on previosly set global
	* variable $word_count, which is defined in qode_set_blog_word_count function
	*/
	function soho_qode_excerpt() {
        $global_options = soho_qode_return_global_options();
        global $word_count, $post;

        if ( post_password_required() ) {
            echo get_the_password_form();
        } else {
            $word_count    = isset( $word_count ) && $word_count != "" ? $word_count : $global_options['number_of_chars'];
            $post_excerpt = $post->post_excerpt !== '' ? $post->post_excerpt : strip_tags( strip_shortcodes( $post->post_content ) );
            $clean_excerpt = strlen( $post_excerpt ) && strpos( $post_excerpt, '...' ) ? strstr( $post_excerpt, '...', true ) : $post_excerpt;

            if ( $clean_excerpt !== '' ) {
                $excerpt_word_array = explode( ' ', $clean_excerpt );
                $excerpt_word_array = array_slice( $excerpt_word_array, 0, $word_count );
                $excerpt            = implode( ' ', $excerpt_word_array ) . '...';

                echo '<p>' . wp_kses_post( $excerpt ) . '</p>';
            }
        }
	}
}

if(!function_exists('soho_qode_set_blog_word_count')) {
	/**
	* Function that sets global blog word count variable used by qode_excerpt function 
	*/
	function soho_qode_set_blog_word_count($word_count_param) {
		global $word_count;

		$word_count = $word_count_param;
	}
}

/* Use slider instead of image for post */

if (!function_exists('soho_qode_slider_blog')) {
    function soho_qode_slider_blog($post_id) {
        $sliders = get_post_meta($post_id, "qode_sliders", true);
        $slider = $sliders[1];
        if($slider) {
            $html = '';
            $html .= '<div class="flexslider"><ul class="slides">';
            $i=0;
            while (isset($slider[$i])){
                $slide = $slider[$i];

                $href = $slide['link'];
                $baseurl = esc_url( home_url() );
                $baseurl = str_replace('http://', '', $baseurl);
                $baseurl = str_replace('www', '', $baseurl);
                $host = parse_url($href, PHP_URL_HOST);
                if($host != $baseurl) {
                    $target = 'target="_blank"';
                }
                else {
                    $target = 'target="_self"';
                }

                $html .= '<li class="slide ' . $slide[imgsize] . '">';
                $html .= '<div class="image"><img src="' . $slide[img] . '" alt="' . $slide[title] . '" /></div>';

                $html .= '</li>';
                $i++;
            }
            $html .= '</ul></div>';
        }
        return $html;
    }
}

/* Get Page ID */

if(!function_exists('soho_qode_init_page_id')) {
	function soho_qode_init_page_id() {
		global $wp_query;
		global $qode_page_id;

		$qode_page_id = $wp_query->get_queried_object_id();
	}

    add_action('get_header', 'soho_qode_init_page_id');
}

if (!function_exists('soho_qode_compare_slides')) {
    function soho_qode_compare_slides($a, $b){
        if (isset($a['ordernumber']) && isset($b['ordernumber'])) {
        if ($a['ordernumber'] == $b['ordernumber']) {
            return 0;
        }
        return ($a['ordernumber'] < $b['ordernumber']) ? -1 : 1;
      }
      return 0;
    }
}

if (!function_exists('soho_qode_compare_portfolio_images')) {
    function soho_qode_compare_portfolio_images($a, $b){
        if (isset($a['portfolioimgordernumber']) && isset($b['portfolioimgordernumber'])) {
        if ($a['portfolioimgordernumber'] == $b['portfolioimgordernumber']) {
            return 0;
        }
            return ($a['portfolioimgordernumber'] < $b['portfolioimgordernumber']) ? -1 : 1;
        }
      return 0;
    }
}

if (!function_exists('soho_qode_compare_portfolio_options')){
    function soho_qode_compare_portfolio_options($a, $b){
        if (isset($a['optionlabelordernumber']) && isset($b['optionlabelordernumber'])) {
        if ($a['optionlabelordernumber'] == $b['optionlabelordernumber']) {
            return 0;
        }
        return ($a['optionlabelordernumber'] < $b['optionlabelordernumber']) ? -1 : 1;
      }
      return 0;
    }
}

if (!function_exists('soho_qode_gallery_upload_get_images')){
    function soho_qode_gallery_upload_get_images(){
	    check_ajax_referer('soho-qode-update-images-nonce', 'upload_gallery_nonce');
	    foreach($_POST['ids'] as $id):
            $image = wp_get_attachment_image_src($id,'thumbnail', true);
            echo '<li class="qode-gallery-image-holder"><img src="'.$image[0].'"/></li>';
        endforeach;
        exit;
    }

    add_action( 'wp_ajax_soho_qode_gallery_upload_get_images', 'soho_qode_gallery_upload_get_images');
}

if (!function_exists('soho_qode_hex2rgb')) {
    function soho_qode_hex2rgb($hex) {
       $hex = str_replace("#", "", $hex);

       if(strlen($hex) == 3) {
          $r = hexdec(substr($hex,0,1).substr($hex,0,1));
          $g = hexdec(substr($hex,1,1).substr($hex,1,1));
          $b = hexdec(substr($hex,2,1).substr($hex,2,1));
       } else {
          $r = hexdec(substr($hex,0,2));
          $g = hexdec(substr($hex,2,2));
          $b = hexdec(substr($hex,4,2));
       }
       $rgb = array($r, $g, $b);
       return $rgb; // returns an array with the rgb values
    }
}

if (!function_exists('soho_qode_remove_vc_grid_element')) {
	/**
	 * Function that removes Grid Elements Post Type
	 * that comes with Visual Composer from version 4.4.2
	 */
	function soho_qode_remove_vc_grid_element() {

		remove_action( 'init', 'vc_grid_item_editor_create_post_type' );

	}

	add_action('vc_after_init', 'soho_qode_remove_vc_grid_element', 12);

}

if(!function_exists('soho_qode_get_vc_version')) {
    /**
     * Return Visual Composer version string
     *
     * @return bool|string
     */
    function soho_qode_get_vc_version() {
        if(soho_qode_visual_composer_installed()) {
            return WPB_VC_VERSION;
        }

        return false;
    }
}

if(!function_exists('soho_qode_visual_composer_installed')) {
    /**
     * Function that checks if visual composer installed
     * @return bool
     */
    function soho_qode_visual_composer_installed() {
        //is Visual Composer installed?
        if(class_exists('WPBakeryVisualComposerAbstract')) {
            return true;
        }

        return false;
    }
}

if(!function_exists('soho_qode_admin_notice')) {
    /**
     * Prints admin notice. It checks if notice has been disabled and if it hasn't then it displays it
     * @param $id string id of notice. It will be used to store notice dismis
     * @param $message string message to show to the user
     * @param $class string HTML class of notice
     * @param bool $is_dismisable whether notice is dismisable or not
     */
    function soho_qode_admin_notice($id, $message, $class, $is_dismisable = true) {
        $is_dismised = get_user_meta(get_current_user_id(), 'dismis_'.$id);

        //if notice isn't dismissed
        if(!$is_dismised && is_admin()) {
            echo '<div style="display: block;" class="'.esc_attr($class).' is-dismissible notice">';
            echo '<p>';

            echo wp_kses_post($message);

            if($is_dismisable) {
                echo '<strong style="display: block; margin-top: 7px;"><a href="'.esc_url(add_query_arg('qode_dismis_notice', $id)).'">'.esc_html__('Dismiss this notice', 'soho').'</a></strong>';
            }

            echo '</p>';

            echo '</div>';
        }

    }
}

if(!function_exists('soho_qode_save_dismisable_notice')) {
    /**
     * Updates user meta with dismisable notice. Hooks to admin_init action
     * in order to check this on every page request in admin
     */
    function soho_qode_save_dismisable_notice() {
        if(is_admin() && !empty($_GET['qode_dismis_notice'])) {
            $notice_id = sanitize_key($_GET['qode_dismis_notice']);
            $current_user_id = get_current_user_id();

            update_user_meta($current_user_id, 'dismis_'.$notice_id, 1);
        }
    }

    add_action('admin_init', 'soho_qode_save_dismisable_notice');
}

if(!function_exists('soho_qode_wp_title')) {
    /**
     * Function that sets page's title. Hooks to wp_title filter
     * @param $title string current page title
     * @param $sep string title separator
     * @return string changed title text if SEO plugins aren't installed
     *
     * @since 4.3
     * @version 0.2
     */
    function soho_qode_wp_title($title, $sep) {
        global $qode_options_soho;

        //is SEO plugin installed?
        if(soho_core_seo_plugin_installed()) {
            //don't do anything, seo plugin will take care of it
        } else {
            //get current post id
            $id = soho_qode_get_page_id();
            $sep = ' | ';
            $title_prefix = get_bloginfo('name');
            $title_suffix = '';

            //is WooCommerce installed and is current page shop page?
            if(soho_qode_is_woocommerce_installed() && soho_qode_is_woocommerce_shop()) {
                //get shop page id
                $id = soho_qode_get_woo_shop_page_id();
            }

            //set unchanged title variable so we can use it later
            $unchanged_title = $title;

            //is qode seo enabled?
            if(isset($qode_options_soho['disable_qode_seo']) && $qode_options_soho['disable_qode_seo'] !== 'yes') {
                //get current post seo title
                $seo_title = get_post_meta($id, "qode_seo_title", true);

                //is current post seo title set?
                if($seo_title !== '') {
                    $title_suffix = $seo_title;
                }
            }

            //title suffix is empty, which means that it wasn't set by qode seo
            if(empty($title_suffix)) {
                //if current page is front page append site description, else take original title string
                $title_suffix = is_front_page() ? get_bloginfo('description') : $unchanged_title;
            }

            //concatenate title string
            $title  = $title_prefix.$sep.$title_suffix;

            //return generated title string
            return $title;
        }
    }

    add_filter('wp_title', 'soho_qode_wp_title', 10, 2);
}

if(!function_exists('soho_qode_get_page_id')) {
    /**
     * Function that returns current page / post id.
     * Checks if current page is woocommerce page and returns that id if it is.
     * Checks if current page is any archive page (category, tag, date, author etc.) and returns -1 because that isn't
     * page that is created in WP admin.
     *
     * @return int
     *
     * @version 0.1
     *
     * @see qode_is_woocommerce_installed()
     * @see soho_qode_is_woocommerce_shop()
     */
    function soho_qode_get_page_id() {
        if(soho_qode_is_woocommerce_installed() && soho_qode_is_woocommerce_shop()) {
            return soho_qode_get_woo_shop_page_id();
        }

        if ( is_archive() || is_search() || is_404() || ( is_front_page() && is_home() ) ) {
            return - 1;
        }

        return get_queried_object_id();
    }
}

if ( ! function_exists( 'soho_qode_user_scalable_meta' ) ) {
    /**
     * Function that outputs user scalable meta if responsiveness is turned on
     * Hooked to soho_qode_action_header_meta action
     */
    function soho_qode_user_scalable_meta() {
        $global_options = soho_qode_return_global_options();

        //is responsiveness option is chosen?
        if ( isset( $global_options['responsiveness'] ) && $global_options['responsiveness'] !== 'no' ) { ?>
            <meta name=viewport content="width=device-width,initial-scale=1,user-scalable=no">
        <?php } else { ?>
            <meta name=viewport content="width=1200,user-scalable=no">
        <?php }
    }

    add_action( 'soho_qode_action_header_meta', 'soho_qode_user_scalable_meta' );
}

if ( ! function_exists('soho_qode_is_gutenberg_installed') ) {
    /**
     * Function that checks if Gutenberg plugin installed
     */
    function soho_qode_is_gutenberg_installed() {
        if ( function_exists( 'is_gutenberg_page' ) ) {
            if(is_admin()){
                wp_enqueue_style( 'gutenberg-fix', get_template_directory_uri() . '/css/gutenberg.css', array(), '1.0' );
            }
        }
    }

    add_action( 'admin_enqueue_scripts', 'soho_qode_is_gutenberg_installed' );
}

if ( ! function_exists( 'soho_qode_enqueue_editor_customizer_styles' ) ) {
    /**
     * Enqueue supplemental block editor styles
     */
    function soho_qode_enqueue_editor_customizer_styles() {
        $protocol = is_ssl() ? 'https:' : 'http:';
        //include default google font that theme is using
        $default_fonts_args          = array(
            'family' => urlencode( 'Raleway:300,400,600,700' ),
            'subset' => urlencode( 'latin-ext' ),
        );
        $soho_global_fonts = add_query_arg( $default_fonts_args, $protocol . '//fonts.googleapis.com/css' );
        wp_enqueue_style( 'soho-editor-google-fonts', esc_url_raw( $soho_global_fonts ) );

        wp_enqueue_style( 'soho-editor-customizer-style', SOHO_QODE_CSS_ROOT . '/admin/editor-customizer-style.css' );
        wp_enqueue_style( 'soho-editor-blocks-style', SOHO_QODE_CSS_ROOT . '/admin/editor-blocks-style.css' );
    }

    add_action( 'enqueue_block_editor_assets', 'soho_qode_enqueue_editor_customizer_styles' );
}