<?php
	if(get_comments_number() == 0){ ?>
		<div class="comment_holder q_no_comments clearfix" id="comments">
	<?php } else { ?>
		<div class="comment_holder clearfix" id="comments">
	<?php }
?>

<div class="comment_number"><div class="comment_number_inner"><h4><?php comments_number( esc_html__('No Comments','soho'), '<span>1</span>'.esc_html__('Comment','soho'), '<span>%</span>'.esc_html__('Comments','soho')); ?></h4></div></div>
<div class="comments">
<?php if ( post_password_required() ) : ?>
			<p class="nopassword"><?php esc_html_e( 'This post is password protected. Enter the password to view any comments.', 'soho' ); ?></p>
		</div></div>
<?php
		return;
	endif;
?>
<?php if ( have_comments() ) : ?>

	<ul class="comment-list">
		<?php wp_list_comments(array( 'callback' => 'soho_qode_comment')); ?>
	</ul>


<?php // End Comments ?>

 <?php else : // this is displayed if there are no comments so far 

	if ( ! comments_open() ) :
?>
		<!-- If comments are open, but there are no comments. -->
	 
		<!-- If comments are closed. -->
		<p><?php esc_html_e('Sorry, the comment form is closed at this time.', 'soho'); ?></p>

	<?php endif; ?>
<?php endif; ?>
</div></div>
<?php
$commenter = wp_get_current_commenter();
$req = get_option( 'require_name_email' );
$aria_req = ( $req ? " aria-required='true'" : '' );
$consent  = empty( $commenter['comment_author_email'] ) ? '' : ' checked="checked"';

$args = array(
	'id_form' => 'commentform',
	'id_submit' => 'submit_comment',
	'title_reply'=>'<h4>'. esc_html__( 'Leave a Comment','soho' ) .'</h4>',
	'title_reply_to' => esc_html__( 'Post A Reply to %s','soho' ),
	'cancel_reply_link' => esc_html__( 'Cancel Reply','soho' ),
	'label_submit' => esc_html__( 'POST COMMENT','soho' ),
	'comment_field' => '<textarea id="comment" placeholder="' . esc_html__( 'Write Your Message Here', 'soho' ) . '" name="comment" cols="45" rows="8" aria-required="true"></textarea>',
	'comment_notes_before' => '',
	'comment_notes_after' => '',
	'fields' => apply_filters( 'comment_form_default_fields', array(
		'author' => '<div class="three_columns clearfix"><div class="column1"><div class="column_inner"><input id="author" placeholder="' . esc_html__( 'First Name *', 'soho' ) . '" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '"' . $aria_req . ' /></div></div>',
		'url' => '<div class="column2"><div class="column_inner"><input id="email" placeholder="' . esc_html__( 'E-mail *', 'soho' ) . '" name="email" type="text" value="' . esc_attr(  $commenter['comment_author_email'] ) . '"' . $aria_req . ' /></div></div>',
		'email' => '<div class="column3"><div class="column_inner"><input id="url" placeholder="' . esc_html__( 'Website', 'soho' ) . '" name="url" type="text" value="' . esc_attr( $commenter['comment_author_url'] ) . '" /></div></div></div>',
        'cookies' => '<p class="comment-form-cookies-consent"><input id="wp-comment-cookies-consent" name="wp-comment-cookies-consent" type="checkbox" value="yes"' . $consent . ' />' .
            '<label for="wp-comment-cookies-consent">' . esc_html__( 'Save my name, email, and website in this browser for the next time I comment.', 'soho' ) . '</label></p>'
		 ) ) );
 ?>
 <div class="comment_pager">
	<p><?php paginate_comments_links(); ?></p>
 </div>
 <div class="comment_form">
	<?php comment_form($args); ?>
</div>