<?php

if (!function_exists('soho_core_register_button')){
function soho_core_register_button($buttons ){
   array_push( $buttons, "|", "qode_shortcodes" );
   return $buttons;
}
}

if (!function_exists('soho_core_add_plugin')){
function soho_core_add_plugin($plugin_array ) {
   $plugin_array['qode_shortcodes'] = SOHO_CORE_MODULES_URL_PATH . '/shortcodes/qode_shortcodes.js';
   return $plugin_array;
}
}

if (!function_exists('soho_core_shortcodes_button')){
function soho_core_shortcodes_button(){
   if ( ! current_user_can('edit_posts') && ! current_user_can('edit_pages') ) {
      return;
   }

   if ( get_user_option('rich_editing') == 'true' ) {
      add_filter( 'mce_external_plugins', 'soho_core_add_plugin' );
      add_filter( 'mce_buttons', 'soho_core_register_button' );
   }
}
}
add_action('after_setup_theme', 'soho_core_shortcodes_button');


if (!function_exists('soho_core_num_shortcodes')){
function soho_core_num_shortcodes($content){
    $columns = substr_count( $content, '[pricing_cell' );
	return $columns;
}
}

/* Blockquote item shortcode */

if (!function_exists('soho_core_blockquote')) {
function soho_core_blockquote($atts, $content = null) {
    $args = array(
        "text"              => "",
        "text_color"        => "",
        "width"             => "",
        "line_height"       => "", 
        "background_color"  => "",
        "border_color"      => "",
        "border_width"      => ""
    );
    
    extract(shortcode_atts($args, $atts));

    //init variables
    $html               = "";
    $blockquote_styles  = "";
    $blockquote_class   = "";
    $heading_styles     = "";

    if($width != "") {
        $blockquote_styles .= "width: ".$width."%;";
    }

    if($border_color != "") {
        if($border_width){
            $blockquote_styles .= "border: ".$border_width."px solid ".$border_color.";";
        } else {
            $blockquote_styles .= "border: 2px solid ".$border_color.";";
        }
    }
    
    if($background_color != "") {
        $blockquote_styles .= "background-color: ".$background_color.";";
    }
    
    if($text_color != "") {
        $heading_styles .= "color: ".$text_color.";";
    }

    if($line_height != "") {
        $heading_styles .= " line-height: ".$line_height."px;";
    }

    if($background_color != "" || $border_color != ""){
        $blockquote_class .= "class='with_style'";
    }

    $html .= "<blockquote ".$blockquote_class." style='".$blockquote_styles."'>"; //open blockquote
        $html .= "<div>";
        $html .= "<span class='blockquote_mark icon_quotations' aria-hidden=true></span>";
        $html .= "<h4 class='blockquote-text' style='".$heading_styles."'>".$text."</h4>";
        $html .= "</div>";
    $html .= "</blockquote>"; //close blockquote
    return $html;
}
}
add_shortcode('blockquote', 'soho_core_blockquote');

/* Box shortcode */

if (!function_exists('soho_core_q_box')) {
function soho_core_q_box($atts, $content = null) {
    $args = array(
        "background_color"  => "",
        "background_image"  => "",
        "border_color"      => "",
        "border_width"      => "",
        "top_padding"       => "",
        "bottom_padding"    => "",
        "leftright_padding" => ""
    );
    
    extract(shortcode_atts($args, $atts));

    //init variables
    $html             = "";
    $box_styles       = "";
    $box_inner_styles = "";

    if($background_color != "") {
        $box_styles .= "background-color: ".$background_color.";";
    }

    if (is_numeric($background_image)) {
        $image_src = wp_get_attachment_url($background_image);
    } else {
        $image_src = $background_image;
    }

    if($background_image != "") {
        $box_styles .= "background-image: url(".$image_src.");";
    }

    if($border_width != "" && $border_color != ""){
        $box_styles .= "border: ".$border_width."px solid ".$border_color.";";
    } else if($border_width == "" && $border_color != ""){
        $box_styles .= "border: 2px solid ".$border_color.";";
    } else if($border_width != "" && $border_color == ""){
        $box_styles .= "border: ".$border_width."px solid #363636;";
    }

    if($top_padding != "") {
        $box_inner_styles .= "padding-top: ".$top_padding."px;";
    }

    if($bottom_padding != "") {
        $box_inner_styles .= "padding-bottom: ".$bottom_padding."px;";
    }

    if($leftright_padding != "") {
        $box_inner_styles .= "padding-left: ".$leftright_padding."px;";
        $box_inner_styles .= "padding-right: ".$leftright_padding."px;";
    }

    $html .= "<div class='q_boxes' style='".$box_styles."'>";
    $html .= "<div class='q_boxes_inner' style='".$box_inner_styles."'>";
        $html .= do_shortcode($content);
    $html .= "</div>";
    $html .= "</div>";

    return $html;
}
}
add_shortcode('q_box', 'soho_core_q_box');

/* Button shortcode */

if (!function_exists('soho_core_q_button')) {
function soho_core_q_button($atts, $content = null) {
        
    $args = array(
        "type"                   => "",
        "size"                   => "",
        "text"                   => "SEE MORE",
        "icon_pack"              => "",
        "fa_icon"                => "",
        "fe_icon"                => "",
        "icon_color"             => "",
        "link"                   => "",
        "target"                 => "_self",
        "color"                  => "",
        "background_color"       => "",
        "border_color"           => "",
        "hover_color"            => "",
        "hover_background_color" => "",
        "hover_border_color"     => "",
        "font_style"             => "",
        "font_weight"            => "",
        "text_align"             => "",
        "margin"				 => ""
    );
        
	extract(shortcode_atts($args, $atts));
        
	if($target == ""){
		$target = "_self";
	}
        
    //init variables
    $html  = "";
    $button_classes = "qbutton ";
    $button_styles  = "";
    $add_icon       = "";
    $data_attr      = "";

    if($type != "") {
        $button_classes .= "{$type}";
    }
    
    if($size != "") {
        $button_classes .= " {$size}";
    }

    if($text_align != "") {
        $button_classes .= " {$text_align}";
    }

    if($color != ""){
        $button_styles .= 'color: '.$color.'; ';
    }

    if($background_color != "") {
        $button_styles .= "background-color: {$background_color};";
    }
    
    if($border_color != ""){
        $button_styles .= 'border-color: '.$border_color.'; ';
    }
    
    if($font_style != ""){
        $button_styles .= 'font-style: '.$font_style.'; ';
    }

    if($font_weight != ""){
        $button_styles .= 'font-weight: '.$font_weight.'; ';
    }

    if($hover_background_color != "") {
        $data_attr .= "data-hover-background-color=".$hover_background_color." ";
    }

    if($hover_border_color != "") {
        $data_attr .= "data-hover-border-color=".$hover_border_color." ";
    }

    if($hover_color != "") {
        $data_attr .= "data-hover-color=".$hover_color;
    }

    if($icon_pack != ""){
        $icon_style = "";
        $button_classes .= " qbutton_with_icon";
        if($icon_color != ""){
            $icon_style .= 'color: '.$icon_color.';';
        }

        if($icon_pack == 'font_awesome' && $fa_icon != '')
            $add_icon .= '<i class="fa '.$fa_icon.'" style="'.$icon_style.'"></i>';
        elseif ($icon_pack == 'font_elegant' && $fe_icon != ''){
            $add_icon .= '<span class="q_font_elegant_icon '.$fe_icon.'" aria-hidden="true" style="'.$icon_style.'"></span>';
        }
    }
	
	if($margin != ""){
        $button_styles .= 'margin: '.$margin.'; ';
    }

    $html .=  '<a href="'.$link.'" target="'.$target.'" class="'.$button_classes.'" style="'.$button_styles.'" '.$data_attr.'>'.$add_icon.'<span>'.$text.'</span></a>';

    return $html;
}
}
add_shortcode('q_button', 'soho_core_q_button');

/* Call to Action shortcode */

if (!function_exists('soho_core_call_to_action')) {
    function soho_core_call_to_action($atts, $content = null) {
        $args = array(
            "type"                          => "normal",
            "box_padding"                   => "",
            "icon_pack"                     => "",
            "fa_icon"                       => "",
            "fe_icon"                       => "",
            "icon_size"                     => "40",
            "icon_color"                    => "",
            "custom_icon"                   => "",
            "text_left_padding"             => "",
            "background_color"              => "",
            "border_color"                  => "",
            "title"                         => "",
            "title_tag"                     => "h4",
            "title_color"                   => "",
            "text"                          => "",
            "text_color"                    => "",
            "show_button"                   => "yes",
            "button_text"                   => "SEE MORE",
            "button_position"               => "",
            "button_link"                   => "",
            "button_target"                 => "_self",
            "button_size"                   => "large",
            "button_text_color"             => "",
            "button_hover_text_color"       => "",
            "button_background_color"       => "",
            "button_hover_background_color" => "",
            "button_border_color"           => "",
            "button_hover_border_color"     => "",
            "button_icon_pack"              => "",
            "button_fa_icon"                => "",
            "button_fe_icon"                => ""
        );

        extract(shortcode_atts($args, $atts));

        $headings_array = array('h2', 'h3', 'h4', 'h5', 'h6');
        //get correct heading value. If provided heading isn't valid get the default one
        $title_tag = (in_array($title_tag, $headings_array)) ? $title_tag : $args['title_tag'];

        $html                 = '';
        $action_classes       = '';
        $action_styles        = '';
        $text_wrapper_classes = '';
        $button_styles        = '';
        $icon_styles          = '';
        $text_holder_style    = '';
        $add_icon             = '';
        $add_icon_class       = '';
        $add_icon_style       = '';
        $title_style          = '';
        $text_style           = '';
        $data_attr            = '';

        if($show_button == 'yes') {
            $text_wrapper_classes   .= 'column1';
        }

        if($background_color != '') {
            $action_styles .= 'background-color: '.$background_color.';';
        }

        $action_classes .= $type;

        if($border_color != '') {
            $action_styles .= 'border: 1px solid '.$border_color.';';
        }

        if($box_padding != '') {
            $action_styles .= 'padding: '.$box_padding.';';
        }

        if($title_color != "") {
            $title_style = " style='color: ".$title_color.";'";
        }

        if($text_color != "") {
            $text_style = " style='color: ".$text_color.";'";
        }

        if($button_text_color != '') {
            $button_styles .= 'color: '.$button_text_color.';';
            $add_icon_style .= 'color: '.$button_text_color.';';
        }

        if($icon_color != "") {
            $icon_styles = "color: ".$icon_color.";";
        }

        if($icon_size != "") {
            $icon_styles = "font-size: ".$icon_size."px;";
        }

        if($text_left_padding != "") {
            $text_holder_style = " style='padding-left: ".$text_left_padding."px;'";
        }

        if($button_border_color != '') {
            $button_styles .= 'border-color: '.$button_border_color.';';
        }

        if($button_background_color != '') {
            $button_styles .= "background-color: {$button_background_color};";
        }

        if($button_hover_background_color != "") {
            $data_attr .= "data-hover-background-color=".$button_hover_background_color." ";
        }

        if($button_hover_border_color != "") {
            $data_attr .= "data-hover-border-color=".$button_hover_border_color." ";
        }

        if($button_hover_text_color != "") {
            $data_attr .= "data-hover-color=".$button_hover_text_color;
        }

        $html.=  '<div class="call_to_action '.$action_classes.'" style="'.$action_styles.'">';

        if($show_button == 'yes' && $type != 'centered') {
            $html .= '<div class="two_columns_75_25 clearfix">';
        }

        $html .= '<div class="text_wrapper '.$text_wrapper_classes.'">';
        
            if($type == "with_icon"){
                $html .= '<div class="call_to_action_icon_holder">';
                    $html .= '<div class="call_to_action_icon">';
                        $html .= '<div class="call_to_action_icon_inner">';
                            if($custom_icon != "") {
                                if(is_numeric($custom_icon)) {
                                    $custom_icon_src = wp_get_attachment_url( $custom_icon );
                                } else {
                                    $custom_icon_src = $custom_icon;
                                }
                            
                                $html .= '<img src="' . $custom_icon_src . '" alt="">';
                            } elseif($icon_pack == 'font_awesome' && $fa_icon != '') {
                                $html .= '<i class="fa '.$fa_icon.'" style="'.$icon_styles.'"></i>';
                            } elseif($icon_pack == 'font_elegant' && $fe_icon != '') {
                                $html .= '<span class="q_font_elegant_icon '.$fe_icon.'" aria-hidden="true" style="'.$icon_styles.'"></span>';
                            }
                        $html .= '</div>';
                    $html .= '</div>';
                $html .= '</div>';
            }

            if($button_icon_pack != ""){
                if($button_icon_pack == 'font_awesome' && $button_fa_icon != '') {
                    $add_icon .= "<i class='fa ".$button_fa_icon."' style='".$add_icon_style."'></i>";
                }
                elseif($button_icon_pack == 'font_elegant' && $button_fe_icon != '') {
                    $add_icon .= '<span class="q_font_elegant_icon '.$button_fe_icon.'" aria-hidden="true" style="'.$add_icon_style.'"></span>';
                }

                $add_icon_class .= "qbutton_with_icon";
            }
           
            $html .= '<div class="call_to_action_text" '.$text_holder_style.'>';

                if($title != ""){
                    $html .= '<'.$title_tag.' '.$title_style.'>'.$title.'</'.$title_tag.'>';
                }

                if($text != ""){
                    $html .= '<p '.$text_style.'>'.$text.'</p>';
                }

            $html .= '</div>';

        $html .= '</div>'; //close text_wrapper

        if($show_button == 'yes') {
            $button_link = ($button_link != '') ? $button_link : 'javascript: void(0)';

            $html .= '<div class="button_wrapper '.$button_position.' column2">';
            $html .= '<a href="'.$button_link.'" class="qbutton transparent_button '.$button_size.' '.$add_icon_class.'" target="'.$button_target.'" style="'.$button_styles.'" '.$data_attr.'>'.$add_icon.'<span>'.$button_text.'</span></a>';
            $html .= '</div>';//close button_wrapper
        }

        if($show_button == 'yes' && $type != 'centered') {
            $html .= '</div>'; //close two_columns_75_25 if opened
        }

        $html .= '</div>';//close call_to_action



        return $html;
    }
}
add_shortcode('call_to_action', 'soho_core_call_to_action');

/* Counter shortcode */

if (!function_exists('soho_core_counter')) {
function soho_core_counter($atts, $content = null) {

    global $qode_options_soho;
    
    $args = array(
        "type"                 => "",
        "box"                  => "",
        "box_background_color" => "",
        "box_border_color"     => "",
        "position"             => "",
        "digit"                => "",
        "digit_color"          => "",
        "digit_color_end"      => "",
        "digit_size"           => "",
        "title"                => "",
        "title_tag"			   => "h5",
        "title_color"		   => "",
        "text"                 => "",
        "text_size"            => "",
        "text_color"           => ""
    );

	extract(shortcode_atts($args, $atts));
	
	$headings_array = array('h2', 'h3', 'h4', 'h5', 'h6');
    //get correct heading value. If provided heading isn't valid get the default one
    $title_tag = (in_array($title_tag, $headings_array)) ? $title_tag : $args['title_tag'];
	
    //init variables
    $html                   = "";
    $counter_holder_classes = "";
    $counter_holder_style   = "";
    $counter_classes        = "";
    $counter_styles         = "";
    $title_style			= "";
    $text_styles            = "";
    $active_digit_color     = "";

    if($position != "") {
        $counter_holder_classes .= " ".$position;
    }

    if($box == "yes") {
        $counter_holder_classes .= " boxed_counter";

        if($box_background_color != ""){
            $counter_holder_style .= "background-color: ".$box_background_color.";";
        }

        if($box_border_color != ""){
            $counter_holder_style .= "border-color: ".$box_border_color.";";
        }
    }

    if($type != "") {
        $counter_classes .= " ".$type;
    }

    if($digit_color != "") {
        $counter_styles .= "color: ".$digit_color.";";
    }

    if($digit_size != "") {
        $counter_styles .= "font-size: ".$digit_size."px;";
    }

    if($text_size != "") {
        $text_styles .= "font-size: ".$text_size."px;";
    }

    if($text_color != "") {
        $text_styles .= "color: ".$text_color.";";
    }
	
    if($title_color != "") {
        $title_style .= "color: ".$title_color;
    }

    if($digit_color_end != ""){
        $active_digit_color = $digit_color_end;
    } else {
       $active_digit_color = "#363636";
    }

    $html .= '<div class="q_counter_holder '.$counter_holder_classes.'" style="'.$counter_holder_style.'">';
    $html .= '<div class="q_counter_inner"><span class="counter '.$counter_classes.'" data-active_color="'.$active_digit_color.'" style="'.$counter_styles.'">'.$digit.'</span></div>';
	
	if($title != "") {
		$html .= '<'.$title_tag.' style="'.$title_style.'">'.$title.'</'.$title_tag.'>';
    }

    $html .= $content;

    if($text != "") {
        $html .= '<p class="counter_text" style="'.$text_styles.'">'.$text.'</p>';
    }

    $html .= '</div>'; //close q_counter_holder

    return $html;
}
}
add_shortcode('counter', 'soho_core_counter');

/* Cover Boxes shortcode */

if (!function_exists('soho_core_cover_boxes')) {
function soho_core_cover_boxes($atts, $content = null) {

    $args = array(
        "active_element"   => "1",
        "title1"           => "",
        "title_color1"     => "",
        "text1"            => "",
        "text_color1"      => "",
        "image1"           => "",
        "link1"            => "",
        "link_label1"      => "",
        "link_target1"     => "",
        "link1_top_margin" => "",
        "title2"           => "",
        "title_color2"     => "",
        "text2"            => "",
        "text_color2"      => "",
        "image2"           => "",
        "link2"            => "",
        "link_label2"      => "",
        "link_target2"     => "",
        "link2_top_margin" => "",
        "title3"           => "",
        "title_color3"     => "",
        "text3"            => "",
        "text_color3"      => "",
        "image3"           => "",
        "link3"            => "",
        "link_label3"      => "",
        "link_target3"     => "",
        "link3_top_margin" => ""
    );

    extract(shortcode_atts($args, $atts));

    $html          = "";
    $button1_style = "";
    $button2_style = "";
    $button3_style = "";

    $html .= "<div class='cover_boxes' data-active-element='".$active_element."'><ul class='clearfix'>";
    
    $html .= "<li>";
    $html .= "<div class='box'>";

    if($link1_top_margin != ""){
        $button1_style = 'margin-top:'.$link1_top_margin.'px;';
    }
    if($link2_top_margin != ""){
        $button2_style = 'margin-top:'.$link2_top_margin.'px;';
    }
    if($link3_top_margin != ""){
        $button3_style = 'margin-top:'.$link3_top_margin.'px;';
    }
    if($link_target1 != ""){
        $target1 = $link_target1;
    }else{
        $target1 = "_self";
    }
    if(is_numeric($image1)) {
        $image_src1 = wp_get_attachment_url( $image1 ); 
    }else {
        $image_src1 = $image1; 
    }
    if(is_numeric($image2)) {
        $image_src2 = wp_get_attachment_url( $image2 ); 
    }else {
        $image_src2 = $image2; 
    }
    if(is_numeric($image3)) {
        $image_src3 = wp_get_attachment_url( $image3 ); 
    }else {
        $image_src3 = $image3; 
    }
    $html .= "<a class='thumb' href='".$link1."' target='".$target1."'><img alt='".$title1."' src='".$image_src1."' /></a>";
    if($title_color1 != ""){
        $color1 = " style='color:".$title_color1."''";
    }else{
        $color1 = "";
    }
    if($text_color1 != ""){
        $t_color1 = " style='color:".$text_color1."''";
    }else{
        $t_color1 = "";
    }
    $html .= "<div class='box_content'><h5 ".$color1.">".$title1."</h5>";
    $html .= "<p ".$t_color1.">".$text1."</p>";
    $html .= "<a class='qbutton transparent_button medium' style='".$button1_style."' href='".$link1."' target='".$target1."'>".$link_label1."</a>";
    $html .= "</div></div>";
    $html .= "</li>";

    $html .= "<li>";
    $html .= "<div class='box'>";
    if($link_target2 != ""){
        $target2 = $link_target2;
    }else{
        $target2 = "_self";
    }
    $html .= "<a class='thumb' href='".$link2."' target='".$target2."'><img alt='".$title2."' src='".$image_src2."' /></a>";
    if($title_color2 != ""){
        $color2 = " style='color:".$title_color2."''";
    }else{
        $color2 = "";
    }
    if($text_color2 != ""){
        $t_color2 = " style='color:".$text_color2."''";
    }else{
        $t_color2 = "";
    }
    $html .= "<div class='box_content'><h5 ".$color2.">".$title2."</h5>";
    $html .= "<p ".$t_color2.">".$text2."</p>";
    $html .= "<a class='qbutton transparent_button medium' style='".$button2_style."' href='".$link2."' target='".$target2."'>".$link_label2."</a>";
    $html .= "</div></div>";
    $html .= "</li>";
    
    $html .= "<li>";
    $html .= "<div class='box'>";
    if($link_target3 != ""){
        $target3 = $link_target3;
    }else{
        $target3 = "_self";
    }
    $html .= "<a class='thumb' href='".$link3."' target='".$target3."'><img alt='".$title3."' src='".$image_src3."' /></a>";
    if($title_color3 != ""){
        $color3 = " style='color:".$title_color3."''";
    }else{
        $color3 = "";
    }
    if($text_color3 != ""){
        $t_color3 = " style='color:".$text_color3."''";
    }else{
        $t_color3 = "";
    }
    $html .= "<div class='box_content'><h5 ".$color3.">".$title3."</h5>";
    $html .= "<p ".$t_color3.">".$text3."</p>";
    $html .= "<a class='qbutton transparent_button medium' style='".$button3_style."' href='".$link3."' target='".$target3."'>".$link_label3."</a>";
    $html .= "</div></div>";
    $html .= "</li>";
    
    $html .= "</ul></div>";
    return $html;
}
}
add_shortcode('cover_boxes', 'soho_core_cover_boxes');

/* Custom Font shortcode */

if (!function_exists('soho_core_custom_font')) {
function soho_core_custom_font($atts, $content = null) {
	extract(shortcode_atts(array("font_family"=>"","font_size"=>"","line_height"=>"","font_style"=>"","font_weight"=>"","color"=>"","text_decoration"=>"","letter_spacing"=>"","text_shadow"=>"","show_dots"=>"","background_color"=>"","padding"=>"","margin"=>"","text_align"=>"left"), $atts));
    $html = '';  
	$html .= '<div class="custom_font_holder';
        if($show_dots == "yes"){
            $html .= ' with_dots';
        }
    $html .= '" style="';
    	if($font_family != ""){
    		$html .= 'font-family: '.$font_family.';';
    	}
    	if($font_size != ""){
    		$html .= ' font-size: '.$font_size.'px;';
    	}
    	if($line_height != ""){
    		$html .= ' line-height: '.$line_height.'px;';
    	}
    	if($font_style != ""){
    		$html .= ' font-style: '.$font_style.';';
    	}
    	if($font_weight != ""){
    		$html .= ' font-weight: '.$font_weight.';';
    	}
    	if($color != ""){
    		$html .= ' color: '.$color.';';
    	}
    	if($text_decoration != ""){
    		$html .= ' text-decoration: '.$text_decoration.';';
    	}
        if($letter_spacing != ""){
            $html .= ' letter-spacing: '.$letter_spacing.'px;';
        }
    	if($text_shadow == "yes"){
    		$html .= ' text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.4);';
    	}
    	if($background_color != ""){
    		$html .= ' background-color: '.$background_color.';';
    	}
    	if($padding != ""){
    		$html .= ' padding: '.$padding.';';
    	}
    	if($margin != ""){
    		$html .= ' margin: '.$margin.';';
    	}
    	$html .= ' text-align: ' . $text_align . ';';
	$html .= '">'.$content.'</div>';
    return $html;
}
}
add_shortcode('custom_font', 'soho_core_custom_font');

/* Dropcaps shortcode */

if (!function_exists('soho_core_dropcaps')) {
    function soho_core_dropcaps($atts, $content = null) {
        $args = array(
            "type"              => "",
            "color"             => "",
            "background_color"  => "",
            "border_color"      => ""
        );
        extract(shortcode_atts($args, $atts));

        $html = "<span class='q_dropcap ".$type."' style='";
        if($background_color != ""){
                $html .= "background-color: $background_color;";
        }
        if($color != ""){
                $html .= " color: $color;";
        }
        if($border_color != ""){
            if($type != "normal"){
                $html .= " border-color: $border_color;";
            }
        }
        $html .= "'>" . $content  . "</span>";

        return $html;
    }
}
add_shortcode('dropcaps', 'soho_core_dropcaps');

/* Highlights shortcode */

if (!function_exists('soho_core_highlight')) {
function soho_core_highlight($atts, $content = null) {
	extract(shortcode_atts(array("color"=>"","background_color"=>""), $atts));
	$html =  "<span class='highlight'";
	if($color != "" || $background_color != ""){
		$html .= " style='color: ".$color."; background-color:".$background_color.";'";
	}
	$html .= ">" . $content . "</span>";  
    return $html;
}
}
add_shortcode('highlight', 'soho_core_highlight');

/* Icon shortcode */

if(!function_exists('soho_core_icons')) {
    function soho_core_icons($atts, $content = null) {
        $default_atts = array(
            "icon_pack"              => "",
            "fa_size"                => "",
            "custom_size"            => "",
            "fa_icon"                => "",
            "fe_icon"                => "",
            "type"                   => "",
            "position"               => "",
            "icon_color"             => "",
            "icon_hover_color"       => "", 
            "border_color"           => "",
            "border_hover_color"     => "",
            "background_color"       => "",
            "background_hover_color" => "",
            "margin"                 => "",
            "icon_animation"         => "",
            "icon_animation_delay"   => "",
            "link"                   => "",
            "target"                 => ""
        );
        
        extract(shortcode_atts($default_atts, $atts));
        
        $html = "";
        if($fa_icon != "" || $fe_icon != "") {

            if ($icon_pack == 'font_awesome' && $fa_icon != '')
                $size = $fa_size;

            //generate inline icon styles
            $icon_stack_classes    = '';
            $animation_delay_style = '';
            $icon_link_style       = '';
            $data_attr             = '';
            $data_attr_link        = '';
            
            //generate icon stack styles
            $icon_stack_style = '';
            $icon_stack_circle_styles = '';
            $icon_stack_square_styles = '';
            $icon_stack_normal_style  = '';

            if($custom_size != "") {
                $icon_stack_normal_style .= 'font-size: '.$custom_size;
                $icon_stack_circle_styles .= 'font-size: '.$custom_size;
                $icon_stack_square_styles .= 'font-size: '.$custom_size;
                
                if(!strstr($custom_size, 'px')) {
                    $icon_stack_normal_style .= 'px;';
                    $icon_stack_circle_styles .= 'px;';
                    $icon_stack_square_styles .= 'px;';
                }
            }

            if($position != "") {
                $icon_stack_classes .= 'pull-'.$position;
            } 

            if($icon_color != "") {
                $icon_stack_normal_style .= 'color: '.$icon_color.';';
                $icon_stack_style .= 'color: '.$icon_color.';';
                $icon_link_style .= 'color: '.$icon_color.';';
            }

            if($background_color != "") {
                $icon_stack_style .= 'background-color: '.$background_color.';';
            }

            if($border_color != "") {
                $icon_stack_style .= 'border-color: '.$border_color.';';
            }

            if($background_hover_color != "") {
                $data_attr .= "data-hover-background-color=".$background_hover_color." ";
            }

            if($border_hover_color != "") {
                $data_attr .= "data-hover-border-color=".$border_hover_color." ";
            }

            if($icon_hover_color != "") {
                $data_attr      .= "data-hover-color=".$icon_hover_color;
                $data_attr_link .= "data-hover-color=".$icon_hover_color;
            }

            if($icon_animation_delay != ""){
                $animation_delay_style .= 'transition-delay: '.$icon_animation_delay.'ms; -webkit-transition-delay: '.$icon_animation_delay.'ms; -moz-transition-delay: '.$icon_animation_delay.'ms; -o-transition-delay: '.$icon_animation_delay.'ms;';
            }
            
            if($margin != "") {
                $icon_stack_style .= 'margin: '.$margin.';';
                $icon_stack_normal_style .= 'margin: '.$margin.';';
            }

            switch ($type) {
                case 'circle':
                    if($icon_pack == 'font_awesome' && $fa_icon != ''){

                        $html = '<span class="fa-stack q_font_awsome_icon_holder q_font_awsome_icon_circle '.$size.' '.$icon_stack_classes.' '.$icon_animation.'" style="'.$icon_stack_style.$icon_stack_circle_styles.' '.$animation_delay_style.'" '.$data_attr.'>';
                        if($link != ""){
                            $html .= '<a href="'.$link.'" target="'.$target.'" style="'.$icon_link_style.'" '.$data_attr_link.'>';
                        }
                            $html .= '<i class="fa '.$fa_icon.'"></i>';

                    } elseif($icon_pack == 'font_elegant' && $fe_icon != ''){
                        
                        $html = '<span class="q_font_elegant_holder '.$type.' '.$icon_stack_classes.' '.$icon_animation.'" style="'.$icon_stack_style.$icon_stack_circle_styles.' '.$animation_delay_style.'" '.$data_attr.'>';
                        if($link != ""){
                            $html .= '<a href="'.$link.'" target="'.$target.'" style="'.$icon_link_style.'" '.$data_attr_link.'>';
                        }
                        $html .= '<span class="q_font_elegant_icon '.$fe_icon.'" aria-hidden="true"></span>';

                    }
                    break;
                case 'square':
                    if($icon_pack == 'font_awesome' && $fa_icon != ''){

                        $html = '<span class="fa-stack q_font_awsome_icon_holder q_font_awsome_icon_square '.$size.' '.$icon_stack_classes.' '.$icon_animation.'" style="'.$icon_stack_style.$icon_stack_square_styles.' '.$animation_delay_style.'" '.$data_attr.'>';
                        if($link != ""){
                            $html .= '<a href="'.$link.'" target="'.$target.'" style="'.$icon_link_style.'" '.$data_attr_link.'>';
                        }
                            $html .= '<i class="fa '.$fa_icon.'"></i>';

                    } elseif($icon_pack == 'font_elegant' && $fe_icon != ''){

                        $html = '<span class="q_font_elegant_holder '.$type.' '.$icon_stack_classes.' '.$icon_animation.'" style="'.$icon_stack_style.$icon_stack_square_styles.' '.$animation_delay_style.'" '.$data_attr.'>';
                        if($link != ""){
                            $html .= '<a href="'.$link.'" target="'.$target.'" style="'.$icon_link_style.'" '.$data_attr_link.'>';
                        }
                        $html .= '<span class="q_font_elegant_icon '.$fe_icon.'" aria-hidden="true"></span>';

                    }
                    break;
                default:
                    if($icon_pack == 'font_awesome' && $fa_icon != ''){

                        $html = '<span class="q_font_awsome_icon q_font_awsome_icon_holder '.$size.' '.$icon_stack_classes.' '.$icon_animation.'" style="'.$icon_stack_normal_style.' '.$animation_delay_style.'" '.$data_attr.'>';
                        if($link != ""){
                            $html .= '<a href="'.$link.'" target="'.$target.'" style="'.$icon_link_style.'" '.$data_attr_link.'>';
                        }
                            $html .= '<i class="fa '.$fa_icon.'"></i>';

                    } elseif($icon_pack == 'font_elegant' && $fe_icon != ''){
                        
                        $html = '<span class="q_font_elegant_holder '.$type.' '.$icon_stack_classes.' '.$icon_animation.'" style="'.$icon_stack_normal_style.' '.$animation_delay_style.'" '.$data_attr.'>';
                        if($link != ""){
                            $html .= '<a href="'.$link.'" target="'.$target.'" style="'.$icon_link_style.'" '.$data_attr_link.'>';
                        }
                        $html .= '<span class="q_font_elegant_icon '.$fe_icon.'" aria-hidden="true"></span>';

                    }
                    break;
            }

            if($link != ""){
                $html .= '</a>';
            }

            $html.= '</span>';
        }
        return $html;
    }
}
add_shortcode('icons', 'soho_core_icons');

/* Icon List Item shortcode */

if (!function_exists('soho_core_icon_list_item')) {
function soho_core_icon_list_item($atts, $content = null) {
    $args = array(
        "icon_pack"                => "",
        "fa_icon"                  => "",
        "fe_icon"                  => "",
        "icon_type"                => "",
        "icon_color"               => "",
        "border_type"              => "",
        "border_color"             => "",
        "title"                    => "",
        "title_color"              => "",
        "title_size"               => ""
    );

    extract(shortcode_atts($args, $atts));

    $html           = '';
    $icon_style     = "";
    $icon_classes   = "";
    $title_style    = "";

    $icon_classes .= $icon_type." ";

    if($icon_color != "") {
        $icon_style .= "color:".$icon_color.";";
    }

    if($border_color != "" && $border_type != "") {
        $icon_style .= "border-color: ".$border_color.";";
    }

    if($title_color != "") {
        $title_style .= "color:".$title_color.";";
    }

    if($title_size != "") {
        $title_style .= "font-size: ".$title_size."px;";
    }

    $html .= '<div class="q_icon_list">';
    if($icon_pack == 'font_awesome' && $fa_icon != ''){

        $html .= '<i class="fa '.$fa_icon.' '.$icon_classes.' '.$border_type.'" style="'.$icon_style.'"></i>';

    } elseif($icon_pack == 'font_elegant' && $fe_icon != ''){

        $html .= '<span class="q_font_elegant_icon '.$fe_icon.' '.$icon_classes.' '.$border_type.'" aria-hidden="true" style="'.$icon_style.'"></span>';
    }

    $html .= '<p class="'.$icon_classes.'" style="'.$title_style.'">'.$title.'</p>';
    $html .= '</div>';
    return $html;
}
}
add_shortcode('icon_list_item', 'soho_core_icon_list_item');

/* Icon with text shortcode */

if(!function_exists('soho_core_icon_text')) {
    function soho_core_icon_text($atts, $content = null) {
        $default_atts = array(
            "icon_size"                   => "", 
            "custom_icon_size"            => "20",
            "text_left_padding"           => "80",
            "icon_pack"                   => "",
            "fa_icon"                     => "",
            "fe_icon"                     => "",
            "icon_animation"              => "",
            "icon_animation_delay"        => "",
            "icon_type"                   => "", 
            "icon_position"               => "",
            "icon_margin"                 => "",
            "icon_color"                  => "",
            "icon_hover_color"            => "",
            "icon_background_color"       => "",
            "icon_background_hover_color" => "",
            "icon_border_color"           => "",
            "icon_border_hover_color"     => "", 
            "box_type"                    => "",
            "box_border"                  => "",
            "box_border_color"            => "",
            "box_background_color"        => "",
            "title"                       => "",
            "title_tag"                   => "h5",
            "title_color"                 => "",
            "title_padding"               => "",
            "text"                        => "",
            "text_color"                  => "",
            "link"                        => "",
            "link_text"                   => "",
            "link_color"                  => "",
            "target"                      => ""
        );
        
        extract(shortcode_atts($default_atts, $atts));
        
        $headings_array = array('h2', 'h3', 'h4', 'h5', 'h6');
                
        //get correct heading value. If provided heading isn't valid get the default one
        $title_tag = (in_array($title_tag, $headings_array)) ? $title_tag : $args['title_tag'];
                                
        //init icon styles
        $style              = '';
        $icon_stack_classes = '';
        $data_attr          = '';
        
        //init icon stack styles
        $icon_margin_style       = '';
        $icon_stack_square_style = '';
        $icon_stack_base_style   = '';
        $icon_stack_style        = '';
        $animation_delay_style   = '';

        //generate inline icon styles
        if($custom_icon_size != "" && $fe_icon != "") {
            $icon_stack_style .= 'font-size: '.$custom_icon_size.'px;';
        } 

        if($icon_color != "") {
            $style .= 'color: '.$icon_color.';';
            $icon_stack_style .= 'color: '.$icon_color.';';
        }

        //generate icon stack styles
        if($icon_background_color != "") {
            $icon_stack_base_style .= 'background-color: '.$icon_background_color.';';
            $icon_stack_square_style .= 'background-color: '.$icon_background_color.';';
        } 

        if($icon_border_color != "") {
            $icon_stack_style .= 'border-color: '.$icon_border_color.';';
        }

        if($icon_hover_color != "") {
            $data_attr .= "data-hover-color=".$icon_hover_color." ";
        }

        if($icon_background_hover_color != "") {
            $data_attr .= "data-hover-background-color=".$icon_background_hover_color." ";
        }

        if($icon_border_hover_color != "") {
            $data_attr .= "data-hover-border-color=".$icon_border_hover_color." ";
        }
        
        if($icon_margin != "") {
            $icon_margin_style .= "margin: ".$icon_margin.";";
        }

        if($icon_animation_delay != "" && $icon_animation == "q_icon_animation"){
            $animation_delay_style .= 'transition-delay: '.$icon_animation_delay.'ms; -webkit-transition-delay: '.$icon_animation_delay.'ms; -moz-transition-delay: '.$icon_animation_delay.'ms; -o-transition-delay: '.$icon_animation_delay.'ms;';
        }
                
        $box_size = '';
        //generate icon text holder styles and classes
        
        //map value of the field to the actual class value

        if($icon_pack == 'font_awesome' && $fa_icon != ''){

            switch ($icon_size) {
                case 'large': //smallest icon size
                    $box_size = 'tiny';
                    break;
                case 'fa-2x':
                    $box_size = 'small';
                    break;
                case 'fa-3x':
                    $box_size = 'medium';
                    break;
                case 'fa-4x':
                    $box_size = 'large';
                    break;
                case 'fa-5x':
                    $box_size = 'very_large';
                    break;
                default:
                    $box_size = 'tiny';
            }
        }

        $box_icon_type = '';
        switch ($icon_type) {
            case 'normal':
                $box_icon_type = 'normal_icon';
                break;
            case 'square':
                $box_icon_type = 'square';
                break;
            case 'circle':
                $box_icon_type = 'circle';
                break;
        }
        
        $html = "";
        $html_icon = "";
        
        if($icon_position != "top_title_over") {
            //genererate icon html
            switch ($icon_type) {
                case 'circle':
                    //if custom icon size is set and if it is larger than large icon size
                    if($custom_icon_size != "") {
                        //add custom font class that has smaller inner icon font
                        $icon_stack_classes .= ' custom-font';
                    }

                    if($icon_pack == 'font_awesome' && $fa_icon != ''){
                        $html_icon .= '<span class="fa-stack icon_with_text_class '.$icon_size.' '.$icon_stack_classes.'" style="'.$icon_stack_style . $icon_stack_base_style .'" '.$data_attr.'>';
                        $html_icon .= '<i class="fa '.$fa_icon.' fa-stack-1x"></i>';
                        $html_icon .= '</span>';
                    }elseif($icon_pack == 'font_elegant' && $fe_icon != ''){
                        $html_icon .= '<span class="q_font_elegant_holder icon_with_text_class '.$icon_type.' '.$icon_stack_classes.'" style="'.$icon_stack_style. $icon_stack_base_style .'" '.$data_attr.'>';
                        $html_icon .= '<span class="q_font_elegant_icon '.$fe_icon.'" aria-hidden="true"></span>';
                        $html_icon .= '</span>';
                    }

                    break;
                case 'square':
                    //if custom icon size is set and if it is larget than large icon size
                    if($custom_icon_size != "") {
                        //add custom font class that has smaller inner icon font
                        $icon_stack_classes .= ' custom-font';
                    }

                    if($icon_pack == 'font_awesome' && $fa_icon != ''){
                        $html_icon .= '<span class="fa-stack icon_with_text_class '.$icon_size.' '.$icon_stack_classes.'" style="'.$icon_stack_style.$icon_stack_square_style.'" '.$data_attr.'>';
                        $html_icon .= '<i class="fa '.$fa_icon.' fa-stack-1x"></i>';
                        $html_icon .= '</span>';
                    } elseif($icon_pack == 'font_elegant' && $fe_icon != ''){
                        $html_icon .= '<span class="q_font_elegant_holder icon_with_text_class '.$icon_type.' '.$icon_stack_classes.'" style="'.$icon_stack_style.$icon_stack_square_style.'" '.$data_attr.'>';
                        $html_icon .= '<span class="q_font_elegant_icon '.$fe_icon.'" aria-hidden="true"></span>';
                        $html_icon .= '</span>';
                    }

                    break;
                default:

                    if($icon_pack == 'font_awesome' && $fa_icon != ''){
                        $html_icon .= '<span style="'.$icon_stack_style.'" class="q_font_awsome_icon icon_with_text_class '.$icon_size.' '.$icon_stack_classes.'" '.$data_attr.'>';
                        $html_icon .= '<i class="fa '.$fa_icon.'"></i>';
                        $html_icon .= '</span>';
                    } elseif($icon_pack == 'font_elegant' && $fe_icon != ''){
                        $html_icon .= '<span class="q_font_elegant_holder icon_with_text_class '.$icon_type.' '.$icon_stack_classes.'" style="'.$icon_stack_style.'" '.$data_attr.'>';
                        $html_icon .= '<span class="q_font_elegant_icon '.$fe_icon.'" aria-hidden="true"></span>';
                        $html_icon .= '</span>';
                    }

                    break;
            }    
        } elseif($icon_position == "top_title_over"){
            if($icon_pack == 'font_awesome' && $fa_icon != ''){
                $html_icon .= '<i class="fa '.$fa_icon.'" style="'.$style.'"></i>';
            } elseif ($icon_pack == 'font_elegant' && $fe_icon != ''){
                $html_icon .= '<span class="q_font_elegant_icon '.$fe_icon.'" aria-hidden="true" style="'.$style.'"></span>';
            }
        }
        
        $title_style = "";
        if($title_color != "") {
            $title_style .= "color: ".$title_color;
        }
        
        $text_style = "";
        if($text_color != "") {
            $text_style .= "color: ".$text_color;
        }

        $link_style = "";

        if($link_color != "") {
            $link_style .= "color: ".$link_color.";";
        }
        
        //generate normal type of a box html
        if($box_type == "normal") {   
            
            //init icon text wrapper styles
            $icon_with_text_clasess = '';
            $icon_with_text_style   = '';
            $icon_text_inner_style  = '';
            $icon_text_holder_style = '';
            
            $icon_with_text_clasess .= $box_size;
            $icon_with_text_clasess .= ' '.$box_icon_type;
            
            if($box_border == "yes") {
                $icon_with_text_clasess .= ' with_border_line';
            }

            if($text_left_padding != "" && $fe_icon != "" && $icon_position == "left"){
                $icon_text_holder_style .= 'padding-left: '.$text_left_padding.'px';
            }
            
            if($box_border == "yes" && $box_border_color != "") {
                $icon_text_inner_style .= 'border-color: '.$box_border_color;
            } 

            if($icon_position == "" || $icon_position == "top" || $icon_position == "top_title_over") {
                $icon_with_text_clasess .= " center";
            }
            if($icon_position == "left_from_title"){
				 $icon_with_text_clasess .= " left_from_title";
			}
            if($icon_position == "top_title_over"){
                 $icon_with_text_clasess .= " top_title_over";
            }
            $html .= "<div class='q_icon_with_title ".$icon_with_text_clasess."'>";
            if($icon_position != "left_from_title") {
				//generate icon holder html part with icon
				$html .= '<div class="icon_holder '.$icon_animation.'" style="'.$icon_margin_style.' '.$animation_delay_style.'">';
				$html .= $html_icon;
				$html .= '</div>'; //close icon_holder
			}
            //generate text html
            $html .= '<div class="icon_text_holder" style="'.$icon_text_holder_style.'">';
            $html .= '<div class="icon_text_inner" style="'.$icon_text_inner_style.'">';
			 if($icon_position == "left_from_title") {
				$html .= '<div class="icon_title_holder">'; //generate icon_title holder for icon from title
				//generate icon holder html part with icon
				$html .= '<div class="icon_holder '.$icon_animation.'" style="'.$icon_margin_style.' '.$animation_delay_style.'">';
				$html .= $html_icon;
				$html .= '</div>'; //close icon_holder
			}
            $html .= '<'.$title_tag.' class="icon_title" style="'.$title_style.'">'.$title.'</'.$title_tag.'>';
			 if($icon_position == "left_from_title") {
				$html .= '</div>'; //close icon_title holder for icon from title
			 }
            $html .= "<p style='".$text_style."'>".$text."</p>";
            if($link != ""){
                if($target == ""){
                    $target = "_self";
                }

                if($link_text == ""){
                    $link_text = "READ MORE";
                }

                $html .= "<a class='icon_with_title_link' href='".$link."' target='".$target."' style='".$link_style."'>".$link_text."</a>";
            }
            $html .= '</div>';  //close icon_text_inner
            $html .= '</div>'; //close icon_text_holder

            $html.= '</div>'; //close icon_with_title     
        } else {
            //init icon text wrapper styles
            $icon_with_text_clasess = '';
            $box_holder_styles = '';
            
            if($box_border_color != "") {
                $box_holder_styles .= 'border-color: '.$box_border_color.';';
            } 
            
            if($box_background_color != "") {
                $box_holder_styles .= 'background-color: '.$box_background_color.';';
            }

            if($title_padding != ""){
                $valid_title_padding = (strstr($title_padding, 'px', true)) ? $title_padding : $title_padding.'px';
                $title_style .= 'padding-top: '.$valid_title_padding.';';
            }
            
            $icon_with_text_clasess .= $box_size;
            $icon_with_text_clasess .= ' '.$box_icon_type;
            
            $html .= '<div class="q_box_holder with_icon" style="'.$box_holder_styles.'">';
            
            $html .= '<div class="box_holder_icon">';
            $html .= '<div class="box_holder_icon_inner '.$icon_with_text_clasess.' '.$icon_animation.'" style="'.$animation_delay_style.'">';
            $html .= $html_icon;
            $html .= '</div>'; //close box_holder_icon_inner
            $html .= '</div>'; //close box_holder_icon
            
            //generate text html
            $html .= '<div class="box_holder_inner '.$box_size.' center">';
            $html .= '<'.$title_tag.' class="icon_title" style="'.$title_style.'">'.$title.'</'.$title_tag.'>';
            $html .= '<p style="'.$text_style.'">'.$text.'</p>';
            $html .= '</div>'; //close box_holder_inner
                        
            $html .= '</div>'; //close box_holder
        }
        
        return $html;
        
    }
}
add_shortcode('icon_text', 'soho_core_icon_text');

/* Image hover shortcode */

if (!function_exists('soho_core_image_hover')) {

    function soho_core_image_hover($atts, $content = null) {
        $args = array(
            "image"             => "",
            "hover_image"       => "",
            "link"              => "",
            "target"            => "_self",
            "animation"         => "",
            "transition_delay"  => ""
        );

        extract(shortcode_atts($args, $atts));
                
        //init variables
        $html               = "";
        $image_classes      = "";
        $image_src          = $image;
        $hover_image_src    = $hover_image;
        $images_styles      = "";
                                        
        if (is_numeric($image)) {
            $image_src = wp_get_attachment_url($image);
        }
                        
        if (is_numeric($hover_image)) {
            $hover_image_src = wp_get_attachment_url($hover_image);
        }
        
        if($hover_image_src != "") {
            $image_classes .= "active_image ";
        }
        
        $css_transition_delay = ($transition_delay != "" && $transition_delay > 0) ? $transition_delay / 1000 . "s" : "";
        
        $animate_class = ($animation == "yes") ? "hovered" : "";
        
        //generate output
        $html .= "<div class='image_hover {$animate_class}' style='' data-transition-delay='{$transition_delay}'>";
        $html .= "<div class='images_holder'>";
        
        if($link != "") {
            $html .= "<a href='{$link}' target='{$target}'>";
        }
        
        $html .= "<img class='{$image_classes}' src='{$image_src}' alt='' style='{$images_styles}' />";
        $html .= "<img class='hover_image' src='{$hover_image_src}' alt='' style='{$images_styles}' />";
        
        if($link != "") {
            $html .= "</a>";
        }
        
        $html .= "</div>"; //close image_hover
        $html .= "</div>"; //close images_holder

        return $html;
    }
    
    add_shortcode('image_hover', 'soho_core_image_hover');
}

/* Image with text shortcode */

if (!function_exists('soho_core_image_with_text')) {

    function soho_core_image_with_text($atts, $content = null) {
        $args = array(
            "image"                 => "",
            "title"                 => "",
            "title_color"           => "",
            "title_tag"             => "h5",
            "text"                  => "",
            "text_color"            => "",
            "link"                  => "",
            "link_text"             => "SEE MORE",
            "target"                => "_self",
            "link_color"            => ""
        );

        extract(shortcode_atts($args, $atts));

        $headings_array = array('h2', 'h3', 'h4', 'h5', 'h6');

        //get correct heading value. If provided heading isn't valid get the default one
        $title_tag = (in_array($title_tag, $headings_array)) ? $title_tag : $args['title_tag'];

        if (is_numeric($image)) {
            $image_src = wp_get_attachment_url($image);
        } else {
            $image_src = $image;
        }

        $html= "";
        $button_classes = "qbutton medium transparent_button";

        //generate output
        $html .= '<div class="q_image_with_text">';

        $html .= '<img src="' . $image_src . '" alt="' . $title . '" />';

        $html .= '<'.$title_tag.' class="q_title"';
        if($title_color != "") {
            $html .= ' style="color:'.$title_color.';"';
        }
        $html .= '>'.$title.'</'.$title_tag.'>';

        $html .= '<p';
        if($text_color != "") {
            $html .= ' style="color:'.$text_color.';"';
        }
        $html .= '>'.$text.'</p>';

        if($link != ''){
            $html .=  '<a href="'.$link.'" target="'.$target.'" class="'.$button_classes.'"';
            if($link_color != "") {
                $html .= ' style="color:'.$link_color.';"';
            }
            $html .= '><span>'.$link_text.'</span></a>';
        }

        $html .= '</div>'; //close image_with_text

        return $html;
    }

    add_shortcode('image_with_text', 'soho_core_image_with_text');
}

/* Interactive banners shortcode */

if (!function_exists('soho_core_image_with_text_over')) {

    function soho_core_image_with_text_over($atts, $content = null) {
        $args = array(
            "layout_width"          => "",
            "image"                 => "",
            "icon_pack"             => "",
            "fa_icon"               => "",
            "fe_icon"               => "",
            "icon_custom_size"      => "55",
            "icon_color"            => "",
            "title"                 => "",
            "title_color"           => "",
            "title_size"            => "",
            "title_tag"             => "h5",
            "link"                  => "",
            "link_text"             => "SEE MORE",
            "target"                => "_self",
            "link_color"            => "",
            "link_border_color"     => "",
            "link_background_color" => ""
        );

        extract(shortcode_atts($args, $atts));

        $headings_array = array('h2', 'h3', 'h4', 'h5', 'h6');

        //get correct heading value. If provided heading isn't valid get the default one
        $title_tag = (in_array($title_tag, $headings_array)) ? $title_tag : $args['title_tag'];
        
        //init variables
        $html            = "";
        $title_styles    = "";
        $subtitle_styles = "";
        $line_styles     = "";
        $no_icon         = "";
        $icon_styles     = "";
        $link_style      = "";
        $icon_font_style = "";
        
        //generate styles
        if($title_color != "") {
            $title_styles .= "color: ".$title_color.";";
        }
        
        if($title_size != "") {
            $valid_title_size = (strstr($title_size, 'px', true)) ? $title_size : $title_size.'px';
            $title_styles .= "font-size: ".$valid_title_size.";";
        }

        $icon_styles .= "style='";
        
        if($icon_color != "") {
            $icon_styles .= "color: ".$icon_color.";";
        }

        if($icon_custom_size != "") {
            $icon_font_style .= ' font-size: '.$icon_custom_size;
            if(!strstr($icon_custom_size, 'px')) {
                $icon_font_style .= 'px;';
            }
            $icon_styles .= $icon_font_style;
        }

        $icon_styles .= "'";
        
        if (is_numeric($image)) {
            $image_src = wp_get_attachment_url($image);
        } else {
            $image_src = $image;
        }

        if(($icon_pack == '') || (($icon_pack == 'font_awesome') && ($fa_icon == '')) || (($icon_pack == 'font_elegant') && ($fe_icon == ''))){
            $no_icon = "no_icon";
        }

        if($link_color != ""){
            $link_style .= "color: ".$link_color.";";
        }

        if($link_border_color != ""){
            $link_style .= "border-color: ".$link_border_color.";";
        }

        if($link_background_color != ""){
            $link_style .= "background-color: ".$link_background_color.";";
        }
        
        //generate output
        $html .= '<div class="q_image_with_text_over '.$layout_width.'">';
        $html .= '<div class="shader"></div>';
        
        $html .= '<img src="' . $image_src . '" alt="' . $title . '" />';
        $html .= '<div class="text">';
        
        //title and subtitle html
        $html .= '<span class="front_holder">';
        $html .= '<span class="front_inner">';

        if($icon_pack == 'font_awesome' && $fa_icon != ""){
            $html .= '<i class="icon_holder fa '.$fa_icon.'" '.$icon_styles .'></i>';
        }
        elseif($icon_pack == 'font_elegant' && $fe_icon != ""){
            $html .= '<span class="icon_holder q_font_elegant_icon '.$fe_icon.'" aria-hidden="true" '.$icon_styles .'></span>';
        }

        $html .= '<'.$title_tag.' class="caption '.$no_icon.'" style="'.$title_styles.'">'.$title.'</'.$title_tag.'>';
        $html .= '</span>';
        $html .= '</span>';
        
        //image description html which appears on mouse hover
        $html .= '<span class="back_holder">';
        $html .= '<span class="back_inner">';
        $html .= '<div class="desc"><p class="desc_text">' . do_shortcode($content) .'</p>';

        if($link != ""){
            $html .= '<a class="qbutton medium" href="'.$link.'" target="'.$target.'" style="'.$link_style.'">'.$link_text.'</a>';
        }

        $html .= '</div>';
        $html .= '</span>';
        $html .= '</span>';
        
        $html .= '</div>'; //close text div
        $html .= '</div>'; //close image_with_text_over

        return $html;
    }
    
    add_shortcode('image_with_text_over', 'soho_core_image_with_text_over');
}

/* Latest post shortcode */

if (!function_exists('soho_core_latest_post')) {
    function soho_core_latest_post($atts, $content = null) {
        global $qode_options_soho;

        $blog_hide_comments = "";
        if (isset($qode_options_soho['blog_hide_comments'])) {
            $blog_hide_comments = $qode_options_soho['blog_hide_comments'];
        }

        $qode_like = "on";
        if (isset($qode_options_soho['qode_like'])) {
            $qode_like = $qode_options_soho['qode_like'];
        }

        $args = array(
            "type"       	                     => "image_in_box",
            "number_of_posts"                    => "",
            "number_of_colums"                   => "",
            "image_size"                         => "portrait",
            "order_by"                           => "",
            "order"                              => "",
            "category"                           => "",
            "background_color"                   => "",
            "background_pattern"                 => "",
            "background_pattern_image"           => "",
            "text_length"                        => "",
            "text_color"                         => "",
            "title_tag"                          => "h5",
            "title_color"                        => "",
            "display_category"                   => "0",
            "display_time"                       => "1",
            "display_author"                     => "1",
            "display_comments"                   => "1",
            "display_like"                       => "1",
            "display_share"                      => "1",
            "display_read_more"                  => "0",
            "post_description_color"             => "",
            "post_description_background_color"  => "",
            "category_text_color"                => ""
        );

        extract(shortcode_atts($args, $atts));

        $headings_array = array('h2', 'h3', 'h4', 'h5', 'h6');

        //get correct heading value. If provided heading isn't valid get the default one
        $title_tag = (in_array($title_tag, $headings_array)) ? $title_tag : $args['title_tag'];

        if($type != "boxes"){
            $q = new WP_Query(
                array('orderby' => $order_by, 'order' => $order, 'posts_per_page' => $number_of_posts, 'category_name' => $category)
            );
        } else {
            $q = new WP_Query(
                array('orderby' => $order_by, 'order' => $order, 'posts_per_page' => $number_of_colums, 'category_name' => $category)
            );
        }

        $columns_number = "";
        if($number_of_colums == 2){
            $columns_number = "two_columns";
        } else if ($number_of_colums == 3) {
            $columns_number = "three_columns";
        } else if ($number_of_colums == 4) {
            $columns_number = "four_columns";
        }

        $box_style = "";

        if($type == "boxes"){
            if($background_color != ""){
                $box_style .= "background-color: ".$background_color.";";
            }
            if($background_pattern == 'no'){
                $box_style .= "background-image: none;";
            }
            if($background_pattern == 'yes' && $background_pattern_image != ''){
                if(is_numeric($background_pattern_image)) {
                    $image_src = wp_get_attachment_url( $background_pattern_image );
                } else {
                    $image_src = $background_pattern_image;
                }
                $box_style .= "background-image: url('".$image_src."');";
            }
        }

        $title_style = "";
        $post_box_description_style = "";
        $post_left_description_style = "";
        $icon_style = "";
        $category_style = "";

        if($text_color != ""){
            $box_style .= "color: ".$text_color.";";
        }

        if($title_color != ""){
            $title_style .= "color: ".$title_color.";";
        }

        if($type == "boxes" && $post_description_background_color != ""){
            $post_box_description_style .= "background-color: ".$post_description_background_color.";";
        }

        if($post_description_color != ""){
            if($type == "boxes")
                $post_box_description_style .= "color: ".$post_description_color.";";
            elseif($type == "image_in_box")
                $post_left_description_style .= "color: ".$post_description_color.";";
        }

        if($category_text_color != ""){
            $category_style .= "color: ".$category_text_color.";";
        }

        $html = "";
        $html .= "<div class='latest_post_holder $type $columns_number'>";
        $html .= "<ul>";

        while ($q->have_posts()) : $q->the_post();
            $li_classes = "";

            $cat = get_the_category();
            $excerpt = ($text_length > 0) ? mb_substr(get_the_excerpt(), 0, intval($text_length)) : get_the_excerpt();

            $html .= '<li class="clearfix">';

            if($type == "boxes"){
                $html .= '<div class="boxes_image">';
                $html .= '<a href="'.get_permalink().'" target="_self">';
                if($image_size == "square"){
                    $html .= get_the_post_thumbnail(get_the_ID(), 'soho-portfolio-list-square');
                } else {
                    $html .= get_the_post_thumbnail(get_the_ID(), 'portfolio_list_portrait');
                }
                $html .= '</a>';
                $html .= '</div>';

                $html .= '<span class="post_description" style="'.$post_box_description_style.'">';

                if($display_time == '1'){
                    $html .= '<span class="post_date">'.get_the_time('d M Y').'</span>';
                }

                if(($display_time == '1') && ($display_author == '1')){
                    $html .= ' - ';
                }

                if($display_author == '1'){
                    $html .= '<span class="post_author_name"> by ';
                    if(get_the_author_meta('first_name') != "" || get_the_author_meta('last_name') != "") {
                        $html .= get_the_author_meta('first_name') . " " . get_the_author_meta('last_name');
                    } else {
                        $html .= get_the_author_meta('display_name');
                    }
                    $html .= '</span>';
                }

                $html .= '</span>'; //close post_description span
            }

            $html .= '<div class="latest_post" style="'.$box_style.'">';

            if($type == "image_in_box") {
				 $html .= '<div class="latest_post_image clearfix">';
				 $featured_image_array = wp_get_attachment_image_src(get_post_thumbnail_id(), 'latest_post_image');
				 $html .= '<a href="'.get_permalink().'" target="_self"><img src="'. $featured_image_array[0] .'" alt="" /></a>';
				 $html .= '</div>';
			}

            $html .= '<div class="latest_post_text">';
			$html .= '<div class="latest_post_inner">';
            $html .= '<div class="latest_post_text_inner">';
			
            $html .= '<'.$title_tag.' class="latest_post_title"><a style="'.$title_style.'" href="'.get_permalink().'" target="_self">' . get_the_title() . '</a></'.$title_tag.'>';

            if($display_category == '1' && $type == "boxes"){
                $html .= '<span class="post_category" style="'.$category_style.'"><span aria-hidden="true" class="icon_tag" style="'.$category_style.'"></span> ';
                $catCount = 0;
                foreach ($cat as $categ) {
                    if($catCount++ != 0)
                        $html .= esc_html__(' / ', 'soho-core');
                    $html .= '<a style="'.$category_style.'" href="'.get_category_link($categ->term_id).'" target="_self">'.$categ->cat_name.'</a>';
                }
                $html .= '</span>';
            }

            if($type == "boxes"){
                $html .= '<p class="boxes_excerpt">'.$excerpt.'...</p>';
            }

            // share, likes and comments
            $html .= '<div class="post_info">';

            if($display_category == '1' && $type == "image_in_box"){
                $html .= '<span class="post_category" style="'.$category_style.'"><span aria-hidden="true" class="icon_tag" style="'.$category_style.'"></span> ';
                $catCount = 0;
                foreach ($cat as $categ) {
                    if($catCount++ != 0)
                        $html .= esc_html__(' / ', 'soho-core');
                    $html .= '<a style="'.$category_style.'" href="'.get_category_link($categ->term_id).'" target="_self">'.$categ->cat_name.'</a>';
                }
                $html .= '</span>';
            }

            if($type == 'image_in_box' && $display_author == '1'){
                $html .= '<span class="post_author_name " style ="'.$post_left_description_style.'"><span class="icon_pencil_alt post_info_icon" style="'.$post_left_description_style.'"></span><span>';
                if(get_the_author_meta('first_name') != "" || get_the_author_meta('last_name') != "") {
                    $html .= get_the_author_meta('first_name') . " " . get_the_author_meta('last_name');
                } else {
                    $html .= get_the_author_meta('display_name');
                }
                $html .= '</span></span>';
            }

            if($type == 'image_in_box' && $display_time == '1'){
                $html .= '<span class="post_date" style ="'.$post_left_description_style.'"><span class="icon_clock post_info_icon" style="'.$post_left_description_style.'"></span><span>'.get_the_time('d/m/Y').'</span></span>';
            }

            if($display_share == '1'){
                $html .= do_shortcode('[social_share]');
            }

            if($qode_like == "on" && function_exists('soho_core_qode_like')) {
                if($display_like == '1'){
                    $html .= '<span class="blog_like">'.soho_core_qode_like_latest_posts().'</span>';
                }
            }

            if ($blog_hide_comments != "yes" && $display_comments == "1") {
                $html .= '<span class="post_comments">';
                $html .= '<a href="'.get_comments_link().'" target="_self"><span aria-hidden="true" class="icon_comment"></span>';
                $html .= '<span class="qode-comments_counts">'.get_comments_number().'</span>';
                $html .= '</a>';
                $html .= '</span>';
            }

            $html .= '</div>';
            // close share, likes and comments

            if($type == "image_in_box"){
                $html .= '<p class="boxes_excerpt">'.$excerpt.'...</p>';
            }

            if($display_read_more == '1') {
                $html .= '<span class="post_read_more">';
                $html .= '<a href="'.get_permalink().'" target="_self">' . esc_html__("Read More", "soho-core") . '</a>';
                $html .= '</span>';
            }


			$html .= '</div>'; //close latest_post_text_inner span
            $html .= '</div>'; //close latest_post_inner div
            $html .= '</div>'; //close latest_post_text div
            $html .= '</div>'; //close latest_post div

        endwhile;
        wp_reset_postdata();

        $html .= "</ul></div>";
        return $html;
    }

}
add_shortcode('latest_post', 'soho_core_latest_post');

/* Line graph shortcode */

if (!function_exists('soho_core_line_graph')) {
function soho_core_line_graph($atts, $content = null) {
	global $qode_options_soho;
	extract(shortcode_atts(array("type" => "rounded", "custom_color" => "", "labels" => "", "width" => "750", "height" => "350", "scale_steps" => "6", "scale_step_width" => "20"), $atts));
	$id = mt_rand(1000, 9999);
	if($type == "rounded"){
		$bezierCurve = "true";
	}else{
		$bezierCurve = "false";
	}
	
	$id = mt_rand(1000, 9999);
	$html = "<div class='q_line_graf_holder'><div class='q_line_graf'><canvas id='lineGraph".$id."' height='".$height."' width='".$width."'></canvas></div><div class='q_line_graf_legend'><ul>";
	$line_graph_array = explode(";", $content);
	for ($i = 0 ; $i < count($line_graph_array) ; $i = $i + 1){
		$line_graph_el = explode(",", $line_graph_array[$i]);
		$html .=  "<li><div class='color_holder' style='background-color: ".trim($line_graph_el[0]).";'></div><p style='color: ".$custom_color.";'>".trim($line_graph_el[1])."</p></li>";   
	}
	$html .=  "</ul></div></div><script>var lineGraph".$id." = {labels : [";
	$line_graph_labels_array = explode(",", $labels);
	for ($i = 0 ; $i < count($line_graph_labels_array) ; $i = $i + 1){
		if ($i > 0) $html .= ",";
		$html .=  '"'.$line_graph_labels_array[$i].'"';
	}
	$html .= "],";
	$html .= "datasets : [";
	$line_graph_array = explode(";", $content);
	for ($i = 0 ; $i < count($line_graph_array) ; $i = $i + 1){
		$line_graph_el = explode(",", $line_graph_array[$i]);
		if ($i > 0) $html .= ",";
		$values = "";
		for ($j = 2 ; $j < count($line_graph_el) ; $j = $j + 1){
			if ($j > 2) $values .= ",";
			$values .= $line_graph_el[$j];
		}
		$color = soho_qode_hex2rgb(trim($line_graph_el[0]));
		$html .=  "{fillColor: 'rgba(".$color[0].",".$color[1].",".$color[2].",0.7)',data:[".$values."]}";   
	}
	if(!empty($qode_options_soho['text_fontsize'])){
		$text_fontsize = $qode_options_soho['text_fontsize'];
	}else{
		$text_fontsize = 15;
	}
	if(!empty($qode_options_soho['text_color']) && $custom_color == ""){
		$text_color = $qode_options_soho['text_color'];
	} else if(empty($qode_options_soho['text_color']) && $custom_color != ""){
		$text_color = $custom_color;
	} else if(!empty($qode_options_soho['text_color']) && $custom_color != ""){
		$text_color = $custom_color;
	}else{
		$text_color = '#626262';
	}
	$html .= "]};
			var \$j = jQuery.noConflict();
			\$j(document).ready(function() {
				if(\$j('.touch .no_delay').length){
					new Chart(document.getElementById('lineGraph".$id."').getContext('2d')).Line(lineGraph".$id.",{scaleOverride : true,
					scaleStepWidth : ".$scale_step_width.",
					scaleSteps : ".$scale_steps.",
					bezierCurve : ".$bezierCurve.",
					pointDot : false,
					scaleLineColor: '#000000',
					scaleFontColor : '".$text_color."',
					scaleFontSize : ".$text_fontsize.",
					scaleGridLineColor : '#e1e1e1',
					datasetStroke : false,
					datasetStrokeWidth : 0,
					animationSteps : 120,});
				}else{
					\$j('#lineGraph".$id."').appear(function() {
						new Chart(document.getElementById('lineGraph".$id."').getContext('2d')).Line(lineGraph".$id.",{scaleOverride : true,
						scaleStepWidth : ".$scale_step_width.",
						scaleSteps : ".$scale_steps.",
						bezierCurve : ".$bezierCurve.",
						pointDot : false,
						scaleLineColor: '#000000',
						scaleFontColor : '".$text_color."',
						scaleFontSize : ".$text_fontsize.",
						scaleGridLineColor : '#e1e1e1',
						datasetStroke : false,
						datasetStrokeWidth : 0,
						animationSteps : 120,});
					},{accX: 0, accY: -200});
				}						
			});
		</script>";
	return $html;
}
}
add_shortcode('line_graph', 'soho_core_line_graph');

/* Message shortcode */

if (!function_exists('soho_core_message')) {
function soho_core_message($atts, $content = null) {
	global $qode_options_soho;
        
    $args = array(
        "type"                  => "", 
        "background_color"      => "",
        "border_color"          => "",
        "border_width"          => "",
        "icon_pack"             => "",
        "fa_icon"               => "",
        "fe_icon"               => "",
        "icon_size"            	=> "fa-2x",
        "icon_custom_size"      => "",
        "icon_color"            => "",
        "icon_background_color" => "",
        "custom_icon"           => "",
        "close_button_style"    => ""
    );
    extract(shortcode_atts($args, $atts));
    
    //init variables
    $html               = ""; 
    $icon_html          = "";
    $message_classes    = "";
    $message_styles     = "";
    $icon_styles        = "";
        
	if($type == "with_icon"){
        $message_classes .= " with_icon";
	}
        
    if($background_color != "") {
        $message_styles .= "background-color: ".$background_color.";";
    }
    
    if($border_color != "") {
        if($border_width != ""){
            $message_styles .= "border: ".$border_width."px solid ".$border_color.";";
        } else {
            $message_styles .= "border: 2px solid ".$border_color.";";
        }
    }
    
    if($icon_color != "") {
        $icon_styles .= "color: ".$icon_color;
    }

    if($icon_background_color != "") {
        $icon_styles .= " background-color: ".$icon_background_color;
    }

    if($icon_custom_size != "") {
        $icon_font_style = ' font-size: '.$icon_custom_size;
        if(!strstr($icon_custom_size, 'px')) {
            $icon_font_style .= 'px;';
        }
        $icon_styles .= $icon_font_style;
    }
    
    $html .= "<div class='q_message ".$message_classes."' style='".$message_styles."'>";
        $html .= "<div class='q_message_inner'>";   
    	if($type == "with_icon"){
    		$icon_html .= '<div class="q_message_icon_holder"><div class="q_message_icon"><div class="q_message_icon_inner">';
            if($custom_icon != "") {
                if(is_numeric($custom_icon)) {
                    $custom_icon_src = wp_get_attachment_url( $custom_icon );
                } else {
                    $custom_icon_src = $custom_icon;
                }
                
                $icon_html .= '<img src="' . $custom_icon_src . '" alt="">';
            } elseif($icon_pack == 'font_awesome' && $fa_icon != "") {
                $icon_html .= "<i class='fa ".$fa_icon." ". $icon_size . "' style='".$icon_styles."'></i>";
            } elseif($icon_pack == 'font_elegant' && $fe_icon != ""){
                $icon_html .= "<span class='q_font_elegant_icon ".$fe_icon."' aria-hidden='true' style='".$icon_styles ."'></span>";
            }
    		$icon_html .= '</div></div></div>';
    	}
            
        $html .= $icon_html;
            
    	$html .= "<a href='#' class='close'>";
            $html .= "<i class='fa fa-times ".$close_button_style."'></i>";
        $html .= "</a>"; //close a.close
    
        $html .= "<div class='message_text_holder'><div class='message_text'><div class='message_text_inner'>".do_shortcode($content)."</div></div></div>";
        
        $html .= "</div></div>"; //close message text div
	return $html;
}
}
add_shortcode('message', 'soho_core_message');

/* Ordered List shortcode */

if (!function_exists('soho_core_ordered_list')) {
function soho_core_ordered_list($atts, $content = null) {
    $html =  "<div class=ordered>" . $content . "</div>";  
    return $html;
}
}
add_shortcode('ordered_list', 'soho_core_ordered_list');

/* Pie Chart shortcode */

if (!function_exists('soho_core_pie_chart')) {

    function soho_core_pie_chart($atts, $content = null) {

        global $qode_options_soho;

        $args = array(
            "title"                 => "",
            "title_color"           => "",
            "title_tag"             => "h5",
            "percent"               => "",
            "percentage_color"      => "",
            "show_percent_mark"     => "yes",
            "active_color"          => "",
            "noactive_color"        => "",
            "line_width"            => "",
            "text"                  => "",
            "text_color"            => ""
        );

        extract(shortcode_atts($args, $atts));

        $headings_array = array('h2', 'h3', 'h4', 'h5', 'h6');

        //get correct heading value. If provided heading isn't valid get the default one
        $title_tag = (in_array($title_tag, $headings_array)) ? $title_tag : $args['title_tag'];

        $html               = '';
        $percent_mark_class = '';

        if($show_percent_mark != "yes"){
            $percent_mark_class .= "without_percent_mark";
        }

        $html .= '<div class="q_pie_chart_holder"><div class="q_percentage" data-percent="'.$percent.'" data-linewidth="'.$line_width.'" data-active="'.$active_color.'" data-noactive="'.$noactive_color.'">';
        $html .= '<span class="tocounter '.$percent_mark_class.'"';
        if ($percentage_color != "") {
            $html .= ' style="color: ' . $percentage_color . ';"';
        }
        $html .= '>' . $percent . '</span>';
        $html .= '</div><div class="pie_chart_text">';

            if ($title != "") {
                $html .= '<'.$title_tag.' class="pie_title"';
                if ($title_color != "") {
                    $html .= ' style="color: ' . $title_color . ';"';
                }
                $html .= '>' . $title . '</'.$title_tag.'>';
            }

            if ($text != "") {
                $html .= '<p';
                if($text_color != ""){
                    $html .= ' style="color: '.$text_color.';"';
                }
                $html .= '>' . $text . '</p>';
            }

        $html .= "</div></div>";
        return $html;
    }

}
add_shortcode('pie_chart', 'soho_core_pie_chart');

/* Pie Chart With Icon shortcode */

if (!function_exists('soho_core_pie_chart_with_icon')) {

    function soho_core_pie_chart_with_icon($atts, $content = null) {

        global $qode_options_soho;

        $args = array(
            "percent"         => "",
            "active_color"    => "",
            "noactive_color"  => "",
            "line_width"      => "",
            "icon_pack"       => "",
            "fa_icon"         => "",
            "fe_icon"         => "",
            "icon_color"      => "",
            "title"           => "",
            "title_color"     => "",
            "title_tag"       => "h5",
            "text"            => "",
            "text_color"      => ""
        );

        extract(shortcode_atts($args, $atts));

        $headings_array = array('h2', 'h3', 'h4', 'h5', 'h6');

        //get correct heading value. If provided heading isn't valid get the default one
        $title_tag = (in_array($title_tag, $headings_array)) ? $title_tag : $args['title_tag'];
        
        $html = '';

        $html .= '<div class="q_pie_chart_with_icon_holder"><div class="q_percentage_with_icon" data-percent="'.$percent.'" data-linewidth="'.$line_width.'" data-active="'.$active_color.'" data-noactive="'.$noactive_color.'">';

        if($icon_pack == 'font_awesome' && $fa_icon != ""){
            $html .= '<i class="fa '.$fa_icon.'"';


            if ($icon_color != "") {
                $html .= ' style="color: ' . $icon_color . ';"';
            }
            $html .= '></i>';
        }

        elseif($icon_pack == 'font_elegant' && $fe_icon != ""){
            $html .= '<span class="q_font_elegant_icon '.$fe_icon.'"';


            if ($icon_color != "") {
                $html .= ' style="color: ' . $icon_color . ';"';
            }
            $html .= '></span>';
        }

        $html .= '</div><div class="pie_chart_text">';
            if ($title != "") {
                $html .= '<'.$title_tag.' class="pie_title"';
                if ($title_color != "") {
                    $html .= ' style="color: ' . $title_color . ';"';
                }
                $html .= '>' . $title . '</'.$title_tag.'>';
            }

            if ($text != "") {
                $html .= '<p ';
                if ($text_color != "") {
                    $html .= ' style="color: ' . $text_color . ';"';
                }
                $html .= '>' . $text . '</p>';
            }
        $html .= "</div></div>";
        return $html;
    }
}
add_shortcode('pie_chart_with_icon', 'soho_core_pie_chart_with_icon');

/* Pie Chart Full shortcode */

if (!function_exists('soho_core_pie_chart2')) {
function soho_core_pie_chart2($atts, $content = null) {
	extract(shortcode_atts(array("width" => "120", "height" => "120", "color" => ""), $atts));
    $id = mt_rand(1000, 9999);
    $html = "<div class='q_pie_graf_holder'><div class='q_pie_graf'><canvas id='pie".$id."' height='".$height."' width='".$width."'></canvas></div><div class='q_pie_graf_legend'><ul>";
    $pie_chart_array = explode(";", $content);
    for ($i = 0 ; $i < count($pie_chart_array) ; $i = $i + 1){
    	$pie_chart_el = explode(",", $pie_chart_array[$i]);
		$html .= "<li><div class='color_holder' style='background-color: ".trim($pie_chart_el[1]).";'></div><p style='color: ".$color.";'>".trim($pie_chart_el[2])."</p></li>";   
    }
    $html .= "</ul></div></div><script>var pie".$id." = [";
    $pie_chart_array = explode(";", $content);
    for ($i = 0 ; $i < count($pie_chart_array) ; $i = $i + 1){
    	$pie_chart_el = explode(",", $pie_chart_array[$i]);
    	if ($i > 0) $html .= ",";
		$html .= "{value: ".trim($pie_chart_el[0]).",color:'".trim($pie_chart_el[1])."'}";   
    }
    $html .= "];
		var \$j = jQuery.noConflict();
		\$j(document).ready(function() {
			if(\$j('.touch .no_delay').length){
				new Chart(document.getElementById('pie".$id."').getContext('2d')).Pie(pie".$id.",{segmentStrokeColor : 'transparent',});
			}else{
				\$j('#pie".$id."').appear(function() {
					new Chart(document.getElementById('pie".$id."').getContext('2d')).Pie(pie".$id.",{segmentStrokeColor : 'transparent',});
				},{accX: 0, accY: -200});
			}
		});
	</script>";
    return $html;
}
}
add_shortcode('pie_chart2', 'soho_core_pie_chart2');

/* Pie Chart Doughnut shortcode */

if (!function_exists('soho_core_pie_chart3')) {
function soho_core_pie_chart3($atts, $content = null) {
    extract(shortcode_atts(array("width" => "120", "height" => "120", "color" => ""), $atts));
    $id = mt_rand(1000, 9999);
    $html = "<div class='q_pie_graf_holder'><div class='q_pie_graf'><canvas id='pie".$id."' height='".$height."' width='".$width."'></canvas></div><div class='q_pie_graf_legend'><ul>";
    $pie_chart_array = explode(";", $content);
    for ($i = 0 ; $i < count($pie_chart_array) ; $i = $i + 1){
    	$pie_chart_el = explode(",", $pie_chart_array[$i]);
		$html .= "<li><div class='color_holder' style='background-color: ".trim($pie_chart_el[1]).";'></div><p style='color: ".$color.";'>".trim($pie_chart_el[2])."</p></li>";   
    }
    $html .= "</ul></div></div><script>var pie".$id." = [";
    $pie_chart_array = explode(";", $content);
    for ($i = 0 ; $i < count($pie_chart_array) ; $i = $i + 1){
    	$pie_chart_el = explode(",", $pie_chart_array[$i]);
    	if ($i > 0) $html .= ",";
			$html .= "{value: ".trim($pie_chart_el[0]).",color:'".trim($pie_chart_el[1])."'}";   
    }
    $html .= "];
		var \$j = jQuery.noConflict();
		\$j(document).ready(function() {
			if(\$j('.touch .no_delay').length){
				new Chart(document.getElementById('pie".$id."').getContext('2d')).Doughnut(pie".$id.",{segmentStrokeColor : 'transparent',});
			}else{
				\$j('#pie".$id."').appear(function() {
					new Chart(document.getElementById('pie".$id."').getContext('2d')).Doughnut(pie".$id.",{segmentStrokeColor : 'transparent',});
				},{accX: 0, accY: -200});
			}							
		});
	</script>";
    return $html;
}
}
add_shortcode('pie_chart3', 'soho_core_pie_chart3');

/* Portfolio shortcode */

if (!function_exists('soho_core_portfolio_list')) {

    function soho_core_portfolio_list($atts, $content = null) {

        global $wp_query;
        global $portfolio_project_id;
        global $qode_options_soho;
        $portfolio_qode_like = "on";
        if (isset($qode_options_soho['portfolio_qode_like'])) {
            $portfolio_qode_like = $qode_options_soho['portfolio_qode_like'];
        }

        $args = array(
            "type"                    => "standard",
            "columns"                 => "3",
            "image_size"              => "portrait",
            "order_by"                => "menu_order",
            "order"                   => "ASC",
            "number"                  => "-1",
            "filter"                  => "no",
            "filter_in_grid"          => "",
            "hover_type"              => "hover_default",
            "lightbox"                => "yes",
            "link_type"               => "single_link",
            "show_like"               => "yes",
            "category"                => "",
            "selected_projects"       => "",
            "show_load_more"          => "",
            "show_load_more_position" => "right",
            "title_tag"               => "h5"
        );

        extract(shortcode_atts($args, $atts));

        $headings_array = array('h2', 'h3', 'h4', 'h5', 'h6');

        //get correct heading value. If provided heading isn't valid get the default one
        $title_tag = (in_array($title_tag, $headings_array)) ? $title_tag : $args['title_tag'];

        $html = "";
        $_type_class = '';

        if ($type == "standard"){
            $_type_class = " standard";
        } elseif ($type == "gallery") {
            $_type_class = " gallery";
        } elseif ($type == "gallery_no_space") {
            $_type_class = " gallery without_space";
        }

        $html .= "<div class='projects_holder_outer v$columns'>";
        if ($filter == "yes") {
            $page_template = get_page_template_slug();
            $filter_in_grid_class = '';
            if($filter_in_grid == 'yes'){ $filter_in_grid_class = 'filter_in_grid'; }

            if($page_template != "full_width.php") {
                $html .= "<div class='container'><div class='container_inner clearfix'>";
            }

            if ($category == "") {
                $args = array(
                    'parent' => 0,
                    'fields' => 'count',
                );
                $cat_count = get_terms('portfolio_category', $args)+1;
            } else {
                $parent_category = get_term_by('slug', $category, 'portfolio_category');
                $term_id = '';
                if (isset($parent_category->term_id))
                    $term_id = $parent_category->term_id;
                $args = array(
                    'parent' => $term_id,
                    'fields' => 'count',
                );
                $cat_count = get_terms('portfolio_category', $args)+1;
            }

            $html .= "<div class='filter_holder ".$filter_in_grid_class." v$cat_count'>";

                $html .= "<ul>";
                $html .= "<li class='filter' data-filter='all'><span>" . esc_html__('All', 'soho-core') . "</span></li>";

                if ($category == "") {
                    $args = array(
                        'parent' => 0
                    );
                    $portfolio_categories = get_terms('portfolio_category', $args);
                } else {
                    $top_category = get_term_by('slug', $category, 'portfolio_category');
                    $term_id = '';
                    if (isset($top_category->term_id))
                        $term_id = $top_category->term_id;
                    $args = array(
                        'parent' => $term_id
                    );
                    $portfolio_categories = get_terms('portfolio_category', $args);
                }

                foreach ($portfolio_categories as $portfolio_category) {
                    $html .= "<li class='filter' data-filter='portfolio_category_$portfolio_category->term_id'><span>$portfolio_category->name</span>";
                    $args = array(
                        'child_of' => $portfolio_category->term_id
                    );
                    $html .= '</li>';
                }

                $html .= "</ul>";

            $html .= "</div>";

            $html .= "<div class='filter_holder_mobile'>";

                $html .= "<ul><li class='label'><span data-label='". esc_html__('Filter','soho-core') ."'>". esc_html__('Filter','soho-core') ."</span><i class='fa fa-angle-down'></i>
						</li>";
                $html .= "<li class='filter' data-filter='all'><span>" . esc_html__('All', 'soho-core') . "</span></li>";

                if ($category == "") {
                    $args = array(
                        'parent' => 0
                    );
                    $portfolio_categories = get_terms('portfolio_category', $args);
                } else {
                    $top_category = get_term_by('slug', $category, 'portfolio_category');
                    $term_id = '';
                    if (isset($top_category->term_id))
                        $term_id = $top_category->term_id;
                    $args = array(
                        'parent' => $term_id
                    );
                    $portfolio_categories = get_terms('portfolio_category', $args);
                }

                foreach ($portfolio_categories as $portfolio_category) {
                    $html .= "<li class='filter' data-filter='portfolio_category_$portfolio_category->term_id'><span>$portfolio_category->name</span>";
                    $args = array(
                        'child_of' => $portfolio_category->term_id
                    );
                    $html .= '</li>';
                }

                $html .= "</ul>";

            $html .= "</div>";

            if($page_template != "full_width.php") {
                $html .= "</div></div>";
            }
        }

        $html .= "<div class='projects_holder clearfix v$columns$_type_class'>\n";
        if (get_query_var('paged')) {
            $paged = get_query_var('paged');
        } elseif (get_query_var('page')) {
            $paged = get_query_var('page');
        } else {
            $paged = 1;
        }
        if ($category == "") {
            $args = array(
                'post_type' => 'portfolio_page',
                'orderby' => $order_by,
                'order' => $order,
                'posts_per_page' => $number,
                'paged' => $paged
            );
        } else {
            $args = array(
                'post_type' => 'portfolio_page',
                'portfolio_category' => $category,
                'orderby' => $order_by,
                'order' => $order,
                'posts_per_page' => $number,
                'paged' => $paged
            );
        }
        $project_ids = null;
        if ($selected_projects != "") {
            $project_ids = explode(",", $selected_projects);
            $args['post__in'] = $project_ids;
        }

        $q = new WP_Query( $args );

        if ($q->have_posts()) : while ($q->have_posts()) : $q->the_post();
            $terms = wp_get_post_terms(get_the_ID(), 'portfolio_category');
            $html .= "<article class='mix ";
            foreach ($terms as $term) {
                $html .= "portfolio_category_$term->term_id ";
            }

            $title = get_the_title();
            $featured_image_array = wp_get_attachment_image_src(get_post_thumbnail_id(), 'full'); //original size
            $large_image = $featured_image_array[0];
            $slug_list_ = "pretty_photo_gallery";

            $html .="'>";

            $html .= "<div class='image_holder'>";
            $html .= "<span class='image'>";
                if($image_size == "square"){
                    $html .= get_the_post_thumbnail(get_the_ID(), 'soho-portfolio-list-square');
                } elseif ($image_size == "portrait"){
                    $html .= get_the_post_thumbnail(get_the_ID(), 'portfolio_list_portrait');
                } else {
                    $html .= get_the_post_thumbnail(get_the_ID(), 'full');
                }
            $html .= "</span>";

            if ($type == "standard") {

                if($link_type != "no_link"){
                    if(get_post_meta(get_the_ID(), "qode_custom-portfolio-single-link", true) != ""){
                        $html .= '<a class="portfolio_link_class" href="'.get_post_meta(get_the_ID(), "qode_custom-portfolio-single-link", true).'" target="_self"></a>';
                    } else {
                        $html .= '<a class="portfolio_link_class" href="'.get_permalink().'" target="_self"></a>';
                    }
                }

                $html .= "<span class='text_holder'>";
                $html .= "<span class='text_outer'>";
                $html .= "<span class='text_inner'>";
                $html .= "<span class='feature_holder'>";

                    if ($hover_type == "hover_with_likes"){
                        if ($portfolio_qode_like == "on") {
                            if($show_like == "yes"){
                                $html .= "<span class='portfolio_like'>";
                                $portfolio_project_id = get_the_ID();

                                if (function_exists('soho_core_qode_like_portfolio_list')) {
                                    $html .= soho_core_qode_like_portfolio_list();
                                }
                                $html .= "</span>";
                            }
                        }
                    }

                $html .= "</span></span></span></span>";

                if ($lightbox == "yes" && $hover_type == "hover_default") {
                    $html .= "<a class='lightbox fs1' aria-hidden='true' data-icon='&#x55;' title='".$title."' href='".$large_image."' data-rel='prettyPhoto[".$slug_list_."]'></a>";
                }

            } else if ($type == "gallery" || $type == "gallery_no_space") {

                if($link_type != "no_link"){
                    if(get_post_meta(get_the_ID(), "qode_custom-portfolio-single-link", true) != ""){
                        $html .= '<a class="portfolio_link_class" href="'.get_post_meta(get_the_ID(), "qode_custom-portfolio-single-link", true).'" target="_self"></a>';
                    } else {
                        $html .= '<a class="portfolio_link_class" href="'.get_permalink().'" target="_self"></a>';
                    }
                }

                $html .= "<span class='text_holder'>";
                $html .= "<span class='text_outer'>";
                $html .= "<span class='text_inner'>";
                $html .= "<span class='feature_holder'>";

                    $html .= '<span class="feature_holder_info">';

                        $html .= '<'.$title_tag.' class="portfolio_title">'.get_the_title().'</'.$title_tag.'>';

                        $html .= '<span class="project_category">';
                        $k = 1;
                        foreach ($terms as $term) {
                            $html .= "$term->name";
                            if (count($terms) != $k) {
                                $html .= ' / ';
                            }
                            $k++;
                        }
                        $html .= '</span>';
                    $html .= "</span>";

                    $html .= '<span class="feature_holder_icons">';

                        if ($hover_type == "hover_with_likes"){
                            if ($portfolio_qode_like == "on") {
                                if($show_like == "yes"){
                                    $html .= "<span class='portfolio_like'>";
                                    $portfolio_project_id = get_the_ID();

                                    if (function_exists('soho_core_qode_like_portfolio_list')) {
                                        $html .= soho_core_qode_like_portfolio_list();
                                    }
                                    $html .= "</span>";
                                }
                            }
                        }

                    $html .= "</span>";    

                $html .= "</span></span></span></span>";

                if ($lightbox == "yes" && $hover_type == "hover_default") {
                    $html .= "<a class='lightbox fs1' aria-hidden='true' data-icon='&#x55;' title='".$title."' href='".$large_image."' data-rel='prettyPhoto[".$slug_list_."]'></a>";
                }
            }
            $html .= "</div>";
            if ($type == "standard") {
                $html .= "<div class='portfolio_description'>";

                if($link_type != "no_link"){
                    if(get_post_meta(get_the_ID(), "qode_custom-portfolio-single-link", true) != ""){
                        $html .= '<'.$title_tag.' class="portfolio_title"><a href="'.get_post_meta(get_the_ID(), "qode_custom-portfolio-single-link", true).'" target="_self">'.get_the_title().'</a></'.$title_tag.'>';
                    } else {
                        $html .= '<'.$title_tag.' class="portfolio_title"><a href="'.get_permalink().'" target="_self">'.get_the_title().'</a></'.$title_tag.'>';
                    }
                } else {
                    $html .= '<'.$title_tag.' class="portfolio_title">'.get_the_title().'</'.$title_tag.'>';
                }

                $html .= '<span class="project_category">' . esc_html__('Category:', 'soho-core');
                $k = 1;
                foreach ($terms as $term) {
                    $html .= "$term->name";
                    if (count($terms) != $k) {
                        $html .= ' / ';
                    }
                    $k++;
                }
                $html .= '</span>';
                $html .= '</div>';
            }

            $html .= "</article>\n";

        endwhile;

            $i = 1;
            while ($i <= $columns) {
                $i++;
                if ($columns != 1) {
                    $html .= "<div class='filler'></div>\n";
                }
            }

        else:
            ?>
            <p><?php esc_html_e('Sorry, no posts matched your criteria.', 'soho-core'); ?></p>
        <?php
        endif;


        $html .= "</div>";
        if (get_next_posts_link('', $q->max_num_pages)) {
            if ($show_load_more == "yes" || $show_load_more == "") {
                $html .= '<div class="portfolio_load_more '.$show_load_more_position.'"><span rel="' . $q->max_num_pages . '" class="q_load_more">' . get_next_posts_link(esc_html__('LOAD MORE', 'soho-core'), $q->max_num_pages) . '</span></div>';
            }
        }
        $html .= "</div>";
        wp_reset_postdata();
        return $html;
    }
}
add_shortcode('portfolio_list', 'soho_core_portfolio_list');

/* Portfolio Slider shortcode */

if (!function_exists('soho_core_portfolio_slider')) {
function soho_core_portfolio_slider( $atts, $content = null ) {

    global $portfolio_project_id;
    global $qode_options_soho;
    $portfolio_qode_like = "on";
    if (isset($qode_options_soho['portfolio_qode_like'])) {
        $portfolio_qode_like = $qode_options_soho['portfolio_qode_like'];
    }

    $args = array(
        "order_by"          => "menu_order",
        "space_between_images" => "no",
        "image_size"        => "portrait",
        "order"             => "ASC",
        "number"            => "-1",
        "category"          => "",
        "selected_projects" => "",
        "lightbox"          => "yes",
        "link_type"         => "single_link",
        "title_tag"         => "h5"
    );
    extract(shortcode_atts($args, $atts));

    $headings_array = array('h2', 'h3', 'h4', 'h5', 'h6');

    //get correct heading value. If provided heading isn't valid get the default one
    $title_tag = (in_array($title_tag, $headings_array)) ? $title_tag : $args['title_tag'];

    $space_between_images_class = "";
    if($space_between_images == "yes"){ $space_between_images_class = "with_space"; }

    $html = "";
    
    $html .= "<div class='portfolio_slider_holder clearfix'><div class='portfolio_slider ".$space_between_images_class."'><ul class='portfolio_slides'>";

    if ($category == "") {
        $q = array(
            'post_type' => 'portfolio_page',
            'orderby' => $order_by,
            'order' => $order,
            'posts_per_page' => $number
        );
    } else {
        $q = array(
            'post_type' => 'portfolio_page',
            'portfolio_category' => $category,
            'orderby' => $order_by,
            'order' => $order,
            'posts_per_page' => $number
        );
    }

    $project_ids = null;
    if ($selected_projects != "") {
        $project_ids = explode(",", $selected_projects);
        $q['post__in'] = $project_ids;
    }

    $query = new WP_Query($q);

    if ( $query->have_posts() ) : $postCount = 0; while ( $query->have_posts() ) : $query->the_post();

        $title = get_the_title();
        $terms = wp_get_post_terms(get_the_ID(), 'portfolio_category');
       
        if($image_size == "square"){
            $featured_image_array = wp_get_attachment_image_src(get_post_thumbnail_id(), 'soho-portfolio-list-square');
        } else {
            $featured_image_array = wp_get_attachment_image_src(get_post_thumbnail_id(), 'portfolio_list_portrait');
        }

        $large_image = $featured_image_array[0];

        $html .= "<li class='item'>";

            $html .= "<div class='image_holder'>";
                $html .= "<span class='image'>";
                    $html .= "<img src='".$large_image."' alt='".$title."'>";
                $html .= "</span>";


                $html .= "<span class='text_holder'>";

                if($link_type != "no_link"){
                    if(get_post_meta(get_the_ID(), "qode_custom-portfolio-single-link", true) != ""){
                        $html .= '<a class="portfolio_link_class" href="'.get_post_meta(get_the_ID(), "qode_custom-portfolio-single-link", true).'" target="_self"></a>';
                    } else {
                        $html .= '<a class="portfolio_link_class" href="'.get_permalink().'" target="_self">';
                    }
                }

                $html .= "<span class='text_outer'>";
                $html .= "<span class='text_inner'>";
                $html .= "<span class='feature_holder'>";
                $html .= '<span class="feature_holder_info">';

                $html .= '<'.$title_tag.' class="portfolio_title">'.get_the_title().'</'.$title_tag.'>';

                    $html .= '<span class="project_category">';
                    $k = 1;
                    foreach ($terms as $term) {
                        $html .= "$term->name";
                        if (count($terms) != $k) {
                            $html .= ' / ';
                        }
                        $k++;
                    }
                    $html .= '</span>';
                $html .= "</span>";

                $html .= "</span></span></span>";

                 if($link_type != "no_link"){
                            $html .= '</a>';
                        }

                $html .= "</span>";

                if ($lightbox == "yes") {
                    $html .= "<a class='lightbox fs1' aria-hidden='true' data-icon='&#x55;' title='".$title."' href='".$large_image."' data-rel='prettyPhoto[portfolio_slider_images]'></a>";
                }

            $html .= "</div>";

        $html .= "</li>";

        $postCount++;

    endwhile;

    else:
        $html .= esc_html__('Sorry, no posts matched your criteria.','soho-core');
    endif;

    wp_reset_postdata();

    $html .= "</ul>";
		$html .="</div></div>";
    
    return $html;
}
}
add_shortcode('portfolio_slider', 'soho_core_portfolio_slider');

/* Progress bar horizontal shortcode */

if (!function_exists('soho_core_progress_bar')) {

    function soho_core_progress_bar($atts, $content = null) {
        $args = array(
            "title"                     => "",
            "title_color"               => "",
            "title_tag"                 => "h5",
            "percent"                   => "",
            "percent_color"             => "",
            "show_percent_mark"         => "yes",
            "active_background_color"   => "",
            "noactive_background_color" => "",
            "height"                    => ""
        );

        extract(shortcode_atts($args, $atts));
        
        $headings_array = array('h2', 'h3', 'h4', 'h5', 'h6');
                
        //get correct heading value. If provided heading isn't valid get the default one
        $title_tag = (in_array($title_tag, $headings_array)) ? $title_tag : $args['title_tag'];

        //init variables
        $html                           = "";
        $progress_title_holder_styles   = "";
        $number_styles                  = "";
        $outer_progress_styles          = "";
        $percentage_styles              = "";

        //generate styles
        if ($title_color != "") {
            $progress_title_holder_styles .= "color: " . $title_color . ";";
        }

        if ($percent_color != "") {
            $number_styles .= "color: " . $percent_color . ";";
        }

        if ($height != "") {
            $valid_height = (strstr($height, 'px', true)) ? $height : $height . "px";
            $outer_progress_styles .= "height: " . $valid_height . ";";
            $percentage_styles .= "height: " . $valid_height . ";";
        }

        if ($noactive_background_color != "") {
            $outer_progress_styles .= "background-color: ".$noactive_background_color.";";
        }

        if ($active_background_color != "") {
            $percentage_styles .= "background-color: ".$active_background_color.";";
        }

        $html .= "<div class='q_progress_bar'>";
        $html .= "<div class='progress_title_holder clearfix'>";
        $html .= "<div class='progress_title'>";
        $html .= "<{$title_tag} style='{$progress_title_holder_styles}'>$title</{$title_tag}>";
        $html .= "</div>"; //close progress_title

        $html .= "<span class='progress_number_wrapper'>";
        $html .= "<span class='progress_number' style='{$number_styles}'>";
        $html .= "<span>" . $percent . "</span>";
        if($show_percent_mark == "yes"){
            $html .= "%";
        }
        $html .= "</span>";
        $html .= "</span>"; //close progress_number_wrapper
        $html .= "</div>"; //close progress_title_holder
        
        $html .= "<div class='progress_content_outer' style='{$outer_progress_styles}'>";
        $html .= "<div data-percentage='" . $percent . "' class='progress_content' style='{$percentage_styles}'>";
        $html .="</div>"; //close progress_content
        $html .= "</div>"; //close progress_content_outer

        $html .= "</div>"; //close progress_bar
        return $html;
    }
    
    add_shortcode('progress_bar', 'soho_core_progress_bar');
}

/* Progress bars icon shortcode */

if (!function_exists('soho_core_progress_bar_icon')) {
function soho_core_progress_bar_icon($atts, $content = null) {

    $args =  array(
        "icons_number"              => "",
        "active_number"             => "",
        "type"                      => "",
        "icon_pack"                 => "",
        "fa_icon"                   => "",
        "fe_icon"                   => "",
        "size"                      => "",
        "icon_color"                => "",
        "icon_active_color"         => "",
        "background_color"          => "",
        "background_active_color"   => "",
        "border_color"              => "",
        "border_active_color"       => ""
    );

    extract(shortcode_atts($args, $atts));
    $html =  "<div class='q_progress_bars_icons_holder'><div class='q_progress_bars_icons'><div class='q_progress_bars_icons_inner ".$type." ".$size;

    $html .= " clearfix' data-number='".$active_number."'>";

    $i = 0;
    while ($i < $icons_number) {
        $html .= "<div class='bar'><span class='bar_noactive fa-stack ";
        if($size != ""){
            if($size == "tiny"){
                $html .= "fa-lg";
            } else if($size == "small"){
                $html .= "fa-2x";
            } else if($size == "medium"){
                $html .= "fa-3x";
            } else if($size == "large"){
                $html .= "fa-4x";
            } else if($size == "very_large"){
                $html .= "fa-5x";
            }
        }
        $html .= "'";
        if($type == "circle" || $type == "square"){
            if($background_active_color != "" || $border_active_color != ""){
                $html .= " style='";
                if($background_active_color != ""){
                    $html .= "background-color: ".$background_active_color.";";
                }
                if($border_active_color != ""){
                    $html .= " border-color: ".$border_active_color.";";    
                }
                $html .= "'";
            }
        }
        $html .= ">";

        if($icon_pack == 'font_awesome' && $fa_icon != ''){
            $html .= "<i class='fa fa-stack-1x ".$fa_icon."'";

            if($icon_active_color != ""){
                $html .= " style='color: ".$icon_active_color.";'";
            }

            $html .= "></i>";
        }
        elseif($icon_pack == 'font_elegant' && $fe_icon != ''){
            $html .= "<span class='q_font_elegant_icon ".$fe_icon."'";

            if($icon_active_color != ""){
                $html .= " style='color: ".$icon_active_color.";'";
            }

            $html .= "></span>";
        }

        $html .= "</span><span class='bar_active fa-stack ";
        if($size != ""){
            if($size == "tiny"){
                $html .= "fa-lg";
            } else if($size == "small"){
                $html .= "fa-2x";
            } else if($size == "medium"){
                $html .= "fa-3x";
            } else if($size == "large"){
                $html .= "fa-4x";
            } else if($size == "very_large"){
                $html .= "fa-5x";
            }
        }
        $html .= "'";
        if($type == "circle" || $type == "square"){
            if($background_color != "" || $border_color != ""){
                $html .= " style='";
                if($background_color != ""){
                    $html .= "background-color: ".$background_color.";";
                }
                if($border_color != ""){
                    $html .= " border-color: ".$border_color.";";   
                }
                $html .= "'";
            }
        }
        $html .= ">";

        if($icon_pack == 'font_awesome' && $fa_icon != ''){
            $html .= "<i class='fa ".$fa_icon." fa-stack-1x'";

            if($icon_color != ""){
                $html .= " style='color: ".$icon_color.";'";
            }

            $html .= "></i>";
        }
        elseif($icon_pack == 'font_elegant' && $fa_icon != ''){
            $html .= "<span class='q_font_elegant_icon ".$fe_icon."'";

            if($icon_color != ""){
                $html .= " style='color: ".$icon_color.";'";
            }

            $html .= "></span>";
        }

        $html .= "</span></div>";


        $i++;
    }
    $html .= "</div></div></div>";
    return $html;
}
}
add_shortcode('progress_bar_icon', 'soho_core_progress_bar_icon');

/* Qode Carousel shortcode */

if (!function_exists('soho_core_qode_carousel')) {
function soho_core_qode_carousel( $atts, $content = null ) {
    $args = array(
        "carousel" => "",
        "orderby"  => "date",
        "order"    => "ASC"
    );
    extract(shortcode_atts($args, $atts));

    $html = "";
    
    if ($carousel != "") {

        $html .= "<div class='qode_carousels_holder clearfix'><div class='qode_carousels'><ul class='slides'>";

        $q = array('post_type'=> 'carousels', 'carousels_category' => $carousel, 'orderby' => $orderby, 'order' => $order, 'posts_per_page' => '-1');

        $query = new WP_Query($q);

        if ( $query->have_posts() ) : $postCount = 0; while ( $query->have_posts() ) : $query->the_post();

            if(get_post_meta(get_the_ID(), "qode_carousel-image", true) != ""){
                $image = get_post_meta(get_the_ID(), "qode_carousel-image", true);
            } else {
                $image = "";
            }

            if(get_post_meta(get_the_ID(), "qode_carousel-hover-image", true) != ""){
                $hover_image = get_post_meta(get_the_ID(), "qode_carousel-hover-image", true);
                $has_hover_image = "has_hover_image";
            } else {
                $hover_image = "";
                $has_hover_image = "";
            }

            if(get_post_meta(get_the_ID(), "qode_carousel-item-link", true) != ""){
                $link = get_post_meta(get_the_ID(), "qode_carousel-item-link", true);
            } else {
                $link = "";
            }

            if(get_post_meta(get_the_ID(), "qode_carousel-item-target", true) != ""){
                $target = get_post_meta(get_the_ID(), "qode_carousel-item-target", true);
            } else {
                $target = "_self";
            }

            $title = get_the_title();

            $html .= "<li class='item'>";

            if($link != ""){
                $html .= "<a href='".$link."' target='".$target."'>";
            }

            if($image != ""){
                $html .= "<span class='first_image_holder ".$has_hover_image."'><img src='".$image."' alt='".$title."'></span>";
            }

            if($hover_image != ""){
                $html .= "<span class='second_image_holder ".$has_hover_image."'><img src='".$hover_image."' alt='".$title."'></span>";
            }
            
            if($link != ""){
                $html .= "</a>";
            }

            $html .= "</li>";

            $postCount++;

        endwhile;

        else:
            $html .= esc_html__('Sorry, no posts matched your criteria.','soho-core');
        endif;

        wp_reset_postdata();

        $html .= "</ul>";

        $html .= "<div class='qode_carousel_navigation'>";
            $html .= "<a class='qode_carousel_prev' href='#' target='_self'><i class='fa fa-angle-left'></i></a>";
            $html .= "<a class='qode_carousel_next' href='#' target='_self'><i class='fa fa-angle-right'></i></a>";
        $html .= "</div>";

        $html .= "</div></div>";
        
    }
    
    return $html;
}
}
add_shortcode('qode_carousel', 'soho_core_qode_carousel');

/* Qode Slider shortcode */

if (!function_exists('soho_core_qode_slider')) {
function soho_core_qode_slider( $atts, $content = null ) {
    global $qode_options_soho;
    extract(shortcode_atts(array("slider"=>"", "height"=>"", "responsive_height"=>"", "background_color"=>"", "auto_start"=>"", "animation_type"=>"", "slide_animation"=>"6000"), $atts));
    $html = ""; 
    
    if ($slider != "") {
        $args = array(
            'post_type'=> 'slides',
            'slides_category' => $slider,
            'orderby' => "menu_order",
            'order' => "ASC",
            'posts_per_page' => -1
        );
        
        $slider_id = get_term_by('slug',$slider,'slides_category')->term_id;
        $slider_meta = get_option( "taxonomy_term_".$slider_id );
        $slider_header_effect =  $slider_meta['header_effect'];
        if($slider_header_effect == 'yes'){
            $header_effect_class = 'header_effect';
        }else{
            $header_effect_class = '';
        }

        $slider_thumbs = 'no';
        if(isset($slider_meta['slider_thumbs'])){
            $slider_thumbs =  $slider_meta['slider_thumbs'];
        }
        if($slider_thumbs == 'yes'){
            $slider_thumbs_class = 'slider_thumbs';
        }else{
            $slider_thumbs_class = '';
        }

        $slider_css_position_class = '';
        $slider_parallax = 'yes';
        if(isset($slider_meta['slider_parallax_effect'])){
            $slider_parallax = $slider_meta['slider_parallax_effect'];
        }
        if($slider_parallax == 'no'){
            $data_parallax_effect = 'data-parallax="no"';
            $slider_css_position_class = 'relative_position';
        }else{
            $data_parallax_effect = 'data-parallax="yes"';
        }

        if($height == "" || $height == "0"){
            $full_screen_class = "full_screen";
            $responsive_height_class = "";
            $slide_height = "";
            $data_height = "";
        }else{
            $full_screen_class = "";
            if($responsive_height == "yes"){
                $responsive_height_class = "responsive_height";
            }else{
                $responsive_height_class = "";
            }
            $slide_height = "height: ".$height."px;";
            $data_height = "data-height='".$height."'";
        }
        
        $slider_transparency_class = "header_not_transparent";
        if(isset($qode_options_soho['header_background_transparency_initial']) && $qode_options_soho['header_background_transparency_initial'] != "1" && $qode_options_soho['header_background_transparency_initial'] != ""){
            $slider_transparency_class = "";
        }
        
        if($background_color != ""){
            $background_color = 'background-color:'.$background_color.';';
        }
        
        $auto = "true";
        if($auto_start != ""){
            $auto = $auto_start;
        }
        
        if($auto == "true"){
            $auto_start_class = "q_auto_start";
        } else {
            $auto_start_class = "";
        }

        if($slide_animation != ""){
            $slide_animation = 'data-slide_animation="'.$slide_animation.'"';
        } else {
            $slide_animation = 'data-slide_animation=""';
        }

        if($animation_type == 'fade'){
            $animation_type_class = 'fade';
        }else{
            $animation_type_class = '';
        }
        
        /**************** Count positioning of navigation arrows and preloader depending on header transparency and layout - START ****************/
        
        global $wp_query; 
        
        $page_id = $wp_query->get_queried_object_id();
        $header_height_padding = 0;
        if(((get_post_meta($page_id, "qode_header_color_transparency_per_page", true) == "1") && ($qode_options_soho['header_background_transparency_initial'] == "1")) || ((get_post_meta($page_id, "qode_header_color_transparency_per_page", true) == "") && ($qode_options_soho['header_background_transparency_initial'] == "")) && $qode_options_soho['vertical_area'] == "no"){
            if (!empty($qode_options_soho['header_height'])) {
                $header_height = $qode_options_soho['header_height'];
            } else {
                $header_height = 110;
            }
            if($qode_options_soho['header_bottom_appearance'] == 'stick menu_bottom'){
                $menu_bottom = '46';
                if(is_active_sidebar('header_fixed_right')){
                    $menu_bottom = $menu_bottom + 22;
                }
            } else {
                $menu_bottom = 0;
            }

            $header_top = 0;
            if(isset($qode_options_soho['header_top_area']) && $qode_options_soho['header_top_area'] == "yes"){
                $header_top = 36;   
            }
            $header_height_padding = $header_height + $menu_bottom + $header_top;
            if (isset($qode_options_soho['center_logo_image']) && $qode_options_soho['center_logo_image'] == "yes") {
                if(isset($qode_options_soho['logo_image'])){
                            $logo_width = 0;
                            $logo_height = 0;
                            if (!empty($qode_options_soho['logo_image'])) {
                                $logo_url_obj = parse_url($qode_options_soho['logo_image']);
                                list($logo_width, $logo_height, $logo_type, $logo_attr) = getimagesize($_SERVER['DOCUMENT_ROOT'].$logo_url_obj['path']);  
                            } 
                        }
                $header_height_padding = $logo_height + 30 + $menu_bottom + $header_top; // 30 is top and bottom margin of centered logo
            }
        }
        if($header_height_padding != 0){ 
            $navigation_margin_top = 'style="margin-top:'. ($header_height_padding/2 - 30).'px;"'; // 30 is half of navigation arrow
            $loader_margin_top = 'style="margin-top:'. ($header_height_padding/2).'px;"';
        }
        else { 
            $navigation_margin_top = ''; 
            $loader_margin_top = ''; 
        }
        
        /**************** Count positioning of navigation arrows and preloader depending on header transparency and layout - END ****************/
        
        
        $html .= '<div id="qode-'.$slider.'" class="carousel slide '.$animation_type_class.' '.$full_screen_class.' '.$responsive_height_class.' '.$auto_start_class.' '.$header_effect_class.' '.$slider_thumbs_class.' '.$slider_transparency_class.'" '.$slide_animation.' '.$data_height.' '.$data_parallax_effect.' style="'.$slide_height.' '.$background_color.'"><div class="qode_slider_preloader"></div>';
        $html .= '<div class="carousel-inner '.$slider_css_position_class.'" data-start="transform: translateY(0px);" data-1440="transform: translateY(-500px);">';

        $query = new WP_Query( $args );;
            
            
      $found_slides =  $query->post_count;
            
            if ( $query->have_posts() ) : $postCount = 0; while ( $query->have_posts() ) : $query->the_post();
                $active_class = '';
                if($postCount == 0){
                    $active_class = 'active';
                }else{
                    $active_class = 'inactive';
                }
                
                $slide_type = get_post_meta(get_the_ID(), "qode_slide-background-type", true);
                
                $image = get_post_meta(get_the_ID(), "qode_slide-image", true);
                $thumbnail = get_post_meta(get_the_ID(), "qode_slide-thumbnail", true);
                $thumbnail_animation = get_post_meta(get_the_ID(), "qode_slide-thumbnail-animation", true);
                $image_overlay = get_post_meta(get_the_ID(), "qode_slide-overlay", true);
                $image_overlay_pattern = get_post_meta(get_the_ID(), "qode_slide-overlay-image", true);
                
                $video_webm = get_post_meta(get_the_ID(), "qode_slide-video-webm", true);
                $video_mp4 = get_post_meta(get_the_ID(), "qode_slide-video-mp4", true);
                $video_ogv = get_post_meta(get_the_ID(), "qode_slide-video-ogv", true);
                $video_image = get_post_meta(get_the_ID(), "qode_slide-video-image", true);
                $video_overlay = get_post_meta(get_the_ID(), "qode_slide-video-overlay", true);
                $video_overlay_image = get_post_meta(get_the_ID(), "qode_slide-video-overlay-image", true);

                $content_animation = get_post_meta(get_the_ID(), "qode_slide-content-animation", true);

                $subtitle_color = "";
                if(get_post_meta(get_the_ID(), "qode_slide-subtitle-color", true) != ""){
                    $subtitle_color .= "color: ". get_post_meta(get_the_ID(), "qode_slide-subtitle-color", true) . ";";
                }
                $subtitle_font_size = "";
                if(get_post_meta(get_the_ID(), "qode_slide-subtitle-font-size", true) != ""){
                    $subtitle_font_size .= "font-size: ". get_post_meta(get_the_ID(), "qode_slide-subtitle-font-size", true) . "px;";
                }
                $subtitle_line_height = "";
                if(get_post_meta(get_the_ID(), "qode_slide-subtitle-line-height", true) != ""){
                    $subtitle_line_height .= "line-height: ". get_post_meta(get_the_ID(), "qode_slide-subtitle-line-height", true) . "px;";
                }
                $subtitle_font_family = "";
                if(get_post_meta(get_the_ID(), "qode_slide-subtitle-font-family", true) != ""){
                    $subtitle_font_family .= "font-family:'". str_replace('+', ' ', get_post_meta(get_the_ID(), "qode_slide-subtitle-font-family", true)) . "';";
                }
                $subtitle_font_style = "";
                if(get_post_meta(get_the_ID(), "qode_slide-subtitle-font-style", true) != ""){
                    $subtitle_font_style .= "font-style: ". get_post_meta(get_the_ID(), "qode_slide-subtitle-font-style", true) . ";";
                }
                $subtitle_font_weight = "";
                if(get_post_meta(get_the_ID(), "qode_slide-subtitle-font-weight", true) != ""){
                    $subtitle_font_weight .= "font-weight: ". get_post_meta(get_the_ID(), "qode_slide-subtitle-font-weight", true) . ";";
                }

                $title_color = "";                  
                if(get_post_meta(get_the_ID(), "qode_slide-title-color", true) != ""){
                    $title_color .= "color: ". get_post_meta(get_the_ID(), "qode_slide-title-color", true) . ";";
                }
                $title_background_color = "";
                if(get_post_meta(get_the_ID(), "qode_slide-title-background-color", true) != ""){
                    $title_background_color_hex = soho_qode_hex2rgb(get_post_meta(get_the_ID(), "qode_slide-title-background-color", true));
                    $title_background_color .= "background-color: rgba(".$title_background_color_hex[0].",".$title_background_color_hex[1].",".$title_background_color_hex[2].",0.9);";
                }
                if(get_post_meta(get_the_ID(), "qode_slide-hide-title-background", true) == true){
                    $title_background_color .= "background-color: transparent;";
                }
                $title_font_size = "";                  
                if(get_post_meta(get_the_ID(), "qode_slide-title-font-size", true) != ""){
                    $title_font_size .= "font-size: ". get_post_meta(get_the_ID(), "qode_slide-title-font-size", true) . "px;";
                }
                $title_line_height = "";                    
                if(get_post_meta(get_the_ID(), "qode_slide-title-line-height", true) != ""){
                    $title_line_height .= "line-height: ". get_post_meta(get_the_ID(), "qode_slide-title-line-height", true) . "px;";
                }
                $title_font_family = "";                    
                if(get_post_meta(get_the_ID(), "qode_slide-title-font-family", true) != ""){
                    $title_font_family .= "font-family: '".  str_replace('+', ' ', get_post_meta(get_the_ID(), "qode_slide-title-font-family", true)) . "';";
                }
                $title_font_style = "";                 
                if(get_post_meta(get_the_ID(), "qode_slide-title-font-style", true) != ""){
                    $title_font_style .= "font-style: ". get_post_meta(get_the_ID(), "qode_slide-title-font-style", true) . ";";
                }
                $title_font_weight = "";                    
                if(get_post_meta(get_the_ID(), "qode_slide-title-font-weight", true) != ""){
                    $title_font_weight .= "font-weight: ". get_post_meta(get_the_ID(), "qode_slide-title-font-weight", true) . ";";
                }
                $text_shadow = "";
                if(get_post_meta(get_the_ID(), "qode_slide-hide-shadow", true) == true){
                    $text_shadow = "text-shadow: none;";
                }
                
                $text_color = "";                   
                if(get_post_meta(get_the_ID(), "qode_slide-text-color", true) != ""){
                    $text_color = "color: ". get_post_meta(get_the_ID(), "qode_slide-text-color", true) . ";";
                }
                $text_font_size = "";                   
                if(get_post_meta(get_the_ID(), "qode_slide-text-font-size", true) != ""){
                    $text_font_size = "font-size: ". get_post_meta(get_the_ID(), "qode_slide-text-font-size", true) . "px;";
                }
                $text_line_height = "";                 
                if(get_post_meta(get_the_ID(), "qode_slide-text-line-height", true) != ""){
                    $text_line_height = "line-height: ". get_post_meta(get_the_ID(), "qode_slide-text-line-height", true) . "px;";
                }
                $text_font_family = "";                 
                if(get_post_meta(get_the_ID(), "qode_slide-text-font-family", true) != ""){
                    $text_font_family = "font-family: '".  str_replace('+', ' ', get_post_meta(get_the_ID(), "qode_slide-text-font-family", true)) . "';";
                }
                $text_font_style = "";                  
                if(get_post_meta(get_the_ID(), "qode_slide-text-font-style", true) != ""){
                    $text_font_style = "font-style: ". get_post_meta(get_the_ID(), "qode_slide-text-font-style", true) . ";";
                }
                $text_font_weight = "";                 
                if(get_post_meta(get_the_ID(), "qode_slide-text-font-weight", true) != ""){
                    $text_font_weight = "font-weight: ". get_post_meta(get_the_ID(), "qode_slide-text-font-weight", true) . ";";
                }
                
                $graphic_alignment = get_post_meta(get_the_ID(), "qode_slide-graphic-alignment", true);
                $content_alignment = get_post_meta(get_the_ID(), "qode_slide-content-alignment", true);
                
                $separate_text_graphic = get_post_meta(get_the_ID(), "qode_slide-separate-text-graphic", true);
                
                if(get_post_meta(get_the_ID(), "qode_slide-content-width", true) != ""){
                    $content_width = "width:".get_post_meta(get_the_ID(), "qode_slide-content-width", true)."%;";
                }else{
                    $content_width = "width:100%;";
                }
                if(get_post_meta(get_the_ID(), "qode_slide-content-left", true) != ""){
                    $content_xaxis= "left:".get_post_meta(get_the_ID(), "qode_slide-content-left", true)."%;";
                }else{
                    if(get_post_meta(get_the_ID(), "qode_slide-content-right", true) != ""){
                        $content_xaxis = "right:".get_post_meta(get_the_ID(), "qode_slide-content-right", true)."%;";
                    }else{
                        $content_xaxis = "left: 0%;";
                    }
                }
                if(get_post_meta(get_the_ID(), "qode_slide-content-top", true) != ""){
                    $content_yaxis_start = "top:".get_post_meta(get_the_ID(), "qode_slide-content-top", true)."%;";
                    $content_yaxis_end = "top:".(get_post_meta(get_the_ID(), "qode_slide-content-top", true)-10)."%;";
                }else{
                    if(get_post_meta(get_the_ID(), "qode_slide-content-bottom", true) != ""){
                        $content_yaxis_start = "bottom:".get_post_meta(get_the_ID(), "qode_slide-content-bottom", true)."%;";
                        $content_yaxis_end = "bottom:".(get_post_meta(get_the_ID(), "qode_slide-content-bottom", true)+10)."%;";
                    }else{
                        $content_yaxis_start = "top: 30%;";
                        $content_yaxis_end = "top: 10%;";
                    }
                }
                
                if(get_post_meta(get_the_ID(), "qode_slide-graphic-width", true) != ""){
                    $graphic_width = "width:".get_post_meta(get_the_ID(), "qode_slide-graphic-width", true)."%;";
                }else{
                    $graphic_width = "width:50%;";
                }
                if(get_post_meta(get_the_ID(), "qode_slide-graphic-left", true) != ""){
                    $graphic_xaxis= "left:".get_post_meta(get_the_ID(), "qode_slide-graphic-left", true)."%;";
                }else{
                    if(get_post_meta(get_the_ID(), "qode_slide-graphic-right", true) != ""){
                        $graphic_xaxis = "right:".get_post_meta(get_the_ID(), "qode_slide-graphic-right", true)."%;";
                    }else{
                        $graphic_xaxis = "left: 25%;";
                    }
                }
                if(get_post_meta(get_the_ID(), "qode_slide-graphic-top", true) != ""){
                    $graphic_yaxis_start = "top:".get_post_meta(get_the_ID(), "qode_slide-graphic-top", true)."%;";
                    $graphic_yaxis_end = "top:".(get_post_meta(get_the_ID(), "qode_slide-graphic-top", true)-10)."%;";
                }else{
                    if(get_post_meta(get_the_ID(), "qode_slide-graphic-bottom", true) != ""){
                        $graphic_yaxis_start = "bottom:".get_post_meta(get_the_ID(), "qode_slide-graphic-bottom", true)."%;";
                        $graphic_yaxis_end = "bottom:".(get_post_meta(get_the_ID(), "qode_slide-graphic-bottom", true)+10)."%;";
                    }else{
                        $graphic_yaxis_start = "top: 20%;";
                        $graphic_yaxis_end = "top: 10%;";
                    }
                }
                
                $header_style = "";
                if(get_post_meta(get_the_ID(), "qode_slide-header-style", true) != ""){
                    $header_style = get_post_meta(get_the_ID(), "qode_slide-header-style", true);
                }
                
                $navigation_color = "";
                if(get_post_meta(get_the_ID(), "qode_slide-navigation-color", true) != ""){
                    $navigation_color = 'data-navigation-color="'.get_post_meta(get_the_ID(), "qode_slide-navigation-color", true).'"';
                }

                $navigation_text_color = "";
                if(get_post_meta(get_the_ID(), "qode_slide-navigation-color", true) != ""){
                    $navigation_text_color = 'data-navigation-text-color="'.get_post_meta(get_the_ID(), "qode_slide-navigation-text-color", true).'"';
                }

                $button_icon1 = "";
                $button_icon_class1 = "";
                if(get_post_meta(get_the_ID(), "qode_slide-button-icon", true) != ""){
                    $button_icon1 = "<i class='fa ".get_post_meta(get_the_ID(), "qode_slide-button-icon", true)."'></i>";
                    $button_icon_class1 = "qbutton_with_icon";
                }

                $button_icon2 = "";
                $button_icon_class2 = "";
                if(get_post_meta(get_the_ID(), "qode_slide-button-icon2", true) != ""){
                    $button_icon2 = "<i class='fa ".get_post_meta(get_the_ID(), "qode_slide-button-icon2", true)."'></i>";
                    $button_icon_class2 = "qbutton_with_icon";
                }
                
                $title = get_the_title();
                
                $html .= '<div class="item '.$header_style.'" '.$navigation_color.' '.$navigation_text_color.' style="'.$slide_height.'">';
                if($slide_type == 'video'){
                
                    $html .= '<div class="video"><div class="mobile-video-image" style="background-image: url('.$video_image.')"></div><div class="video-overlay';
                                if($video_overlay == "yes"){
                                    $html .= ' active';
                                }
                                $html .= '"';
                                if($video_overlay_image != ""){
                                    $html .= ' style="background-image:url('.$video_overlay_image.');"';
                                }
                                $html .= '>';
                                if($video_overlay_image != ""){
                                    $html .= '<img src="'.$video_overlay_image.'" alt="" />';
                                }else{
                                    $html .= '<img src="'.get_template_directory_uri().'/css/img/pixel-video.png" alt="" />';
                                }
                                $html .= '</div><div class="video-wrap">
                                    
                                    <video class="video"  poster="'.$video_image.'" controls="controls" preload="auto" loop autoplay muted>';
                                            if(!empty($video_webm)) { $html .= '<source type="video/webm" src="'.$video_webm.'">'; }
                                            if(!empty($video_mp4)) { $html .= '<source type="video/mp4" src="'.$video_mp4.'">'; }
                                            if(!empty($video_ogv)) { $html .= '<source type="video/ogg" src="'. $video_ogv.'">'; }
                                         $html .='<object width="320" height="240" type="application/x-shockwave-flash" data="'.get_template_directory_uri().'/js/flashmediaelement.swf">
                                                    <param name="movie" value="'.get_template_directory_uri().'/js/flashmediaelement.swf" />
                                                    <param name="flashvars" value="controls=true&file='.$video_mp4.'" />
                                                    <img src="'.$video_image.'" width="1920" height="800" title="' . esc_attr__( 'No video playback capabilities', 'soho-core' ) . '" alt="' . esc_attr__( 'Video thumb', 'soho-core' ) . '" />
                                            </object>
                                    </video>        
                            </div></div>';
                }else{
                    $html .= '<div class="image" style="background-image:url('.$image.');">';
                    if($slider_thumbs == 'no'){
                        $html .= '<img src="'.$image.'" alt="'.$title.'">';
                    }
                    $html .= '</div>';

                    if($image_overlay == "yes"){
                        $html .= '<div class="image_pattern"';
                        if($image_overlay_pattern != ""){
                            $html .= 'style="background-image:url('.$image_overlay_pattern.');"';
                        }
                        $html .= '></div>';
                    }
                }
                
                $html_thumb = "";
                if($thumbnail != ""){
                    $html_thumb .= '<div class="thumb '.$thumbnail_animation.'">';
                    $html_thumb .= '<img src="'.$thumbnail.'" alt="'.$title.'">';
                    $html_thumb .= '</div>';
                }
                $html_text = "";
                $html_text .= '<div class="text '.$content_animation.'">';
                if(get_post_meta(get_the_ID(), "qode_slide-hide-subtitle", true) != true && get_post_meta(get_the_ID(), "qode_slide-subtitle", true) != ""){
                    $html_text .= '<h2 style="'.$subtitle_color.$subtitle_font_size.$subtitle_line_height.$subtitle_font_family.$subtitle_font_style.$subtitle_font_weight.$text_shadow.'"><span>'.get_post_meta(get_the_ID(), "qode_slide-subtitle", true).'</span></h2>';
                }

                if(get_post_meta(get_the_ID(), "qode_slide-hide-title", true) != true){
                    $html_text .= '<h1 style="'.$title_color.$title_background_color.$title_font_size.$title_line_height.$title_font_family.$title_font_style.$title_font_weight.$text_shadow.'"><span>'.get_the_title().'</span></h1>';
                }
                if(get_post_meta(get_the_ID(), "qode_slide-text", true) != "" && get_post_meta(get_the_ID(), "qode_slide-text", true) != ""){
                    $html_text .= '<h3 style="'.$text_color.$text_font_size.$text_line_height.$text_font_family.$text_font_style.$text_font_weight.$text_shadow.'"><span>'.get_post_meta(get_the_ID(), "qode_slide-text", true).'</span></h3>';
                }
                if(get_post_meta(get_the_ID(), "qode_slide-button-label", true) != "" && get_post_meta(get_the_ID(), "qode_slide-button-link", true) != ""){
                    $html_text .= '<a class="qbutton large '.$button_icon_class1.'" href="'.get_post_meta(get_the_ID(), "qode_slide-button-link", true).'">'.$button_icon1.'<span>'.get_post_meta(get_the_ID(), "qode_slide-button-label", true).'</span></a>';
                }
                if(get_post_meta(get_the_ID(), "qode_slide-button-label2", true) != "" && get_post_meta(get_the_ID(), "qode_slide-button-link2", true) != ""){
                    $html_text .= '<a class="qbutton transparent_button large '.$button_icon_class2.'" href="'.get_post_meta(get_the_ID(), "qode_slide-button-link2", true).'">'.$button_icon2.'<span>'.get_post_meta(get_the_ID(), "qode_slide-button-label2", true).'</span></a>';
                }
                $html_text .= '</div>';
                $html .= '<div class="slider_content_outer">';
                
                if($separate_text_graphic != 'yes'){
                    $html .= '<div class="slider_content '.$content_alignment.'" style="'.$content_width.$content_xaxis.$content_yaxis_start.'" data-start="'.$content_width.' opacity:1; '.$content_xaxis.' '.$content_yaxis_start.'" data-300="opacity: 0; '.$content_xaxis.' '.$content_yaxis_end.'">';
                    $html .= $html_thumb;
                    $html .= $html_text;
                    $html .= '</div>';
                }else{
                    $html .= '<div class="slider_content '.$graphic_alignment.'" style="'.$graphic_width.$graphic_xaxis.$graphic_yaxis_start.'" data-start="'.$graphic_width.' opacity:1; '.$graphic_xaxis.' '.$graphic_yaxis_start.'" data-300="opacity: 0; '.$graphic_xaxis.' '.$graphic_yaxis_end.'">';
                    $html .= $html_thumb;
                    $html .= '</div>';
                    $html .= '<div class="slider_content '.$content_alignment.'" style="'.$content_width.$content_xaxis.$content_yaxis_start.'" data-start="'.$content_width.' opacity:1; '.$content_xaxis.' '.$content_yaxis_start.'" data-300="opacity: 0; '.$content_xaxis.' '.$content_yaxis_end.'">';
                    $html .= $html_text;
                    $html .= '</div>';
                }
                
                $html .= '</div>';
                $html .= '</div>';
                
                $postCount++;
            endwhile;
            else:
                $html .= esc_html__('Sorry, no slides matched your criteria.','soho-core');
            endif;
            wp_reset_postdata();
            
        $html .= '</div>';
        if($found_slides > 1){
            $html .= '<ol class="carousel-indicators" data-start="opacity: 1;" data-300="opacity:0;">';
                $query = new WP_Query( $args );
                if ( $query->have_posts() ) : $postCount = 0; while ( $query->have_posts() ) : $query->the_post();
                    
                    $html .= '<li data-target="#qode-'.$slider.'" data-slide-to="'.$postCount.'"'; 
                    if($postCount == 0){
                        $html .= ' class="active"';
                    }
                    $html .= '></li>';
                    
                    $postCount++;
                endwhile;
                else:
                    $html .= esc_html__('Sorry, no posts matched your criteria.','soho-core');
                endif;
                
                wp_reset_postdata();
            $html .= '</ol>';
            $html .= '<a class="left carousel-control" href="#qode-'.$slider.'" data-slide="prev" data-start="opacity: 1;" data-300="opacity:0;"><span class="thumb_holder" '.$navigation_margin_top.'><span class="thumb_top clearfix"><span class="arrow_left"></span><span class="numbers"><span class="prev"></span> / '.$postCount.'</span></span><span class="img_outer"><span class="img"></span></span></span></a>';
            $html .= '<a class="right carousel-control" href="#qode-'.$slider.'" data-slide="next" data-start="opacity: 1;" data-300="opacity:0;"><span class="thumb_holder" '.$navigation_margin_top.'><span class="thumb_top clearfix"><span class="arrow_right"></span><span class="numbers"> <span class="next"></span> / '.$postCount.'</span></span><span class="img_outer"><span class="img"></span></span></span></a>';
        }
        $html .= '</div>';
    }
    
    
    return $html;
}
}
add_shortcode('qode_slider', 'soho_core_qode_slider');

/* Service table shortcode */

if (!function_exists('soho_core_service_table')) {
    function soho_core_service_table($atts, $content = null) {
        $args = array(
            "title"                  => "",
            "title_tag"              => "h5",
            "title_color"            => "",
            "background_color"       => "",
            "use_pattern_background" => "yes",
            "icon_pack"              => "",
            "fa_icon"                => "",
            "fe_icon"                => "",    
            "custom_size"            => "50",
            "icon_color"             => ""
        );
            
        extract(shortcode_atts($args, $atts));

        $headings_array = array('h2', 'h3', 'h4', 'h5', 'h6');
                
        //get correct heading value. If provided heading isn't valid get the default one
        $title_tag = (in_array($title_tag, $headings_array)) ? $title_tag : $args['title_tag'];

        //init variables
        $html          = "";
        $title_style   = "";
        $icon_style    = "";
        $content_style = "";
        $content_class = "";


        if($title_color != ""){
            $title_style .= "color: ".$title_color.";";
        }

        if($custom_size != ""){
            $icon_style .= "font-size: ".$custom_size."px;";
        }

        if($icon_color != ""){
            $icon_style .= "color: ".$icon_color.";";
        }

        if($background_color != ""){
            $content_style .= "background-color: ".$background_color.";";
        }

        if($use_pattern_background == "yes"){
            $content_class .= "with_pattern";
        }

        $html .= "<div class='service_table_holder'><ul class='service_table_inner ".$content_class."' style='".$content_style.">";
        $html .= "<li class='service_table_title_holder'><div class='service_table_title_inner'>";

            if($title != ""){    
                $html .= "<".$title_tag." class='service_title' style='".$title_style."'>".$title."</".$title_tag.">";
            }

            if ($icon_pack == 'font_awesome' && $fa_icon != ''){
                if($fa_icon != ""){
                    $html .= "<i class='fa ".$fa_icon."' style='".$icon_style."'></i>";
                }
            } elseif ($icon_pack == 'font_elegant' && $fe_icon != ''){
                if($fe_icon != ""){
                    $html .= "<span class='".$fe_icon."' style='".$icon_style."'></span>";
                }
            }

        $html .= "</div></li>";

        $html .= "<li class='service_table_content'>".do_shortcode($content)."</li>";

        $html .= "</ul></div>";

        return $html;
    }
}
add_shortcode('service_table', 'soho_core_service_table');

/* Social Icons shortcode */

if (!function_exists('soho_core_social_icons')) {
function soho_core_social_icons($atts, $content = null) {
    $args = array(
        "type"                   => "",
        "icon_pack"              => "",
        "fa_icon"                => "",
        "fe_icon"                => "",
        "link"                   => "",
        "target"                 => "",
        "size"                   => "",
        "icon_color"             => "",
        "background_color"       => "",
        "border_color"           => "",
        "icon_hover_color"       => "",
        "background_hover_color" => "",
        "border_hover_color"     => ""
    );

    extract(shortcode_atts($args, $atts));

    $html            = "";
    $fa_stack_styles = "";
    $icon_styles     = "";
    $data_attr       = "";

    if($icon_color != ""){
        $icon_styles .= "color: ".$icon_color.";";
    }

    if($background_color != ""){
        $fa_stack_styles .= "background-color: {$background_color};";
    }

    if($border_color != ""){
        $fa_stack_styles .= "border: 2px solid {$border_color};";
    }

    if($background_hover_color != "") {
        $data_attr .= "data-hover-background-color=".$background_hover_color." ";
    }

    if($border_hover_color != "") {
        $data_attr .= "data-hover-border-color=".$border_hover_color." ";
    }

    if($icon_hover_color != "") {
        $data_attr .= "data-hover-color=".$icon_hover_color;
    }

    $html .= "<span class='q_social_icon_holder'>";

    if($link != ""){
    	$html .= "<a href='".$link."' target='".$target."'>";
    }

        if($type == "normal_social"){

            if($icon_pack == 'font_awesome' && $fa_icon != ""){
                $html .= "<i class='fa ".$fa_icon." ".$size." simple_social q_social_icon_class' style='".$icon_styles."' ".$data_attr."></i>";
            }
            elseif($icon_pack == 'font_elegant' && $fe_icon != ""){
                $html .= "<span class='".$fe_icon." ".$size." simple_social q_social_icon_class' style='".$icon_styles."' ".$data_attr."></span>";
            }

        } else {

            $html .= "<span class='fa-stack q_social_icon_class ".$size." ".$type."' style='".$icon_styles.$fa_stack_styles."' ".$data_attr.">";

            if($icon_pack == 'font_awesome' && $fa_icon != ""){
                $html .= "<i class='fa ".$fa_icon."'></i>";
            } elseif($icon_pack == 'font_elegant' && $fe_icon != ""){
                $html .= "<span class='".$fe_icon."'></span>";
            }

            $html .= "</span>"; //close fa-stack

        }

    if($link != ""){
    	$html .= "</a>";
    }

    $html .= "</span>"; //close q_social_icon_holder
    return $html;
}
}
add_shortcode('social_icons', 'soho_core_social_icons');

/* Social Share shortcode */

if (!function_exists('soho_core_social_share')) {
function soho_core_social_share($atts, $content = null) {
	global $qode_options_soho;

    if(isset($_SERVER["https"])) {
        $count_char = 23;
    } else{
        $count_char = 22;
    }

    if(isset($qode_options_soho['twitter_via']) && !empty($qode_options_soho['twitter_via'])) {
		$twitter_via = " via " . $qode_options_soho['twitter_via'] . " ";
	} else {
		$twitter_via = 	"";
	}
	$image = wp_get_attachment_image_src(get_post_thumbnail_id(), 'full'); 
    $html = "";  
	if(isset($qode_options_soho['enable_social_share']) && $qode_options_soho['enable_social_share'] == "yes") {
		$post_type = get_post_type();
		if(isset($qode_options_soho["post_types_names_$post_type"])) {
			if($qode_options_soho["post_types_names_$post_type"] == $post_type) {
				if($post_type == "portfolio_page") {
					$html .= '<div class="portfolio_share">';
				} elseif($post_type == "post") {
					$html .= '<div class="blog_share">';
				} elseif($post_type == "page") {
					$html .= '<div class="page_share">';
				}
				$html .= '<div class="social_share_holder">';
				$html .= '<a href="javascript:void(0)" target="_self"><span class="social_share"></span>';
                    if($post_type == "post") {
                        $html .= '<span class="social_share_title">'.  esc_html__('Share','soho-core') .'</span>';
                    } 
                    $html .= '</a>';
					$html .= '<div class="social_share_dropdown"><ul>';
					if(isset($qode_options_soho['enable_facebook_share']) &&  $qode_options_soho['enable_facebook_share'] == "yes") {
						$html .= '<li class="facebook_share">';
                                if(wp_is_mobile()) {
                                    $html .= '<a title="'.esc_html__("Share on Facebook","soho-core").'" href="javascript:void(0)" onclick="window.open(\'https://m.facebook.com/sharer.php?u=' . urlencode(get_permalink());
                                }
                                else {
                                    $html .= '<a title="'.esc_html__("Share on Facebook","soho-core").'" href="javascript:void(0)" onclick="window.open(\'https://www.facebook.com/sharer.php?s=100&amp;p[title]=' . urlencode(addslashes(get_the_title())) . '&amp;p[url]=' . urlencode(get_permalink()) . '&amp;p[images][0]=';
                                    if(function_exists('the_post_thumbnail')) {
                                        $html .=  wp_get_attachment_url(get_post_thumbnail_id());
                                    }
                                }

                                $html .= '&amp;p[summary]=' . urlencode(addslashes(strip_tags(get_the_excerpt())));
                                $html .='\', \'sharer\', \'toolbar=0,status=0,width=620,height=280\');">';
        						if(!empty($qode_options_soho['facebook_icon'])) {
        							$html .= '<img src="' . $qode_options_soho["facebook_icon"] . '" alt="" />';
        						} else { 
        							$html .= '<span class="social_facebook" aria-hidden="true"></span>';
        						}
    						$html .= "</a>";
						$html .= "</li>";
					} 
						
					if($qode_options_soho['enable_twitter_share'] == "yes") {
						$html .= '<li class="twitter_share">';
                                if(wp_is_mobile()) {
                                    $html .= '<a href="#" onclick="popUp=window.open(\'https://twitter.com/intent/tweet?text=' . urlencode(soho_qode_the_excerpt_max_charlength($count_char) . $twitter_via) . get_permalink() . '\', \'popupwindow\', \'scrollbars=yes,width=800,height=400\');popUp.focus();return false;">';
                                }
                                else {
                                    $html .= '<a href="#" onclick="popUp=window.open(\'https://twitter.com/home?status=' . urlencode(soho_qode_the_excerpt_max_charlength($count_char) . $twitter_via) . get_permalink() . '\', \'popupwindow\', \'scrollbars=yes,width=800,height=400\');popUp.focus();return false;">';
                                }
								if(!empty($qode_options_soho['twitter_icon'])) {
									$html .= '<img src="' . $qode_options_soho["twitter_icon"] . '" alt="" />';
								 } else { 
									$html .= '<span class="social_twitter"></span>';
								 }
							$html .= "</a>";
						$html .= "</li>";
					} 
					if($qode_options_soho['enable_google_plus'] == "yes") {
							$html .= '<li  class="google_share">';
									$html .= '<a href="#" onclick="popUp=window.open(\'https://plus.google.com/share?url=' . urlencode(get_permalink()) . '\', \'popupwindow\', \'scrollbars=yes,width=800,height=400\');popUp.focus();return false">';
									if(!empty($qode_options_soho['google_plus_icon'])) {
										$html .= '<img src="' . $qode_options_soho['google_plus_icon'] . '" alt="" />';
									} else { 
										$html .= '<span class="social_googleplus"></span>';
									 }
								$html .= "</a>";
							$html .= "</li>";
					}
					if(isset($qode_options_soho['enable_linkedin']) && $qode_options_soho['enable_linkedin'] == "yes") {
						$html .= '<li  class="linkedin_share">';
                            $html .= '<a href="#" onclick="popUp=window.open(\'https://linkedin.com/shareArticle?mini=true&amp;url=' . urlencode(get_permalink()). '&amp;title=' . urlencode(get_the_title()) . '\', \'popupwindow\', \'scrollbars=yes,width=800,height=400\');popUp.focus();return false">';
								if(!empty($qode_options_soho['linkedin_icon'])) {
									$html .= '<img src="' . $qode_options_soho['linkedin_icon'] . '" alt="" />';
								} else { 
									$html .= '<span class="social_linkedin "></span>';
								 }
							$html .= "</a>";
						$html .= "</li>";
					}
					if(isset($qode_options_soho['enable_tumblr']) && $qode_options_soho['enable_tumblr'] == "yes") {
						$html .= '<li  class="tumblr_share">';
					       	$html .= '<a href="#" onclick="popUp=window.open(\'https://www.tumblr.com/share/link?url=' . urlencode(get_permalink()). '&amp;name=' . urlencode(get_the_title()) .'&amp;description='.urlencode(get_the_excerpt()) . '\', \'popupwindow\', \'scrollbars=yes,width=800,height=400\');popUp.focus();return false">';
								if(!empty($qode_options_soho['tumblr_icon'])) {
									$html .= '<img src="' . $qode_options_soho['tumblr_icon'] . '" alt="" />';
								} else { 
									$html .= '<span class="social_tumblr"></span>';
								 }
							$html .= "</a>";
						$html .= "</li>";
					}
					if(isset($qode_options_soho['enable_pinterest']) && $qode_options_soho['enable_pinterest'] == "yes") {
						$html .= '<li  class="pinterest_share">';
							$html .= '<a href="#" onclick="popUp=window.open(\'https://pinterest.com/pin/create/button/?url=' . urlencode(get_permalink()). '&amp;description=' . addslashes(get_the_title()) .'&amp;media='.urlencode($image[0]) . '\', \'popupwindow\', \'scrollbars=yes,width=800,height=400\');popUp.focus();return false">';
								if(!empty($qode_options_soho['pinterest_icon'])) {
									$html .= '<img src="' . $qode_options_soho['pinterest_icon'] . '" alt="" />';
								} else { 
									$html .= '<span class="social_pinterest"></span>';
								 }
							$html .= "</a>";
						$html .= "</li>";
					}
					if(isset($qode_options_soho['enable_vk']) && $qode_options_soho['enable_vk'] == "yes") {
						$html .= '<li  class="vk_share">';
							$image = wp_get_attachment_image_src(get_post_thumbnail_id(), 'full'); 
							$html .= '<a href="#" onclick="popUp=window.open(\'https://vkontakte.ru/share.php?url=' . urlencode(get_permalink()). '&amp;title=' . urlencode(get_the_title()) .'&amp;description=' . urlencode(get_the_excerpt()) .'&amp;image='.urlencode($image[0]) . '\', \'popupwindow\', \'scrollbars=yes,width=800,height=400\');popUp.focus();return false">';
								if(!empty($qode_options_soho['vk_icon'])) {
									$html .= '<img src="' . $qode_options_soho['vk_icon'] . '" alt="" />';
								} else { 
									$html .= '<i class="fa fa-vk"></i>';
						    	}
							$html .= "</a>";
						$html .= "</li>";
					}
					$html .= "</ul></div>";
				$html .= "</div>";
                
				$html .= '</div>';
			} 
		}  
	}
    return $html;
}
}
add_shortcode('social_share', 'soho_core_social_share');

/* Social Share Simple shortcode */

if (!function_exists('soho_core_social_share_simple')) {
function soho_core_social_share_simple($atts, $content = null) {
    global $qode_options_soho;

    if(isset($_SERVER["https"])) {
        $count_char = 23;
    } else{
        $count_char = 22;
    }

    if(isset($qode_options_soho['twitter_via']) && !empty($qode_options_soho['twitter_via'])) {
        $twitter_via = " via " . $qode_options_soho['twitter_via'] . " ";
    } else {
        $twitter_via =  "";
    }

    $image = wp_get_attachment_image_src(get_post_thumbnail_id(), 'full'); 
    $html = "";

    if(isset($qode_options_soho['enable_social_share']) && $qode_options_soho['enable_social_share'] == "yes") {
        $post_type = get_post_type();
        if(isset($qode_options_soho["post_types_names_$post_type"])) {
            if($qode_options_soho["post_types_names_$post_type"] == $post_type) {

                $html .= '<div class="social_share_simple_holder">';

                    if(isset($qode_options_soho['enable_facebook_share']) &&  $qode_options_soho['enable_facebook_share'] == "yes") {
                        $html .= '<a href="#" onclick="window.open(\'https://www.facebook.com/sharer.php?s=100&amp;p[title]=' . addslashes(get_the_title()) . '&amp;p[summary]=' . addslashes(get_the_excerpt()) . '&amp;p[url]=' . urlencode(get_permalink()) . '&amp;&p[images][0]=';
                            if(function_exists('the_post_thumbnail')) {
                                $html .=  wp_get_attachment_url(get_post_thumbnail_id());
                            }
                            $html .='\', \'sharer\', \'toolbar=0,status=0,width=620,height=280\');" href="javascript: void(0)">';
                            if(!empty($qode_options_soho['facebook_icon'])) {
                                $html .= '<img src="' . $qode_options_soho["facebook_icon"] . '" alt="" />';
                            } else { 
                                $html .= '<span class="social_facebook" aria-hidden="true"></span>';
                            }
                        $html .= "</a>";
                    } 
                    if($qode_options_soho['enable_twitter_share'] == "yes") {
                        $html .= '<a href="#" onclick="popUp=window.open(\'https://twitter.com/home?status=' . urlencode(soho_qode_the_excerpt_max_charlength($count_char) . $twitter_via) . get_permalink() . '\', \'popupwindow\', \'scrollbars=yes,width=800,height=400\');popUp.focus();return false;">';
                            if(!empty($qode_options_soho['twitter_icon'])) {
                                $html .= '<img src="' . $qode_options_soho["twitter_icon"] . '" alt="" />';
                             } else { 
                                $html .= '<span class="social_twitter"></span>';
                             }
                        $html .= "</a>";
                    } 
                    if($qode_options_soho['enable_google_plus'] == "yes") {
                        $html .= '<a href="#" onclick="popUp=window.open(\'https://plus.google.com/share?url=' . urlencode(get_permalink()) . '\', \'popupwindow\', \'scrollbars=yes,width=800,height=400\');popUp.focus();return false">';
                            if(!empty($qode_options_soho['google_plus_icon'])) {
                                $html .= '<img src="' . $qode_options_soho['google_plus_icon'] . '" alt="" />';
                            } else { 
                                $html .= '<span class="social_googleplus"></span>';
                             }
                        $html .= "</a>";
                    }
                    if(isset($qode_options_soho['enable_linkedin']) && $qode_options_soho['enable_linkedin'] == "yes") {
                        $html .= '<a href="#" onclick="popUp=window.open(\'https://linkedin.com/shareArticle?mini=true&amp;url=' . urlencode(get_permalink()). '&amp;title=' . urlencode(get_the_title()) . '\', \'popupwindow\', \'scrollbars=yes,width=800,height=400\');popUp.focus();return false">';
                            if(!empty($qode_options_soho['linkedin_icon'])) {
                                $html .= '<img src="' . $qode_options_soho['linkedin_icon'] . '" alt="" />';
                            } else { 
                                $html .= '<span class="social_linkedin "></span>';
                            }
                        $html .= "</a>";
                    }
                    if(isset($qode_options_soho['enable_tumblr']) && $qode_options_soho['enable_tumblr'] == "yes") {
                        $html .= '<a href="#" onclick="popUp=window.open(\'https://www.tumblr.com/share/link?url=' . urlencode(get_permalink()). '&amp;name=' . urlencode(get_the_title()) .'&amp;description='.urlencode(get_the_excerpt()) . '\', \'popupwindow\', \'scrollbars=yes,width=800,height=400\');popUp.focus();return false">';
                            if(!empty($qode_options_soho['tumblr_icon'])) {
                                $html .= '<img src="' . $qode_options_soho['tumblr_icon'] . '" alt="" />';
                            } else { 
                                $html .= '<span class="social_tumblr"></span>';
                            }
                        $html .= "</a>";
                    }
                    if(isset($qode_options_soho['enable_pinterest']) && $qode_options_soho['enable_pinterest'] == "yes") {
                        $html .= '<a href="#" onclick="popUp=window.open(\'https://pinterest.com/pin/create/button/?url=' . urlencode(get_permalink()). '&amp;description=' . addslashes(get_the_title()) .'&amp;media='.urlencode($image[0]) . '\', \'popupwindow\', \'scrollbars=yes,width=800,height=400\');popUp.focus();return false">';
                            if(!empty($qode_options_soho['pinterest_icon'])) {
                                $html .= '<img src="' . $qode_options_soho['pinterest_icon'] . '" alt="" />';
                            } else { 
                                $html .= '<span class="social_pinterest"></span>';
                            }
                        $html .= "</a>";
                    }
                    if(isset($qode_options_soho['enable_vk']) && $qode_options_soho['enable_vk'] == "yes") {
                        $image = wp_get_attachment_image_src(get_post_thumbnail_id(), 'full'); 
                        $html .= '<a href="#" onclick="popUp=window.open(\'https://vkontakte.ru/share.php?url=' . urlencode(get_permalink()). '&amp;title=' . urlencode(get_the_title()) .'&amp;description=' . urlencode(get_the_excerpt()) .'&amp;image='.urlencode($image[0]) . '\', \'popupwindow\', \'scrollbars=yes,width=800,height=400\');popUp.focus();return false">';
                            if(!empty($qode_options_soho['vk_icon'])) {
                                $html .= '<img src="' . $qode_options_soho['vk_icon'] . '" alt="" />';
                            } else { 
                                $html .= '<i class="fa fa-vk"></i>';
                            }
                        $html .= "</a>";
                    }

                $html .= "</div>";
            } 
        }  
    }
    return $html;
}
}
add_shortcode('social_share_simple', 'soho_core_social_share_simple');

/* Team shortcode */

if (!function_exists('soho_core_q_team')) {
function soho_core_q_team($atts, $content = null) {
    $args = array(
		"team_image"				=> "",
		"team_name"					=> "",
        "team_name_color"           => "",
		"team_position"				=> "",
        "team_position_color"       => "",
		"team_description"			=> "",
        "team_description_color"    => "",
		"team_social_icon_size"     => "tiny",
		"team_social_icon_pack"     => "",
        "team_social_fa_icon_1"		=> "",
        "team_social_fe_icon_1"		=> "",
		"team_social_icon_1_link"	=> "",
		"team_social_icon_1_target"	=> "",
		"team_social_fa_icon_2"		=> "",
		"team_social_fe_icon_2"		=> "",
		"team_social_icon_2_link"	=> "",
		"team_social_icon_2_target"	=> "",
		"team_social_fa_icon_3"		=> "",
		"team_social_fe_icon_3"		=> "",
		"team_social_icon_3_link"	=> "",
		"team_social_icon_3_target"	=> "",
		"team_social_fa_icon_4"		=> "",
		"team_social_fe_icon_4"		=> "",
		"team_social_icon_4_link"	=> "",
		"team_social_icon_4_target"	=> "",
        "team_social_fa_icon_5"     => "",
        "team_social_fe_icon_5"     => "",
        "team_social_icon_5_link"   => "",
        "team_social_icon_5_target" => ""
    );
        
    extract(shortcode_atts($args, $atts));

	if(is_numeric($team_image)) {
		$team_image_src = wp_get_attachment_url( $team_image );
	} else {
		$team_image_src = $team_image;
	}

    $html              = "";
    $name_style        = "";
    $position_style    = "";
    $description_style = "";

    if($team_name_color != ""){
        $name_style .= "style='color: ".$team_name_color.";'";
    }

    if($team_position_color != ""){
        $position_style .= "style='color: ".$team_position_color.";'";
    }

    if($team_description_color != ""){
        $description_style .= "style='color: ".$team_description_color.";'";
    }
    
    $html =  "<div class='q_team'>";
		$html .=  "<div class='q_team_inner'>";
			if($team_image != "") {
				$html .=  "<div class='q_team_image'>";
					$html .=  "<img src='$team_image_src' alt='" . esc_html__('team_image', 'soho-core') . "' />";
				$html .=  "</div>";
			}
			$html .=  "<div class='q_team_text'>";
				$html .=  "<div class='q_team_title_holder'>";
					$html .=  "<h5 class='q_team_name' ".$name_style.">".$team_name."</h5>";

					if($team_position != "") {
						$html .= "<span ".$position_style.">" . $team_position . "</span>";
					}
				$html .=  "</div>";

				$html .=  "<p ".$description_style.">" . $team_description . "</p>";

                $html .=  "<div class='q_team_social_holder'>";

                if($team_social_icon_pack == 'font_awesome'){
                    if($team_social_fa_icon_1 != "") {
                        $html .=  do_shortcode('[social_icons icon_pack="font_awesome" fa_icon="'.$team_social_fa_icon_1.'" type="square_social" size="'.$team_social_icon_size.'" link="'.$team_social_icon_1_link.'" target="'.$team_social_icon_1_target.'"]');
                    }
                    if($team_social_fa_icon_2 != "") {
                        $html .=  do_shortcode('[social_icons icon_pack="font_awesome" fa_icon="'.$team_social_fa_icon_2.'" type="square_social" size="'.$team_social_icon_size.'" link="'.$team_social_icon_2_link.'" target="'.$team_social_icon_2_target.'"]');
                    }
                    if($team_social_fa_icon_3 != "") {
                        $html .=  do_shortcode('[social_icons icon_pack="font_awesome" fa_icon="'.$team_social_fa_icon_3.'" type="square_social" size="'.$team_social_icon_size.'" link="'.$team_social_icon_3_link.'" target="'.$team_social_icon_3_target.'"]');
                    }
                    if($team_social_fa_icon_4 != "") {
                        $html .=  do_shortcode('[social_icons icon_pack="font_awesome" fa_icon="'.$team_social_fa_icon_4.'" type="square_social" size="'.$team_social_icon_size.'" link="'.$team_social_icon_4_link.'" target="'.$team_social_icon_4_target.'"]');
                    }
                    if($team_social_fa_icon_5 != "") {
                        $html .=  do_shortcode('[social_icons icon_pack="font_awesome" fa_icon="'.$team_social_fa_icon_5.'" type="square_social" size="'.$team_social_icon_size.'" link="'.$team_social_icon_5_link.'" target="'.$team_social_icon_5_target.'"]');
                    }
                }
                if($team_social_icon_pack == 'font_elegant'){
                    if($team_social_fe_icon_1 != "") {
                        $html .=  do_shortcode('[social_icons icon_pack="font_elegant" fe_icon="'.$team_social_fe_icon_1.'" type="square_social" size="'.$team_social_icon_size.'" link="'.$team_social_icon_1_link.'" target="'.$team_social_icon_1_target.'"]');
                    }
                    if($team_social_fe_icon_2 != "") {
                        $html .=  do_shortcode('[social_icons icon_pack="font_elegant" fe_icon="'.$team_social_fe_icon_2.'" type="square_social" size="'.$team_social_icon_size.'" link="'.$team_social_icon_2_link.'" target="'.$team_social_icon_2_target.'"]');
                    }
                    if($team_social_fe_icon_3 != "") {
                        $html .=  do_shortcode('[social_icons icon_pack="font_elegant" fe_icon="'.$team_social_fe_icon_3.'" type="square_social" size="'.$team_social_icon_size.'" link="'.$team_social_icon_3_link.'" target="'.$team_social_icon_3_target.'"]');
                    }
                    if($team_social_fe_icon_4 != "") {
                        $html .=  do_shortcode('[social_icons icon_pack="font_elegant" fe_icon="'.$team_social_fe_icon_4.'" type="square_social" size="'.$team_social_icon_size.'" link="'.$team_social_icon_4_link.'" target="'.$team_social_icon_4_target.'"]');
                    }
                    if($team_social_fe_icon_5 != "") {
                        $html .=  do_shortcode('[social_icons icon_pack="font_elegant" fe_icon="'.$team_social_fe_icon_5.'" type="square_social" size="'.$team_social_icon_size.'" link="'.$team_social_icon_5_link.'" target="'.$team_social_icon_5_target.'"]');
                    }
}
                $html .=  "</div>";
			$html .=  "</div>";
		$html .=  "</div>";
	$html .=  "</div>";

    return $html;
}
}
add_shortcode('q_team', 'soho_core_q_team');

/* Team Simple shortcode */

if (!function_exists('soho_core_q_team_simple')) {
function soho_core_q_team_simple($atts, $content = null) {
    $args = array(
        "image"            => "",
        "background_color" => "",
        "name"             => "",
        "name_color"       => "",
        "position"         => "",
        "position_color"   => "",
        "link"             => "",
        "target"           => "_self"
    );
        
    extract(shortcode_atts($args, $atts));

    if(is_numeric($image)) {
        $team_image_src = wp_get_attachment_url( $image );
    } else {
        $team_image_src = $image;
    }

    $html           = "";
    $name_style     = "";
    $position_style = "";
    $holder_style   = "";

    if($name_color != ""){
        $name_style .= "style='color: ".$name_color.";'";
    }

    if($position_color != ""){
        $position_style .= "style='color: ".$position_color.";'";
    }

    if($background_color != ""){
        $holder_style .= "style='background-color: ".$background_color.";'";
    }
    
    $html =  "<div class='q_team_simple'>";

        if($image != "") {
            $html .=  "<div class='q_team_simple_image'>";
                $html .=  "<img src='$team_image_src' alt='" . esc_html__('team_image', 'soho-core') . "' />";
            $html .=  "</div>";
        }

        if($link != ""){
            $html .= "<a href='".$link."' target='".$target."'>";
        } else {
            $html .= "<a href='javascript:void(0)' target='_self'>";
        }

            $html .= "<span class='q_team_simple_text' ".$holder_style.">";
                $html .= "<span class='q_team_simple_text_inner'>";
                    $html .= "<span class='q_team_simple_title'>";
                        $html .= "<span class='q_team_simple_name' ".$name_style.">".$name."</span>";

                        if($position != "") {
                            $html .= "<span ".$position_style.">" . $position . "</span>";
                        }
                    $html .= "</span>";
                $html .= "</span>";    
            $html .= "</span>";

        if($link != ""){
            $html .= "</a>";
        } else {
            $html .= "</a>";
        }   

    $html .=  "</div>";

    return $html;
}
}
add_shortcode('q_team_simple', 'soho_core_q_team_simple');

/* Testimonials shortcode */

if (!function_exists('soho_core_testimonials')) {

    function soho_core_testimonials($atts, $content = null) {
        $deafult_args = array(
            "type"                     => "standard",
            "category"                 => "",
            "number"                   => "-1",
            "text_align"               => "center",
            "text_color"               => "",
            "author_color"             => "",
            "background_color"         => "",
            "border_color"             => "",
            "author_image"             => "",
            "control_navigation"       => "",
            "control_navigation_color" => ""
        );
        
        extract(shortcode_atts($deafult_args, $atts));
        
        $html                           = "";
        $testimonial_text_inner_styles  = "";
        $testimonial_name_styles        = "";
        $testimonial_text_style         = "";
        
        if($text_color != "") {
            $testimonial_text_style        .= "color: ".$text_color.";";
        }

        if($author_color != ""){
            $testimonial_name_styles       .= "color: ".$author_color.";";
        }

        if($background_color != ''){
            $testimonial_text_inner_styles .= "background-color: ".$background_color.';';
        }

        if($border_color != ''){
            $testimonial_text_inner_styles .= "border: 2px solid ".$border_color.';';
        }

        $args = array(
            'post_type' => 'testimonials',
            'orderby' => "date",
            'order' => "DESC",
            'posts_per_page' => $number
        );

        if ($category != "") {
            $args['testimonials_category'] = $category;
        }
        
        $html .= "<div class='testimonials_holder $type clearfix'>";
        $html .= '<div class="testimonials '.$control_navigation.' '.$control_navigation_color.' testimonials_carousel"';
            if($type == "simple"){
                $html .= ' style="'.$testimonial_text_inner_styles.'"';
            }
        $html .= '>';
        $html .= '<ul class="slides">';
        
        $query = new WP_Query( $args );
        if ($query->have_posts()) :
            while ($query->have_posts()) : $query->the_post();
                $author = get_post_meta(get_the_ID(), "qode_testimonial-author", true);
                $website = get_post_meta(get_the_ID(), "qode_testimonial_website", true);
                $company_position = get_post_meta(get_the_ID(), "qode_testimonial-company_position", true);
                $text = get_post_meta(get_the_ID(), "qode_testimonial-text", true);
                $html .= '<li id="testimonials' . get_the_ID() . '" class="testimonial_content">';
                    $html .= '<div class="testimonial_content_inner">';
                        $html .= '<div class="testimonial_text_holder">';
                            $html .= '<div class="testimonial_text_inner ';
                                if($type == "simple"){
                                    $html .= $text_align.'"';
                                } else {
                                    $html .= '"';
                                }

                                if($type != "simple"){
                                    $html .= 'style="'.$testimonial_text_inner_styles.'"';
                                }
                            $html .=  '>';

                            $html .= '<p style="'.$testimonial_text_style.'">' . trim($text) . '</p>';

                            if($type == "simple") {
                                $html .= '<h5 style="'.$testimonial_name_styles.'">' . $author;
                                if($company_position != "") {
                                    $html .= ' / <span class="author-description"> ' . $company_position .'</span>';
                                }
                                if($website != "") {
                                    $html .= ' / <span class="author-description"> ' . $website .'</span>';
                                }
                                $html .= '</h5>';
                            }
                            
                            $html .= '</div>'; //close testimonial_text_inner
                            if($type == "standard") {
                                $html .= '<span class="testimonial_arrow"';
                                
                                    if($background_color != '' || $border_color != ''){
                                        $html .= ' style="background-color: '.$background_color.'; border-color: '.$border_color.';"';
                                    }

                                $html .= '></span>';
                            }

                        $html .= '</div>'; //close testimonial_text_holder

                        if($type == "standard") {

                            $html .= '<div class="author_image_holder clearfix">';
                            
                                if($author_image == 'yes') {
                                    $html .= '<div class="image_holder">';
                                        if(get_the_post_thumbnail(get_the_ID())){
                                            $html .= get_the_post_thumbnail(get_the_ID());
                                        } else {
                                            $html .= '<img src="'.SOHO_QODE_ROOT.'/img/avatar.png" alt="' . esc_html__('testimonial_avatar', 'soho-core') . '" />';
                                        }
                                    $html .= '</div>';
                                }

                                $html .= '<div class="testimonial_author">';
                                
                                    $html .= '<h5 style="'.$testimonial_name_styles.'">' . $author;
                                    if($company_position != "") {
                                        $html .= ' / <span class="author-description"> ' . $company_position .'</span>';
                                    }
                                    if($website != "") {
                                        $html .= ' / <span class="author-description"> ' . $website .'</span>';
                                    }
                                    $html .= '</h5>';

                                $html .= '</div>'; //close testimonial_author
                            $html .= '</div>';//close author_image_holder
                        }
                    $html .= '</div>'; //close content_inner
                $html .= '</li>'; //close testimonials
            endwhile;
        else:
            $html .= esc_html__('Sorry, no posts matched your criteria.', 'soho-core');
        endif;

        wp_reset_postdata();
        $html .= '</ul>';//close slides
        $html .= '</div>';
        $html .= '</div>';
        return $html;
    }

}
add_shortcode('testimonials', 'soho_core_testimonials');

/* Unordered List shortcode */

if (!function_exists('soho_core_unordered_list')) {
function soho_core_unordered_list($atts, $content = null) {
    $args = array(
        "style"         => "",
        "animate"       => "",
        'number_type'   => ""
    );
        
    extract(shortcode_atts($args, $atts));
        
    $list_item_classes = "";
    
    if($style != "") {
        $list_item_classes .= "{$style}";
    }
    
    if($number_type != "") {
        $list_item_classes .= " {$number_type}";
    }
    
    $html =  "<div class='q_list $list_item_classes";
    if($animate == "yes"){
    	$html .= " animate_list'>".$content."</div>";	
    } else {
    	$html .= "'>".$content."</div>";
   	}
    return $html;
}
}
add_shortcode('unordered_list', 'soho_core_unordered_list');