<?php

/**
 * Add URL fields to media uploader
 *
 * @param $form_fields array, fields to include in attachment form
 * @param $post object, attachment record in database
 * @return $form_fields, modified form fields
 */

function soho_qode_be_attachment_field_credit( $form_fields, $post ) {

    $form_fields['image-url'] = array(
        'label' => 'URL',
        'input' => 'text',
        'value' => get_post_meta( $post->ID, 'image_url', true ),
        'helps' => 'Add image URL',
    );

    $html = '';
    $values = array(
        '_self' => 'Self',
        '_blank' => 'Blank',
        '_parent' => 'Parent'
    );

    $html .= "<select name='attachments[{$post->ID}][image-url-target]'>";
    $target_val = get_post_meta( $post->ID, 'image_url_target', true );

    foreach ($values as $key => $value) {
        $selected = '';
        if($key == $target_val) {
            $selected = 'selected';
        }

        $html .= '<option value="'.$key.'" '.$selected.'>'.$value.'</option>';
    }

    $html .= "</select>";

    $form_fields['image-url-target'] = array(
        'label' => 'URL Target',
        'input' => 'html',
        'value' => $target_val,
        'html' => $html,
    );

    return $form_fields;
}

add_filter( 'attachment_fields_to_edit', 'soho_qode_be_attachment_field_credit', 10, 2 );

/**
 * Save values of URL in media uploader
 *
 * @param $post array, the post data for database
 * @param $attachment array, attachment fields from $_POST form
 * @return $post array, modified post data
 */

function soho_qode_be_attachment_field_credit_save( $post, $attachment ) {

    if( isset( $attachment['image-url'] ) )
        update_post_meta( $post['ID'], 'image_url', esc_url( $attachment['image-url'] ) );

    if( isset( $attachment['image-url-target'] ) )
        update_post_meta( $post['ID'], 'image_url_target', $attachment['image-url-target'] );

    return $post;
}

add_filter( 'attachment_fields_to_save', 'soho_qode_be_attachment_field_credit_save', 10, 2 );